/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.concurrent.tasks.drives.RemoveFileTask;
import net.lecousin.framework.io.IOUtil;

public class RenameFileTask
extends Task.OnFile<Void, IOException> {
    private File source;
    private File destination;

    public static ISynchronizationPoint<IOException> rename(File source, File destination, byte priority) {
        TaskManager t2;
        TaskManager t1 = Threading.getDrivesTaskManager().getTaskManager(source);
        if (t1 == (t2 = Threading.getDrivesTaskManager().getTaskManager(destination))) {
            return new RenameFileTask(t1, source, destination, priority).start().getOutput();
        }
        AsyncWork<Long, IOException> copy = IOUtil.copy(source, destination, priority, source.length(), null, 0L, null);
        SynchronizationPoint<IOException> result = new SynchronizationPoint<IOException>();
        copy.listenInline(() -> new RemoveFileTask(source, priority).start().getOutput().listenInline(result), result);
        return result;
    }

    private RenameFileTask(TaskManager tm, File source, File destination, byte priority) {
        super(tm, "Rename file", priority);
        this.source = source;
        this.destination = destination;
    }

    @Override
    public Void run() throws IOException {
        if (!this.source.renameTo(this.destination)) {
            throw new IOException("Unable to rename file " + this.source.getAbsolutePath() + " into " + this.destination.getAbsolutePath());
        }
        return null;
    }
}

