/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.synch;

import java.util.Collection;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.ThreadingDebugHelper;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;

public class JoinPoint<TError extends Exception>
extends SynchronizationPoint<TError> {
    private int nbToJoin = 0;
    private boolean started = false;

    public JoinPoint() {
        if (Threading.debugSynchronization) {
            ThreadingDebugHelper.register(this);
        }
    }

    public int getToJoin() {
        return this.nbToJoin;
    }

    public synchronized void addToJoin(int nb) {
        this.nbToJoin += nb;
    }

    public synchronized void addToJoin(final ISynchronizationPoint<? extends TError> sp) {
        ++this.nbToJoin;
        sp.listenInline(new Runnable(){

            @Override
            public void run() {
                if (sp.isCancelled()) {
                    JoinPoint.this.cancel(sp.getCancelEvent());
                } else if (sp.hasError()) {
                    JoinPoint.this.error(sp.getError());
                } else {
                    JoinPoint.this.joined();
                }
            }
        });
        if (Threading.debugSynchronization) {
            ThreadingDebugHelper.registerJoin(this, sp);
        }
    }

    public synchronized void addToJoin(Task<?, ? extends TError> task) {
        this.addToJoin(task.getOutput());
    }

    public synchronized void addToJoinNoException(ISynchronizationPoint<?> sp) {
        ++this.nbToJoin;
        sp.listenInline(new Runnable(){

            @Override
            public void run() {
                JoinPoint.this.joined();
            }
        });
        if (Threading.debugSynchronization) {
            ThreadingDebugHelper.registerJoin(this, sp);
        }
    }

    public synchronized void addToJoinDoNotCancel(final ISynchronizationPoint<? extends TError> sp) {
        ++this.nbToJoin;
        sp.listenInline(new Runnable(){

            @Override
            public void run() {
                if (sp.hasError()) {
                    JoinPoint.this.error(sp.getError());
                } else {
                    JoinPoint.this.joined();
                }
            }
        });
        if (Threading.debugSynchronization) {
            ThreadingDebugHelper.registerJoin(this, sp);
        }
    }

    public synchronized void start() {
        if (Threading.debugSynchronization) {
            ThreadingDebugHelper.started(this);
        }
        this.started = true;
        if (this.nbToJoin == 0) {
            this.unblock();
        }
    }

    public synchronized void joined() {
        if (this.nbToJoin == 0) {
            LCCore.getApplication().getDefaultLogger().error("JoinPoint: nbToJoin already 0", new Exception());
            return;
        }
        if (this.isUnblocked()) {
            --this.nbToJoin;
            if (!this.hasError() && !this.isCancelled()) {
                LCCore.getApplication().getDefaultLogger().error("JoinPoint: joined after timeout", new Exception());
            }
            return;
        }
        if (--this.nbToJoin <= 0 && this.started) {
            this.unblock();
        }
    }

    public synchronized void timeout(long millis, final Runnable callback) {
        if (this.isUnblocked()) {
            return;
        }
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("JoinPoint timeout", 5){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                JoinPoint joinPoint = JoinPoint.this;
                synchronized (joinPoint) {
                    if (JoinPoint.this.isUnblocked()) {
                        return null;
                    }
                    if (callback != null) {
                        try {
                            callback.run();
                        }
                        catch (Throwable t) {
                            LCCore.getApplication().getDefaultLogger().error("Error in callback of JoinPoint timeout", t);
                        }
                    }
                    JoinPoint.this.unblock();
                    return null;
                }
            }
        };
        task.executeIn(millis);
        if (this.isUnblocked()) {
            return;
        }
        task.start();
    }

    public synchronized void listenTime(long timeout, final Runnable callback) {
        if (this.isUnblocked()) {
            return;
        }
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("JoinPoint timeout", 5){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                JoinPoint joinPoint = JoinPoint.this;
                synchronized (joinPoint) {
                    if (JoinPoint.this.isUnblocked()) {
                        return null;
                    }
                    if (callback != null) {
                        try {
                            callback.run();
                        }
                        catch (Throwable t) {
                            LCCore.getApplication().getDefaultLogger().error("Error in callback of JoinPoint time listener", t);
                        }
                    }
                    return null;
                }
            }
        };
        task.executeIn(timeout);
        if (this.isUnblocked()) {
            return;
        }
        task.start();
    }

    public static JoinPoint<Exception> fromSynchronizationPoints(ISynchronizationPoint<?> ... synchPoints) {
        JoinPoint<Exception> jp = new JoinPoint<Exception>();
        for (int i = 0; i < synchPoints.length; ++i) {
            jp.addToJoin(synchPoints[i]);
        }
        jp.start();
        return jp;
    }

    public static JoinPoint<Exception> fromSynchronizationPoints(Collection<? extends ISynchronizationPoint<?>> synchPoints) {
        JoinPoint<Exception> jp = new JoinPoint<Exception>();
        for (ISynchronizationPoint<?> sp : synchPoints) {
            jp.addToJoin(sp);
        }
        jp.start();
        return jp;
    }

    @SafeVarargs
    public static <T extends Exception> JoinPoint<T> fromSynchronizationPointsSimilarError(ISynchronizationPoint<T> ... synchPoints) {
        JoinPoint<T> jp = new JoinPoint<T>();
        for (int i = 0; i < synchPoints.length; ++i) {
            if (synchPoints[i] == null) continue;
            jp.addToJoin(synchPoints[i]);
        }
        jp.start();
        return jp;
    }

    public static JoinPoint<Exception> fromTasks(Task<?, ?> ... tasks) {
        JoinPoint<Exception> jp = new JoinPoint<Exception>();
        for (Task<?, ?> task : tasks) {
            jp.addToJoin(task.getOutput());
        }
        jp.start();
        return jp;
    }

    public static JoinPoint<Exception> fromTasks(Collection<? extends Task<?, ?>> tasks) {
        JoinPoint<Exception> jp = new JoinPoint<Exception>();
        for (Task<?, ?> task : tasks) {
            jp.addToJoin(task.getOutput());
        }
        jp.start();
        return jp;
    }

    public static JoinPoint<NoException> onAllDone(Collection<? extends Task<?, ?>> tasks) {
        final JoinPoint<NoException> jp = new JoinPoint<NoException>();
        jp.addToJoin(tasks.size());
        Runnable jpr = new Runnable(){

            @Override
            public void run() {
                jp.joined();
            }
        };
        jp.start();
        for (Task<?, ?> t : tasks) {
            t.getOutput().listenInline(jpr);
        }
        return jp;
    }

    public static void listenInline(Runnable listener, ISynchronizationPoint<?> ... synchPoints) {
        JoinPoint jp = new JoinPoint();
        for (int i = 0; i < synchPoints.length; ++i) {
            if (synchPoints[i] == null) continue;
            jp.addToJoin(synchPoints[i]);
        }
        jp.start();
        jp.listenInline(listener);
    }

    public static void listenInlineOnAllDone(Runnable listener, ISynchronizationPoint<?> ... synchPoints) {
        final JoinPoint jp = new JoinPoint();
        jp.addToJoin(synchPoints.length);
        Runnable jpr = new Runnable(){

            @Override
            public void run() {
                jp.joined();
            }
        };
        for (int i = 0; i < synchPoints.length; ++i) {
            synchPoints[i].listenInline(jpr);
        }
        jp.start();
        jp.listenInline(listener);
    }
}

