/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.synch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.BlockedThreadHandler;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.event.Listener;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class AsyncWork<T, TError extends Exception>
implements ISynchronizationPoint<TError>,
Future<T> {
    private boolean unblocked = false;
    private T result = null;
    private TError error = null;
    private CancelException cancel = null;
    private ArrayList<AsyncWorkListener<T, TError>> listenersInline = null;

    public AsyncWork() {
    }

    public AsyncWork(T result, TError error) {
        this.unblocked = true;
        this.result = result;
        this.error = error;
    }

    public AsyncWork(T result, TError error, CancelException cancel) {
        this(result, error);
        this.cancel = cancel;
    }

    public T getResult() {
        return this.result;
    }

    @Override
    public TError getError() {
        return this.error;
    }

    @Override
    public CancelException getCancelEvent() {
        return this.cancel;
    }

    @Override
    public boolean isCancelled() {
        return this.cancel != null;
    }

    @Override
    public boolean hasError() {
        return this.error != null;
    }

    @Override
    public Collection<?> getAllListeners() {
        if (this.listenersInline == null) {
            return new ArrayList(0);
        }
        return new ArrayList<AsyncWorkListener<T, TError>>(this.listenersInline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listenInline(AsyncWorkListener<T, TError> listener) {
        AsyncWork asyncWork = this;
        synchronized (asyncWork) {
            if (!this.unblocked || this.listenersInline != null) {
                if (this.listenersInline == null) {
                    this.listenersInline = new ArrayList(5);
                }
                this.listenersInline.add(listener);
                return;
            }
        }
        if (this.error != null) {
            listener.error(this.error);
        } else if (this.cancel != null) {
            listener.cancelled(this.cancel);
        } else {
            listener.ready(this.result);
        }
    }

    public void listenInline(final AsyncWork<T, TError> sp) {
        this.listenInline(new AsyncWorkListener<T, TError>(){

            @Override
            public void ready(T result) {
                sp.unblockSuccess(result);
            }

            @Override
            public void error(TError error) {
                sp.unblockError(error);
            }

            @Override
            public void cancelled(CancelException event) {
                sp.unblockCancel(event);
            }
        });
    }

    @Override
    public void listenInline(final SynchronizationPoint<TError> sp) {
        this.listenInline(new AsyncWorkListener<T, TError>(){

            @Override
            public void ready(T result) {
                sp.unblock();
            }

            @Override
            public void error(TError error) {
                sp.error(error);
            }

            @Override
            public void cancelled(CancelException event) {
                sp.cancel(event);
            }
        });
    }

    public void listenInline(final Listener<T> onready, final Listener<TError> onerror, final Listener<CancelException> oncancel) {
        this.listenInline(new AsyncWorkListener<T, TError>(){

            @Override
            public void ready(T result) {
                onready.fire(result);
            }

            @Override
            public void error(TError error) {
                onerror.fire(error);
            }

            @Override
            public void cancelled(CancelException event) {
                oncancel.fire(event);
            }

            public String toString() {
                return "AsyncWork.listenInline: " + onready;
            }
        });
    }

    public void listenInline(final Listener<T> onready, final ISynchronizationPoint<TError> onErrorAndCancel) {
        this.listenInline(new AsyncWorkListener<T, TError>(){

            @Override
            public void ready(T result) {
                onready.fire(result);
            }

            @Override
            public void error(TError error) {
                onErrorAndCancel.error(error);
            }

            @Override
            public void cancelled(CancelException event) {
                onErrorAndCancel.cancel(event);
            }

            public String toString() {
                return "AsyncWork.listenInline: " + onready;
            }
        });
    }

    @Override
    public void listenInline(final Runnable onready, final ISynchronizationPoint<TError> onErrorAndCancel) {
        this.listenInline(new AsyncWorkListener<T, TError>(){

            @Override
            public void ready(T result) {
                onready.run();
            }

            @Override
            public void error(TError error) {
                onErrorAndCancel.error(error);
            }

            @Override
            public void cancelled(CancelException event) {
                onErrorAndCancel.cancel(event);
            }

            public String toString() {
                return "AsyncWork.listenInline: " + onready;
            }
        });
    }

    @Override
    public void listenInline(final Runnable r) {
        this.listenInline(new AsyncWorkListener<T, TError>(){

            @Override
            public void ready(T result) {
                r.run();
            }

            @Override
            public void error(TError error) {
                r.run();
            }

            @Override
            public void cancelled(CancelException event) {
                r.run();
            }

            public String toString() {
                return "AsyncWork.listenInline: " + r;
            }
        });
    }

    @Override
    public void listenInline(final Listener<T> onSuccess) {
        this.listenInline(new AsyncWorkListener<T, TError>(){

            @Override
            public void ready(T result) {
                onSuccess.fire(result);
            }

            @Override
            public void error(TError error) {
            }

            @Override
            public void cancelled(CancelException event) {
            }

            public String toString() {
                return "AsyncWork.listenInline: " + onSuccess;
            }
        });
    }

    public void listenInlineGenericError(final AsyncWork<T, Exception> sp) {
        this.listenInline(new AsyncWorkListener<T, TError>(){

            @Override
            public void ready(T result) {
                sp.unblockSuccess(result);
            }

            @Override
            public void error(TError error) {
                sp.unblockError(error);
            }

            @Override
            public void cancelled(CancelException event) {
                sp.unblockCancel(event);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblockSuccess(T result) {
        ArrayList<AsyncWorkListener<T, TError>> listeners;
        AsyncWork asyncWork = this;
        synchronized (asyncWork) {
            if (this.unblocked) {
                return;
            }
            this.unblocked = true;
            this.result = result;
            if (this.listenersInline == null) {
                this.notifyAll();
                return;
            }
            listeners = this.listenersInline;
            this.listenersInline = new ArrayList(2);
        }
        Logger log = LCCore.getApplication().getLoggerFactory().getLogger(SynchronizationPoint.class);
        while (true) {
            int i;
            if (!log.debug()) {
                for (i = 0; i < listeners.size(); ++i) {
                    try {
                        listeners.get(i).ready(result);
                        continue;
                    }
                    catch (Throwable t) {
                        log.error("Exception thrown by an inline listener of AsyncWork: " + listeners.get(i), t);
                    }
                }
            } else {
                for (i = 0; i < listeners.size(); ++i) {
                    long start = System.nanoTime();
                    try {
                        listeners.get(i).ready(result);
                    }
                    catch (Throwable t) {
                        log.error("Exception thrown by an inline listener of AsyncWork: " + listeners.get(i), t);
                    }
                    long time = System.nanoTime() - start;
                    if (time <= 1000000L) continue;
                    log.debug("Listener ready took " + (double)time / 1000000.0 + "ms: " + listeners.get(i));
                }
            }
            AsyncWork asyncWork2 = this;
            synchronized (asyncWork2) {
                if (this.listenersInline.isEmpty()) {
                    this.listenersInline = null;
                    listeners = null;
                    this.notifyAll();
                    break;
                }
                listeners.clear();
                ArrayList<AsyncWorkListener<T, TError>> tmp = listeners;
                listeners = this.listenersInline;
                this.listenersInline = tmp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblockError(TError error) {
        ArrayList<AsyncWorkListener<T, TError>> listeners;
        AsyncWork asyncWork = this;
        synchronized (asyncWork) {
            if (this.unblocked) {
                return;
            }
            this.unblocked = true;
            this.error = error;
            if (this.listenersInline == null) {
                this.notifyAll();
                return;
            }
            listeners = this.listenersInline;
            this.listenersInline = new ArrayList(2);
        }
        Logger log = LCCore.getApplication().getLoggerFactory().getLogger(SynchronizationPoint.class);
        while (true) {
            int i;
            if (!log.debug()) {
                for (i = 0; i < listeners.size(); ++i) {
                    try {
                        listeners.get(i).error(error);
                        continue;
                    }
                    catch (Throwable t) {
                        log.error("Exception thrown by an inline listener of AsyncWork, cancel it: " + listeners.get(i), t);
                        try {
                            listeners.get(i).cancelled(new CancelException("Error in listener", t));
                            continue;
                        }
                        catch (Throwable t2) {
                            log.error("Exception thrown while cancelling inline listener of AsyncWork after error: " + listeners.get(i), t2);
                        }
                    }
                }
            } else {
                for (i = 0; i < listeners.size(); ++i) {
                    long start = System.nanoTime();
                    try {
                        listeners.get(i).error(error);
                    }
                    catch (Throwable t) {
                        log.error("Exception thrown by an inline listener of AsyncWork, cancel it: " + listeners.get(i), t);
                        try {
                            listeners.get(i).cancelled(new CancelException("Error in listener", t));
                        }
                        catch (Throwable t2) {
                            log.error("Exception thrown while cancelling inline listener of AsyncWork after error: " + listeners.get(i), t2);
                        }
                    }
                    long time = System.nanoTime() - start;
                    if (time <= 1000000L) continue;
                    log.debug("Listener error took " + (double)time / 1000000.0 + "ms: " + listeners.get(i));
                }
            }
            AsyncWork asyncWork2 = this;
            synchronized (asyncWork2) {
                if (this.listenersInline.isEmpty()) {
                    this.listenersInline = null;
                    listeners = null;
                    this.notifyAll();
                    break;
                }
                listeners.clear();
                ArrayList<AsyncWorkListener<T, TError>> tmp = listeners;
                listeners = this.listenersInline;
                this.listenersInline = tmp;
            }
        }
    }

    @Override
    public void error(TError error) {
        this.unblockError(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblockCancel(CancelException event) {
        ArrayList<AsyncWorkListener<T, TError>> listeners;
        AsyncWork asyncWork = this;
        synchronized (asyncWork) {
            if (this.unblocked) {
                return;
            }
            this.unblocked = true;
            this.cancel = event;
            if (this.listenersInline == null) {
                this.notifyAll();
                return;
            }
            listeners = this.listenersInline;
            this.listenersInline = new ArrayList(2);
        }
        Logger log = LCCore.getApplication().getLoggerFactory().getLogger(SynchronizationPoint.class);
        while (true) {
            int i;
            if (!log.debug()) {
                for (i = 0; i < listeners.size(); ++i) {
                    try {
                        listeners.get(i).cancelled(event);
                        continue;
                    }
                    catch (Throwable t) {
                        log.error("Exception thrown by an inline listener of AsyncWork: " + listeners.get(i), t);
                    }
                }
            } else {
                for (i = 0; i < listeners.size(); ++i) {
                    long start = System.nanoTime();
                    try {
                        listeners.get(i).cancelled(event);
                    }
                    catch (Throwable t) {
                        log.error("Exception thrown by an inline listener of AsyncWork: " + listeners.get(i), t);
                    }
                    long time = System.nanoTime() - start;
                    if (time <= 1000000L) continue;
                    log.debug("Listener cancelled took " + (double)time / 1000000.0 + "ms: " + listeners.get(i));
                }
            }
            AsyncWork asyncWork2 = this;
            synchronized (asyncWork2) {
                if (this.listenersInline.isEmpty()) {
                    this.listenersInline = null;
                    listeners = null;
                    this.notifyAll();
                    break;
                }
                listeners.clear();
                ArrayList<AsyncWorkListener<T, TError>> tmp = listeners;
                listeners = this.listenersInline;
                this.listenersInline = tmp;
            }
        }
    }

    @Override
    public void cancel(CancelException reason) {
        this.unblockCancel(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void block(long timeout) {
        BlockedThreadHandler blockedHandler;
        AsyncWork asyncWork = this;
        synchronized (asyncWork) {
            if (this.unblocked && this.listenersInline == null) {
                return;
            }
            Thread t = Thread.currentThread();
            blockedHandler = Threading.getBlockedThreadHandler(t);
            if (blockedHandler == null) {
                if (timeout <= 0L) {
                    while (!this.unblocked || this.listenersInline != null) {
                        try {
                            this.wait(0L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                } else {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
        if (blockedHandler != null) {
            blockedHandler.blocked(this, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T blockResult(long timeout) throws TError, CancelException {
        BlockedThreadHandler blockedHandler;
        AsyncWork asyncWork = this;
        synchronized (asyncWork) {
            if (this.unblocked && this.listenersInline == null) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.cancel != null) {
                    throw this.cancel;
                }
                return this.result;
            }
            Thread t = Thread.currentThread();
            blockedHandler = Threading.getBlockedThreadHandler(t);
            if (blockedHandler == null) {
                while (!this.unblocked || this.listenersInline != null) {
                    try {
                        this.wait(timeout < 0L ? 0L : timeout);
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                }
            }
        }
        if (blockedHandler != null) {
            blockedHandler.blocked(this, timeout);
        }
        if (this.error != null) {
            throw this.error;
        }
        if (this.cancel != null) {
            throw this.cancel;
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockPause(long logAfter) {
        AsyncWork asyncWork = this;
        synchronized (asyncWork) {
            while (!this.unblocked || this.listenersInline != null) {
                long start = System.currentTimeMillis();
                try {
                    this.wait(logAfter + 1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (System.currentTimeMillis() - start <= logAfter) continue;
                System.err.println("Still blocked after " + logAfter / 1000L + "s.");
                new Exception("").printStackTrace(System.err);
            }
        }
    }

    @Override
    public synchronized boolean isUnblocked() {
        return this.unblocked;
    }

    public void reset() {
        this.unblocked = false;
        this.result = null;
        this.error = null;
        this.cancel = null;
        this.listenersInline = null;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.block(0L);
        if (!this.isUnblocked()) {
            throw new InterruptedException();
        }
        if (this.hasError()) {
            throw new ExecutionException((Throwable)this.error);
        }
        if (this.isCancelled()) {
            throw new ExecutionException(this.cancel);
        }
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.block(unit.toMillis(timeout));
        if (!this.isUnblocked()) {
            throw new TimeoutException();
        }
        if (this.hasError()) {
            throw new ExecutionException((Throwable)this.error);
        }
        if (this.isCancelled()) {
            throw new ExecutionException(this.cancel);
        }
        return this.result;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isUnblocked()) {
            return false;
        }
        this.cancel(new CancelException("Cancelled"));
        return true;
    }

    @Override
    public boolean isDone() {
        return this.isUnblocked();
    }

    public static class AsyncWorkListenerReady<T, TError extends Exception>
    implements AsyncWorkListener<T, TError> {
        protected OnReady<T, TError> listener;
        protected ISynchronizationPoint<TError> onErrorOrCancel;
        protected RunnableWithParameter<Pair<T, TError>> onError;

        public AsyncWorkListenerReady(OnReady<T, TError> listener, ISynchronizationPoint<TError> onErrorOrCancel) {
            this.listener = listener;
            this.onErrorOrCancel = onErrorOrCancel;
        }

        public AsyncWorkListenerReady(OnReady<T, TError> listener, ISynchronizationPoint<TError> onErrorOrCancel, RunnableWithParameter<Pair<T, TError>> onDoneError) {
            this.listener = listener;
            this.onErrorOrCancel = onErrorOrCancel;
            this.onError = onDoneError;
        }

        @Override
        public void ready(T result) {
            this.listener.ready(result, this);
        }

        @Override
        public void error(TError error) {
            if (this.onError != null) {
                this.onError.run(new Pair<Object, TError>(null, error));
            }
            this.onErrorOrCancel.error(error);
        }

        @Override
        public void cancelled(CancelException event) {
            this.onErrorOrCancel.cancel(event);
        }

        public static interface OnReady<T, TError extends Exception> {
            public void ready(T var1, AsyncWorkListenerReady<T, TError> var2);
        }
    }

    public static interface AsyncWorkListener<T, TError extends Exception> {
        public void ready(T var1);

        public void error(TError var1);

        public void cancelled(CancelException var1);
    }
}

