/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.BlockedThreadHandler;
import net.lecousin.framework.concurrent.CPUTaskManager;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.DrivesTaskManager;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.TaskMonitoring;
import net.lecousin.framework.concurrent.TaskPriorityManager;
import net.lecousin.framework.concurrent.TaskScheduler;
import net.lecousin.framework.concurrent.ThreadPoolTaskManager;
import net.lecousin.framework.concurrent.ThreadingDebugHelper;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.util.AsyncCloseable;

public final class Threading {
    static Logger logger;
    public static boolean traceBlockingTasks;
    public static boolean traceTaskTime;
    public static boolean debugSynchronization;
    public static boolean traceTaskDone;
    public static boolean traceTasksNotDone;
    public static final Object CPU;
    public static final Object UNMANAGED;
    private static CPUTaskManager cpu;
    private static DrivesTaskManager drives;
    private static ThreadPoolTaskManager unmanaged;
    private static Map<Object, TaskManager> resources;
    private static Map<Thread, BlockedThreadHandler> blockedHandlers;

    private Threading() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(ThreadFactory threadFactory, Class<? extends TaskPriorityManager> taskPriorityManager, int nbCPUThreads, DrivesTaskManager.DrivesProvider drivesProvider, int nbUnmanagedThreads) throws IllegalStateException {
        if (Threading.isInitialized()) {
            throw new IllegalStateException("Threading has been already initialized.");
        }
        logger = LCCore.get().getThreadingLogger();
        TaskScheduler.init();
        cpu = new CPUTaskManager(threadFactory, taskPriorityManager, nbCPUThreads);
        cpu.start();
        resources.put(CPU, cpu);
        drives = new DrivesTaskManager(threadFactory, taskPriorityManager, drivesProvider);
        unmanaged = new ThreadPoolTaskManager("Unmanaged tasks manager", UNMANAGED, nbUnmanagedThreads, threadFactory, taskPriorityManager);
        resources.put(UNMANAGED, unmanaged);
        LCCore.get().toClose(new StopMultiThreading());
        if (traceTasksNotDone) {
            ThreadingDebugHelper.traceTasksNotDone();
        }
        TaskMonitoring.start(threadFactory);
        Map<Object, TaskManager> map = resources;
        synchronized (map) {
            for (TaskManager tm : resources.values()) {
                tm.started();
            }
        }
    }

    public static boolean isInitialized() {
        return cpu != null;
    }

    public static TaskManager getCPUTaskManager() {
        return cpu;
    }

    public static DrivesTaskManager getDrivesTaskManager() {
        return drives;
    }

    public static ThreadPoolTaskManager getUnmanagedTaskManager() {
        return unmanaged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerResource(Object resource, TaskManager tm) {
        if (resource == null) {
            return;
        }
        Map<Object, TaskManager> map = resources;
        synchronized (map) {
            resources.put(resource, tm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskManager unregisterResource(Object resource) {
        if (resource == null) {
            return null;
        }
        Map<Object, TaskManager> map = resources;
        synchronized (map) {
            return resources.remove(resource);
        }
    }

    public static TaskManager get(Object resource) {
        return resources.get(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TaskManager> getAllTaskManagers() {
        Map<Object, TaskManager> map = resources;
        synchronized (map) {
            return new ArrayList<TaskManager>(resources.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerBlockedThreadHandler(BlockedThreadHandler handler, Thread thread) {
        Map<Thread, BlockedThreadHandler> map = blockedHandlers;
        synchronized (map) {
            blockedHandlers.put(thread, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterBlockedThreadHandler(Thread thread) {
        Map<Thread, BlockedThreadHandler> map = blockedHandlers;
        synchronized (map) {
            blockedHandlers.remove(thread);
        }
    }

    public static BlockedThreadHandler getBlockedThreadHandler(Thread thread) {
        return blockedHandlers.get(thread);
    }

    public static void waitFinished(Collection<? extends Task<?, ?>> tasks) throws Exception {
        for (Task<?, ?> t : tasks) {
            t.getOutput().blockThrow(0L);
        }
    }

    public static <TError extends Exception> void waitUnblockedWithError(Collection<AsyncWork<?, TError>> tasks) throws TError, CancelException {
        for (AsyncWork<?, TError> t : tasks) {
            t.blockResult(0L);
        }
    }

    public static void waitOneFinished(List<? extends Task<?, ?>> tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        if (tasks.size() == 1) {
            try {
                tasks.get(0).getOutput().block(0L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        SynchronizationPoint sp = new SynchronizationPoint();
        for (Task<?, ?> t : tasks) {
            if (t.isDone()) {
                return;
            }
            t.getOutput().synchWithNoError(sp);
        }
        sp.block(0L);
    }

    public static String debug() {
        StringBuilder s = new StringBuilder();
        for (TaskManager tm : resources.values()) {
            tm.debug(s);
        }
        return s.toString();
    }

    public static String printStats() {
        StringBuilder s = new StringBuilder();
        for (TaskManager tm : resources.values()) {
            tm.printStats(s);
        }
        return s.toString();
    }

    static {
        traceBlockingTasks = System.getProperty("lc.traceBlockingTasks") != null;
        traceTaskTime = System.getProperty("lc.traceTaskTime") != null;
        debugSynchronization = System.getProperty("lc.debugSynchronization") != null;
        traceTaskDone = System.getProperty("lc.traceTaskDone") != null;
        traceTasksNotDone = System.getProperty("lc.traceTasksNotDone") != null;
        CPU = new Object();
        UNMANAGED = new Object();
        resources = new HashMap<Object, TaskManager>();
        blockedHandlers = new HashMap<Thread, BlockedThreadHandler>();
    }

    private static class StopMultiThreading
    implements AsyncCloseable<Exception> {
        private StopMultiThreading() {
        }

        @Override
        public ISynchronizationPoint<Exception> closeAsync() {
            final SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
            Thread t = new Thread("Stopping tasks managers"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean hasTasks = false;
                    long start = System.currentTimeMillis();
                    while (true) {
                        hasTasks = false;
                        Map map = resources;
                        synchronized (map) {
                            for (TaskManager tm : resources.values()) {
                                int nb = tm.getRemainingTasks(false);
                                if (nb <= 0) continue;
                                System.out.println("   * Still " + nb + " tasks to do for " + tm.getName());
                                hasTasks = true;
                            }
                        }
                        if (!hasTasks || System.currentTimeMillis() - start > 5000L) break;
                        try {
                            Thread.sleep(25L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    if (!hasTasks) {
                        System.out.println("   * No more task to do in any task manager, continue stop process");
                    } else {
                        System.out.println("   * Still some tasks after 5 seconds, continue stop process anyway");
                    }
                    TaskScheduler.end();
                    Map e = resources;
                    synchronized (e) {
                        for (TaskManager tm : resources.values()) {
                            tm.shutdownWhenNoMoreTasks();
                        }
                    }
                    boolean stop = true;
                    start = System.currentTimeMillis();
                    while (true) {
                        Object object = resources;
                        synchronized (object) {
                            for (TaskManager tm : resources.values()) {
                                stop &= tm.isStopped();
                            }
                        }
                        if (stop) break;
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e2) {
                            break;
                        }
                        stop = true;
                        if (System.currentTimeMillis() - start <= 10000L) continue;
                        start = Long.MAX_VALUE;
                        TaskScheduler.end();
                        object = resources;
                        synchronized (object) {
                            for (TaskManager tm : resources.values()) {
                                if (tm.isStopped()) continue;
                                System.err.println("Force to stop " + tm.getName());
                                tm.forceStop();
                            }
                        }
                    }
                    System.out.println("   * All Task Managers are stopped");
                    sp.unblock();
                }
            };
            t.start();
            return sp;
        }
    }
}

