/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import java.util.concurrent.ThreadFactory;
import net.lecousin.framework.concurrent.FixedThreadTaskManager;
import net.lecousin.framework.concurrent.TaskPriorityManager;
import net.lecousin.framework.concurrent.TaskWorker;

public class MonoThreadTaskManager
extends FixedThreadTaskManager {
    private TaskWorker worker;
    private int workerCount = 2;

    public MonoThreadTaskManager(String name, Object resource, ThreadFactory threadFactory, Class<? extends TaskPriorityManager> taskPriorityManager) {
        super(name, resource, 1, threadFactory, taskPriorityManager);
        this.worker = new TaskWorker(name + " - Worker 1", this);
    }

    @Override
    public void start() {
        this.worker.thread.start();
    }

    @Override
    protected TaskWorker[] getWorkers() {
        return new TaskWorker[]{this.worker};
    }

    @Override
    protected void forceStopWorkers() {
        this.worker.forceStop(false);
    }

    @Override
    protected void finishAndStopWorkers() {
        this.worker.finishAndStop();
    }

    @Override
    boolean isStopped() {
        return !this.worker.thread.isAlive();
    }

    @Override
    protected TaskWorker createWorker() {
        return new TaskWorker(this.getName() + " - Worker " + this.workerCount++, this);
    }

    @Override
    protected void replaceWorkerBySpare(TaskWorker currentWorker, TaskWorker spareWorker) {
        this.worker = spareWorker;
    }
}

