/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class LinkedIterators<T>
implements Iterator<T> {
    private LinkedList<Iterator<T>> iterators = new LinkedList();
    private Iterator<T> current = null;

    public LinkedIterators() {
    }

    public LinkedIterators(Collection<Iterator<T>> iterators) {
        this.iterators.addAll(iterators);
    }

    @SafeVarargs
    public LinkedIterators(Iterator<T> ... iterators) {
        for (int i = 0; i < iterators.length; ++i) {
            this.iterators.add(iterators[i]);
        }
    }

    public void addIterator(Iterator<T> it) {
        this.iterators.add(it);
    }

    @Override
    public boolean hasNext() {
        while (this.current == null || !this.current.hasNext()) {
            if (this.iterators.isEmpty()) {
                return false;
            }
            this.current = this.iterators.removeFirst();
        }
        return true;
    }

    @Override
    public T next() {
        while (this.current == null || !this.current.hasNext()) {
            if (this.iterators.isEmpty()) {
                throw new NoSuchElementException();
            }
            this.current = this.iterators.removeFirst();
        }
        return this.current.next();
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.current.remove();
    }
}

