/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries.classloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.lecousin.framework.application.libraries.classloader.AbstractClassLoader;
import net.lecousin.framework.application.libraries.classloader.AppClassLoader;
import net.lecousin.framework.application.libraries.classpath.DefaultLibrariesManager;
import net.lecousin.framework.event.Listener;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.util.Filter;

public class DirectoryClassLoader
extends AbstractClassLoader {
    private File dir;

    public DirectoryClassLoader(AppClassLoader appClassLoader, File dir) {
        super(appClassLoader);
        this.dir = dir;
    }

    @Override
    public String getDescription() {
        return "DirectoryClassLoader from " + this.dir.getAbsolutePath();
    }

    public String toString() {
        return this.getDescription();
    }

    @Override
    protected byte[] loadFile(String name) throws IOException {
        File file = new File(this.dir, name);
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        try (FileInputStream in = new FileInputStream(file);){
            int nb;
            int size = (int)file.length();
            byte[] buffer = new byte[size];
            int pos = 0;
            while ((nb = in.read(buffer, pos, size - pos)) > 0 && (pos += nb) < size) {
            }
            if (pos < size) {
                throw new IOException("File truncated: " + file.getAbsolutePath());
            }
            byte[] byArray = buffer;
            return byArray;
        }
    }

    @Override
    public IO.Readable loadResourceAsIO(String name, byte priority) throws IOException {
        File file = new File(this.dir, name);
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        return new FileIO.ReadOnly(file, priority);
    }

    @Override
    protected URL loadResourceURL(String name) {
        File file = new File(this.dir, name);
        if (!file.exists()) {
            return null;
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    protected Object getResourcePointer(String path) {
        File file = new File(this.dir, path);
        if (!file.exists() || file.isDirectory()) {
            return null;
        }
        return file;
    }

    @Override
    protected IO.Readable openResourcePointer(Object pointer, byte priority) {
        return new FileIO.ReadOnly((File)pointer, priority);
    }

    @Override
    protected void scan(String rootPackage, boolean includeSubPackages, Filter<String> packageFilter, Filter<String> classFilter, Listener<Class<?>> classScanner) {
        DefaultLibrariesManager.scanDirectoryLibrary(this, this.dir, rootPackage, includeSubPackages, packageFilter, classFilter, classScanner);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

