/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries.artifacts.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class MavenSettings {
    public String localRepository = null;
    public ArrayList<String> activeProfiles = new ArrayList();

    public static MavenSettings load(File file) throws Exception {
        try (FileInputStream input = new FileInputStream(file);){
            MavenSettings mavenSettings = MavenSettings.load(input);
            return mavenSettings;
        }
    }

    public static MavenSettings load(InputStream input) throws Exception {
        XMLStreamReader xml = XMLInputFactory.newFactory().createXMLStreamReader(input);
        while (xml.hasNext()) {
            xml.next();
            if (xml.getEventType() != 1) continue;
            if (!"settings".equals(xml.getLocalName())) {
                throw new Exception("Root element of a Maven settings.xml file must be <settings>");
            }
            MavenSettings settings = new MavenSettings();
            block1: while (xml.hasNext()) {
                xml.next();
                if (xml.getEventType() == 1) {
                    if ("localRepository".equals(xml.getLocalName())) {
                        settings.localRepository = xml.getElementText().trim();
                        continue;
                    }
                    if (!"activeProfiles".equals(xml.getLocalName())) continue;
                    while (xml.hasNext()) {
                        xml.next();
                        if (xml.getEventType() == 1) {
                            if (!"activeProfile".equals(xml.getLocalName())) continue;
                            settings.activeProfiles.add(xml.getElementText().trim());
                            continue;
                        }
                        if (xml.getEventType() != 2) continue;
                        continue block1;
                    }
                    continue;
                }
                if (xml.getEventType() != 2) continue;
            }
            settings.activeProfiles.trimToSize();
            return settings;
        }
        return new MavenSettings();
    }
}

