/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries.artifacts.maven;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.application.Artifact;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.application.Version;
import net.lecousin.framework.application.VersionSpecification;
import net.lecousin.framework.application.libraries.artifacts.LibrariesRepository;
import net.lecousin.framework.application.libraries.artifacts.LibraryDescriptor;
import net.lecousin.framework.application.libraries.artifacts.LibraryDescriptorLoader;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenLocalRepository;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenPOM;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenRemoteRepository;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenRepository;
import net.lecousin.framework.collections.TreeWithParent;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.log.Logger;

public class MavenPOMLoader
implements LibraryDescriptorLoader {
    private static Logger logger = null;
    private Map<String, Map<String, Map<Version, AsyncWork<MavenPOM, Exception>>>> loadingByName = new HashMap<String, Map<String, Map<Version, AsyncWork<MavenPOM, Exception>>>>();
    private Map<URL, AsyncWork<MavenPOM, Exception>> loadingByLocation = new HashMap<URL, AsyncWork<MavenPOM, Exception>>();
    private List<MavenRepository> repositories = new LinkedList<MavenRepository>();
    private List<MavenRepository> knownRepositories = new LinkedList<MavenRepository>();

    @Override
    public boolean detect(File dir) {
        return new File(dir, "pom.xml").exists();
    }

    @Override
    public AsyncWork<? extends LibraryDescriptor, Exception> loadProject(File dir, byte priority) {
        try {
            return this.loadPOM(new File(dir, "pom.xml").toURI().toURL(), false, priority);
        }
        catch (Exception e) {
            return new AsyncWork<Object, Exception>(null, e);
        }
    }

    public synchronized AsyncWork<MavenPOM, Exception> loadPOM(final URL pomFile, boolean fromRepository, byte priority) {
        AsyncWork<MavenPOM, Exception> result;
        if (logger == null) {
            logger = LCCore.getApplication().getLoggerFactory().getLogger(MavenPOMLoader.class);
        }
        if ((result = this.loadingByLocation.get(pomFile)) != null) {
            return result;
        }
        if (logger.debug()) {
            logger.debug("Loading POM " + pomFile.toString());
        }
        result = new AsyncWork();
        final AsyncWork<MavenPOM, Exception> loadPOM = MavenPOM.load(pomFile, priority, this, fromRepository);
        this.loadingByLocation.put(pomFile, result);
        final AsyncWork<MavenPOM, Exception> res = result;
        loadPOM.listenInline(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (loadPOM.hasError()) {
                    if (logger.error()) {
                        logger.error("Unable to load POM " + pomFile.toString(), (Throwable)loadPOM.getError());
                    }
                    res.error(loadPOM.getError());
                    return;
                }
                MavenPOM pom = (MavenPOM)loadPOM.getResult();
                if (pom != null) {
                    if (logger.debug()) {
                        logger.debug("POM loaded: " + pom.getGroupId() + ':' + pom.getArtifactId() + ':' + pom.getVersionString());
                    }
                    MavenPOMLoader mavenPOMLoader = MavenPOMLoader.this;
                    synchronized (mavenPOMLoader) {
                        AsyncWork resu;
                        HashMap<Version, AsyncWork> artifact;
                        HashMap group = (HashMap)MavenPOMLoader.this.loadingByName.get(pom.getGroupId());
                        if (group == null) {
                            group = new HashMap();
                            MavenPOMLoader.this.loadingByName.put(pom.getGroupId(), group);
                        }
                        if ((artifact = (HashMap<Version, AsyncWork>)group.get(pom.getArtifactId())) == null) {
                            artifact = new HashMap<Version, AsyncWork>();
                            group.put(pom.getArtifactId(), artifact);
                        }
                        if ((resu = (AsyncWork)artifact.get(pom.getVersion())) == null) {
                            artifact.put(pom.getVersion(), res);
                        }
                    }
                }
                res.unblockSuccess(pom);
            }
        });
        return result;
    }

    public synchronized AsyncWork<MavenPOM, Exception> loadLibrary(String groupId, String artifactId, VersionSpecification version, byte priority, List<LibrariesRepository> additionalRepositories) {
        Map<Version, AsyncWork<MavenPOM, Exception>> artifact;
        if (logger == null) {
            logger = LCCore.getApplication().getLoggerFactory().getLogger(MavenPOMLoader.class);
        }
        AbstractList repos = additionalRepositories.isEmpty() ? new ArrayList(this.repositories.size()) : new LinkedList();
        repos.addAll(this.repositories);
        for (LibrariesRepository repo : additionalRepositories) {
            if (!(repo instanceof MavenRepository)) continue;
            repos.add((MavenRepository)repo);
        }
        Map<String, Map<Version, AsyncWork<MavenPOM, Exception>>> group = this.loadingByName.get(groupId);
        if (group == null) {
            group = new HashMap<String, Map<Version, AsyncWork<MavenPOM, Exception>>>();
            this.loadingByName.put(groupId, group);
        }
        if ((artifact = group.get(artifactId)) == null) {
            artifact = new HashMap<Version, AsyncWork<MavenPOM, Exception>>();
            group.put(artifactId, artifact);
        }
        AsyncWork<MavenPOM, Exception> r = null;
        Version rv = null;
        for (Map.Entry<Version, AsyncWork<MavenPOM, Exception>> e : artifact.entrySet()) {
            if (!version.isMatching(e.getKey()) || r != null && version.compare(rv, e.getKey()) >= 0) continue;
            r = e.getValue();
            rv = e.getKey();
        }
        if (r != null) {
            return r;
        }
        AsyncWork<MavenPOM, Exception> result = new AsyncWork<MavenPOM, Exception>();
        this.loadFromRepository(groupId, artifactId, version, priority, repos, 0, artifact, result);
        return result;
    }

    private void loadFromRepository(final String groupId, final String artifactId, final VersionSpecification version, byte priority, List<MavenRepository> repos, int repoIndex, Map<Version, AsyncWork<MavenPOM, Exception>> artifact, final AsyncWork<MavenPOM, Exception> result) {
        if (repoIndex == repos.size()) {
            result.error(new Exception("Artifact not found: " + Artifact.toString(groupId, artifactId, version.toString())));
            return;
        }
        final MavenRepository repo = repos.get(repoIndex);
        if (logger.debug()) {
            logger.debug("Search Maven artifact " + groupId + ':' + artifactId + ':' + version.toString() + " in " + repo.toString());
        }
        AsyncWork<List<String>, NoException> getVersions = repo.getAvailableVersions(groupId, artifactId, priority);
        getVersions.listenAsync(new Task.Cpu.FromRunnable("Search artifact", priority, () -> {
            List versions = (List)getVersions.getResult();
            if (versions == null || versions.isEmpty()) {
                if (logger.debug()) {
                    logger.debug("No version found for artifact " + groupId + ':' + artifactId + ':' + version.toString() + " in " + repo.toString());
                }
                this.loadFromRepository(groupId, artifactId, version, priority, repos, repoIndex + 1, artifact, result);
                return;
            }
            String bestVersionString = null;
            Version bestVersion = null;
            for (String s : versions) {
                Version v = new Version(s);
                if (!version.isMatching(v) || bestVersion != null && version.compare(bestVersion, v) > 0) continue;
                bestVersion = v;
                bestVersionString = s;
            }
            if (bestVersion == null) {
                this.loadFromRepository(groupId, artifactId, version, priority, repos, repoIndex + 1, artifact, result);
                return;
            }
            if (logger.debug()) {
                logger.debug("Version " + bestVersionString + " found for artifact " + groupId + ':' + artifactId + ':' + version.toString() + " in " + repo.toString());
            }
            artifact.put(bestVersion, result);
            final AsyncWork<MavenPOM, Exception> load = repo.load(groupId, artifactId, bestVersionString, this, priority);
            load.listenInline(new Runnable(){

                @Override
                public void run() {
                    if (load.getResult() != null) {
                        if (logger.debug()) {
                            logger.debug("Maven artifact " + groupId + ':' + artifactId + ':' + ((MavenPOM)load.getResult()).getVersionString() + " found in " + repo.toString());
                        }
                        result.unblockSuccess(load.getResult());
                        return;
                    }
                    result.error(new Exception("Artifact not found: " + Artifact.toString(groupId, artifactId, version.toString())));
                }
            });
        }), true);
    }

    public void addRepository(MavenRepository repo) {
        this.repositories.add(repo);
    }

    MavenRepository getRepository(String url, boolean releasesEnabled, boolean snapshotsEnabled) {
        for (MavenRepository repo : this.repositories) {
            if (!repo.isSame(url, releasesEnabled, snapshotsEnabled)) continue;
            return null;
        }
        for (MavenRepository repo : this.knownRepositories) {
            if (!repo.isSame(url, releasesEnabled, snapshotsEnabled)) continue;
            return repo;
        }
        if (url.startsWith("file:/")) {
            try {
                MavenLocalRepository local = new MavenLocalRepository(new File(new URI(url)), releasesEnabled, snapshotsEnabled);
                this.knownRepositories.add(local);
                return local;
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        MavenRemoteRepository remote = new MavenRemoteRepository(url, releasesEnabled, snapshotsEnabled);
        this.knownRepositories.add(remote);
        return remote;
    }

    @Override
    public Version resolveVersionConflict(String groupId, String artifactId, Map<Version, List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>> artifactVersions) {
        Version bestVersion = null;
        int bestDepth = -1;
        for (Map.Entry<Version, List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>> e : artifactVersions.entrySet()) {
            for (TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode> node : e.getValue()) {
                int depth = 0;
                TreeWithParent<LibraryDescriptorLoader.DependencyNode> tree = node.getSubNodes().getParent();
                while (tree.getParent() != null) {
                    ++depth;
                    tree = tree.getParent();
                }
                if (bestVersion != null && depth >= bestDepth) continue;
                bestVersion = e.getKey();
                bestDepth = depth;
            }
        }
        return bestVersion;
    }
}

