/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries.artifacts.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.lecousin.framework.application.Version;
import net.lecousin.framework.application.VersionRange;
import net.lecousin.framework.application.VersionSpecification;
import net.lecousin.framework.application.libraries.artifacts.LibrariesRepository;
import net.lecousin.framework.application.libraries.artifacts.LibraryDescriptor;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenPOMLoader;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenRepository;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.buffering.ByteArrayIO;
import net.lecousin.framework.io.buffering.ByteBuffersIO;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.io.provider.IOProviderFromURL;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.SystemEnvironment;
import net.lecousin.framework.xml.XMLStreamEvents;
import net.lecousin.framework.xml.XMLStreamReader;

public class MavenPOM
implements LibraryDescriptor {
    private MavenPOMLoader loader;
    private URL pomFile;
    private String artifactId;
    private String groupId;
    private String version;
    private String packaging;
    private String parentArtifactId;
    private String parentGroupId;
    private String parentVersion;
    private String parentRelativePath = "../pom.xml";
    private AsyncWork<MavenPOM, Exception> parentLoading;
    private Build build = new Build();
    private Map<String, String> properties = new HashMap<String, String>();
    private List<Dependency> dependencies = new LinkedList<Dependency>();
    private List<Dependency> dependencyManagement = new LinkedList<Dependency>();
    private List<Repository> repositories = new LinkedList<Repository>();
    private List<Profile> profiles = new LinkedList<Profile>();
    private File classesFile = null;

    public static AsyncWork<MavenPOM, Exception> load(final URL pomFile, final byte priority, final MavenPOMLoader pomLoader, final boolean fromRepository) {
        IO.Readable fileIO;
        final AsyncWork<MavenPOM, Exception> result = new AsyncWork<MavenPOM, Exception>();
        IOProvider p = IOProviderFromURL.getInstance().get(pomFile);
        if (p == null) {
            return new AsyncWork<Object, FileNotFoundException>(null, new FileNotFoundException(pomFile.toString()));
        }
        if (!(p instanceof IOProvider.Readable)) {
            return new AsyncWork<Object, IOException>(null, new IOException("File not readable: " + pomFile.toString()));
        }
        try {
            fileIO = ((IOProvider.Readable)p).provideIOReadable(priority);
        }
        catch (IOException e) {
            return new AsyncWork<Object, IOException>(null, e);
        }
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Loading POM", priority){

            @Override
            public Void run() {
                AsyncWork<ByteBuffersIO, IOException> readFile;
                int bufSize;
                if (fileIO instanceof IO.KnownSize) {
                    try {
                        bufSize = (int)((IO.KnownSize)((Object)fileIO)).getSizeSync();
                    }
                    catch (IOException e) {
                        result.error(e);
                        return null;
                    }
                    byte[] buf = new byte[bufSize];
                    readFile = new AsyncWork();
                    fileIO.readFullyAsync(ByteBuffer.wrap(buf)).listenInline(() -> readFile.unblockSuccess((ByteBuffersIO)((Object)new ByteArrayIO(buf, pomFile.toString()))), readFile);
                } else {
                    bufSize = 4096;
                    readFile = IOUtil.readFullyAsync(fileIO, 4096);
                }
                MavenPOM pom = new MavenPOM(pomLoader, pomFile);
                readFile.listenAsync(new Task.Cpu.FromRunnable("Loading POM", priority, () -> {
                    fileIO.closeAsync();
                    if (readFile.hasError()) {
                        result.error(readFile.getError());
                        return;
                    }
                    IO.Readable.Buffered bio = (IO.Readable.Buffered)readFile.getResult();
                    AsyncWork<XMLStreamReader, Exception> startXMLReader = XMLStreamReader.start(bio, bufSize);
                    MavenPOM mavenPOM = pom;
                    mavenPOM.getClass();
                    Reader read = mavenPOM.new Reader(startXMLReader, priority, fromRepository, pomFile, pomLoader);
                    read.startOn(startXMLReader, true);
                    read.getOutput().listenInline(() -> {
                        if (pom.parentLoading == null) {
                            MavenPOM mavenPOM = pom;
                            mavenPOM.getClass();
                            mavenPOM.new Finalize(result, priority).start();
                            return;
                        }
                        pom.parentLoading.listenInline(() -> {
                            MavenPOM mavenPOM = pom;
                            mavenPOM.getClass();
                            mavenPOM.new Finalize(result, priority).start();
                        }, result);
                    }, result);
                }), true);
                return null;
            }
        };
        task.startOn(fileIO.canStartReading(), true);
        return result;
    }

    private MavenPOM(MavenPOMLoader loader, URL pomFile) {
        this.loader = loader;
        this.pomFile = pomFile;
    }

    @Override
    public List<LibrariesRepository> getDependenciesAdditionalRepositories() {
        return this.getRepositories(this.repositories);
    }

    private List<LibrariesRepository> getRepositories(List<Repository> repos) {
        ArrayList<LibrariesRepository> list = new ArrayList<LibrariesRepository>(repos.size());
        for (Repository r : repos) {
            MavenRepository repo;
            if (r.url == null || r.url.trim().isEmpty() || (repo = this.loader.getRepository(r.url, r.releasesEnabled, r.snapshotsEnabled)) == null) continue;
            list.add(repo);
        }
        return list;
    }

    @Override
    public MavenPOMLoader getLoader() {
        return this.loader;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersionString() {
        return this.version;
    }

    @Override
    public Version getVersion() {
        return new Version(this.version);
    }

    @Override
    public URL getDirectory() {
        try {
            return this.pomFile.toURI().resolve(".").toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean hasClasses() {
        return "jar".equals(this.packaging) || "bundle".equals(this.packaging);
    }

    @Override
    public AsyncWork<File, NoException> getClasses() {
        if (!this.hasClasses()) {
            return new AsyncWork<Object, Object>(null, null);
        }
        if (this.classesFile != null) {
            return new AsyncWork<File, Object>(this.classesFile, null);
        }
        if ("file".equals(this.pomFile.getProtocol())) {
            File pf;
            try {
                pf = new File(this.pomFile.toURI());
            }
            catch (URISyntaxException e) {
                return new AsyncWork<Object, Object>(null, null);
            }
            pf = pf.getParentFile();
            if (this.build.outputDirectory != null) {
                File dir = new File(this.build.outputDirectory);
                this.classesFile = dir.isAbsolute() ? dir : new File(pf, this.build.outputDirectory);
            } else {
                File f = new File(pf, this.artifactId + '-' + this.version + ".jar");
                if (f.exists()) {
                    this.classesFile = f;
                } else {
                    f = new File(pf, "target/classes");
                    if (f.exists()) {
                        this.classesFile = f;
                    }
                }
            }
            return new AsyncWork<File, Object>(this.classesFile, null);
        }
        try {
            URI uri = this.pomFile.toURI().resolve(".").resolve(this.artifactId + '-' + this.version + ".jar");
            IOProvider p = IOProviderFromURL.getInstance().get(uri.toURL());
            if (p == null || !(p instanceof IOProvider.Readable)) {
                return new AsyncWork<Object, Object>(null, null);
            }
            IO.Readable io = ((IOProvider.Readable)p).provideIOReadable((byte)2);
            if (io == null) {
                return new AsyncWork<Object, Object>(null, null);
            }
            AsyncWork<File, IOException> download = IOUtil.toTempFile(io);
            AsyncWork<File, NoException> result = new AsyncWork<File, NoException>();
            download.listenInline(() -> {
                if (download.isSuccessful()) {
                    this.classesFile = (File)download.getResult();
                    result.unblockSuccess(this.classesFile);
                } else {
                    result.unblockSuccess(null);
                }
            });
            return result;
        }
        catch (Exception e) {
            return new AsyncWork<Object, Object>(null, null);
        }
    }

    @Override
    public List<LibraryDescriptor.Dependency> getDependencies() {
        ArrayList<LibraryDescriptor.Dependency> list = new ArrayList<LibraryDescriptor.Dependency>(this.dependencies.size());
        for (Dependency dep : this.dependencies) {
            if (dep.scope != null && !"compile".equals(dep.scope)) continue;
            list.add(dep);
        }
        return list;
    }

    public List<LibraryDescriptor.Dependency> getAllDependenciesAnyScope() {
        ArrayList<LibraryDescriptor.Dependency> list = new ArrayList<LibraryDescriptor.Dependency>(this.dependencies.size());
        list.addAll(this.dependencies);
        return list;
    }

    private boolean checkProfile(Profile profile, Map<String, String> finalProperties) {
        if (profile.activationOS != null) {
            String s;
            if (profile.activationOS.name != null) {
                String name = System.getProperty("os.name").toLowerCase(Locale.US);
                s = profile.activationOS.name.toLowerCase();
                if (s.startsWith("!") ? name.equals(s.substring(1)) : !name.equals(s)) {
                    return false;
                }
            }
            if (profile.activationOS.arch != null) {
                String arch = System.getProperty("os.arch").toLowerCase(Locale.US);
                s = profile.activationOS.arch.toLowerCase();
                if (s.startsWith("!") ? arch.equals(s.substring(1)) : !arch.equals(s)) {
                    return false;
                }
            }
            if (profile.activationOS.family != null) {
                SystemEnvironment.OSFamily family = SystemEnvironment.getOSFamily();
                if (family == null) {
                    return false;
                }
                String fam = family.getName();
                String s2 = profile.activationOS.family.toLowerCase();
                if (s2.startsWith("!") ? fam.equals(s2.substring(1)) : !fam.equals(s2)) {
                    return false;
                }
            }
            if (profile.activationOS.version != null) {
                String ver = System.getProperty("os.version").toLowerCase(Locale.US);
                s = profile.activationOS.version.toLowerCase();
                if (s.startsWith("!") ? ver.equals(s.substring(1)) : !ver.equals(s)) {
                    return false;
                }
            }
        }
        if (profile.activationPropertyName != null) {
            if (profile.activationPropertyValue == null) {
                boolean presentExpected;
                String s = profile.activationPropertyName;
                boolean bl = presentExpected = !s.startsWith("!");
                if (!presentExpected) {
                    s = s.substring(1);
                }
                if (presentExpected != this.properties.containsKey(s) && presentExpected != finalProperties.containsKey(s)) {
                    return false;
                }
            } else {
                boolean presentExpected;
                String p1 = this.properties.get(profile.activationPropertyName);
                String p2 = finalProperties.get(profile.activationPropertyName);
                String value = profile.activationPropertyName;
                boolean bl = presentExpected = !value.startsWith("!");
                if (!presentExpected) {
                    value = value.substring(1);
                }
                if (p1 == null) {
                    if (p2 == null) {
                        return false;
                    }
                    if (presentExpected != p2.equals(value)) {
                        return false;
                    }
                }
                if (presentExpected != p1.equals(value)) {
                    if (p2 == null) {
                        return false;
                    }
                    if (presentExpected != p2.equals(value)) {
                        return false;
                    }
                }
            }
        }
        if (profile.activationMissingFile != null) {
            // empty if block
        }
        if (profile.activationFileExists != null) {
            // empty if block
        }
        if (profile.jdk != null) {
            // empty if block
        }
        return true;
    }

    private void addProfile(Profile profile) {
        if (profile.build.outputDirectory != null) {
            this.build.outputDirectory = profile.build.outputDirectory;
        }
        this.properties.putAll(profile.properties);
        this.dependencies.addAll(profile.dependencies);
        this.dependencyManagement.addAll(profile.dependencyManagement);
        this.repositories.addAll(profile.repositories);
    }

    public static VersionSpecification parseVersionSpecification(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return null;
        }
        char c = s.charAt(0);
        if (c == '[') {
            int i = s.indexOf(93);
            boolean excluded = false;
            if (i < 0 && (i = s.indexOf(41)) > 0) {
                excluded = true;
            }
            if (i < 0) {
                return new VersionSpecification.SingleVersion(new Version(s));
            }
            String range = s.substring(1, i).trim();
            if ((i = range.indexOf(44)) < 0) {
                return new VersionSpecification.SingleVersion(new Version(range));
            }
            Version min = new Version(range.substring(0, i).trim());
            Version max = (range = range.substring(i + 1).trim()).length() == 0 && excluded ? null : new Version(range);
            return new VersionSpecification.Range(new VersionRange(min, max, !excluded));
        }
        Version v = new Version(s);
        return new VersionSpecification.RangeWithRecommended(new VersionRange(v, null, false), v);
    }

    private class Finalize
    extends Task.Cpu<Void, NoException> {
        private AsyncWork<MavenPOM, Exception> result;

        public Finalize(AsyncWork<MavenPOM, Exception> result, byte priority) {
            super("Finalize POM loading", priority);
            this.result = result;
        }

        @Override
        public Void run() {
            HashMap<String, String> finalProperties = new HashMap<String, String>();
            if (MavenPOM.this.parentLoading != null) {
                if (MavenPOM.this.parentLoading.hasError()) {
                    this.result.error(new Exception("Error loading parent POM", (Throwable)MavenPOM.this.parentLoading.getError()));
                    return null;
                }
                if (MavenPOM.this.parentLoading.isCancelled()) {
                    this.result.cancel(MavenPOM.this.parentLoading.getCancelEvent());
                    return null;
                }
                MavenPOM parent = (MavenPOM)MavenPOM.this.parentLoading.getResult();
                if (MavenPOM.this.groupId == null) {
                    MavenPOM.this.groupId = parent.groupId;
                }
                if (MavenPOM.this.version == null) {
                    MavenPOM.this.version = parent.version;
                }
                for (Map.Entry p : parent.properties.entrySet()) {
                    if (MavenPOM.this.properties.containsKey(p.getKey())) continue;
                    finalProperties.put((String)p.getKey(), (String)p.getValue());
                }
                for (Dependency pdm : parent.dependencyManagement) {
                    if (pdm.groupId == null || pdm.artifactId == null) continue;
                    boolean found = false;
                    for (Dependency dm : MavenPOM.this.dependencyManagement) {
                        if (dm.groupId == null || dm.artifactId == null || !dm.groupId.equals(pdm.groupId) || !dm.artifactId.equals(pdm.artifactId)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    MavenPOM.this.dependencyManagement.add(pdm);
                }
            }
            this.resolveProperties(MavenPOM.this.properties, finalProperties);
            Profile defaultProfile = null;
            LinkedList<Profile> activeProfiles = new LinkedList<Profile>();
            for (Profile profile : MavenPOM.this.profiles) {
                if (MavenPOM.this.checkProfile(profile, finalProperties)) {
                    activeProfiles.add(profile);
                    continue;
                }
                if (!profile.activeByDefault || defaultProfile != null) continue;
                defaultProfile = profile;
            }
            if (activeProfiles.isEmpty() && defaultProfile != null) {
                activeProfiles.add(defaultProfile);
            }
            for (Profile p : activeProfiles) {
                MavenPOM.this.addProfile(p);
            }
            this.resolveProperties(MavenPOM.this.properties, finalProperties);
            MavenPOM.this.properties = finalProperties;
            MavenPOM.this.groupId = this.resolve(MavenPOM.this.groupId, finalProperties);
            MavenPOM.this.artifactId = this.resolve(MavenPOM.this.artifactId, finalProperties);
            MavenPOM.this.version = this.resolve(MavenPOM.this.version, finalProperties);
            if (MavenPOM.this.packaging == null) {
                MavenPOM.this.packaging = "jar";
            }
            MavenPOM.this.build.outputDirectory = this.resolve(MavenPOM.this.build.outputDirectory, finalProperties);
            this.resolveDependencies(MavenPOM.this.dependencies, finalProperties);
            this.resolveDependencies(MavenPOM.this.dependencyManagement, finalProperties);
            this.resolveRepositories(MavenPOM.this.repositories, finalProperties);
            for (Dependency dep : MavenPOM.this.dependencies) {
                if (dep.groupId == null || dep.artifactId == null) continue;
                for (Dependency dm : MavenPOM.this.dependencyManagement) {
                    if (!dep.groupId.equals(dm.groupId) || !dep.artifactId.equals(dm.artifactId) || dm.version == null) continue;
                    dep.version = dm.version;
                }
            }
            this.result.unblockSuccess(MavenPOM.this);
            return null;
        }

        private void resolveDependencies(List<Dependency> deps, Map<String, String> props) {
            for (Dependency dep : deps) {
                dep.groupId = this.resolve(dep.groupId, props);
                dep.artifactId = this.resolve(dep.artifactId, props);
                dep.version = this.resolve(dep.version, props);
                dep.scope = this.resolve(dep.scope, props);
                dep.type = this.resolve(dep.type, props);
                dep.classifier = this.resolve(dep.classifier, props);
                dep.systemPath = this.resolve(dep.systemPath, props);
                for (Pair e : dep.exclusions) {
                    e.setValue1(this.resolve((String)e.getValue1(), props));
                    e.setValue2(this.resolve((String)e.getValue2(), props));
                }
            }
        }

        private void resolveRepositories(List<Repository> repos, Map<String, String> props) {
            for (Repository repo : repos) {
                repo.url = this.resolve(repo.url, props);
            }
        }

        private void resolveProperties(Map<String, String> toResolve, Map<String, String> resolved) {
            while (!toResolve.isEmpty()) {
                boolean changed = false;
                Iterator<Map.Entry<String, String>> it = toResolve.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> p = it.next();
                    String value = this.resolve(p.getValue(), resolved);
                    if (value == null) continue;
                    changed = true;
                    resolved.put(p.getKey(), value);
                    it.remove();
                }
                if (changed) continue;
                break;
            }
        }

        private String resolve(String value, Map<String, String> properties) {
            if (value == null) {
                return null;
            }
            int i = value.indexOf("${");
            if (i < 0) {
                return value;
            }
            int j = value.indexOf(125, i + 2);
            if (j < 0) {
                return value;
            }
            String name = value.substring(i + 2, j).trim();
            if (properties.containsKey(name)) {
                StringBuffer s = new StringBuffer();
                if (i > 0) {
                    s.append(value.substring(0, i));
                }
                s.append(properties.get(name));
                if (j < value.length() - 1) {
                    s.append(value.substring(j + 1));
                }
                return this.resolve(s.toString(), properties);
            }
            if (name.equals("project.groupId")) {
                if (MavenPOM.this.groupId != null) {
                    return MavenPOM.this.groupId;
                }
                return null;
            }
            if (name.equals("project.artifactId")) {
                if (MavenPOM.this.artifactId != null) {
                    return MavenPOM.this.artifactId;
                }
                return null;
            }
            if (name.equals("project.version")) {
                if (MavenPOM.this.version != null) {
                    return MavenPOM.this.version;
                }
                return null;
            }
            if (name.equals("parent.groupId")) {
                if (MavenPOM.this.parentLoading != null) {
                    return ((MavenPOM)MavenPOM.this.parentLoading.getResult()).groupId;
                }
                return null;
            }
            if (name.equals("parent.artifactId")) {
                if (MavenPOM.this.parentLoading != null) {
                    return ((MavenPOM)MavenPOM.this.parentLoading.getResult()).artifactId;
                }
                return null;
            }
            if (name.equals("parent.version")) {
                if (MavenPOM.this.parentLoading != null) {
                    return ((MavenPOM)MavenPOM.this.parentLoading.getResult()).version;
                }
                return null;
            }
            if (name.startsWith("env.")) {
                return System.getenv(name.substring(4));
            }
            if (name.startsWith("settings.")) {
                return null;
            }
            return System.getProperty(name);
        }
    }

    private class Reader
    extends Task.Cpu<Void, Exception> {
        private AsyncWork<XMLStreamReader, Exception> startXMLReader;
        private boolean fromRepository;
        private URL pomFile;
        private MavenPOMLoader pomLoader;

        private Reader(AsyncWork<XMLStreamReader, Exception> startXMLReader, byte priority, boolean fromRepository, URL pomFile, MavenPOMLoader pomLoader) {
            super("Read POM " + pomFile.toString(), priority);
            this.startXMLReader = startXMLReader;
            this.fromRepository = fromRepository;
            this.pomFile = pomFile;
            this.pomLoader = pomLoader;
        }

        @Override
        public Void run() throws Exception {
            if (this.startXMLReader.hasError()) {
                throw this.startXMLReader.getError();
            }
            if (this.startXMLReader.isCancelled()) {
                throw this.startXMLReader.getCancelEvent();
            }
            XMLStreamReader xml = this.startXMLReader.getResult();
            while (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)xml.event.type)) {
                xml.next();
            }
            if (!xml.event.text.equals("project")) {
                throw new Exception("Invalid POM: root element must be a project");
            }
            while (xml.nextStartElement()) {
                if (xml.event.text.equals("artifactId")) {
                    MavenPOM.this.artifactId = xml.readInnerText().trim().asString();
                    continue;
                }
                if (xml.event.text.equals("groupId")) {
                    MavenPOM.this.groupId = xml.readInnerText().trim().asString();
                    continue;
                }
                if (xml.event.text.equals("version")) {
                    MavenPOM.this.version = xml.readInnerText().trim().asString();
                    continue;
                }
                if (xml.event.text.equals("packaging")) {
                    MavenPOM.this.packaging = xml.readInnerText().trim().asString();
                    continue;
                }
                if (xml.event.text.equals("parent")) {
                    this.readParent(xml);
                    continue;
                }
                if (xml.event.text.equals("build")) {
                    this.readBuild(xml, MavenPOM.this.build);
                    continue;
                }
                if (xml.event.text.equals("properties")) {
                    this.readProperties(xml, MavenPOM.this.properties);
                    continue;
                }
                if (xml.event.text.equals("dependencyManagement")) {
                    this.readDependencyManagement(xml, MavenPOM.this.dependencyManagement);
                    continue;
                }
                if (xml.event.text.equals("dependencies")) {
                    this.readDependencies(xml, MavenPOM.this.dependencies);
                    continue;
                }
                if (xml.event.text.equals("profiles")) {
                    this.readProfiles(xml);
                    continue;
                }
                if (xml.event.text.equals("repositories")) {
                    this.readRepositories(xml, MavenPOM.this.repositories);
                    continue;
                }
                xml.closeElement();
            }
            if (MavenPOM.this.parentGroupId != null) {
                File parentFile;
                if (!this.fromRepository && (parentFile = new File(new File(this.pomFile.toURI()).getParentFile(), MavenPOM.this.parentRelativePath)).exists()) {
                    if (parentFile.isDirectory()) {
                        if ((parentFile = new File(parentFile, "pom.xml")).exists()) {
                            MavenPOM.this.parentLoading = this.pomLoader.loadPOM(parentFile.toURI().toURL(), false, this.getPriority());
                        }
                    } else {
                        MavenPOM.this.parentLoading = this.pomLoader.loadPOM(parentFile.toURI().toURL(), false, this.getPriority());
                    }
                }
                if (MavenPOM.this.parentLoading == null) {
                    MavenPOM.this.parentLoading = this.pomLoader.loadLibrary(MavenPOM.this.parentGroupId, MavenPOM.this.parentArtifactId, new VersionSpecification.SingleVersion(new Version(MavenPOM.this.parentVersion)), this.getPriority(), MavenPOM.this.getRepositories(MavenPOM.this.repositories));
                }
            }
            return null;
        }

        private void readParent(XMLStreamReader xml) throws Exception {
            if (xml.event.isClosed) {
                return;
            }
            XMLStreamEvents.ElementContext ctx = xml.event.context.getFirst();
            while (true) {
                if (!xml.nextInnerElement(ctx)) {
                    if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)xml.event.type)) break;
                    throw new Exception("Invalid POM: missing closing parent tag");
                }
                if (xml.event.text.equals("artifactId")) {
                    MavenPOM.this.parentArtifactId = xml.readInnerText().trim().asString();
                    continue;
                }
                if (xml.event.text.equals("groupId")) {
                    MavenPOM.this.parentGroupId = xml.readInnerText().trim().asString();
                    continue;
                }
                if (xml.event.text.equals("version")) {
                    MavenPOM.this.parentVersion = xml.readInnerText().trim().asString();
                    continue;
                }
                if (xml.event.text.equals("relativePath")) {
                    MavenPOM.this.parentRelativePath = xml.readInnerText().trim().asString();
                    continue;
                }
                xml.closeElement();
            }
        }

        private void readBuild(XMLStreamReader xml, Build build) throws Exception {
            if (xml.event.isClosed) {
                return;
            }
            XMLStreamEvents.ElementContext ctx = xml.event.context.getFirst();
            while (true) {
                if (!xml.nextInnerElement(ctx)) {
                    if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)xml.event.type)) break;
                    throw new Exception("Invalid POM: missing closing build tag");
                }
                if (xml.event.text.equals("outputDirectory")) {
                    build.outputDirectory = xml.readInnerText().trim().asString();
                    continue;
                }
                xml.closeElement();
            }
        }

        private void readProperties(XMLStreamReader xml, Map<String, String> properties) throws Exception {
            if (xml.event.isClosed) {
                return;
            }
            XMLStreamEvents.ElementContext ctx = xml.event.context.getFirst();
            while (true) {
                if (!xml.nextInnerElement(ctx)) {
                    if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)xml.event.type)) break;
                    throw new Exception("Invalid POM: missing closing properties tag");
                }
                properties.put(xml.event.text.asString(), xml.readInnerText().asString());
            }
        }

        private void readDependencyManagement(XMLStreamReader xml, List<Dependency> dependencyManagement) throws Exception {
            if (xml.event.isClosed) {
                return;
            }
            XMLStreamEvents.ElementContext ctx = xml.event.context.getFirst();
            while (true) {
                if (!xml.nextInnerElement(ctx)) {
                    if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)xml.event.type)) break;
                    throw new Exception("Invalid POM: missing closing dependencyManagement tag");
                }
                if (!xml.event.text.equals("dependencies")) {
                    xml.closeElement();
                    continue;
                }
                this.readDependencies(xml, dependencyManagement);
            }
        }

        private void readDependencies(XMLStreamReader xml, List<Dependency> dependencies) throws Exception {
            if (xml.event.isClosed) {
                return;
            }
            XMLStreamEvents.ElementContext ctx = xml.event.context.getFirst();
            while (true) {
                if (!xml.nextInnerElement(ctx)) {
                    if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)xml.event.type)) break;
                    throw new Exception("Invalid POM: missing closing dependencies tag");
                }
                if (!xml.event.text.equals("dependency")) {
                    xml.closeElement();
                    continue;
                }
                Dependency dep = new Dependency();
                XMLStreamEvents.ElementContext depCtx = xml.event.context.getFirst();
                while (xml.nextInnerElement(depCtx)) {
                    if (xml.event.text.equals("groupId")) {
                        dep.groupId = xml.readInnerText().trim().asString();
                        continue;
                    }
                    if (xml.event.text.equals("artifactId")) {
                        dep.artifactId = xml.readInnerText().trim().asString();
                        continue;
                    }
                    if (xml.event.text.equals("version")) {
                        dep.version = xml.readInnerText().trim().asString();
                        continue;
                    }
                    if (xml.event.text.equals("type")) {
                        dep.type = xml.readInnerText().trim().asString();
                        continue;
                    }
                    if (xml.event.text.equals("classifier")) {
                        dep.classifier = xml.readInnerText().trim().asString();
                        continue;
                    }
                    if (xml.event.text.equals("scope")) {
                        dep.scope = xml.readInnerText().trim().asString();
                        continue;
                    }
                    if (xml.event.text.equals("systemPath")) {
                        dep.systemPath = xml.readInnerText().trim().asString();
                        continue;
                    }
                    if (xml.event.text.equals("optional")) {
                        dep.optional = xml.readInnerText().trim().equals("true");
                        continue;
                    }
                    if (xml.event.text.equals("exclusions")) {
                        this.readExclusions(xml, dep.exclusions);
                        continue;
                    }
                    xml.closeElement();
                }
                dependencies.add(dep);
            }
        }

        private void readExclusions(XMLStreamReader xml, List<Pair<String, String>> exclusions) throws Exception {
            if (xml.event.isClosed) {
                return;
            }
            XMLStreamEvents.ElementContext ctx = xml.event.context.getFirst();
            while (true) {
                if (!xml.nextInnerElement(ctx)) {
                    if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)xml.event.type)) break;
                    throw new Exception("Invalid POM: missing closing exclusions tag");
                }
                if (!xml.event.text.equals("exclusion")) {
                    xml.closeElement();
                    continue;
                }
                Pair<Object, Object> e = new Pair<Object, Object>(null, null);
                XMLStreamEvents.ElementContext excluCtx = xml.event.context.getFirst();
                while (xml.nextInnerElement(excluCtx)) {
                    if (xml.event.text.equals("groupId")) {
                        e.setValue1(xml.readInnerText().trim().asString());
                        continue;
                    }
                    if (xml.event.text.equals("artifactId")) {
                        e.setValue2(xml.readInnerText().trim().asString());
                        continue;
                    }
                    xml.closeElement();
                }
                if (((String)e.getValue1()).equals("*")) {
                    e.setValue1(null);
                }
                if (((String)e.getValue2()).equals("*")) {
                    e.setValue2(null);
                }
                exclusions.add(e);
            }
        }

        private void readProfiles(XMLStreamReader xml) throws Exception {
            if (xml.event.isClosed) {
                return;
            }
            XMLStreamEvents.ElementContext ctx = xml.event.context.getFirst();
            while (true) {
                if (!xml.nextInnerElement(ctx)) {
                    if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)xml.event.type)) break;
                    throw new Exception("Invalid POM: missing closing profiles tag");
                }
                if (!xml.event.text.equals("profile")) {
                    xml.closeElement();
                    continue;
                }
                Profile profile = this.readProfile(xml);
                if (profile == null) continue;
                MavenPOM.this.profiles.add(profile);
            }
        }

        private Profile readProfile(XMLStreamReader xml) throws Exception {
            if (xml.event.isClosed) {
                return null;
            }
            Profile profile = new Profile();
            XMLStreamEvents.ElementContext ctx = xml.event.context.getFirst();
            block0: while (true) {
                if (!xml.nextInnerElement(ctx)) {
                    if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)xml.event.type)) break;
                    throw new Exception("Invalid POM: missing closing profile tag");
                }
                if (xml.event.text.equals("activation")) {
                    XMLStreamEvents.ElementContext ctxActivation = xml.event.context.getFirst();
                    block1: while (true) {
                        if (!xml.nextInnerElement(ctxActivation)) continue block0;
                        if (xml.event.text.equals("activeByDefault")) {
                            if (!xml.readInnerText().trim().equals("true")) continue;
                            profile.activeByDefault = true;
                            continue;
                        }
                        if (xml.event.text.equals("jdk")) {
                            profile.jdk = xml.readInnerText().trim().asString();
                            continue;
                        }
                        if (xml.event.text.equals("os")) {
                            profile.activationOS = new ActivationOS();
                            XMLStreamEvents.ElementContext ctxOS = xml.event.context.getFirst();
                            while (true) {
                                if (!xml.nextInnerElement(ctxOS)) continue block1;
                                if (xml.event.text.equals("name")) {
                                    profile.activationOS.name = xml.readInnerText().trim().asString();
                                    continue;
                                }
                                if (xml.event.text.equals("family")) {
                                    profile.activationOS.family = xml.readInnerText().trim().asString();
                                    continue;
                                }
                                if (xml.event.text.equals("arch")) {
                                    profile.activationOS.arch = xml.readInnerText().trim().asString();
                                    continue;
                                }
                                if (xml.event.text.equals("version")) {
                                    profile.activationOS.version = xml.readInnerText().trim().asString();
                                    continue;
                                }
                                xml.closeElement();
                            }
                        }
                        if (xml.event.text.equals("property")) {
                            XMLStreamEvents.ElementContext ctxProperty = xml.event.context.getFirst();
                            while (true) {
                                if (!xml.nextInnerElement(ctxProperty)) continue block1;
                                if (xml.event.text.equals("name")) {
                                    profile.activationPropertyName = xml.readInnerText().trim().asString();
                                    continue;
                                }
                                if (xml.event.text.equals("value")) {
                                    profile.activationPropertyValue = xml.readInnerText().trim().asString();
                                    continue;
                                }
                                xml.closeElement();
                            }
                        }
                        if (xml.event.text.equals("file")) {
                            XMLStreamEvents.ElementContext ctxFile = xml.event.context.getFirst();
                            while (true) {
                                if (!xml.nextInnerElement(ctxFile)) continue block1;
                                if (xml.event.text.equals("missing")) {
                                    profile.activationMissingFile = xml.readInnerText().trim().asString();
                                    continue;
                                }
                                if (xml.event.text.equals("exists")) {
                                    profile.activationFileExists = xml.readInnerText().trim().asString();
                                    continue;
                                }
                                xml.closeElement();
                            }
                        }
                        xml.closeElement();
                    }
                }
                if (xml.event.text.equals("build")) {
                    this.readBuild(xml, profile.build);
                    continue;
                }
                if (xml.event.text.equals("properties")) {
                    this.readProperties(xml, profile.properties);
                    continue;
                }
                if (xml.event.text.equals("dependencyManagement")) {
                    this.readDependencyManagement(xml, profile.dependencyManagement);
                    continue;
                }
                if (xml.event.text.equals("dependencies")) {
                    this.readDependencies(xml, profile.dependencies);
                    continue;
                }
                if (xml.event.text.equals("repositories")) {
                    this.readRepositories(xml, profile.repositories);
                    continue;
                }
                xml.closeElement();
            }
            return profile;
        }

        private void readRepositories(XMLStreamReader xml, List<Repository> repositories) throws Exception {
            if (xml.event.isClosed) {
                return;
            }
            XMLStreamEvents.ElementContext ctx = xml.event.context.getFirst();
            while (true) {
                if (!xml.nextInnerElement(ctx)) {
                    if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)xml.event.type)) break;
                    throw new Exception("Invalid POM: missing closing repositories tag");
                }
                if (!xml.event.text.equals("repository")) {
                    xml.closeElement();
                    continue;
                }
                Repository repo = this.readRepository(xml);
                if (repo == null) continue;
                repositories.add(repo);
            }
        }

        private Repository readRepository(XMLStreamReader xml) throws Exception {
            if (xml.event.isClosed) {
                return null;
            }
            XMLStreamEvents.ElementContext ctx = xml.event.context.getFirst();
            Repository repo = new Repository();
            block0: while (true) {
                String s;
                if (!xml.nextInnerElement(ctx)) {
                    if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)xml.event.type)) break;
                    throw new Exception("Invalid POM: missing closing repository tag");
                }
                if (xml.event.text.equals("id")) continue;
                if (xml.event.text.equals("url")) {
                    repo.url = xml.readInnerText().trim().asString();
                    continue;
                }
                if (xml.event.text.equals("releases")) {
                    if (xml.event.isClosed) continue;
                    while (true) {
                        if (!xml.nextInnerElement(ctx)) {
                            if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)xml.event.type)) continue block0;
                            throw new Exception("Invalid POM: missing closing releases tag");
                        }
                        if (!xml.event.text.equals("enabled") || !(s = xml.readInnerText().trim().asString()).equalsIgnoreCase("false")) continue;
                        repo.releasesEnabled = false;
                    }
                }
                if (xml.event.text.equals("snapshots")) {
                    if (xml.event.isClosed) continue;
                    while (true) {
                        if (!xml.nextInnerElement(ctx)) {
                            if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)xml.event.type)) continue block0;
                            throw new Exception("Invalid POM: missing closing snapshots tag");
                        }
                        if (!xml.event.text.equals("enabled") || !(s = xml.readInnerText().trim().asString()).equalsIgnoreCase("false")) continue;
                        repo.snapshotsEnabled = false;
                    }
                }
                xml.closeElement();
            }
            return repo;
        }
    }

    private static class ActivationOS {
        private String name;
        private String family;
        private String arch;
        private String version;

        private ActivationOS() {
        }
    }

    private static class Profile {
        private boolean activeByDefault = false;
        private String jdk = null;
        private ActivationOS activationOS;
        private String activationPropertyName;
        private String activationPropertyValue;
        private String activationMissingFile;
        private String activationFileExists;
        private Build build = new Build();
        private Map<String, String> properties = new HashMap<String, String>();
        private List<Dependency> dependencyManagement = new LinkedList<Dependency>();
        private List<Dependency> dependencies = new LinkedList<Dependency>();
        private List<Repository> repositories = new LinkedList<Repository>();

        private Profile() {
        }
    }

    private static class Repository {
        private String url;
        private boolean releasesEnabled = true;
        private boolean snapshotsEnabled = true;

        private Repository() {
        }
    }

    public class Dependency
    implements LibraryDescriptor.Dependency {
        private String groupId;
        private String artifactId;
        private String version;
        private String type;
        private String classifier;
        private String scope;
        private String systemPath;
        private boolean optional = false;
        private List<Pair<String, String>> exclusions = new LinkedList<Pair<String, String>>();

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getArtifactId() {
            return this.artifactId;
        }

        @Override
        public VersionSpecification getVersionSpecification() {
            return MavenPOM.parseVersionSpecification(this.version);
        }

        @Override
        public String getClassifier() {
            return this.classifier;
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }

        @Override
        public URL getKnownLocation() {
            if (this.systemPath == null) {
                return null;
            }
            try {
                URI uri = new URI(this.systemPath);
                if (uri.isAbsolute()) {
                    return uri.toURL();
                }
                URI pomURI = MavenPOM.this.pomFile.toURI();
                URI parent = pomURI.resolve(".");
                return parent.resolve(this.systemPath).toURL();
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public List<Pair<String, String>> getExcludedDependencies() {
            return this.exclusions;
        }
    }

    private static class Build {
        private String outputDirectory;

        private Build() {
        }
    }
}

