/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.launcher;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.ApplicationBootstrap;
import net.lecousin.framework.application.ApplicationClassLoader;
import net.lecousin.framework.application.ApplicationConfiguration;
import net.lecousin.framework.application.Artifact;
import net.lecousin.framework.application.SplashScreen;
import net.lecousin.framework.application.Version;
import net.lecousin.framework.application.VersionSpecification;
import net.lecousin.framework.application.libraries.artifacts.ArtifactsLibrariesManager;
import net.lecousin.framework.application.libraries.artifacts.LibrariesRepository;
import net.lecousin.framework.application.libraries.artifacts.LibraryDescriptor;
import net.lecousin.framework.application.libraries.artifacts.LibraryDescriptorLoader;
import net.lecousin.framework.application.libraries.artifacts.LoadedLibrary;
import net.lecousin.framework.application.libraries.classloader.AbstractClassLoader;
import net.lecousin.framework.application.libraries.classloader.AppClassLoader;
import net.lecousin.framework.application.libraries.classpath.LoadLibraryExtensionPointsFile;
import net.lecousin.framework.application.libraries.classpath.LoadLibraryPluginsFile;
import net.lecousin.framework.collections.TreeWithParent;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.concurrent.tasks.drives.FullReadFileTask;
import net.lecousin.framework.event.Listener;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.PreBufferedReadable;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.io.provider.IOProviderFromPathUsingClassloader;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.mutable.MutableInteger;
import net.lecousin.framework.plugins.CustomExtensionPoint;
import net.lecousin.framework.plugins.ExtensionPoints;
import net.lecousin.framework.progress.FakeWorkProgress;
import net.lecousin.framework.progress.WorkProgress;
import net.lecousin.framework.util.Filter;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.Triple;

public class DynamicLibrariesManager
implements ArtifactsLibrariesManager {
    private Application app;
    private File appDir;
    private AppClassLoader appClassLoader;
    private ArrayList<File> devPaths;
    private SplashScreen splash;
    private List<LibraryDescriptorLoader> loaders;
    private JoinPoint<Exception> canStartApp = new JoinPoint();
    private Lib appLib;
    private ApplicationConfiguration appCfg;
    private List<Triple<String, String, String>> loadPlugins;
    private Map<String, Lib> libraries = new HashMap<String, Lib>();

    public DynamicLibrariesManager(ArrayList<File> devPaths, SplashScreen splash, List<LibraryDescriptorLoader> loaders, File appDir, ApplicationConfiguration cfg, List<Triple<String, String, String>> plugins) {
        this.devPaths = devPaths;
        this.splash = splash;
        this.loaders = loaders;
        this.appCfg = cfg;
        this.loadPlugins = plugins;
        this.appDir = appDir;
    }

    @Override
    public ApplicationClassLoader start(Application app) {
        this.app = app;
        this.appClassLoader = new AppClassLoader(app);
        app.getDefaultLogger().debug("Start loading application in development mode");
        long work = this.splash != null ? this.splash.getRemainingWork() : 0L;
        work -= work * 40L / 100L;
        long stepDevProjects = this.devPaths != null ? work / 20L : 0L;
        long stepDependencies = work * (long)(this.devPaths != null ? 80 : 85) / 100L;
        long stepVersionConflicts = work - stepDevProjects - stepDependencies;
        if (this.splash != null) {
            if (this.appCfg.splash != null) {
                File splashFile = new File(this.appDir, this.appCfg.splash);
                if (splashFile.exists()) {
                    final FullReadFileTask read = new FullReadFileTask(splashFile, 1);
                    read.start();
                    Task.Cpu<Void, NoException> load = new Task.Cpu<Void, NoException>("Loading splash image", 1){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Void run() {
                            ImageIcon img = new ImageIcon((byte[])read.getResult());
                            if (DynamicLibrariesManager.this.splash == null) {
                                return null;
                            }
                            SplashScreen splashScreen = DynamicLibrariesManager.this.splash;
                            synchronized (splashScreen) {
                                if (!DynamicLibrariesManager.this.splash.isReady()) {
                                    try {
                                        DynamicLibrariesManager.this.splash.wait();
                                    }
                                    catch (InterruptedException e) {
                                        return null;
                                    }
                                }
                            }
                            DynamicLibrariesManager.this.splash.setLogo(img, true);
                            return null;
                        }
                    };
                    read.ondone(load, false);
                } else {
                    this.splash.loadDefaultLogo();
                }
            } else {
                this.splash.loadDefaultLogo();
            }
        }
        if (this.devPaths != null) {
            this.developmentMode(stepDevProjects, stepDependencies, stepVersionConflicts);
        } else {
            this.productionMode(stepDependencies, stepVersionConflicts);
        }
        return this.appClassLoader;
    }

    private void developmentMode(final long stepDevProjects, final long stepDependencies, final long stepVersionConflicts) {
        if (this.splash != null) {
            this.splash.setText("Analyzing development projects");
        }
        final JoinPoint<Exception> jpDevProjects = new JoinPoint<Exception>();
        final ArrayList devProjects = new ArrayList(this.devPaths.size());
        Task.Cpu<Void, NoException> loadDevProjects = new Task.Cpu<Void, NoException>("Load development projects", 2){

            @Override
            public Void run() {
                int nb = DynamicLibrariesManager.this.devPaths.size();
                long w = stepDevProjects;
                for (File dir : DynamicLibrariesManager.this.devPaths) {
                    final long step = w / (long)nb--;
                    w -= step;
                    AsyncWork<? extends LibraryDescriptor, Exception> load = null;
                    for (LibraryDescriptorLoader loader : DynamicLibrariesManager.this.loaders) {
                        if (!loader.detect(dir)) continue;
                        load = loader.loadProject(dir, (byte)2);
                        break;
                    }
                    if (load == null) {
                        DynamicLibrariesManager.this.app.getDefaultLogger().error("Unknown type of project: " + dir.getAbsolutePath());
                        if (DynamicLibrariesManager.this.splash == null) continue;
                        DynamicLibrariesManager.this.splash.progress(step);
                        continue;
                    }
                    if (DynamicLibrariesManager.this.splash != null) {
                        load.listenInline(new Runnable(){

                            @Override
                            public void run() {
                                DynamicLibrariesManager.this.splash.progress(step);
                            }
                        });
                    }
                    devProjects.add(load);
                    jpDevProjects.addToJoin(load);
                }
                jpDevProjects.start();
                DynamicLibrariesManager.this.devPaths = null;
                return null;
            }
        };
        loadDevProjects.start();
        jpDevProjects.listenAsync(new Task.Cpu<Void, NoException>("Load application libraries", 2){

            @Override
            public Void run() {
                LibraryDescriptor appLib = null;
                for (AsyncWork p : devProjects) {
                    LibraryDescriptor lib = (LibraryDescriptor)p.getResult();
                    if (lib == null || !DynamicLibrariesManager.this.app.getGroupId().equals(lib.getGroupId()) || !DynamicLibrariesManager.this.app.getArtifactId().equals(lib.getArtifactId())) continue;
                    appLib = lib;
                    break;
                }
                if (appLib == null) {
                    DynamicLibrariesManager.this.canStartApp.error(new Exception("Cannot find application " + DynamicLibrariesManager.this.app.getGroupId() + ':' + DynamicLibrariesManager.this.app.getArtifactId()));
                    return null;
                }
                if (!appLib.hasClasses()) {
                    DynamicLibrariesManager.this.canStartApp.error(new Exception("Application project must provide classes"));
                    return null;
                }
                DynamicLibrariesManager.this.app.getDefaultLogger().debug("Development projects analyzed, loading application");
                LinkedList<LibraryDescriptor> addPlugins = new LinkedList<LibraryDescriptor>();
                for (Triple t : DynamicLibrariesManager.this.loadPlugins) {
                    for (AsyncWork p : devProjects) {
                        LibraryDescriptor lib = (LibraryDescriptor)p.getResult();
                        if (!lib.getGroupId().equals(t.getValue1()) || t.getValue2() != null && !lib.getArtifactId().equals(t.getValue2()) || t.getValue3() != null && !lib.getVersionString().equals(t.getValue3())) continue;
                        addPlugins.add(lib);
                    }
                }
                DynamicLibrariesManager.this.loadApplicationLibrary(appLib, addPlugins, stepDependencies, stepVersionConflicts);
                return null;
            }
        }, this.canStartApp);
    }

    private void productionMode(long stepDependencies, long stepVersionConflicts) {
        this.searchApplication(0, stepDependencies, stepVersionConflicts);
    }

    private void searchApplication(int loaderIndex, long stepDependencies, long stepVersionConflicts) {
        if (loaderIndex == this.loaders.size()) {
            this.canStartApp.error(new Exception("Application nout found"));
            return;
        }
        AsyncWork<? extends LibraryDescriptor, Exception> load = this.loaders.get(loaderIndex).loadLibrary(this.app.getGroupId(), this.app.getArtifactId(), new VersionSpecification.SingleVersion(this.app.getVersion()), (byte)2, new ArrayList<LibrariesRepository>(0));
        load.listenInline(() -> {
            if (!load.isSuccessful() || load.getResult() == null) {
                this.searchApplication(loaderIndex + 1, stepDependencies, stepVersionConflicts);
                return;
            }
            LibraryDescriptor appLib = (LibraryDescriptor)load.getResult();
            if (!appLib.hasClasses()) {
                this.canStartApp.error(new Exception("Application project must provide classes"));
                return;
            }
            this.app.getDefaultLogger().debug("Loading application");
            LinkedList<LibraryDescriptor> addPlugins = new LinkedList<LibraryDescriptor>();
            this.loadApplicationLibrary(appLib, addPlugins, stepDependencies, stepVersionConflicts);
        });
    }

    private void loadApplicationLibrary(final LibraryDescriptor descr, final List<LibraryDescriptor> addPlugins, long stepDependencies, long stepVersionConflicts) {
        this.app.getDefaultLogger().debug("Building dependencies tree");
        if (this.splash != null) {
            this.splash.setText("Analyzing dependencies");
        }
        TreeWithParent<LibraryDescriptorLoader.DependencyNode> tree = new TreeWithParent<LibraryDescriptorLoader.DependencyNode>(null);
        HashMap<String, Map<String, List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>>> artifacts = new HashMap<String, Map<String, List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>>>();
        JoinPoint<NoException> treeDone = new JoinPoint<NoException>();
        this.buildDependenciesTree(descr, tree, artifacts, new ArrayList<Pair<String, String>>(0), treeDone, addPlugins, this.splash, stepDependencies);
        treeDone.start();
        final ResolveVersionConflicts resolveConflicts = new ResolveVersionConflicts(artifacts, descr.getLoader(), this.splash, stepVersionConflicts);
        resolveConflicts.startOn(treeDone, true);
        resolveConflicts.getOutput().listenInline(new Runnable(){

            @Override
            public void run() {
                DynamicLibrariesManager.this.app.getDefaultLogger().debug("Dependencies analyzed, loading and initializing libraries");
                if (DynamicLibrariesManager.this.splash != null) {
                    DynamicLibrariesManager.this.splash.setText("Initializing libraries");
                }
                Lib lib = new Lib();
                lib.descr = descr;
                DynamicLibrariesManager.this.libraries.put(descr.getGroupId() + ':' + descr.getArtifactId(), lib);
                DynamicLibrariesManager.this.appLib = lib;
                new LoadLibrary(lib, (Map)resolveConflicts.getResult(), addPlugins).start();
                lib.load.listenAsync(new Task.Cpu<Void, NoException>("Finishing to initialize", 2){

                    @Override
                    public Void run() {
                        if (DynamicLibrariesManager.this.canStartApp.hasError()) {
                            return null;
                        }
                        DynamicLibrariesManager.this.app.getDefaultLogger().debug("Libraries initialized.");
                        ExtensionPoints.allPluginsLoaded();
                        DynamicLibrariesManager.this.canStartApp.unblock();
                        return null;
                    }
                }, DynamicLibrariesManager.this.canStartApp);
            }
        }, this.canStartApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDependenciesTree(LibraryDescriptor descr, final TreeWithParent<LibraryDescriptorLoader.DependencyNode> tree, final Map<String, Map<String, List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>>> artifacts, final List<Pair<String, String>> exclusions, final JoinPoint<NoException> jp, List<LibraryDescriptor> addPlugins, final WorkProgress progress, long work) {
        List<LibraryDescriptor.Dependency> deps = descr.getDependencies();
        if (addPlugins != null) {
            ArrayList<LibraryDescriptor.Dependency> newDeps = new ArrayList<LibraryDescriptor.Dependency>(deps.size() + addPlugins.size());
            newDeps.addAll(deps);
            for (final LibraryDescriptor l : addPlugins) {
                newDeps.add(new LibraryDescriptor.Dependency(){

                    @Override
                    public String getGroupId() {
                        return l.getGroupId();
                    }

                    @Override
                    public String getArtifactId() {
                        return l.getArtifactId();
                    }

                    @Override
                    public VersionSpecification getVersionSpecification() {
                        return new VersionSpecification.SingleVersion(l.getVersion());
                    }

                    @Override
                    public String getClassifier() {
                        return null;
                    }

                    @Override
                    public boolean isOptional() {
                        return false;
                    }

                    @Override
                    public URL getKnownLocation() {
                        return l.getDirectory();
                    }

                    @Override
                    public List<Pair<String, String>> getExcludedDependencies() {
                        return new ArrayList<Pair<String, String>>(0);
                    }
                });
            }
            deps = newDeps;
        }
        int nb = deps.size();
        for (final LibraryDescriptor.Dependency dep : deps) {
            List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>> l;
            TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode> n;
            VersionSpecification depV;
            if (DynamicLibrariesManager.isMatching(dep.getGroupId(), dep.getArtifactId(), exclusions)) {
                --nb;
                continue;
            }
            this.app.getDefaultLogger().debug("Dependency: " + descr.getGroupId() + ':' + descr.getArtifactId() + ':' + descr.getVersionString() + " => " + dep.getGroupId() + ':' + dep.getArtifactId() + ':' + dep.getVersionSpecification());
            final long step = work / (long)nb--;
            work -= step;
            final LibraryDescriptorLoader.DependencyNode node = new LibraryDescriptorLoader.DependencyNode();
            node.dep = dep;
            node.descr = dep.getGroupId() == null || dep.getGroupId().length() == 0 ? new AsyncWork<Object, Exception>(null, new Exception("Missing groupId in dependency")) : (dep.getArtifactId() == null || dep.getArtifactId().length() == 0 ? new AsyncWork<Object, Exception>(null, new Exception("Missing artifactId in dependency")) : ((depV = dep.getVersionSpecification()) == null ? new AsyncWork<Object, Exception>(null, new Exception("Missing version in dependency")) : descr.getLoader().loadLibrary(dep.getGroupId(), dep.getArtifactId(), depV, (byte)3, descr.getDependenciesAdditionalRepositories())));
            TreeWithParent<LibraryDescriptorLoader.DependencyNode> treeWithParent = tree;
            synchronized (treeWithParent) {
                n = tree.add(node);
            }
            Map<String, Map<String, List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>>> map = artifacts;
            synchronized (map) {
                List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>> list;
                Map<String, List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>> group = artifacts.get(dep.getGroupId());
                if (group == null) {
                    group = new HashMap<String, List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>>();
                    artifacts.put(dep.getGroupId(), group);
                }
                if ((list = group.get(dep.getArtifactId())) == null) {
                    list = new LinkedList<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>();
                    group.put(dep.getArtifactId(), list);
                }
                list.add(n);
                l = list;
            }
            jp.addToJoin(1);
            node.descr.listenInline(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (node.descr.getResult() != null) {
                        List<Pair<String, String>> addExcl = dep.getExcludedDependencies();
                        ArrayList<Pair<String, String>> excl = new ArrayList<Pair<String, String>>(exclusions.size() + addExcl.size());
                        excl.addAll(exclusions);
                        for (Pair<String, String> e : addExcl) {
                            if (excl.contains(e)) continue;
                            excl.add(e);
                        }
                        if (progress != null) {
                            progress.progress(step / 2L);
                        }
                        DynamicLibrariesManager.this.buildDependenciesTree(node.descr.getResult(), n.getSubNodes(), artifacts, excl, jp, null, progress, step - step / 2L);
                    } else {
                        if (progress != null) {
                            progress.progress(step);
                        }
                        if (dep.isOptional()) {
                            DynamicLibrariesManager.this.app.getDefaultLogger().debug("Dependency " + dep.getGroupId() + ':' + dep.getArtifactId() + ':' + dep.getVersionSpecification() + " not found, but optional");
                            Object object = tree;
                            synchronized (object) {
                                tree.removeInstance(node);
                            }
                            object = artifacts;
                            synchronized (object) {
                                l.remove(n);
                                if (l.isEmpty()) {
                                    Map group = (Map)artifacts.get(dep.getGroupId());
                                    group.remove(dep.getArtifactId());
                                    if (group.isEmpty()) {
                                        artifacts.remove(dep.getGroupId());
                                    }
                                }
                            }
                        }
                    }
                    jp.joined();
                }
            });
        }
        if (progress != null && work > 0L) {
            progress.progress(work);
        }
    }

    private static boolean isMatching(String groupId, String artifactId, List<Pair<String, String>> list) {
        for (Pair<String, String> p : list) {
            if (p.getValue1() != null && !p.getValue1().equals(groupId) || p.getValue2() != null && !p.getValue2().equals(artifactId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ISynchronizationPoint<Exception> onLibrariesLoaded() {
        return this.canStartApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncWork<LoadedLibrary, Exception> loadNewLibrary(final String groupId, final String artifactId, final VersionSpecification version, boolean optional, final byte priority, WorkProgress progress, long work) {
        Lib l;
        final String key = groupId + ':' + artifactId;
        Map<String, Lib> map = this.libraries;
        synchronized (map) {
            final Lib lib = this.libraries.get(key);
            if (lib != null) {
                if (lib.load.isUnblocked()) {
                    if (lib.load.hasError()) {
                        return new AsyncWork(null, lib.load.getError());
                    }
                    return new AsyncWork<LoadedLibrary, Object>(lib.library, null);
                }
                final AsyncWork<LoadedLibrary, Exception> result = new AsyncWork<LoadedLibrary, Exception>();
                lib.load.listenInline(new Runnable(){

                    @Override
                    public void run() {
                        if (lib.load.hasError()) {
                            result.error(lib.load.getError());
                        } else {
                            result.unblockSuccess(lib.library);
                        }
                    }
                });
                return result;
            }
            l = new Lib();
            this.libraries.put(key, l);
        }
        final MutableInteger loaderIndex = new MutableInteger(0);
        final AsyncWork<LoadedLibrary, Exception> result = new AsyncWork<LoadedLibrary, Exception>();
        Runnable nextLoader = new Runnable(){

            @Override
            public void run() {
                if (loaderIndex.get() == DynamicLibrariesManager.this.loaders.size()) {
                    Exception error = new Exception("Cannot find library " + key);
                    l.load.error(error);
                    result.error(error);
                    return;
                }
                final AsyncWork<? extends LibraryDescriptor, Exception> loadDescr = ((LibraryDescriptorLoader)DynamicLibrariesManager.this.loaders.get(loaderIndex.get())).loadLibrary(groupId, artifactId, version, priority, new ArrayList<LibrariesRepository>(0));
                final 8 next = this;
                loadDescr.listenInline(new Runnable(){

                    @Override
                    public void run() {
                        if (loadDescr.getResult() == null) {
                            loaderIndex.inc();
                            next.run();
                            return;
                        }
                        l.descr = (LibraryDescriptor)loadDescr.getResult();
                        TreeWithParent tree = new TreeWithParent(null);
                        HashMap artifacts = new HashMap();
                        JoinPoint treeDone = new JoinPoint();
                        ArrayList<Pair<String, String>> exclusions = new ArrayList<Pair<String, String>>(DynamicLibrariesManager.this.libraries.size());
                        for (Lib lib : DynamicLibrariesManager.this.libraries.values()) {
                            if (lib.descr == null) continue;
                            exclusions.add(new Pair<String, String>(lib.descr.getGroupId(), lib.descr.getArtifactId()));
                        }
                        DynamicLibrariesManager.this.buildDependenciesTree(l.descr, tree, artifacts, exclusions, treeDone, null, null, 0L);
                        treeDone.start();
                        ResolveVersionConflicts resolveConflicts = new ResolveVersionConflicts(artifacts, l.descr.getLoader(), null, 0L);
                        resolveConflicts.startOn(treeDone, true);
                        resolveConflicts.getOutput().listenInline(() -> {
                            DynamicLibrariesManager.this.app.getDefaultLogger().debug("Dependencies analyzed, loading and initializing libraries");
                            LoadLibrary load = new LoadLibrary(l, (Map)resolveConflicts.getResult(), null);
                            load.start();
                            l.load.listenInline(new Runnable(){

                                @Override
                                public void run() {
                                    if (l.load.hasError()) {
                                        result.error(l.load.getError());
                                    } else {
                                        result.unblockSuccess(l.library);
                                    }
                                }
                            });
                        }, result);
                    }
                });
            }
        };
        nextLoader.run();
        return result;
    }

    @Override
    public LoadedLibrary getLibrary(String groupId, String artifactId) {
        for (Lib lib : this.libraries.values()) {
            if (!lib.library.getGroupId().equals(groupId) || !lib.library.getArtifactId().equals(artifactId)) continue;
            return lib.library;
        }
        return null;
    }

    @Override
    public IO.Readable getResource(String groupId, String artifactId, String path, byte priority) {
        if (groupId != null && artifactId != null) {
            LoadedLibrary lib = this.getLibrary(groupId, artifactId);
            if (lib == null) {
                return null;
            }
            return this.getResourceFrom((ClassLoader)lib.getClassLoader(), path, priority);
        }
        return this.appClassLoader.getResourceIO(path, priority);
    }

    @Override
    public IO.Readable getResource(String path, byte priority) {
        return this.appClassLoader.getResourceIO(path, priority);
    }

    public IO.Readable getResourceFrom(ClassLoader cl, String path, byte priority) {
        IOProvider.Readable provider = new IOProviderFromPathUsingClassloader(cl).get(path);
        if (provider == null) {
            return null;
        }
        try {
            return provider.provideIOReadable(priority);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public List<File> getLibrariesLocations() {
        ArrayList<File> list = new ArrayList<File>(this.libraries.size());
        for (Lib lib : this.libraries.values()) {
            this.getLibrariesLocations(list, lib);
        }
        return list;
    }

    private void getLibrariesLocations(List<File> list, Lib lib) {
        File f;
        try {
            f = lib.descr.getClasses().blockResult(0L);
        }
        catch (Exception e) {
            return;
        }
        if (f == null) {
            return;
        }
        if (list.contains(f)) {
            return;
        }
        for (LibraryDescriptor.Dependency dep : lib.descr.getDependencies()) {
            String key = dep.getGroupId() + ':' + dep.getArtifactId();
            Lib depLib = this.libraries.get(key);
            if (depLib == null) continue;
            this.getLibrariesLocations(list, depLib);
        }
        list.add(f);
    }

    Task.Cpu<ISynchronizationPoint<Exception>, Exception> startApp() {
        Task.Cpu<ISynchronizationPoint<Exception>, Exception> task = new Task.Cpu<ISynchronizationPoint<Exception>, Exception>(this.app.getGroupId() + ':' + this.app.getArtifactId() + ':' + this.app.getVersion().toString(), 4){

            @Override
            public ISynchronizationPoint<Exception> run() throws Exception {
                Class<?> cl;
                if (DynamicLibrariesManager.this.splash != null) {
                    DynamicLibrariesManager.this.splash.setText("Starting application " + ((DynamicLibrariesManager)DynamicLibrariesManager.this).appCfg.name);
                }
                if (!ApplicationBootstrap.class.isAssignableFrom(cl = ((ClassLoader)DynamicLibrariesManager.this.appLib.library.getClassLoader()).loadClass(((DynamicLibrariesManager)DynamicLibrariesManager.this).appCfg.clazz))) {
                    throw new Exception("Application class " + ((DynamicLibrariesManager)DynamicLibrariesManager.this).appCfg.clazz + " must implements ApplicationBootstrap");
                }
                ApplicationBootstrap startup = (ApplicationBootstrap)cl.newInstance();
                WorkProgress progress = DynamicLibrariesManager.this.splash != null ? DynamicLibrariesManager.this.splash : new FakeWorkProgress();
                ISynchronizationPoint<Exception> start = startup.start(DynamicLibrariesManager.this.app, progress);
                progress.getSynch().listenInline(new Runnable(){

                    @Override
                    public void run() {
                        DynamicLibrariesManager.this.splash = null;
                    }
                });
                return start;
            }
        };
        task.start();
        return task;
    }

    @Override
    public void scanLibraries(String rootPackage, boolean includeSubPackages, Filter<String> packageFilter, Filter<String> classFilter, Listener<Class<?>> classScanner) {
        this.appClassLoader.scanLibraries(rootPackage, includeSubPackages, packageFilter, classFilter, classScanner);
    }

    private class Init
    extends Task.Cpu<Void, NoException> {
        private Lib lib;

        private Init(Lib lib) {
            super("Initialize library " + lib.descr.getGroupId() + ':' + lib.descr.getArtifactId(), (byte)2);
            this.lib = lib;
        }

        @Override
        public Void run() {
            if (DynamicLibrariesManager.this.app.getDefaultLogger().debug()) {
                DynamicLibrariesManager.this.app.getDefaultLogger().debug("Initializing " + this.lib.descr.getGroupId() + ':' + this.lib.descr.getArtifactId() + ':' + this.lib.descr.getVersionString());
            }
            final JoinPoint<Object> jp = new JoinPoint<Object>();
            AsyncWork ep = null;
            try {
                IO.Readable io = ((AbstractClassLoader)this.lib.library.getClassLoader()).open("META-INF/net.lecousin/extensionpoints", (byte)2);
                PreBufferedReadable bio = new PreBufferedReadable(io, 512, 2, 1024, 3, 8);
                BufferedReadableCharacterStream stream = new BufferedReadableCharacterStream((IO.Readable)bio, StandardCharsets.UTF_8, 256, 32);
                ep = new LoadLibraryExtensionPointsFile(stream, this.lib.library.getClassLoader()).start();
                jp.addToJoin(ep);
            }
            catch (FileNotFoundException io) {
            }
            catch (Throwable t) {
                this.lib.load.error(new Exception("Error reading file META-INF/net.lecousin/extensionpoints from library " + this.lib.descr.getGroupId() + ':' + this.lib.descr.getArtifactId(), t));
                return null;
            }
            ISynchronizationPoint<Object> previous = ep;
            for (CustomExtensionPoint custom : ExtensionPoints.getCustomExtensionPoints()) {
                String path = custom.getPluginConfigurationFilePath();
                if (path == null) continue;
                try {
                    IO.Readable io = ((AbstractClassLoader)this.lib.library.getClassLoader()).open(path, (byte)2);
                    previous = custom.loadPluginConfiguration(io, this.lib.library.getClassLoader(), new ISynchronizationPoint[]{previous});
                    jp.addToJoin(previous);
                }
                catch (FileNotFoundException io) {
                }
                catch (Throwable t) {
                    this.lib.load.error(new Exception("Error reading file " + path + " from library " + this.lib.descr.getGroupId() + ':' + this.lib.descr.getArtifactId(), t));
                    return null;
                }
            }
            try {
                IO.Readable io = ((AbstractClassLoader)this.lib.library.getClassLoader()).open("META-INF/net.lecousin/plugins", (byte)2);
                PreBufferedReadable bio = new PreBufferedReadable(io, 512, 2, 1024, 3, 8);
                BufferedReadableCharacterStream stream = new BufferedReadableCharacterStream((IO.Readable)bio, StandardCharsets.UTF_8, 256, 32);
                LoadLibraryPluginsFile task = new LoadLibraryPluginsFile(stream, this.lib.library.getClassLoader());
                SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
                if (previous == null) {
                    task.start().listenInlineSP(sp);
                } else {
                    previous.listenInlineSP(() -> task.start().listenInlineSP(sp), sp);
                }
                jp.addToJoin(sp);
            }
            catch (FileNotFoundException io) {
            }
            catch (Throwable t) {
                this.lib.load.error(new Exception("Error reading file META-INF/net.lecousin/plugins from library " + this.lib.descr.getGroupId() + ':' + this.lib.descr.getArtifactId(), t));
                return null;
            }
            jp.start();
            jp.listenInline(new Runnable(){

                @Override
                public void run() {
                    if (jp.hasError()) {
                        if (!Init.this.lib.load.hasError()) {
                            Init.this.lib.load.error(jp.getError());
                        }
                        return;
                    }
                    Init.this.lib.load.unblock();
                }
            });
            return null;
        }
    }

    private class LoadLibrary
    extends Task.Cpu<Void, NoException> {
        private Lib lib;
        private Map<String, LibraryDescriptor> versions;
        private List<LibraryDescriptor> addPlugins;

        private LoadLibrary(Lib lib, Map<String, LibraryDescriptor> versions, List<LibraryDescriptor> addPlugins) {
            super("Load library " + lib.descr.getGroupId() + ':' + lib.descr.getArtifactId(), (byte)2);
            this.lib = lib;
            this.versions = versions;
            this.addPlugins = addPlugins;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void run() {
            String key;
            if (DynamicLibrariesManager.this.app.getDefaultLogger().debug()) {
                DynamicLibrariesManager.this.app.getDefaultLogger().debug("Loading " + this.lib.descr.getGroupId() + ':' + this.lib.descr.getArtifactId() + ':' + this.lib.descr.getVersionString());
            }
            JoinPoint jp = new JoinPoint();
            for (LibraryDescriptor.Dependency dep : this.lib.descr.getDependencies()) {
                Lib l;
                key = dep.getGroupId() + ':' + dep.getArtifactId();
                LibraryDescriptor d = this.versions.get(key);
                if (d == null) continue;
                Map map = DynamicLibrariesManager.this.libraries;
                synchronized (map) {
                    l = (Lib)DynamicLibrariesManager.this.libraries.get(key);
                    if (l != null) {
                        jp.addToJoin(l.load);
                        continue;
                    }
                    l = new Lib();
                    l.descr = d;
                    DynamicLibrariesManager.this.libraries.put(key, l);
                }
                new LoadLibrary(l, this.versions, null).start();
                jp.addToJoin(l.load);
            }
            if (this.addPlugins != null) {
                for (LibraryDescriptor d : this.addPlugins) {
                    Lib l;
                    key = d.getGroupId() + ':' + d.getArtifactId();
                    Map map = DynamicLibrariesManager.this.libraries;
                    synchronized (map) {
                        l = (Lib)DynamicLibrariesManager.this.libraries.get(key);
                        if (l != null) {
                            jp.addToJoin(l.load);
                            continue;
                        }
                        l = new Lib();
                        l.descr = d;
                        DynamicLibrariesManager.this.libraries.put(key, l);
                    }
                    new LoadLibrary(l, this.versions, null).start();
                    jp.addToJoin(l.load);
                }
            }
            jp.start();
            this.lib.descr.getClasses().listenInline(file -> {
                if (file != null) {
                    if (DynamicLibrariesManager.this.app.getDefaultLogger().debug()) {
                        DynamicLibrariesManager.this.app.getDefaultLogger().debug(this.lib.descr.getGroupId() + ':' + this.lib.descr.getArtifactId() + ':' + this.lib.descr.getVersionString() + " loaded from " + file.getAbsolutePath());
                    }
                    this.lib.library = new LoadedLibrary(new Artifact(this.lib.descr.getGroupId(), this.lib.descr.getArtifactId(), this.lib.descr.getVersion()), DynamicLibrariesManager.this.appClassLoader.add((File)file, null));
                    jp.listenAsync(new Init(this.lib), this.lib.load);
                } else {
                    if (DynamicLibrariesManager.this.app.getDefaultLogger().debug()) {
                        DynamicLibrariesManager.this.app.getDefaultLogger().debug("No classes in " + this.lib.descr.getGroupId() + ':' + this.lib.descr.getArtifactId() + ':' + this.lib.descr.getVersionString());
                    }
                    this.lib.library = new LoadedLibrary(new Artifact(this.lib.descr.getGroupId(), this.lib.descr.getArtifactId(), this.lib.descr.getVersion()), null);
                    jp.listenInline(this.lib.load);
                }
            });
            return null;
        }
    }

    private class ResolveVersionConflicts
    extends Task.Cpu<Map<String, LibraryDescriptor>, Exception> {
        private Map<String, Map<String, List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>>> artifacts;
        private LibraryDescriptorLoader resolver;
        private WorkProgress progress;
        private long work;

        private ResolveVersionConflicts(Map<String, Map<String, List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>>> artifacts, LibraryDescriptorLoader resolver, WorkProgress progress, long work) {
            super("Resolve library version conflicts", (byte)2);
            this.artifacts = artifacts;
            this.resolver = resolver;
            this.progress = progress;
            this.work = work;
        }

        @Override
        public Map<String, LibraryDescriptor> run() throws Exception {
            if (this.progress != null) {
                this.progress.setText("Resolving dependencies versions");
            }
            DynamicLibrariesManager.this.app.getDefaultLogger().debug("Resolving version conflicts");
            HashMap<String, LibraryDescriptor> versions = new HashMap<String, LibraryDescriptor>();
            for (Map.Entry<String, Map<String, List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>>> group : this.artifacts.entrySet()) {
                for (Map.Entry<String, List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>> artifact : group.getValue().entrySet()) {
                    Version version;
                    HashMap<Version, List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>> artifactVersions = new HashMap<Version, List<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>>();
                    for (TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode> node : artifact.getValue()) {
                        if (node.getElement().descr.hasError()) {
                            DynamicLibrariesManager.this.app.getDefaultLogger().error("Dependency ignored: " + node.getElement().dep.getGroupId() + ':' + node.getElement().dep.getArtifactId() + " because of loading error", node.getElement().descr.getError());
                            continue;
                        }
                        Version version2 = node.getElement().descr.getResult().getVersion();
                        LinkedList<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>> nodes = (LinkedList<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>)artifactVersions.get(version2);
                        if (nodes == null) {
                            nodes = new LinkedList<TreeWithParent.Node<LibraryDescriptorLoader.DependencyNode>>();
                            artifactVersions.put(version2, nodes);
                        }
                        nodes.add(node);
                    }
                    if (artifactVersions.isEmpty()) {
                        throw new Exception("Unable to load library " + group.getKey() + ':' + artifact.getKey());
                    }
                    if (artifactVersions.size() == 1) {
                        version = (Version)artifactVersions.keySet().iterator().next();
                        versions.put(group.getKey() + ':' + artifact.getKey(), ((LibraryDescriptorLoader.DependencyNode)((TreeWithParent.Node)((List)artifactVersions.get((Object)version)).get((int)0)).getElement()).descr.getResult());
                        continue;
                    }
                    version = this.resolver.resolveVersionConflict(group.getKey(), artifact.getKey(), artifactVersions);
                    if (version == null) {
                        throw new Exception("Unable to resolve version conflict for library " + group.getKey() + ':' + artifact.getKey());
                    }
                    if (DynamicLibrariesManager.this.app.getDefaultLogger().debug()) {
                        DynamicLibrariesManager.this.app.getDefaultLogger().debug("Version conflict for " + group.getKey() + ':' + artifact.getKey() + " resolved to " + ((LibraryDescriptorLoader.DependencyNode)((TreeWithParent.Node)((List)artifactVersions.get((Object)version)).get((int)0)).getElement()).descr.getResult().getVersionString());
                    }
                    versions.put(group.getKey() + ':' + artifact.getKey(), ((LibraryDescriptorLoader.DependencyNode)((TreeWithParent.Node)((List)artifactVersions.get((Object)version)).get((int)0)).getElement()).descr.getResult());
                }
            }
            if (this.progress != null) {
                this.progress.progress(this.work);
            }
            return versions;
        }
    }

    private static class Lib {
        private LibraryDescriptor descr;
        private SynchronizationPoint<Exception> load = new SynchronizationPoint();
        private LoadedLibrary library;

        private Lib() {
        }
    }
}

