/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.launcher;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.ApplicationConfiguration;
import net.lecousin.framework.application.Artifact;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.application.SplashScreen;
import net.lecousin.framework.application.Version;
import net.lecousin.framework.application.launcher.DynamicLibrariesManager;
import net.lecousin.framework.application.libraries.artifacts.LibraryDescriptorLoader;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenLocalRepository;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenPOMLoader;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenSettings;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.util.Triple;

public class DevLauncher {
    public static void printUsage() {
        System.out.println("Usage: -groupId=<groupId> -artifactId=<artifactId> -version=<artifactVersion> -config=<path_to_lc=project.xml> -projects=<projects_paths> [-plugins=<plugins>] [-maven-repository=<path>][-parameters ...]");
    }

    public static void main(final String[] args) {
        SplashScreen splashScreen = null;
        if (!GraphicsEnvironment.isHeadless() && !"true".equals(System.getProperty("nosplash"))) {
            splashScreen = new SplashScreen(true);
        }
        final SplashScreen splash = splashScreen;
        LCCore.keepMainThread(new Runnable(){

            @Override
            public void run() {
                File dir;
                ApplicationConfiguration cfg;
                MavenPOMLoader pomLoader = new MavenPOMLoader();
                ArrayList<LibraryDescriptorLoader> loaders = new ArrayList<LibraryDescriptorLoader>(1);
                loaders.add(pomLoader);
                String groupId = null;
                String artifactId = null;
                String version = null;
                String config = null;
                String projects = null;
                String plugins = null;
                String[] appParameters = new String[]{};
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].startsWith("-groupId=")) {
                        groupId = args[i].substring(9);
                        continue;
                    }
                    if (args[i].startsWith("-artifactId=")) {
                        artifactId = args[i].substring(12);
                        continue;
                    }
                    if (args[i].startsWith("-version=")) {
                        version = args[i].substring(9);
                        continue;
                    }
                    if (args[i].startsWith("-config=")) {
                        config = args[i].substring(8);
                        continue;
                    }
                    if (args[i].startsWith("-projects=")) {
                        projects = args[i].substring(10);
                        continue;
                    }
                    if (args[i].startsWith("-plugins=")) {
                        plugins = args[i].substring(9);
                        continue;
                    }
                    if (args[i].startsWith("-maven-repository=")) {
                        String path = args[i].substring(18);
                        File dir2 = new File(path);
                        if (!dir2.exists()) continue;
                        pomLoader.addRepository(new MavenLocalRepository(dir2, true, true));
                        continue;
                    }
                    if (args[i].equals("-parameters")) {
                        appParameters = new String[args.length - i - 1];
                        for (int j = 0; j < appParameters.length; ++j) {
                            appParameters[j] = args[i + 1 + j];
                        }
                        break;
                    }
                    System.err.println("Unknown option: " + args[i]);
                    DevLauncher.printUsage();
                    LCCore.stop(true);
                    return;
                }
                boolean stop = true;
                if (config == null) {
                    System.err.println("Missing config parameter in command line");
                } else if (groupId == null) {
                    System.err.println("Missing groupId parameter in command line");
                } else if (artifactId == null) {
                    System.err.println("Missing artifactId parameter in command line");
                } else if (version == null) {
                    System.err.println("Missing version parameter in command line");
                } else if (projects == null) {
                    System.err.println("Missing projects parameter in command line");
                } else {
                    stop = false;
                }
                if (stop) {
                    DevLauncher.printUsage();
                    LCCore.stop(true);
                    return;
                }
                File cfgFile = new File(config);
                if (!cfgFile.exists() || !cfgFile.isFile()) {
                    System.err.println("Configuration file does not exist");
                    LCCore.stop(true);
                    return;
                }
                if (splash != null) {
                    splash.setText("Reading application configuration");
                }
                try {
                    cfg = ApplicationConfiguration.load(cfgFile);
                }
                catch (Exception e) {
                    System.err.println("Error reading configuration file " + cfgFile.getAbsolutePath());
                    e.printStackTrace(System.err);
                    LCCore.stop(true);
                    return;
                }
                if (splash != null && cfg.name != null) {
                    splash.setApplicationName(cfg.name);
                }
                File appDir = cfgFile.getParentFile();
                File settings = new File(System.getProperty("user.home") + "/.m2/settings.xml");
                String localRepo = System.getProperty("user.home") + "/.m2/repository";
                if (settings.exists()) {
                    try {
                        MavenSettings ms = MavenSettings.load(settings);
                        if (ms.localRepository != null) {
                            localRepo = ms.localRepository;
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Error reading Maven settings.xml");
                        e.printStackTrace(System.err);
                    }
                }
                if ((dir = new File(localRepo)).exists()) {
                    pomLoader.addRepository(new MavenLocalRepository(dir, true, true));
                }
                String[] s = projects.split(File.pathSeparator);
                ArrayList<File> devPaths = new ArrayList<File>(s.length);
                for (String path : s) {
                    dir = new File(path);
                    if (!dir.exists()) {
                        System.err.println("Development path " + path + " does not exist");
                        continue;
                    }
                    devPaths.add(dir);
                }
                if (splash != null) {
                    splash.endInit();
                }
                if (cfg.properties.get("net.lecousin.application.config.directory") == null && System.getProperty("net.lecousin.application.config.directory") == null) {
                    cfg.properties.put("net.lecousin.application.config.directory", System.getProperty("user.home") + "/.lc.apps/" + groupId + "/" + artifactId + "/cfg");
                }
                if (cfg.properties.get("net.lecousin.application.log.directory") == null && System.getProperty("net.lecousin.application.log.directory") == null) {
                    cfg.properties.put("net.lecousin.application.log.directory", System.getProperty("user.home") + "/.lc.apps/" + groupId + "/" + artifactId + "/log");
                }
                LinkedList<Triple<String, String, String>> addPlugins = new LinkedList<Triple<String, String, String>>();
                if (plugins != null) {
                    String[] list;
                    for (String plugin : list = plugins.split(";")) {
                        if ((plugin = plugin.trim()).length() == 0) continue;
                        int i = plugin.indexOf(58);
                        if (i < 0) {
                            addPlugins.add(new Triple<String, Object, Object>(plugin, null, null));
                            continue;
                        }
                        String pluginGroupId = plugin.substring(0, i);
                        if ((i = (plugin = plugin.substring(i + 1)).indexOf(58)) < 0) {
                            addPlugins.add(new Triple<String, String, Object>(pluginGroupId, plugin, null));
                            continue;
                        }
                        addPlugins.add(new Triple<String, String, String>(pluginGroupId, plugin.substring(0, i), plugin.substring(i + 1)));
                    }
                }
                DynamicLibrariesManager librariesManager = new DynamicLibrariesManager(devPaths, splash, loaders, appDir, cfg, addPlugins);
                ISynchronizationPoint<Exception> start = Application.start(new Artifact(groupId, artifactId, new Version(version)), appParameters, cfg.properties, true, Executors.defaultThreadFactory(), librariesManager);
                start.block(0L);
                if (start.hasError()) {
                    start.getError().printStackTrace(System.err);
                    LCCore.stop(true);
                    return;
                }
                if (start.isCancelled()) {
                    start.getCancelEvent().printStackTrace(System.err);
                    LCCore.stop(true);
                    return;
                }
                Task.Cpu<ISynchronizationPoint<Exception>, Exception> startApp = librariesManager.startApp();
                startApp.getOutput().block(0L);
                if (!startApp.isSuccessful()) {
                    if (startApp.isCancelled()) {
                        System.err.println("Application cancelled:");
                        startApp.getCancelEvent().printStackTrace(System.err);
                    } else {
                        System.err.println("Error while starting application:");
                        ((Throwable)startApp.getError()).printStackTrace(System.err);
                    }
                    LCCore.stop(true);
                    return;
                }
                ISynchronizationPoint appClosed = (ISynchronizationPoint)startApp.getResult();
                if (appClosed != null) {
                    appClosed.block(0L);
                    if (appClosed.isCancelled()) {
                        System.err.println("Application cancelled:");
                        appClosed.getCancelEvent().printStackTrace(System.err);
                    } else if (appClosed.hasError()) {
                        System.err.println("Error while running application:");
                        ((Throwable)appClosed.getError()).printStackTrace(System.err);
                    }
                }
                LCCore.stop(true);
            }
        });
    }
}

