/*
 * Decompiled with CFR 0.152.
 */
package net.lbruun.springboot.preliquibase.utils;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import net.lbruun.springboot.preliquibase.PreLiquibaseException;

public class LiquibaseUtils {
    private LiquibaseUtils() {
    }

    public static String getLiquibaseDatabaseShortName(DataSource dataSource) {
        Connection connection = null;
        Database database = null;
        try {
            connection = dataSource.getConnection();
            database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
            String string = database.getShortName();
            return string;
        }
        catch (SQLException ex1) {
            throw new PreLiquibaseException.ResolveDbPlatformError("Could not acquire connection for DataSource", ex1);
        }
        catch (DatabaseException ex2) {
            throw new PreLiquibaseException.ResolveDbPlatformError("Error while finding Liquibase Database implementation for DataSource", ex2);
        }
        catch (Exception ex3) {
            throw new PreLiquibaseException.ResolveDbPlatformError("Unexpected error while finding Liquibase Database implementation for DataSource", ex3);
        }
        finally {
            if (database != null) {
                try {
                    database.close();
                }
                catch (DatabaseException ex) {
                    throw new PreLiquibaseException.ResolveDbPlatformError("Error while closing connection for DataSource", ex);
                }
            }
            if (connection != null) {
                try {
                    if (!connection.isClosed()) {
                        if (!connection.getAutoCommit()) {
                            connection.rollback();
                        }
                        connection.close();
                    }
                }
                catch (SQLException ex) {
                    throw new PreLiquibaseException.ResolveDbPlatformError("Error while closing connection for DataSource", ex);
                }
            }
        }
    }
}

