/*
 * Decompiled with CFR 0.152.
 */
package net.lbruun.springboot.preliquibase;

import java.util.Objects;
import javax.sql.DataSource;
import liquibase.change.DatabaseChange;
import liquibase.integration.spring.SpringLiquibase;
import net.lbruun.springboot.preliquibase.PreLiquibase;
import net.lbruun.springboot.preliquibase.PreLiquibaseDataSourceProvider;
import net.lbruun.springboot.preliquibase.PreLiquibaseProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AbstractDependsOnBeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseDataSource;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.NonNull;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SpringLiquibase.class, DatabaseChange.class})
@Conditional(value={LiquibaseDataSourceCondition.class, EnabledCondition.class})
@ConditionalOnMissingBean(value={SpringLiquibase.class, PreLiquibase.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@AutoConfigureBefore(value={LiquibaseAutoConfiguration.class})
@EnableConfigurationProperties(value={DataSourceProperties.class, LiquibaseProperties.class, PreLiquibaseProperties.class})
public class PreLiquibaseAutoConfiguration {
    Logger logger = LoggerFactory.getLogger(PreLiquibaseAutoConfiguration.class);

    @Bean
    public PreLiquibaseDataSourceProvider preLiquibaseDataSourceProvider(LiquibaseProperties liquibaseProperties, DataSourceProperties dataSourceProperties, ObjectProvider<DataSource> dataSource, @LiquibaseDataSource ObjectProvider<DataSource> liquibaseDataSource) {
        this.logger.debug("Instantiation of PreLiquibaseDataSourceProvider");
        return new DefaultPreLiquibaseDataSourceProvider(liquibaseProperties, dataSourceProperties, dataSource, liquibaseDataSource);
    }

    @Bean
    public PreLiquibase preLiquibase(Environment environment, PreLiquibaseProperties properties, PreLiquibaseDataSourceProvider dataSourceProvider, ApplicationContext applicationContext) {
        this.logger.debug("Instantiation of PreLiquibase");
        PreLiquibase preLiquibase = new PreLiquibase(environment, dataSourceProvider.getDataSource(), properties, (ResourceLoader)applicationContext);
        preLiquibase.execute();
        return preLiquibase;
    }

    static class DefaultPreLiquibaseDataSourceProvider
    implements PreLiquibaseDataSourceProvider {
        private final DataSource dataSourceToUse;

        public DefaultPreLiquibaseDataSourceProvider(@NonNull LiquibaseProperties liquibaseProperties, @NonNull DataSourceProperties dataSourceProperties, @NonNull ObjectProvider<DataSource> dataSource, @NonNull ObjectProvider<DataSource> liquibaseDataSource) {
            LiquibaseAutoConfiguration.LiquibaseConfiguration liquibaseConfiguration = new LiquibaseAutoConfiguration.LiquibaseConfiguration(liquibaseProperties);
            SpringLiquibase liquibase = liquibaseConfiguration.liquibase(dataSource, liquibaseDataSource);
            Objects.requireNonNull(liquibase.getDataSource(), "Unexpected: null value for DataSource returned from SpringLiquibase class");
            this.dataSourceToUse = liquibase.getDataSource();
        }

        @Override
        public DataSource getDataSource() {
            return this.dataSourceToUse;
        }
    }

    static final class EnabledCondition
    extends AllNestedConditions {
        EnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="spring.liquibase", name={"enabled"}, matchIfMissing=true)
        private static final class liquibaseEnabledCondition {
            private liquibaseEnabledCondition() {
            }
        }

        @ConditionalOnProperty(prefix="preliquibase", name={"enabled"}, matchIfMissing=true)
        private static final class preLiquibaseEnabledCondition {
            private preLiquibaseEnabledCondition() {
            }
        }
    }

    static final class LiquibaseDataSourceCondition
    extends AnyNestedCondition {
        LiquibaseDataSourceCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="spring.liquibase", name={"url"}, matchIfMissing=false)
        private static final class LiquibaseUrlCondition {
            private LiquibaseUrlCondition() {
            }
        }

        @ConditionalOnBean(value={DataSource.class})
        private static final class DataSourceBeanCondition {
            private DataSourceBeanCondition() {
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={SpringLiquibase.class})
    static class LiquibaseOnPreLiquibaseDependencyPostProcessor
    extends AbstractDependsOnBeanFactoryPostProcessor {
        Logger logger = LoggerFactory.getLogger(LiquibaseOnPreLiquibaseDependencyPostProcessor.class);

        LiquibaseOnPreLiquibaseDependencyPostProcessor() {
            super(SpringLiquibase.class, new Class[]{PreLiquibase.class});
            this.logger.debug("Downstream dependencies on PreLiquibase are now configured");
        }
    }
}

