/*
 * Decompiled with CFR 0.152.
 */
package net.koofr.android.timeago;

import android.content.Context;
import android.content.res.Resources;
import java.util.Date;
import net.koofr.android.timeago.R;

public class TimeAgo {
    protected Context context;

    public TimeAgo(Context context) {
        this.context = context;
    }

    public String timeAgo(Date date) {
        return this.timeAgo(date.getTime());
    }

    public String timeAgo(long millis) {
        long diff = new Date().getTime() - millis;
        Resources r = this.context.getResources();
        String prefix = r.getString(R.string.time_ago_prefix);
        String suffix = r.getString(R.string.time_ago_suffix);
        double seconds = Math.abs(diff) / 1000L;
        double minutes = seconds / 60.0;
        double hours = minutes / 60.0;
        double days = hours / 24.0;
        double years = days / 365.0;
        String words = seconds < 45.0 ? r.getString(R.string.time_ago_seconds, new Object[]{(int)Math.round(seconds)}) : (seconds < 90.0 ? r.getString(R.string.time_ago_minute, new Object[]{1}) : (minutes < 45.0 ? r.getQuantityString(R.plurals.time_ago_minutes, (int)Math.round(minutes), new Object[]{(int)Math.round(minutes)}) : (minutes < 90.0 ? r.getString(R.string.time_ago_hour, new Object[]{1}) : (hours < 24.0 ? r.getQuantityString(R.plurals.time_ago_hours, (int)Math.round(hours), new Object[]{(int)Math.round(hours)}) : (hours < 42.0 ? r.getString(R.string.time_ago_day, new Object[]{1}) : (days < 30.0 ? r.getQuantityString(R.plurals.time_ago_days, (int)Math.round(days), new Object[]{(int)Math.round(days)}) : (days < 45.0 ? r.getString(R.string.time_ago_month, new Object[]{1}) : (days < 365.0 ? r.getQuantityString(R.plurals.time_ago_months, (int)Math.round(days / 30.0), new Object[]{(int)Math.round(days / 30.0)}) : (years < 1.5 ? r.getString(R.string.time_ago_year, new Object[]{1}) : r.getQuantityString(R.plurals.time_ago_years, (int)Math.round(years), new Object[]{(int)Math.round(years)}))))))))));
        StringBuilder sb = new StringBuilder();
        if (prefix != null && prefix.length() > 0) {
            sb.append(prefix).append(" ");
        }
        sb.append(words);
        if (suffix != null && suffix.length() > 0) {
            sb.append(" ").append(suffix);
        }
        return sb.toString().trim();
    }
}

