/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.assertj;

import net.javacrumbs.jsonunit.assertj.ExpectedNode;
import net.javacrumbs.jsonunit.assertj.JsonAssert;
import net.javacrumbs.jsonunit.assertj.internal.JsonRepresentation;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.presentation.Representation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonAssertions {
    private JsonAssertions() {
    }

    @NotNull
    public static JsonAssert.ConfigurableJsonAssert assertThatJson(@Nullable Object actual) {
        return new JsonAssert.ConfigurableJsonAssert(actual, Configuration.empty());
    }

    @NotNull
    public static JsonAssert.ConfigurableJsonAssert assertThatJson(@NotNull Object actual, JsonAssertionCallback ... callbacks) {
        JsonAssert.ConfigurableJsonAssert a = JsonAssertions.assertThatJson(actual);
        for (JsonAssertionCallback callback : callbacks) {
            callback.doAssert(a);
        }
        return a;
    }

    @NotNull
    public static Object json(Object input) {
        return new ExpectedNode(JsonUtils.convertToJson((Object)input, (String)"expected", (boolean)true));
    }

    @NotNull
    public static Object value(Object input) {
        return new ExpectedNode(JsonUtils.wrapDeserializedObject((Object)input));
    }

    static {
        Assertions.useRepresentation((Representation)new JsonRepresentation());
    }

    @FunctionalInterface
    public static interface JsonAssertionCallback {
        public void doAssert(@NotNull JsonAssert.ConfigurableJsonAssert var1);
    }
}

