/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools.ldserver.query;

import info.aduna.iteration.CloseableIteration;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import net.fortytwo.sesametools.ldserver.query.QueryException;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.sparql.SPARQLParser;
import org.openrdf.query.resultio.sparqljson.SPARQLResultsJSONWriter;
import org.openrdf.query.resultio.sparqlxml.SPARQLResultsXMLWriter;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.restlet.data.MediaType;
import org.restlet.representation.Variant;

public class SparqlTools {
    private static final String BASE_URI = "http://example.org/bogusBaseURI";

    private static ParsedQuery parseQuery(String query) throws MalformedQueryException {
        SPARQLParser parser = new SPARQLParser();
        return parser.parseQuery(query, BASE_URI);
    }

    public static synchronized CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateQuery(ParsedQuery query, SailConnection sc) throws QueryException {
        MapBindingSet bindings = new MapBindingSet();
        boolean includeInferred = false;
        try {
            return sc.evaluate(query.getTupleExpr(), query.getDataset(), (BindingSet)bindings, includeInferred);
        }
        catch (SailException e) {
            throw new QueryException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeQuery(String queryStr, SailConnection sc, OutputStream out, int limit, SparqlResultFormat format) throws QueryException {
        ParsedQuery query;
        SPARQLResultsJSONWriter w;
        switch (format) {
            case JSON: {
                w = new SPARQLResultsJSONWriter(out);
                break;
            }
            case XML: {
                w = new SPARQLResultsXMLWriter(out);
                break;
            }
            default: {
                throw new QueryException(new Throwable("bad query result format: " + (Object)((Object)format)));
            }
        }
        try {
            query = SparqlTools.parseQuery(queryStr);
        }
        catch (MalformedQueryException e) {
            throw new QueryException(e);
        }
        LinkedList columnHeaders = new LinkedList();
        columnHeaders.addAll(query.getTupleExpr().getBindingNames());
        try {
            w.startQueryResult(columnHeaders);
        }
        catch (TupleQueryResultHandlerException e) {
            throw new QueryException(e);
        }
        CloseableIteration<? extends BindingSet, QueryEvaluationException> iter = SparqlTools.evaluateQuery(query, sc);
        try {
            try {
                for (int count = 0; iter.hasNext() && count < limit; ++count) {
                    w.handleSolution((BindingSet)iter.next());
                }
            }
            finally {
                iter.close();
            }
            w.endQueryResult();
        }
        catch (QueryEvaluationException e) {
            throw new QueryException(e);
        }
        catch (TupleQueryResultHandlerException e) {
            throw new QueryException(e);
        }
    }

    public static enum SparqlResultFormat {
        XML("application/sparql-results+xml"),
        JSON("application/sparql-results+json");

        private static List<Variant> VARIANTS;
        private final MediaType mediaType;

        private SparqlResultFormat(String mimeType) {
            this.mediaType = new MediaType(mimeType);
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public static SparqlResultFormat lookup(MediaType mediaType) {
            for (SparqlResultFormat f : SparqlResultFormat.values()) {
                if (!f.mediaType.equals((Object)mediaType)) continue;
                return f;
            }
            return null;
        }

        public static List<Variant> getVariants() {
            if (null == VARIANTS) {
                VARIANTS = new LinkedList<Variant>();
                for (SparqlResultFormat f : SparqlResultFormat.values()) {
                    VARIANTS.add(new Variant(f.mediaType));
                }
            }
            return VARIANTS;
        }
    }
}

