/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools.ldserver;

import net.fortytwo.sesametools.ldserver.ServerException;
import net.fortytwo.sesametools.mappingsail.MappingSail;
import net.fortytwo.sesametools.mappingsail.MappingSchema;
import net.fortytwo.sesametools.mappingsail.RewriteRule;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.sail.Sail;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.data.Protocol;
import org.restlet.routing.VirtualHost;

public class LinkedDataServer {
    private final Sail sail;
    private final Component component;
    private final URI datasetURI;
    private final Context context;
    private final VirtualHost host;
    private static LinkedDataServer singleton = null;

    public LinkedDataServer(Sail baseSail, String internalBaseURI, String externalBaseURI, int serverPort) throws ServerException {
        this(baseSail, internalBaseURI, externalBaseURI, serverPort, null);
    }

    public LinkedDataServer(Sail baseSail, final String internalBaseURI, final String externalBaseURI, int serverPort, String dataset) {
        if (null != singleton) {
            throw new IllegalStateException("only one LinkedDataServer may be instantiated in the same JVM");
        }
        singleton = this;
        final ValueFactory vf = baseSail.getValueFactory();
        if (!internalBaseURI.equals(externalBaseURI)) {
            RewriteRule outboundRewriter = new RewriteRule(){

                public URI rewrite(URI original) {
                    if (null == original) {
                        return null;
                    }
                    String s = original.stringValue();
                    return s.startsWith(internalBaseURI) ? vf.createURI(s.replace(internalBaseURI, externalBaseURI)) : original;
                }
            };
            RewriteRule inboundRewriter = new RewriteRule(){

                public URI rewrite(URI original) {
                    if (null == original) {
                        return null;
                    }
                    String s = original.stringValue();
                    return s.startsWith(externalBaseURI) ? vf.createURI(s.replace(externalBaseURI, internalBaseURI)) : original;
                }
            };
            MappingSchema schema = new MappingSchema();
            schema.setRewriter(MappingSchema.Direction.INBOUND, inboundRewriter);
            schema.setRewriter(MappingSchema.Direction.OUTBOUND, outboundRewriter);
            this.sail = new MappingSail(baseSail, schema);
            this.datasetURI = null == dataset ? null : outboundRewriter.rewrite(vf.createURI(dataset));
        } else {
            this.sail = baseSail;
            this.datasetURI = null == dataset ? null : vf.createURI(dataset);
        }
        this.component = new Component();
        this.component.getServers().add(Protocol.HTTP, serverPort);
        this.component.getClients().add(Protocol.FILE);
        this.host = this.component.getDefaultHost();
        this.context = this.component.getContext();
    }

    public Context getContext() {
        return this.context;
    }

    public VirtualHost getHost() {
        return this.host;
    }

    public void start() throws Exception {
        this.component.start();
    }

    public Sail getSail() {
        return this.sail;
    }

    public URI getDatasetURI() {
        return this.datasetURI;
    }

    public static LinkedDataServer getInstance() {
        return singleton;
    }
}

