/*
 * Decompiled with CFR 0.152.
 */
package net.cattaka.android.adaptertoolbox.decoration;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import net.cattaka.android.adaptertoolbox.adapter.listener.ForwardingListener;

public class VerticalListDividerItemDecoration
extends RecyclerView.ItemDecoration {
    private boolean mIgnoreParentPadding = true;
    private Drawable mDrawable;

    public VerticalListDividerItemDecoration(Context context, boolean ignoreParentPadding) {
        this.mIgnoreParentPadding = ignoreParentPadding;
        TypedArray a = context.obtainStyledAttributes(new int[]{16843284});
        this.mDrawable = a.getDrawable(0);
        a.recycle();
    }

    public VerticalListDividerItemDecoration(Context context, boolean ignoreParentPadding, @DrawableRes int drawableRes) {
        this.mIgnoreParentPadding = ignoreParentPadding;
        this.mDrawable = ContextCompat.getDrawable((Context)context, (int)drawableRes);
    }

    public VerticalListDividerItemDecoration(boolean ignoreParentPadding, Drawable drawable) {
        this.mDrawable = drawable;
        this.mIgnoreParentPadding = ignoreParentPadding;
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (this.mDrawable == null) {
            return;
        }
        int left = this.mIgnoreParentPadding ? 0 : parent.getPaddingLeft();
        int right = this.mIgnoreParentPadding ? parent.getWidth() : parent.getWidth() - parent.getPaddingRight();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.ViewHolder nextHolder = ForwardingListener.findContainingViewHolder(parent, child);
            Integer prevViewType = this.findPrevViewType(parent, nextHolder);
            if (nextHolder == null || prevViewType == null || !this.isAssignable(parent, nextHolder, prevViewType)) continue;
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int bottom = child.getTop() - params.topMargin;
            int top = bottom - this.mDrawable.getIntrinsicHeight();
            this.mDrawable.setBounds(left, top, right, bottom);
            this.mDrawable.draw(c);
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        RecyclerView.ViewHolder nextHolder = ForwardingListener.findContainingViewHolder(parent, view);
        Integer prevViewType = this.findPrevViewType(parent, nextHolder);
        if (this.mDrawable != null && nextHolder != null && prevViewType != null && this.isAssignable(parent, nextHolder, prevViewType)) {
            outRect.set(0, this.mDrawable.getIntrinsicHeight(), 0, 0);
        } else {
            outRect.set(0, 0, 0, 0);
        }
    }

    @Nullable
    private Integer findPrevViewType(@NonNull RecyclerView parent, @Nullable RecyclerView.ViewHolder nextHolder) {
        if (nextHolder == null) {
            return null;
        }
        RecyclerView.Adapter adapter = parent.getAdapter();
        if (adapter != null && nextHolder.getAdapterPosition() > 0) {
            return adapter.getItemViewType(nextHolder.getAdapterPosition() - 1);
        }
        return null;
    }

    public boolean isAssignable(@NonNull RecyclerView parent, RecyclerView.ViewHolder nextViewHolder, int prevViewType) {
        return true;
    }

    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public void setDrawable(Drawable drawable) {
        this.mDrawable = drawable;
    }

    public boolean isIgnoreParentPadding() {
        return this.mIgnoreParentPadding;
    }

    public void setIgnoreParentPadding(boolean ignoreParentPadding) {
        this.mIgnoreParentPadding = ignoreParentPadding;
    }
}

