/*
 * Decompiled with CFR 0.152.
 */
package net.cattaka.android.adaptertoolbox.thirdparty;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MergeRecyclerAdapter<T extends RecyclerView.Adapter>
extends RecyclerView.Adapter {
    private Context mContext;
    protected ArrayList<LocalAdapter> mAdapters = new ArrayList();
    private int mViewTypeIndex = 0;

    public MergeRecyclerAdapter() {
    }

    public MergeRecyclerAdapter(Context context) {
        this.mContext = context;
    }

    public void addAdapter(T adapter) {
        this.addAdapter(this.mAdapters.size(), adapter);
    }

    public void addAdapter(T adapter, boolean useNotifyItemRangeInserted) {
        this.addAdapter(this.mAdapters.size(), adapter, useNotifyItemRangeInserted);
    }

    public void addAdapter(int index, T adapter) {
        this.addAdapter(index, adapter, true);
    }

    public void addAdapter(int index, T adapter, boolean useNotifyItemRangeInserted) {
        LocalAdapter la = new LocalAdapter(this, adapter);
        this.mAdapters.add(index, la);
        adapter.registerAdapterDataObserver((RecyclerView.AdapterDataObserver)la);
        if (useNotifyItemRangeInserted) {
            int position = this.getAdapterOffsetForAdapter(la);
            this.notifyItemRangeInserted(position, adapter.getItemCount());
        } else {
            this.notifyDataSetChanged();
        }
    }

    public void removeAdapter(T adapter) {
        this.removeAdapter(adapter, true);
    }

    public void removeAdapter(T adapter, boolean useNotifyItemRangeRemoved) {
        int index = this.indexOfAdapter(adapter);
        if (index != -1) {
            this.removeAdapter(index, useNotifyItemRangeRemoved);
        }
    }

    public void removeAdapter(int index) {
        this.removeAdapter(index, true);
    }

    public void removeAdapter(int index, boolean useNotifyItemRangeRemoved) {
        if (index < 0 || index >= this.mAdapters.size()) {
            return;
        }
        LocalAdapter adapter = this.mAdapters.get(index);
        int position = this.getAdapterOffsetForAdapter(adapter);
        int itemCount = adapter.mAdapter.getItemCount();
        this.mAdapters.remove(index);
        adapter.mAdapter.unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)adapter);
        if (useNotifyItemRangeRemoved) {
            this.notifyItemRangeRemoved(position, itemCount);
        } else {
            this.notifyDataSetChanged();
        }
    }

    public int indexOfAdapter(T adapter) {
        int index = 0;
        for (LocalAdapter la : this.mAdapters) {
            if (la.mAdapter.equals(adapter)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getSubAdapterCount() {
        return this.mAdapters.size();
    }

    public T getSubAdapter(int index) {
        return this.mAdapters.get((int)index).mAdapter;
    }

    public void addView(View view) {
        ArrayList<View> list = new ArrayList<View>(1);
        list.add(view);
        this.addViews(list);
    }

    public void addViews(List<View> views) {
        this.addAdapter(new ViewsAdapter(this.mContext, views));
    }

    public int getItemCount() {
        int count = 0;
        for (LocalAdapter adapter : this.mAdapters) {
            count += adapter.mAdapter.getItemCount();
        }
        return count;
    }

    public LocalAdapter getAdapterOffsetForItem(int position) {
        int adapterCount = this.mAdapters.size();
        int count = 0;
        for (int i = 0; i < adapterCount; ++i) {
            LocalAdapter a = this.mAdapters.get(i);
            int newCount = count + a.mAdapter.getItemCount();
            if (position < newCount) {
                a.mLocalPosition = position - count;
                return a;
            }
            count = newCount;
        }
        return null;
    }

    private int getAdapterOffsetForAdapter(LocalAdapter t) {
        int adapterCount = this.mAdapters.size();
        int count = 0;
        for (int i = 0; i < adapterCount; ++i) {
            LocalAdapter a = this.mAdapters.get(i);
            int newCount = count + a.mAdapter.getItemCount();
            if (a == t) {
                return count;
            }
            count = newCount;
        }
        return -1;
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        LocalAdapter result = this.getAdapterOffsetForItem(position);
        int localViewType = result.mAdapter.getItemViewType(result.mLocalPosition);
        if (result.mViewTypesMap.containsValue(localViewType)) {
            for (Map.Entry<Integer, Integer> entry : result.mViewTypesMap.entrySet()) {
                if (entry.getValue() != localViewType) continue;
                return entry.getKey();
            }
        }
        ++this.mViewTypeIndex;
        result.mViewTypesMap.put(this.mViewTypeIndex, localViewType);
        return this.mViewTypeIndex;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
        for (LocalAdapter adapter : this.mAdapters) {
            if (!adapter.mViewTypesMap.containsKey(viewType)) continue;
            return adapter.mAdapter.onCreateViewHolder(viewGroup, adapter.mViewTypesMap.get(viewType).intValue());
        }
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        LocalAdapter result = this.getAdapterOffsetForItem(position);
        result.mAdapter.onBindViewHolder(viewHolder, result.mLocalPosition);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position, List payloads) {
        LocalAdapter result = this.getAdapterOffsetForItem(position);
        result.mAdapter.onBindViewHolder(viewHolder, result.mLocalPosition, payloads);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        for (LocalAdapter adapter : this.mAdapters) {
            adapter.mAdapter.onAttachedToRecyclerView(recyclerView);
        }
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        for (LocalAdapter adapter : this.mAdapters) {
            adapter.mAdapter.onDetachedFromRecyclerView(recyclerView);
        }
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        super.onViewRecycled(holder);
        LocalAdapter la = this.getAdapterOffsetForItem(holder.getAdapterPosition());
        if (la != null) {
            la.mAdapter.onViewRecycled(holder);
        }
    }

    public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
        LocalAdapter la = this.getAdapterOffsetForItem(holder.getAdapterPosition());
        if (la != null) {
            return la.mAdapter.onFailedToRecycleView(holder);
        }
        return super.onFailedToRecycleView(holder);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        LocalAdapter la = this.getAdapterOffsetForItem(holder.getAdapterPosition());
        if (la != null) {
            la.mAdapter.onViewAttachedToWindow(holder);
        }
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
        LocalAdapter la = this.getAdapterOffsetForItem(holder.getAdapterPosition());
        if (la != null) {
            la.mAdapter.onViewDetachedFromWindow(holder);
        }
    }

    public static class ViewsViewHolder
    extends RecyclerView.ViewHolder {
        public ViewsViewHolder(View itemView) {
            super(itemView);
        }
    }

    public static class ViewsAdapter
    extends RecyclerView.Adapter {
        private List<View> views = null;
        private Context context;

        public ViewsAdapter(Context context, int count) {
            this.context = context;
            this.views = new ArrayList<View>(count);
            for (int i = 0; i < count; ++i) {
                this.views.add(null);
            }
        }

        public ViewsAdapter(Context context, List<View> views) {
            this.context = context;
            this.views = views;
        }

        public int getItemCount() {
            return this.views.size();
        }

        public int getItemViewType(int position) {
            return position;
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
            ViewsViewHolder holder = new ViewsViewHolder(this.views.get(viewType));
            return holder;
        }

        public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        }

        public long getItemId(int position) {
            return position;
        }

        public boolean hasView(View v) {
            return this.views.contains(v);
        }

        protected View newView(int position, ViewGroup parent) {
            throw new RuntimeException("You must override newView()!");
        }
    }

    public static class LocalAdapter
    extends RecyclerView.AdapterDataObserver {
        public final T mAdapter;
        public int mLocalPosition = 0;
        public Map<Integer, Integer> mViewTypesMap = new HashMap<Integer, Integer>();
        final /* synthetic */ MergeRecyclerAdapter this$0;

        public LocalAdapter(T adapter) {
            this.this$0 = this$0;
            this.mAdapter = adapter;
        }

        public void onChanged() {
            this.this$0.notifyDataSetChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            super.onItemRangeChanged(positionStart, itemCount);
            int offset = this.this$0.getAdapterOffsetForAdapter(this);
            this.this$0.notifyItemRangeChanged(offset + positionStart, itemCount);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            super.onItemRangeInserted(positionStart, itemCount);
            int offset = this.this$0.getAdapterOffsetForAdapter(this);
            this.this$0.notifyItemRangeInserted(offset + positionStart, itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            super.onItemRangeRemoved(positionStart, itemCount);
            int offset = this.this$0.getAdapterOffsetForAdapter(this);
            this.this$0.notifyItemRangeRemoved(offset + positionStart, itemCount);
        }
    }
}

