/*
 * Decompiled with CFR 0.152.
 */
package net.cattaka.android.adaptertoolbox.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;
import net.cattaka.android.adaptertoolbox.adapter.AbsTreeItemAdapter;
import net.cattaka.android.adaptertoolbox.data.ITreeItem;

public abstract class AbsChoosableTreeItemAdapter<A extends AbsChoosableTreeItemAdapter<A, VH, T, W>, VH extends RecyclerView.ViewHolder, T extends ITreeItem<T>, W extends WrappedItem<W, T>>
extends AbsTreeItemAdapter<A, VH, T, W> {
    public static final int CHOICE_MODE_MULTIPLE = 2;
    public static final int CHOICE_MODE_SINGLE = 1;
    @ChoiceMode
    private int mChoiceMode = 2;

    public <REF extends AbsTreeItemAdapter.ITreeItemAdapterRef<A, ?, T, W>> AbsChoosableTreeItemAdapter(Context context, List<T> items, REF ref) {
        super(context, items, ref);
    }

    public void toggleCheck(@NonNull W item) {
        this.doCheck(item, !((WrappedItem)item).isChecked());
    }

    public void doCheck(@NonNull W item, boolean checked) {
        if (this.mChoiceMode == 2) {
            if (!checked) {
                WrappedItem p = (WrappedItem)((WrappedItem)item).parent;
                while (p != null) {
                    p.setChecked(checked);
                    this.notifyItemChanged(this.getItems().indexOf(p));
                    p = (WrappedItem)p.parent;
                }
            }
            this.doCheckInner(item, checked);
        } else {
            WrappedItem w;
            int i;
            for (i = 0; i < this.getItemCount(); ++i) {
                w = (WrappedItem)this.getItemAt(i);
                if (w == item) {
                    if (w.isChecked()) continue;
                    this.notifyItemChanged(this.getItems().indexOf(w));
                    continue;
                }
                if (!w.isChecked()) continue;
                this.notifyItemChanged(this.getItems().indexOf(w));
            }
            for (i = 0; i < this.getItemCount(); ++i) {
                w = (WrappedItem)this.getItemAt(i);
                if (w.level != 0) continue;
                this.uncheckAll(w);
            }
            ((WrappedItem)item).setChecked(checked);
        }
    }

    private void doCheckInner(@NonNull W item, boolean checked) {
        ((WrappedItem)item).setChecked(checked);
        for (WrappedItem child : ((WrappedItem)item).children) {
            child.setChecked(checked);
            this.doCheckInner(child, checked);
        }
        this.notifyItemChanged(this.getItems().indexOf(item));
    }

    private void uncheckAll(@NonNull W item) {
        ((WrappedItem)item).setChecked(false);
        if (((WrappedItem)item).children != null) {
            for (WrappedItem child : ((WrappedItem)item).children) {
                this.uncheckAll(child);
            }
        }
    }

    @ChoiceMode
    public int getChoiceMode() {
        return this.mChoiceMode;
    }

    public void setChoiceMode(@ChoiceMode int choiceMode) {
        this.mChoiceMode = choiceMode;
    }

    public List<T> getCheckedItems() {
        ArrayList checkedItems = new ArrayList();
        for (WrappedItem witem : this.getItems()) {
            if (witem.level != 0) continue;
            this.collectCheckedItems(checkedItems, witem);
        }
        return checkedItems;
    }

    private void collectCheckedItems(List<T> dest, W witem) {
        if (witem == null) {
            return;
        }
        if (((WrappedItem)witem).isChecked()) {
            dest.add(((AbsTreeItemAdapter.WrappedItem)witem).getItem());
        }
        if (((WrappedItem)witem).children != null) {
            for (WrappedItem child : ((WrappedItem)witem).children) {
                this.collectCheckedItems(dest, child);
            }
        }
    }

    public static class WrappedItem<W extends WrappedItem<W, T>, T extends ITreeItem<T>>
    extends AbsTreeItemAdapter.WrappedItem<W, T> {
        private boolean checked;

        public WrappedItem(int level, T item, W parent) {
            super(level, item, parent);
        }

        public boolean isChecked() {
            return this.checked;
        }

        void setChecked(boolean checked) {
            this.checked = checked;
        }
    }

    public static @interface ChoiceMode {
    }
}

