package name.remal.gradle_plugins.api;

import org.jetbrains.annotations.NotNull;

public final class BuildTimeConstants {

    /**
     * Invocation of this method will be replaced with actual class name. <b>Class parameter must be a constant expression</b>.
     */
    @NotNull
    public static String getClassName(@NotNull Class<?> clazz) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process this method invocation.");
    }

    /**
     * Invocation of this method will be replaced with actual class simple name. <b>Class parameter must be a constant expression</b>.
     */
    @NotNull
    public static String getClassSimpleName(@NotNull Class<?> clazz) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process this method invocation.");
    }

    /**
     * Invocation of this method will be replaced with actual property value. <b>Property name parameter must be a constant expression</b>.
     */
    @NotNull
    public static String getStringProperty(@NotNull String propertyName) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process this method invocation.");
    }

    /**
     * Invocation of this method will be replaced with actual property value parsed as int. <b>Property name parameter must be a constant expression</b>.
     */
    public static int getIntegerProperty(@NotNull String propertyName) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process this method invocation.");
    }

    /**
     * Invocation of this method will be replaced with actual property value parsed as long. <b>Property name parameter must be a constant expression</b>.
     */
    public static long getLongProperty(@NotNull String propertyName) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process this method invocation.");
    }

    /**
     * Invocation of this method will be replaced with actual property value parsed as boolean. <b>Property name parameter must be a constant expression</b>.
     */
    public static boolean getBooleanProperty(@NotNull String propertyName) {
        throw new UnsupportedOperationException("This method can't be invoked directly. Use 'remal.name.classes-processing' Gradle plugin to process this method invocation.");
    }

    private BuildTimeConstants() {
    }

    static {
        throwIllegalClassUseException();
    }

    private static void throwIllegalClassUseException() {
        throw new UnsupportedOperationException("This class can't be used directly. Use 'remal.name.classes-processing' Gradle plugin to process this class's methods.");
    }

}
