/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.preference.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Arrays;
import java.util.Comparator;
import moe.shizuku.preference.animation.SimpleMenuAnimation;
import moe.shizuku.preference.drawable.FixedBoundsDrawable;
import moe.shizuku.preference.simplemenu.R;
import moe.shizuku.preference.widget.SimpleMenuListAdapter;

@RequiresApi(api=21)
public class SimpleMenuPopupWindow
extends PopupWindow {
    public static final int POPUP_MENU = 0;
    public static final int DIALOG = 1;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected final int[] elevation = new int[2];
    protected final int[][] margin = new int[2][2];
    protected final int[][] listPadding = new int[2][2];
    protected final int itemHeight;
    protected final int dialogMaxWidth;
    protected final int unit;
    protected final int maxUnits;
    private int mMode = 0;
    private boolean mRequestMeasure = true;
    private RecyclerView mList;
    private SimpleMenuListAdapter mAdapter;
    private OnItemClickListener mOnItemClickListener;
    private CharSequence[] mEntries;
    private int mSelectedIndex;
    private int mMeasuredWidth;

    public SimpleMenuPopupWindow(Context context) {
        this(context, null);
    }

    public SimpleMenuPopupWindow(Context context, AttributeSet attrs) {
        this(context, attrs, R.styleable.SimpleMenuPreference_popupStyle);
    }

    public SimpleMenuPopupWindow(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, R.style.Preference_SimpleMenuPreference_Popup);
    }

    @SuppressLint(value={"InflateParams"})
    public SimpleMenuPopupWindow(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.getBackground();
        this.setFocusable(true);
        this.setOutsideTouchable(false);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SimpleMenuPopup, defStyleAttr, defStyleRes);
        this.elevation[0] = (int)a.getDimension(R.styleable.SimpleMenuPopup_listElevation, 4.0f);
        this.elevation[1] = (int)a.getDimension(R.styleable.SimpleMenuPopup_dialogElevation, 48.0f);
        this.margin[0][0] = (int)a.getDimension(R.styleable.SimpleMenuPopup_listMarginHorizontal, 0.0f);
        this.margin[0][1] = (int)a.getDimension(R.styleable.SimpleMenuPopup_listMarginVertical, 0.0f);
        this.margin[1][0] = (int)a.getDimension(R.styleable.SimpleMenuPopup_dialogMarginHorizontal, 0.0f);
        this.margin[1][1] = (int)a.getDimension(R.styleable.SimpleMenuPopup_dialogMarginVertical, 0.0f);
        this.listPadding[0][0] = (int)a.getDimension(R.styleable.SimpleMenuPopup_listItemPadding, 0.0f);
        this.listPadding[1][0] = (int)a.getDimension(R.styleable.SimpleMenuPopup_dialogItemPadding, 0.0f);
        this.dialogMaxWidth = (int)a.getDimension(R.styleable.SimpleMenuPopup_dialogMaxWidth, 0.0f);
        this.unit = (int)a.getDimension(R.styleable.SimpleMenuPopup_unit, 0.0f);
        this.maxUnits = a.getInteger(R.styleable.SimpleMenuPopup_maxUnits, 0);
        this.mList = (RecyclerView)LayoutInflater.from((Context)context).inflate(R.layout.simple_menu_list, null);
        this.mList.setFocusable(true);
        this.mList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.mList.setItemAnimator(null);
        this.setContentView((View)this.mList);
        this.mAdapter = new SimpleMenuListAdapter(this);
        this.mList.setAdapter((RecyclerView.Adapter)this.mAdapter);
        a.recycle();
        this.itemHeight = Math.round(context.getResources().getDisplayMetrics().density * 48.0f);
        int n = Math.round(context.getResources().getDisplayMetrics().density * 8.0f);
        this.listPadding[1][1] = n;
        this.listPadding[0][1] = n;
    }

    public OnItemClickListener getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    protected int getMode() {
        return this.mMode;
    }

    private void setMode(int mode) {
        this.mMode = mode;
    }

    protected CharSequence[] getEntries() {
        return this.mEntries;
    }

    public void setEntries(CharSequence[] entries) {
        this.mEntries = entries;
    }

    protected int getSelectedIndex() {
        return this.mSelectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.mSelectedIndex = selectedIndex;
    }

    public RecyclerView getContentView() {
        return (RecyclerView)super.getContentView();
    }

    public FixedBoundsDrawable getBackground() {
        Drawable background = super.getBackground();
        if (background != null && !(background instanceof FixedBoundsDrawable)) {
            this.setBackgroundDrawable(background);
        }
        return (FixedBoundsDrawable)super.getBackground();
    }

    public void setBackgroundDrawable(Drawable background) {
        if (background == null) {
            throw new IllegalStateException("SimpleMenuPopupWindow must have a background");
        }
        if (!(background instanceof FixedBoundsDrawable)) {
            background = new FixedBoundsDrawable(background);
        }
        super.setBackgroundDrawable(background);
    }

    public void show(View anchor, View container, int extraMargin) {
        int maxMaxWidth = container.getWidth() - this.margin[0][0] * 2;
        int measuredWidth = this.measureWidth(maxMaxWidth, this.mEntries);
        if (measuredWidth == -1) {
            this.setMode(1);
        } else if (measuredWidth != 0) {
            this.setMode(0);
            this.mMeasuredWidth = measuredWidth;
        }
        this.mAdapter.notifyDataSetChanged();
        if (this.mMode == 0) {
            this.showPopupMenu(anchor, container, this.mMeasuredWidth, extraMargin);
        } else {
            this.showDialog(anchor, container);
        }
    }

    private void showDialog(View parent, View container) {
        final int index = Math.max(0, this.mSelectedIndex);
        final int count = this.mEntries.length;
        this.getContentView().setOverScrollMode(1);
        this.getContentView().scrollToPosition(index);
        int width = Math.min(this.dialogMaxWidth, container.getWidth() - this.margin[1][0] * 2);
        this.setWidth(width);
        this.setHeight(-2);
        this.setAnimationStyle(R.style.Animation_SimpleMenuCenter);
        this.setElevation(this.elevation[1]);
        super.showAtLocation(parent, 16, 0, 0);
        this.getContentView().post(new Runnable(){

            @Override
            public void run() {
                int width = SimpleMenuPopupWindow.this.getContentView().getWidth();
                int height = SimpleMenuPopupWindow.this.getContentView().getHeight();
                Rect start = new Rect(width / 2, height / 2, width / 2, height / 2);
                SimpleMenuAnimation.startEnterAnimation((View)SimpleMenuPopupWindow.this.getContentView(), SimpleMenuPopupWindow.this.getBackground(), width, height, width / 2, height / 2, start, SimpleMenuPopupWindow.this.itemHeight, SimpleMenuPopupWindow.this.elevation[1] / 4, index);
            }
        });
        this.getContentView().post(new Runnable(){

            @Override
            public void run() {
                LinearLayoutManager lm = (LinearLayoutManager)SimpleMenuPopupWindow.this.getContentView().getLayoutManager();
                if (lm.findFirstCompletelyVisibleItemPosition() == 0 && lm.findLastCompletelyVisibleItemPosition() == count - 1) {
                    SimpleMenuPopupWindow.this.getContentView().setOverScrollMode(2);
                }
            }
        });
    }

    private void showPopupMenu(View anchor, View container, int width, int extraMargin) {
        int startRight;
        int startLeft;
        int centerY;
        int y;
        boolean rtl = container.getResources().getConfiguration().getLayoutDirection() == 1;
        int index = Math.max(0, this.mSelectedIndex);
        int count = this.mEntries.length;
        int anchorTop = anchor.getTop();
        int anchorHeight = anchor.getHeight();
        final int measuredHeight = this.itemHeight * count + this.listPadding[0][1] * 2;
        int[] location = new int[2];
        container.getLocationInWindow(location);
        int containerTopInWindow = location[1];
        int containerHeight = container.getHeight();
        int height = measuredHeight;
        int elevation = this.elevation[0];
        int centerX = rtl ? location[0] + extraMargin - width + this.listPadding[0][0] : location[0] + extraMargin + this.listPadding[0][0];
        int animItemHeight = this.itemHeight + this.listPadding[0][1] * 2;
        int animIndex = index;
        if (height > containerHeight) {
            y = containerTopInWindow + this.margin[0][1];
            final int scroll = this.itemHeight * index - anchorTop + this.listPadding[0][1] + this.margin[0][1] - anchorHeight / 2 + this.itemHeight / 2;
            this.getContentView().post(new Runnable(){

                @Override
                public void run() {
                    SimpleMenuPopupWindow.this.getContentView().scrollBy(0, -measuredHeight);
                    SimpleMenuPopupWindow.this.getContentView().scrollBy(0, scroll);
                }
            });
            this.getContentView().setOverScrollMode(1);
            height = containerHeight - this.margin[0][1] * 2;
            animIndex = index;
            centerY = this.itemHeight * index;
        } else {
            y = containerTopInWindow + anchorTop + anchorHeight / 2 - this.itemHeight / 2 - this.listPadding[0][1] - index * this.itemHeight;
            int maxY = containerTopInWindow + containerHeight - measuredHeight - this.margin[0][1];
            y = Math.min(y, maxY);
            int minY = containerTopInWindow + this.margin[0][1];
            y = Math.max(y, minY);
            this.getContentView().setOverScrollMode(2);
            centerY = (int)((double)(this.listPadding[0][1] + index * this.itemHeight) + (double)this.itemHeight * 0.5);
        }
        this.setWidth(width);
        this.setHeight(height);
        this.setElevation(elevation);
        this.setAnimationStyle(R.style.Animation_SimpleMenuCenter);
        if (Build.VERSION.SDK_INT >= 23) {
            this.setEnterTransition(null);
            this.setExitTransition(null);
        }
        super.showAtLocation(anchor, 0, centerX, y);
        int startTop = centerY - (int)((double)this.itemHeight * 0.2);
        int startBottom = centerY + (int)((double)this.itemHeight * 0.2);
        if (!rtl) {
            startLeft = centerX;
            startRight = centerX + this.unit;
        } else {
            startLeft = centerX + width - this.unit;
            startRight = centerX + width;
        }
        Rect animStartRect = new Rect(startLeft, startTop, startRight, startBottom);
        int animElevation = (int)Math.round((double)elevation * 0.25);
        SimpleMenuAnimation.postStartEnterAnimation(this, this.getBackground(), width, height, centerX, centerY, animStartRect, animItemHeight, animElevation, animIndex);
    }

    public void requestMeasure() {
        this.mRequestMeasure = true;
    }

    private int measureWidth(int maxWidth, CharSequence[] entries) {
        int w;
        if (!this.mRequestMeasure) {
            return 0;
        }
        this.mRequestMeasure = false;
        entries = Arrays.copyOf(entries, entries.length);
        Arrays.sort(entries, new Comparator<CharSequence>(){

            @Override
            public int compare(CharSequence o1, CharSequence o2) {
                return o2.length() - o1.length();
            }
        });
        Context context = this.getContentView().getContext();
        int width = 0;
        maxWidth = Math.min(this.unit * this.maxUnits, maxWidth);
        Rect bounds = new Rect();
        TextPaint textPaint = new TextPaint();
        textPaint.setTextSize(16.0f * context.getResources().getDisplayMetrics().scaledDensity);
        for (CharSequence chs : entries) {
            textPaint.getTextBounds(chs.toString(), 0, chs.length(), bounds);
            width = Math.max(width, bounds.width() + this.listPadding[0][0] * 2);
            if (width <= maxWidth && !chs.toString().contains("\n")) continue;
            return -1;
        }
        for (w = 0; width > w; w += this.unit) {
        }
        return w;
    }

    public void showAtLocation(View parent, int gravity, int x, int y) {
        throw new UnsupportedOperationException("use show(anchor) to show the window");
    }

    public void showAsDropDown(View anchor) {
        throw new UnsupportedOperationException("use show(anchor) to show the window");
    }

    public void showAsDropDown(View anchor, int xoff, int yoff) {
        throw new UnsupportedOperationException("use show(anchor) to show the window");
    }

    public void showAsDropDown(View anchor, int xoff, int yoff, int gravity) {
        throw new UnsupportedOperationException("use show(anchor) to show the window");
    }

    public static interface OnItemClickListener {
        public void onClick(int var1);
    }
}

