/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.preference.widget;

import android.util.Log;
import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import moe.shizuku.preference.widget.Hack$$;

class Hack {
    public static Class<?> ANY_TYPE = Hack$$.class;
    private static final HackedClass<?> FALLBACK = new HackedClass(ANY_TYPE);
    private static AssertionFailureHandler sFailureHandler;

    public static <T> HackedClass<T> into(@NonNull Class<T> clazz) {
        return new HackedClass<T>(clazz);
    }

    public static <T> HackedClass<T> into(String class_name) {
        try {
            return new HackedClass(Class.forName(class_name));
        }
        catch (ClassNotFoundException e) {
            Hack.fail(new AssertionException(e));
            return new HackedClass(ANY_TYPE);
        }
    }

    public static <C> HackedClass<C> onlyIf(boolean condition, Hacking<HackedClass<C>> hacking) {
        if (condition) {
            return hacking.hack();
        }
        return FALLBACK;
    }

    public static ConditionalHack onlyIf(boolean condition) {
        return condition ? new ConditionalHack(){

            @Override
            public <T> HackedClass<T> into(@NonNull Class<T> clazz) {
                return Hack.into(clazz);
            }

            @Override
            public <T> HackedClass<T> into(String class_name) {
                return Hack.into(class_name);
            }
        } : new ConditionalHack(){

            @Override
            public <T> HackedClass<T> into(@NonNull Class<T> clazz) {
                return FALLBACK;
            }

            @Override
            public <T> HackedClass<T> into(String class_name) {
                return FALLBACK;
            }
        };
    }

    private static void fail(AssertionException e) {
        if (sFailureHandler != null) {
            sFailureHandler.onAssertionFailure(e);
        }
    }

    public static AssertionFailureHandler setAssertionFailureHandler(AssertionFailureHandler handler) {
        AssertionFailureHandler old = sFailureHandler;
        sFailureHandler = handler;
        return old;
    }

    private Hack() {
    }

    private static class Demo {
        boolean mField;
        static String sField;

        static void demo() {
            Demo demo = Hacks.Demo_ctor.invoke(0).statically();
            try {
                Hacks.Demo_methodThrows.invoke().on(demo);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
            Hacks.Demo_staticMethod.invoke(1, "xx").statically();
        }

        Demo(int flags) {
        }

        private void methodThrows() throws InterruptedException, IOException {
        }

        static boolean staticMethod(int a, String c) {
            return false;
        }

        static class Hacks {
            static HackedMethod1<Demo, Void, Unchecked, Unchecked, Unchecked, Integer> Demo_ctor;
            static HackedMethod0<Void, Demo, InterruptedException, IOException, Unchecked> Demo_methodThrows;
            static HackedMethod2<Boolean, Void, Unchecked, Unchecked, Unchecked, Integer, String> Demo_staticMethod;
            @Nullable
            static HackedField<Demo, Boolean> Demo_mField;
            @Nullable
            static HackedTargetField<String> Demo_sField;

            Hacks() {
            }

            static {
                Hack.setAssertionFailureHandler(new AssertionFailureHandler(){

                    @Override
                    public void onAssertionFailure(AssertionException failure) {
                        Log.w((String)"Demo", (String)("Partially incompatible: " + failure.getDebugInfo()));
                    }
                });
                Demo_ctor = Hack.into(Demo.class).constructor().withParam(Integer.TYPE);
                Demo_methodThrows = Hack.into(Demo.class).method("methodThrows").returning(Void.class).fallbackReturning(null).throwing(InterruptedException.class, IOException.class).withoutParams();
                Demo_staticMethod = Hack.into(Demo.class).staticMethod("methodWith2Params").returning(Boolean.TYPE).fallbackReturning(false).withParams(Integer.TYPE, String.class);
                Demo_mField = Hack.into(Demo.class).field("mField").fallbackTo(false);
                Demo_sField = Hack.into(Demo.class).staticField("sField").ofType(String.class);
            }
        }
    }

    public static interface ConditionalHack {
        public <T> HackedClass<T> into(@NonNull Class<T> var1);

        public <T> HackedClass<T> into(String var1);
    }

    public static interface Hacking<T> {
        public T hack();
    }

    public static class HackedClass<C> {
        private final Class<C> mClass;

        @CheckResult
        public <T> MemberFieldToHack<C> field(@NonNull String name) {
            return new MemberFieldToHack(this.mClass, name, 0);
        }

        @CheckResult
        public <T> StaticFieldToHack<C> staticField(@NonNull String name) {
            return new StaticFieldToHack(this.mClass, name, 8);
        }

        @CheckResult
        public NonNullHackedMethod<Void, C, Unchecked, Unchecked, Unchecked> method(String name) {
            return new HackedMethodImpl(this.mClass, name, 0);
        }

        @CheckResult
        public NonNullHackedMethod<Void, Void, Unchecked, Unchecked, Unchecked> staticMethod(String name) {
            return new HackedMethodImpl<Void, Void, Unchecked, Unchecked, Unchecked>(this.mClass, name, 8);
        }

        @CheckResult
        public NonNullHackedInvokable<C, Void, Unchecked, Unchecked, Unchecked> constructor() {
            HackedMethodImpl constructor = new HackedMethodImpl(this.mClass, null, 0);
            constructor.fallbackReturning(null);
            return constructor;
        }

        HackedClass(Class<C> clazz) {
            this.mClass = clazz;
        }
    }

    private static class FallbackInvokable<C>
    implements Invokable<C> {
        @Nullable
        private final Object mValue;

        FallbackInvokable(@Nullable Object value) {
            this.mValue = value;
        }

        @Override
        public Object invoke(C target, Object[] args) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            return this.mValue;
        }

        @Override
        public Class<?> getReturnType() {
            return this.mValue == null ? Object.class : this.mValue.getClass();
        }
    }

    private static class InvokableConstructor<C>
    implements Invokable<C> {
        private final Constructor<C> constructor;

        InvokableConstructor(Constructor<C> method) {
            this.constructor = method;
        }

        @Override
        public Object invoke(C target, Object[] args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.constructor.newInstance(args);
        }

        @Override
        public Class<?> getReturnType() {
            return this.constructor.getDeclaringClass();
        }

        public String toString() {
            return this.constructor.toString();
        }
    }

    private static class InvokableMethod<C>
    implements Invokable<C> {
        private final Method method;

        InvokableMethod(Method method) {
            this.method = method;
        }

        @Override
        public Object invoke(C target, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.method.invoke(target, args);
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        public String toString() {
            return this.method.toString();
        }
    }

    private static class HackedMethodImpl<R, C, T1 extends Throwable, T2 extends Throwable, T3 extends Throwable>
    implements NonNullHackedMethod<R, C, T1, T2, T3> {
        private final Class<C> mClass;
        @Nullable
        private final String mName;
        private final int mModifiers;
        private Class<?> mReturnType;
        private Class<?>[] mThrowTypes;
        private R mFallbackReturnValue;
        private boolean mHasFallback;
        private static final Comparator<Class> CLASS_COMPARATOR = new Comparator<Class>(){

            @Override
            public int compare(Class lhs, Class rhs) {
                return lhs.toString().compareTo(rhs.toString());
            }

            @Override
            public boolean equals(Object object) {
                return this == object;
            }
        };

        HackedMethodImpl(Class<?> clazz, @Nullable String name, int modifiers) {
            this.mClass = clazz;
            this.mName = name;
            this.mModifiers = modifiers;
        }

        @Override
        public <RR> HackedMethod<RR, C, T1, T2, T3> returning(Class<RR> type) {
            this.mReturnType = type;
            HackedMethodImpl casted = this;
            return casted;
        }

        @Override
        public NonNullHackedMethod<R, C, T1, T2, T3> fallbackReturning(R value) {
            this.mFallbackReturnValue = value;
            this.mHasFallback = true;
            return this;
        }

        @Override
        public <TT extends Throwable> NonNullHackedMethod<R, C, TT, T2, T3> throwing(Class<TT> type) {
            this.mThrowTypes = new Class[]{type};
            HackedMethodImpl casted = this;
            return casted;
        }

        @Override
        public <TT1 extends Throwable, TT2 extends Throwable> NonNullHackedMethod<R, C, TT1, TT2, T3> throwing(Class<TT1> type1, Class<TT2> type2) {
            this.mThrowTypes = new Class[]{type1, type2};
            Arrays.sort(this.mThrowTypes, CLASS_COMPARATOR);
            HackedMethodImpl cast = this;
            return cast;
        }

        @Override
        public <TT1 extends Throwable, TT2 extends Throwable, TT3 extends Throwable> NonNullHackedMethod<R, C, TT1, TT2, TT3> throwing(Class<TT1> type1, Class<TT2> type2, Class<TT3> type3) {
            this.mThrowTypes = new Class[]{type1, type2, type3};
            Arrays.sort(this.mThrowTypes, CLASS_COMPARATOR);
            HackedMethodImpl cast = this;
            return cast;
        }

        @Override
        public HackedMethod<R, C, Exception, T2, T3> throwing(Class<?> ... types) {
            this.mThrowTypes = types;
            Arrays.sort(this.mThrowTypes, CLASS_COMPARATOR);
            HackedMethodImpl cast = this;
            return cast;
        }

        @Override
        @NonNull
        public HackedMethod0<R, C, T1, T2, T3> withoutParams() {
            Invokable<C> invokable = this.findInvokable(new Class[0]);
            return invokable == null ? null : new HackedMethod0(invokable);
        }

        @Override
        @NonNull
        public <A1> HackedMethod1<R, C, T1, T2, T3, A1> withParam(Class<A1> type) {
            Invokable<C> invokable = this.findInvokable(type);
            return invokable == null ? null : new HackedMethod1(invokable);
        }

        @Override
        @NonNull
        public <A1, A2> HackedMethod2<R, C, T1, T2, T3, A1, A2> withParams(Class<A1> type1, Class<A2> type2) {
            Invokable<C> invokable = this.findInvokable(type1, type2);
            return invokable == null ? null : new HackedMethod2(invokable);
        }

        @Override
        @NonNull
        public <A1, A2, A3> HackedMethod3<R, C, T1, T2, T3, A1, A2, A3> withParams(Class<A1> type1, Class<A2> type2, Class<A3> type3) {
            Invokable<C> invokable = this.findInvokable(type1, type2, type3);
            return invokable == null ? null : new HackedMethod3(invokable);
        }

        @Override
        @NonNull
        public <A1, A2, A3, A4> HackedMethod4<R, C, T1, T2, T3, A1, A2, A3, A4> withParams(Class<A1> type1, Class<A2> type2, Class<A3> type3, Class<A4> type4) {
            Invokable<C> invokable = this.findInvokable(type1, type2, type3, type4);
            return invokable == null ? null : new HackedMethod4(invokable);
        }

        @Override
        @NonNull
        public <A1, A2, A3, A4, A5> HackedMethod5<R, C, T1, T2, T3, A1, A2, A3, A4, A5> withParams(Class<A1> type1, Class<A2> type2, Class<A3> type3, Class<A4> type4, Class<A5> type5) {
            Invokable<C> invokable = this.findInvokable(type1, type2, type3, type4, type5);
            return invokable == null ? null : new HackedMethod5(invokable);
        }

        @Override
        @NonNull
        public HackedMethodN<R, C, T1, T2, T3> withParams(Class<?> ... types) {
            Invokable<C> invokable = this.findInvokable(types);
            return invokable == null ? null : new HackedMethodN(invokable);
        }

        @Nullable
        private Invokable<C> findInvokable(Class<?> ... param_types) {
            Executable accessible;
            Invokable<C> invokable;
            int modifiers;
            Object[] ex_types;
            if (this.mClass == ANY_TYPE) {
                return this.mHasFallback ? new FallbackInvokable(this.mFallbackReturnValue) : null;
            }
            try {
                if (this.mName != null) {
                    Method candidate;
                    Method method = candidate = this.mClass.getDeclaredMethod(this.mName, param_types);
                    ex_types = candidate.getExceptionTypes();
                    modifiers = method.getModifiers();
                    if (Modifier.isStatic(this.mModifiers) != Modifier.isStatic(candidate.getModifiers())) {
                        Hack.fail(new AssertionException(candidate + (Modifier.isStatic(this.mModifiers) ? " is not static" : "is static")).setHackedMethod(method));
                        method = null;
                    }
                    if (this.mReturnType != null && this.mReturnType != ANY_TYPE && !candidate.getReturnType().equals(this.mReturnType)) {
                        Hack.fail(new AssertionException("Return type mismatch: " + candidate));
                        method = null;
                    }
                    if (method != null) {
                        invokable = new InvokableMethod(method);
                        accessible = method;
                    } else {
                        invokable = null;
                        accessible = null;
                    }
                } else {
                    Constructor<C> ctor = this.mClass.getDeclaredConstructor(param_types);
                    modifiers = ctor.getModifiers();
                    invokable = new InvokableConstructor<C>(ctor);
                    accessible = ctor;
                    ex_types = ctor.getExceptionTypes();
                }
            }
            catch (NoSuchMethodException e) {
                Hack.fail(new AssertionException(e).setHackedClass(this.mClass).setHackedMethodName(this.mName).setParamTypes(param_types));
                return this.mHasFallback ? new FallbackInvokable(this.mFallbackReturnValue) : null;
            }
            if (this.mModifiers > 0 && (modifiers & this.mModifiers) != this.mModifiers) {
                Hack.fail(new AssertionException(invokable + " does not match modifiers: " + this.mModifiers).setHackedMethodName(this.mName));
            }
            if (this.mThrowTypes == null && ex_types.length > 0 || this.mThrowTypes != null && ex_types.length == 0) {
                Hack.fail(new AssertionException("Checked exception(s) not match: " + invokable));
                if (ex_types.length > 0) {
                    invokable = null;
                }
            } else if (this.mThrowTypes != null) {
                Arrays.sort(ex_types, CLASS_COMPARATOR);
                if (!Arrays.equals(ex_types, this.mThrowTypes)) {
                    Hack.fail(new AssertionException("Checked exception(s) not match: " + invokable));
                    invokable = null;
                }
            }
            if (invokable == null) {
                if (!this.mHasFallback) {
                    return null;
                }
                return new FallbackInvokable(this.mFallbackReturnValue);
            }
            if (!accessible.isAccessible()) {
                accessible.setAccessible(true);
            }
            return invokable;
        }
    }

    static interface Invokable<C> {
        public Object invoke(C var1, Object[] var2) throws InvocationTargetException, IllegalAccessException, InstantiationException;

        public Class<?> getReturnType();
    }

    public static class HackInvocation<R, C, T1 extends Throwable, T2 extends Throwable, T3 extends Throwable> {
        private final Invokable invokable;
        private final Object[] args;

        HackInvocation(Invokable invokable, Object ... args) {
            this.invokable = invokable;
            this.args = args;
        }

        public R on(@NonNull C target) throws T1, T2, T3 {
            return this.onTarget(target);
        }

        public R statically() throws T1, T2, T3 {
            return this.onTarget(null);
        }

        private R onTarget(C target) throws T1 {
            try {
                Object result = this.invokable.invoke(target, this.args);
                return (R)result;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                Throwable ex = e.getTargetException();
                throw ex;
            }
        }
    }

    public static class HackedMethodN<R, C, T1 extends Throwable, T2 extends Throwable, T3 extends Throwable>
    extends CheckedHackedMethod<R, C, T1, T2, T3> {
        HackedMethodN(Invokable invokable) {
            super(invokable);
        }

        @Override
        @CheckResult
        public HackInvocation<R, C, T1, T2, T3> invoke(Object ... args) {
            return super.invoke(args);
        }
    }

    public static class HackedMethod5<R, C, T1 extends Throwable, T2 extends Throwable, T3 extends Throwable, A1, A2, A3, A4, A5>
    extends CheckedHackedMethod<R, C, T1, T2, T3> {
        HackedMethod5(Invokable invokable) {
            super(invokable);
        }

        @CheckResult
        public HackInvocation<R, C, T1, T2, T3> invoke(A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
            return super.invoke(arg1, arg2, arg3, arg4, arg5);
        }
    }

    public static class HackedMethod4<R, C, T1 extends Throwable, T2 extends Throwable, T3 extends Throwable, A1, A2, A3, A4>
    extends CheckedHackedMethod<R, C, T1, T2, T3> {
        HackedMethod4(Invokable invokable) {
            super(invokable);
        }

        @CheckResult
        public HackInvocation<R, C, T1, T2, T3> invoke(A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
            return super.invoke(arg1, arg2, arg3, arg4);
        }
    }

    public static class HackedMethod3<R, C, T1 extends Throwable, T2 extends Throwable, T3 extends Throwable, A1, A2, A3>
    extends CheckedHackedMethod<R, C, T1, T2, T3> {
        HackedMethod3(Invokable invokable) {
            super(invokable);
        }

        @CheckResult
        public HackInvocation<R, C, T1, T2, T3> invoke(A1 arg1, A2 arg2, A3 arg3) {
            return super.invoke(arg1, arg2, arg3);
        }
    }

    public static class HackedMethod2<R, C, T1 extends Throwable, T2 extends Throwable, T3 extends Throwable, A1, A2>
    extends CheckedHackedMethod<R, C, T1, T2, T3> {
        HackedMethod2(Invokable invokable) {
            super(invokable);
        }

        @CheckResult
        public HackInvocation<R, C, T1, T2, T3> invoke(A1 arg1, A2 arg2) {
            return super.invoke(arg1, arg2);
        }
    }

    public static class HackedMethod1<R, C, T1 extends Throwable, T2 extends Throwable, T3 extends Throwable, A1>
    extends CheckedHackedMethod<R, C, T1, T2, T3> {
        HackedMethod1(Invokable invokable) {
            super(invokable);
        }

        @CheckResult
        public HackInvocation<R, C, T1, T2, T3> invoke(A1 arg) {
            return super.invoke(arg);
        }
    }

    public static class HackedMethod0<R, C, T1 extends Throwable, T2 extends Throwable, T3 extends Throwable>
    extends CheckedHackedMethod<R, C, T1, T2, T3> {
        HackedMethod0(Invokable invokable) {
            super(invokable);
        }

        @CheckResult
        public HackInvocation<R, C, T1, T2, T3> invoke() {
            return super.invoke(new Object[0]);
        }
    }

    public static class CheckedHackedMethod<R, C, T1 extends Throwable, T2 extends Throwable, T3 extends Throwable> {
        private final Invokable mInvokable;

        CheckedHackedMethod(Invokable invokable) {
            this.mInvokable = invokable;
        }

        public Class<R> getReturnType() {
            return this.mInvokable.getReturnType();
        }

        protected HackInvocation<R, C, T1, T2, T3> invoke(Object ... args) {
            return new HackInvocation(this.mInvokable, args);
        }

        public boolean isAbsent() {
            return this.mInvokable instanceof FallbackInvokable;
        }
    }

    public static interface NonNullHackedMethod<R, C, T1 extends Throwable, T2 extends Throwable, T3 extends Throwable>
    extends HackedMethod<R, C, T1, T2, T3>,
    NonNullHackedInvokable<R, C, T1, T2, T3> {
        @Override
        @CheckResult
        public <RR> HackedMethod<RR, C, T1, T2, T3> returning(Class<RR> var1);

        @Override
        @CheckResult
        public <TT1 extends Throwable> NonNullHackedMethod<R, C, TT1, T2, T3> throwing(Class<TT1> var1);

        @Override
        @CheckResult
        public <TT1 extends Throwable, TT2 extends Throwable> NonNullHackedMethod<R, C, TT1, TT2, T3> throwing(Class<TT1> var1, Class<TT2> var2);

        @Override
        @CheckResult
        public <TT1 extends Throwable, TT2 extends Throwable, TT3 extends Throwable> NonNullHackedMethod<R, C, TT1, TT2, TT3> throwing(Class<TT1> var1, Class<TT2> var2, Class<TT3> var3);
    }

    public static interface HackedMethod<R, C, T1 extends Throwable, T2 extends Throwable, T3 extends Throwable>
    extends HackedInvokable<R, C, T1, T2, T3> {
        @CheckResult
        public <RR> HackedMethod<RR, C, T1, T2, T3> returning(Class<RR> var1);

        @CheckResult
        public NonNullHackedMethod<R, C, T1, T2, T3> fallbackReturning(R var1);

        @Override
        @CheckResult
        public <TT1 extends Throwable> HackedMethod<R, C, TT1, T2, T3> throwing(Class<TT1> var1);

        @Override
        @CheckResult
        public <TT1 extends Throwable, TT2 extends Throwable> HackedMethod<R, C, TT1, TT2, T3> throwing(Class<TT1> var1, Class<TT2> var2);

        @Override
        @CheckResult
        public <TT1 extends Throwable, TT2 extends Throwable, TT3 extends Throwable> HackedMethod<R, C, TT1, TT2, TT3> throwing(Class<TT1> var1, Class<TT2> var2, Class<TT3> var3);

        @CheckResult
        public HackedMethod<R, C, Exception, T2, T3> throwing(Class<?> ... var1);
    }

    public static interface NonNullHackedInvokable<R, C, T1 extends Throwable, T2 extends Throwable, T3 extends Throwable>
    extends HackedInvokable<R, C, T1, T2, T3> {
        @Override
        @CheckResult
        public <TT1 extends Throwable> NonNullHackedInvokable<R, C, TT1, T2, T3> throwing(Class<TT1> var1);

        @Override
        @CheckResult
        public <TT1 extends Throwable, TT2 extends Throwable> NonNullHackedInvokable<R, C, TT1, TT2, T3> throwing(Class<TT1> var1, Class<TT2> var2);

        @Override
        @CheckResult
        public <TT1 extends Throwable, TT2 extends Throwable, TT3 extends Throwable> NonNullHackedInvokable<R, C, TT1, TT2, TT3> throwing(Class<TT1> var1, Class<TT2> var2, Class<TT3> var3);

        @Override
        @NonNull
        public HackedMethod0<R, C, T1, T2, T3> withoutParams();

        @Override
        @NonNull
        public <A1> HackedMethod1<R, C, T1, T2, T3, A1> withParam(Class<A1> var1);

        @Override
        @NonNull
        public <A1, A2> HackedMethod2<R, C, T1, T2, T3, A1, A2> withParams(Class<A1> var1, Class<A2> var2);

        @Override
        @NonNull
        public <A1, A2, A3> HackedMethod3<R, C, T1, T2, T3, A1, A2, A3> withParams(Class<A1> var1, Class<A2> var2, Class<A3> var3);

        @Override
        @NonNull
        public <A1, A2, A3, A4> HackedMethod4<R, C, T1, T2, T3, A1, A2, A3, A4> withParams(Class<A1> var1, Class<A2> var2, Class<A3> var3, Class<A4> var4);

        @Override
        @NonNull
        public <A1, A2, A3, A4, A5> HackedMethod5<R, C, T1, T2, T3, A1, A2, A3, A4, A5> withParams(Class<A1> var1, Class<A2> var2, Class<A3> var3, Class<A4> var4, Class<A5> var5);

        @Override
        @NonNull
        public HackedMethodN<R, C, T1, T2, T3> withParams(Class<?> ... var1);
    }

    public static interface HackedInvokable<R, C, T1 extends Throwable, T2 extends Throwable, T3 extends Throwable> {
        @CheckResult
        public <TT1 extends Throwable> HackedInvokable<R, C, TT1, T2, T3> throwing(Class<TT1> var1);

        @CheckResult
        public <TT1 extends Throwable, TT2 extends Throwable> HackedInvokable<R, C, TT1, TT2, T3> throwing(Class<TT1> var1, Class<TT2> var2);

        @CheckResult
        public <TT1 extends Throwable, TT2 extends Throwable, TT3 extends Throwable> HackedInvokable<R, C, TT1, TT2, TT3> throwing(Class<TT1> var1, Class<TT2> var2, Class<TT3> var3);

        @Nullable
        public HackedMethod0<R, C, T1, T2, T3> withoutParams();

        @Nullable
        public <A1> HackedMethod1<R, C, T1, T2, T3, A1> withParam(Class<A1> var1);

        @Nullable
        public <A1, A2> HackedMethod2<R, C, T1, T2, T3, A1, A2> withParams(Class<A1> var1, Class<A2> var2);

        @Nullable
        public <A1, A2, A3> HackedMethod3<R, C, T1, T2, T3, A1, A2, A3> withParams(Class<A1> var1, Class<A2> var2, Class<A3> var3);

        @Nullable
        public <A1, A2, A3, A4> HackedMethod4<R, C, T1, T2, T3, A1, A2, A3, A4> withParams(Class<A1> var1, Class<A2> var2, Class<A3> var3, Class<A4> var4);

        @Nullable
        public <A1, A2, A3, A4, A5> HackedMethod5<R, C, T1, T2, T3, A1, A2, A3, A4, A5> withParams(Class<A1> var1, Class<A2> var2, Class<A3> var3, Class<A4> var4, Class<A5> var5);

        @Nullable
        public HackedMethodN<R, C, T1, T2, T3> withParams(Class<?> ... var1);
    }

    public static class HackedTargetFieldImpl<T>
    implements HackedTargetField<T> {
        private final Field mField;
        private final Object mInstance;
        @Nullable
        private T mFallbackValue;

        @Override
        public T get() {
            if (this.mField == null) {
                return this.mFallbackValue;
            }
            try {
                Object value = this.mField.get(this.mInstance);
                return (T)value;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }

        @Override
        public void set(T value) {
            if (this.mField != null) {
                try {
                    this.mField.set(this.mInstance, value);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }

        @Override
        @Nullable
        public Class<T> getType() {
            return this.mField.getType();
        }

        @Override
        public boolean isAbsent() {
            return this.mField == null;
        }

        HackedTargetFieldImpl(Field field, @Nullable Object instance) {
            this.mField = field;
            this.mInstance = instance;
        }
    }

    private static class FallbackField<C, T>
    implements HackedField<C, T>,
    HackedTargetField<T> {
        private final Class<T> mType;
        private final T mValue;

        @Override
        public T get(C instance) {
            return this.mValue;
        }

        @Override
        public void set(C instance, T value) {
        }

        @Override
        public T get() {
            return this.mValue;
        }

        @Override
        public void set(T value) {
        }

        @Override
        public HackedTargetField<T> on(C target) {
            return this;
        }

        @Override
        public Class<T> getType() {
            return this.mType;
        }

        @Override
        public boolean isAbsent() {
            return true;
        }

        private FallbackField(Class<T> type, T value) {
            this.mType = type;
            this.mValue = value;
        }
    }

    private static class HackedFieldImpl<C, T>
    implements HackedField<C, T> {
        @NonNull
        private final Field mField;

        @Override
        public HackedTargetFieldImpl<T> on(C target) {
            if (target == null) {
                throw new IllegalArgumentException("target is null");
            }
            return this.onTarget(target);
        }

        private HackedTargetFieldImpl<T> onTarget(@Nullable C target) {
            return new HackedTargetFieldImpl(this.mField, target);
        }

        @Override
        public T get(C instance) {
            try {
                Object value = this.mField.get(instance);
                return (T)value;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }

        @Override
        public void set(C instance, T value) {
            try {
                this.mField.set(instance, value);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }

        @Override
        @Nullable
        public Class<T> getType() {
            return this.mField.getType();
        }

        @Override
        public boolean isAbsent() {
            return false;
        }

        HackedFieldImpl(@NonNull Field field) {
            this.mField = field;
        }

        @Nullable
        public Field getField() {
            return this.mField;
        }
    }

    public static interface HackedTargetField<T> {
        public T get();

        public void set(T var1);

        public Class<T> getType();

        public boolean isAbsent();
    }

    public static interface HackedField<C, T> {
        public T get(C var1);

        public void set(C var1, T var2);

        public HackedTargetField<T> on(C var1);

        public Class<T> getType();

        public boolean isAbsent();
    }

    public static class StaticFieldToHack<C>
    extends FieldToHack<C> {
        @Nullable
        public <T> HackedTargetField<T> ofType(Class<T> type) {
            return this.ofType(type, false, null);
        }

        @Nullable
        public <T> HackedTargetField<T> ofType(String type_name) {
            try {
                return this.ofType(Class.forName(type_name, false, this.mClass.getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                Hack.fail(new AssertionException(e));
                return null;
            }
        }

        @NonNull
        public <T> HackedTargetField<T> fallbackTo(T value) {
            Class<?> type = value == null ? null : value.getClass();
            return this.ofType(type, true, value);
        }

        private <T> HackedTargetField<T> ofType(Class<T> type, boolean fallback, T fallback_value) {
            Field field = this.findField(type);
            return field != null ? new HackedFieldImpl(field).onTarget(null) : (fallback ? new FallbackField(type, fallback_value) : null);
        }

        private StaticFieldToHack(Class<C> clazz, String name, int modifiers) {
            super(clazz, name, modifiers);
        }
    }

    public static class MemberFieldToHack<C>
    extends FieldToHack<C> {
        @Nullable
        public <T> HackedField<C, T> ofType(Class<T> type) {
            return this.ofType(type, false, null);
        }

        @Nullable
        public <T> HackedField<C, T> ofType(String type_name) {
            try {
                return this.ofType(Class.forName(type_name, false, this.mClass.getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                Hack.fail(new AssertionException(e));
                return null;
            }
        }

        @NonNull
        public HackedField<C, Byte> fallbackTo(byte value) {
            return this.ofType(Byte.TYPE, true, value);
        }

        @NonNull
        public HackedField<C, Character> fallbackTo(char value) {
            return this.ofType(Character.TYPE, true, Character.valueOf(value));
        }

        @NonNull
        public HackedField<C, Short> fallbackTo(short value) {
            return this.ofType(Short.TYPE, true, value);
        }

        @NonNull
        public HackedField<C, Integer> fallbackTo(int value) {
            return this.ofType(Integer.TYPE, true, value);
        }

        @NonNull
        public HackedField<C, Long> fallbackTo(long value) {
            return this.ofType(Long.TYPE, true, value);
        }

        @NonNull
        public HackedField<C, Boolean> fallbackTo(boolean value) {
            return this.ofType(Boolean.TYPE, true, value);
        }

        @NonNull
        public HackedField<C, Float> fallbackTo(float value) {
            return this.ofType(Float.TYPE, true, Float.valueOf(value));
        }

        @NonNull
        public HackedField<C, Double> fallbackTo(double value) {
            return this.ofType(Double.TYPE, true, value);
        }

        @NonNull
        public <T> HackedField<C, T> fallbackTo(T value) {
            Class<?> type = value == null ? null : value.getClass();
            return this.ofType(type, true, value);
        }

        private <T> HackedField<C, T> ofType(Class<T> type, boolean fallback, T fallback_value) {
            Field field = this.findField(type);
            return field != null ? new HackedFieldImpl(field) : (fallback ? new FallbackField(type, fallback_value) : null);
        }

        private MemberFieldToHack(Class<C> clazz, String name, int modifiers) {
            super(clazz, name, modifiers);
        }
    }

    public static class FieldToHack<C> {
        protected final Class<C> mClass;
        protected final String mName;
        protected final int mModifiers;

        @Nullable
        protected <T> Field findField(@Nullable Class<T> type) {
            if (this.mClass == ANY_TYPE) {
                return null;
            }
            Field field = null;
            try {
                field = this.mClass.getDeclaredField(this.mName);
                if (Modifier.isStatic(this.mModifiers) != Modifier.isStatic(field.getModifiers())) {
                    Hack.fail(new AssertionException(field + (Modifier.isStatic(this.mModifiers) ? " is not static" : " is static")).setHackedFieldName(this.mName));
                    field = null;
                } else if (this.mModifiers > 0 && (field.getModifiers() & this.mModifiers) != this.mModifiers) {
                    Hack.fail(new AssertionException(field + " does not match modifiers: " + this.mModifiers).setHackedFieldName(this.mName));
                    field = null;
                } else if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
            }
            catch (NoSuchFieldException e) {
                AssertionException hae = new AssertionException(e);
                hae.setHackedClass(this.mClass);
                hae.setHackedFieldName(this.mName);
                Hack.fail(hae);
            }
            if (type != null && field != null && !type.isAssignableFrom(field.getType())) {
                Hack.fail(new AssertionException(new ClassCastException(field + " is not of type " + type)).setHackedField(field));
            }
            return field;
        }

        protected FieldToHack(Class<C> clazz, String name, int modifiers) {
            this.mClass = clazz;
            this.mName = name;
            this.mModifiers = modifiers;
        }
    }

    public static interface AssertionFailureHandler {
        public void onAssertionFailure(AssertionException var1);
    }

    public class Unchecked
    extends RuntimeException {
    }

    public static class AssertionException
    extends Throwable {
        private Class<?> mClass;
        private Field mHackedField;
        private Method mHackedMethod;
        private String mHackedFieldName;
        private String mHackedMethodName;
        private Class<?>[] mParamTypes;
        private static final long serialVersionUID = 1L;

        AssertionException(String e) {
            super(e);
        }

        AssertionException(Exception e) {
            super(e);
        }

        @Override
        public String toString() {
            return this.getCause() != null ? this.getClass().getName() + ": " + this.getCause() : super.toString();
        }

        public String getDebugInfo() {
            StringBuilder info;
            block13: {
                Throwable cause;
                block11: {
                    block12: {
                        info = new StringBuilder(this.getCause() != null ? this.getCause().toString() : super.toString());
                        cause = this.getCause();
                        if (!(cause instanceof NoSuchMethodException)) break block11;
                        info.append(" Potential candidates:");
                        int initial_length = info.length();
                        String name = this.getHackedMethodName();
                        if (name == null) break block12;
                        for (Method method : this.getHackedClass().getDeclaredMethods()) {
                            if (!method.getName().equals(name)) continue;
                            info.append(' ').append(method);
                        }
                        if (info.length() == initial_length) {
                            for (Method method : this.getHackedClass().getDeclaredMethods()) {
                                if (!method.getName().startsWith(name)) continue;
                                info.append(' ').append(method);
                            }
                        }
                        if (info.length() != initial_length) break block13;
                        for (Method method : this.getHackedClass().getDeclaredMethods()) {
                            if (method.getName().startsWith("-")) continue;
                            info.append(' ').append(method);
                        }
                        break block13;
                    }
                    for (Constructor<?> constructor : this.getHackedClass().getDeclaredConstructors()) {
                        info.append(' ').append(constructor);
                    }
                    break block13;
                }
                if (cause instanceof NoSuchFieldException) {
                    Field[] fields;
                    info.append(" Potential candidates:");
                    int initial_length = info.length();
                    String name = this.getHackedFieldName();
                    for (Field field : fields = this.getHackedClass().getDeclaredFields()) {
                        if (!field.getName().equals(name)) continue;
                        info.append(' ').append(field);
                    }
                    if (info.length() == initial_length) {
                        for (Field field : fields) {
                            if (!field.getName().startsWith(name)) continue;
                            info.append(' ').append(field);
                        }
                    }
                    if (info.length() == initial_length) {
                        for (Field field : fields) {
                            if (field.getName().startsWith("$")) continue;
                            info.append(' ').append(field);
                        }
                    }
                }
            }
            return info.toString();
        }

        public Class<?> getHackedClass() {
            return this.mClass;
        }

        AssertionException setHackedClass(Class<?> hacked_class) {
            this.mClass = hacked_class;
            return this;
        }

        public Method getHackedMethod() {
            return this.mHackedMethod;
        }

        AssertionException setHackedMethod(Method method) {
            this.mHackedMethod = method;
            return this;
        }

        public String getHackedMethodName() {
            return this.mHackedMethodName;
        }

        AssertionException setHackedMethodName(String method) {
            this.mHackedMethodName = method;
            return this;
        }

        public Class<?>[] getParamTypes() {
            return this.mParamTypes;
        }

        AssertionException setParamTypes(Class<?>[] param_types) {
            this.mParamTypes = param_types;
            return this;
        }

        public Field getHackedField() {
            return this.mHackedField;
        }

        AssertionException setHackedField(Field field) {
            this.mHackedField = field;
            return this;
        }

        public String getHackedFieldName() {
            return this.mHackedFieldName;
        }

        AssertionException setHackedFieldName(String field) {
            this.mHackedFieldName = field;
            return this;
        }
    }
}

