/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.preference;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.core.content.res.TypedArrayUtils;
import androidx.fragment.app.DialogFragment;
import moe.shizuku.preference.DialogPreference;
import moe.shizuku.preference.EditTextPreferenceDialogFragment;
import moe.shizuku.preference.Preference;
import moe.shizuku.preference.R;

public class EditTextPreference
extends DialogPreference {
    private String mText;
    private String mSummary;
    private String mHint;
    private int mInputType;
    private boolean mSingleLine;
    private boolean mSelectAllOnFocus;
    private boolean mCommitOnEnter;

    @SuppressLint(value={"RestrictedApi"})
    public EditTextPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.EditTextPreference);
        this.mInputType = TypedArrayUtils.getInt((TypedArray)a, (int)R.styleable.EditTextPreference_inputType, (int)R.styleable.EditTextPreference_android_inputType, (int)1);
        this.mSingleLine = TypedArrayUtils.getBoolean((TypedArray)a, (int)R.styleable.EditTextPreference_singleLine, (int)R.styleable.EditTextPreference_android_singleLine, (boolean)true);
        this.mSelectAllOnFocus = TypedArrayUtils.getBoolean((TypedArray)a, (int)R.styleable.EditTextPreference_selectAllOnFocus, (int)R.styleable.EditTextPreference_android_selectAllOnFocus, (boolean)false);
        this.mHint = TypedArrayUtils.getString((TypedArray)a, (int)R.styleable.EditTextPreference_hint, (int)R.styleable.EditTextPreference_android_hint);
        this.mCommitOnEnter = a.getBoolean(R.styleable.EditTextPreference_commitOnEnter, false);
        a.recycle();
        a = context.obtainStyledAttributes(attrs, R.styleable.Preference, defStyleAttr, defStyleRes);
        this.mSummary = TypedArrayUtils.getString((TypedArray)a, (int)R.styleable.Preference_summary, (int)R.styleable.Preference_android_summary);
        a.recycle();
    }

    public EditTextPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, R.style.Preference_DialogPreference_EditTextPreference_Material);
    }

    public EditTextPreference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.editTextPreferenceStyle);
    }

    public EditTextPreference(Context context) {
        this(context, null);
    }

    @Override
    @NonNull
    protected DialogFragment onCreateDialogFragment(String key) {
        EditTextPreferenceDialogFragment fragment = new EditTextPreferenceDialogFragment();
        Bundle b = new Bundle(1);
        b.putString("key", key);
        fragment.setArguments(b);
        return fragment;
    }

    public void setText(String text) {
        boolean isBlocking;
        boolean wasBlocking = this.shouldDisableDependents();
        boolean changed = !TextUtils.equals((CharSequence)this.mText, (CharSequence)text);
        this.mText = text;
        if (changed) {
            this.persistString(text);
            this.notifyChanged();
        }
        if ((isBlocking = this.shouldDisableDependents()) != wasBlocking) {
            this.notifyDependencyChange(isBlocking);
        }
    }

    @Override
    public CharSequence getSummary() {
        String entry = this.getText();
        if (this.mSummary == null) {
            return super.getSummary();
        }
        return String.format(this.mSummary, entry == null ? "" : entry);
    }

    @Override
    public void setSummary(CharSequence summary) {
        super.setSummary(summary);
        if (summary == null && this.mSummary != null) {
            this.mSummary = null;
        } else if (summary != null && !summary.equals(this.mSummary)) {
            this.mSummary = summary.toString();
        }
    }

    public String getText() {
        return this.mText;
    }

    public int getInputType() {
        return this.mInputType;
    }

    public String getHint() {
        return this.mHint;
    }

    public boolean isSingleLine() {
        return this.mSingleLine;
    }

    public boolean isSelectAllOnFocus() {
        return this.mSelectAllOnFocus;
    }

    public boolean isCommitOnEnter() {
        return this.mCommitOnEnter;
    }

    @Override
    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getString(index);
    }

    @Override
    protected void onSetInitialValue(boolean restoreValue, Object defaultValue) {
        this.setText(restoreValue ? this.getPersistedString(this.mText) : (String)defaultValue);
    }

    @Override
    public boolean shouldDisableDependents() {
        return TextUtils.isEmpty((CharSequence)this.mText) || super.shouldDisableDependents();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.text = this.getText();
        return myState;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        this.setText(myState.text);
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        String text;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.text = source.readString();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeString(this.text);
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }
    }
}

