/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.preference;

import android.content.DialogInterface;
import android.os.Bundle;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import moe.shizuku.preference.MultiSelectListPreference;
import moe.shizuku.preference.PreferenceDialogBuilder;
import moe.shizuku.preference.PreferenceDialogFragment;

public class MultiSelectListPreferenceDialogFragment
extends PreferenceDialogFragment {
    private static final String SAVE_STATE_VALUES = "MultiSelectListPreferenceDialogFragment.values";
    private static final String SAVE_STATE_CHANGED = "MultiSelectListPreferenceDialogFragment.changed";
    private static final String SAVE_STATE_ENTRIES = "MultiSelectListPreferenceDialogFragment.entries";
    private static final String SAVE_STATE_ENTRY_VALUES = "MultiSelectListPreferenceDialogFragment.entryValues";
    private Set<String> mNewValues = new HashSet<String>();
    private boolean mPreferenceChanged;
    private CharSequence[] mEntries;
    private CharSequence[] mEntryValues;

    private MultiSelectListPreference getListPreference() {
        return (MultiSelectListPreference)this.getPreference();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            MultiSelectListPreference preference = this.getListPreference();
            if (preference.getEntries() == null || preference.getEntryValues() == null) {
                throw new IllegalStateException("MultiSelectListPreference requires an entries array and an entryValues array.");
            }
            this.mNewValues.clear();
            this.mNewValues.addAll(preference.getValues());
            this.mPreferenceChanged = false;
            this.mEntries = preference.getEntries();
            this.mEntryValues = preference.getEntryValues();
        } else {
            this.mNewValues.clear();
            this.mNewValues.addAll(savedInstanceState.getStringArrayList(SAVE_STATE_VALUES));
            this.mPreferenceChanged = savedInstanceState.getBoolean(SAVE_STATE_CHANGED, false);
            this.mEntries = savedInstanceState.getCharSequenceArray(SAVE_STATE_ENTRIES);
            this.mEntryValues = savedInstanceState.getCharSequenceArray(SAVE_STATE_ENTRY_VALUES);
        }
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putStringArrayList(SAVE_STATE_VALUES, new ArrayList<String>(this.mNewValues));
        outState.putBoolean(SAVE_STATE_CHANGED, this.mPreferenceChanged);
        outState.putCharSequenceArray(SAVE_STATE_ENTRIES, this.mEntries);
        outState.putCharSequenceArray(SAVE_STATE_ENTRY_VALUES, this.mEntryValues);
    }

    @Override
    protected void onPrepareDialogBuilder(PreferenceDialogBuilder builder) {
        super.onPrepareDialogBuilder(builder);
        int entryCount = this.mEntryValues.length;
        boolean[] checkedItems = new boolean[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            checkedItems[i] = this.mNewValues.contains(this.mEntryValues[i].toString());
        }
        builder.setMultiChoiceItems(this.mEntries, checkedItems, new DialogInterface.OnMultiChoiceClickListener(){

            public void onClick(DialogInterface dialog, int which, boolean isChecked) {
                if (isChecked) {
                    MultiSelectListPreferenceDialogFragment.this.mPreferenceChanged = MultiSelectListPreferenceDialogFragment.this.mPreferenceChanged | MultiSelectListPreferenceDialogFragment.this.mNewValues.add(MultiSelectListPreferenceDialogFragment.this.mEntryValues[which].toString());
                } else {
                    MultiSelectListPreferenceDialogFragment.this.mPreferenceChanged = MultiSelectListPreferenceDialogFragment.this.mPreferenceChanged | MultiSelectListPreferenceDialogFragment.this.mNewValues.remove(MultiSelectListPreferenceDialogFragment.this.mEntryValues[which].toString());
                }
            }
        });
    }

    @Override
    public void onDialogClosed(boolean positiveResult) {
        Set<String> values;
        MultiSelectListPreference preference = this.getListPreference();
        if (positiveResult && this.mPreferenceChanged && preference.callChangeListener(values = this.mNewValues)) {
            preference.setValues(values);
        }
        this.mPreferenceChanged = false;
    }
}

