/*
 * Decompiled with CFR 0.152.
 */
package moe.shizuku.preference;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.XmlRes;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.RecyclerViewAccessibilityDelegate;
import moe.shizuku.preference.DialogPreference;
import moe.shizuku.preference.Preference;
import moe.shizuku.preference.PreferenceCategory;
import moe.shizuku.preference.PreferenceGroup;
import moe.shizuku.preference.PreferenceGroupAdapter;
import moe.shizuku.preference.PreferenceManager;
import moe.shizuku.preference.PreferenceRecyclerViewAccessibilityDelegate;
import moe.shizuku.preference.PreferenceScreen;
import moe.shizuku.preference.R;

public abstract class PreferenceFragment
extends Fragment
implements PreferenceManager.OnPreferenceTreeClickListener,
PreferenceManager.OnDisplayPreferenceDialogListener,
PreferenceManager.OnNavigateToScreenListener,
DialogPreference.TargetFragment {
    public static final String ARG_PREFERENCE_ROOT = "moe.shizuku.preference.PreferenceFragment.PREFERENCE_ROOT";
    private static final String PREFERENCES_TAG = "android:preferences";
    private static final String DIALOG_FRAGMENT_TAG = "moe.shizuku.preference.PreferenceFragment.DIALOG";
    private PreferenceManager mPreferenceManager;
    private RecyclerView mList;
    private boolean mHavePrefs;
    private boolean mInitDone;
    private Context mStyledContext;
    private int mLayoutResId = R.layout.preference_list_fragment;
    private DividerDecoration mDividerDecoration;
    private static final int MSG_BIND_PREFERENCES = 1;
    @SuppressLint(value={"HandlerLeak"})
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PreferenceFragment.this.bindPreferences();
                }
            }
        }
    };
    private final Runnable mRequestFocus = new Runnable(){

        @Override
        public void run() {
            PreferenceFragment.this.mList.focusableViewAvailable((View)PreferenceFragment.this.mList);
        }
    };
    private Runnable mSelectPreferenceRunnable;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        TypedValue tv = new TypedValue();
        this.getActivity().getTheme().resolveAttribute(R.attr.preferenceTheme, tv, true);
        int theme = tv.resourceId;
        if (theme <= 0) {
            throw new IllegalStateException("Must specify preferenceTheme in theme");
        }
        this.mStyledContext = new ContextThemeWrapper((Context)this.getActivity(), theme);
        this.mPreferenceManager = new PreferenceManager(this.mStyledContext);
        this.mPreferenceManager.setFragment(this);
        this.mPreferenceManager.setOnNavigateToScreenListener(this);
        Bundle args = this.getArguments();
        String rootKey = args != null ? this.getArguments().getString(ARG_PREFERENCE_ROOT) : null;
        this.onCreatePreferences(savedInstanceState, rootKey);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.mPreferenceManager.dispatchActivityResult(requestCode, resultCode, data);
    }

    public abstract void onCreatePreferences(Bundle var1, String var2);

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        TypedArray a = this.mStyledContext.obtainStyledAttributes(null, R.styleable.PreferenceFragment, R.attr.preferenceFragmentStyle, 0);
        this.mLayoutResId = a.getResourceId(R.styleable.PreferenceFragment_android_layout, this.mLayoutResId);
        Drawable divider = a.getDrawable(R.styleable.PreferenceFragment_android_divider);
        int dividerHeight = a.getDimensionPixelSize(R.styleable.PreferenceFragment_android_dividerHeight, -1);
        boolean allowDividerAfterLastItem = a.getBoolean(R.styleable.PreferenceFragment_allowDividerAfterLastItem, false);
        a.recycle();
        TypedValue tv = new TypedValue();
        this.getActivity().getTheme().resolveAttribute(R.attr.preferenceTheme, tv, true);
        int theme = tv.resourceId;
        ContextThemeWrapper themedContext = new ContextThemeWrapper(inflater.getContext(), theme);
        LayoutInflater themedInflater = inflater.cloneInContext((Context)themedContext);
        View view = themedInflater.inflate(this.mLayoutResId, container, false);
        View rawListContainer = view.findViewById(R.id.list_container);
        if (!(rawListContainer instanceof ViewGroup)) {
            throw new RuntimeException("Content has view with id attribute 'R.id.list_container' that is not a ViewGroup class");
        }
        ViewGroup listContainer = (ViewGroup)rawListContainer;
        RecyclerView listView = this.onCreateRecyclerView(themedInflater, listContainer, savedInstanceState);
        if (listView == null) {
            throw new RuntimeException("Could not create RecyclerView");
        }
        this.mList = listView;
        this.mDividerDecoration = this.onCreateItemDecoration();
        if (this.mDividerDecoration != null) {
            this.mList.addItemDecoration((RecyclerView.ItemDecoration)this.mDividerDecoration);
        }
        this.setDivider(divider);
        if (dividerHeight != -1) {
            this.setDividerHeight(dividerHeight);
        }
        this.mDividerDecoration.setAllowDividerAfterLastItem(allowDividerAfterLastItem);
        listContainer.addView((View)this.mList);
        this.mHandler.post(this.mRequestFocus);
        return view;
    }

    @Nullable
    public DividerDecoration onCreateItemDecoration() {
        return new DefaultDividerDecoration();
    }

    public void setDivider(Drawable divider) {
        this.mDividerDecoration.setDivider(divider);
    }

    public void setDividerHeight(int height) {
        this.mDividerDecoration.setDividerHeight(height);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.mHavePrefs) {
            this.bindPreferences();
            if (this.mSelectPreferenceRunnable != null) {
                this.mSelectPreferenceRunnable.run();
                this.mSelectPreferenceRunnable = null;
            }
        }
        this.mInitDone = true;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        PreferenceScreen preferenceScreen;
        Bundle container;
        super.onActivityCreated(savedInstanceState);
        if (savedInstanceState != null && (container = savedInstanceState.getBundle(PREFERENCES_TAG)) != null && (preferenceScreen = this.getPreferenceScreen()) != null) {
            preferenceScreen.restoreHierarchyState(container);
        }
    }

    public void onStart() {
        super.onStart();
        this.mPreferenceManager.setOnPreferenceTreeClickListener(this);
        this.mPreferenceManager.setOnDisplayPreferenceDialogListener(this);
    }

    public void onStop() {
        super.onStop();
        this.mPreferenceManager.dispatchActivityStop();
        this.mPreferenceManager.setOnPreferenceTreeClickListener(null);
        this.mPreferenceManager.setOnDisplayPreferenceDialogListener(null);
    }

    public void onDestroyView() {
        this.mHandler.removeCallbacks(this.mRequestFocus);
        this.mHandler.removeMessages(1);
        if (this.mHavePrefs) {
            this.unbindPreferences();
        }
        this.mList = null;
        super.onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mPreferenceManager.dispatchActivityDestroy();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        if (preferenceScreen != null) {
            Bundle container = new Bundle();
            preferenceScreen.saveHierarchyState(container);
            outState.putBundle(PREFERENCES_TAG, container);
        }
    }

    public PreferenceManager getPreferenceManager() {
        return this.mPreferenceManager;
    }

    public void setPreferenceScreen(PreferenceScreen preferenceScreen) {
        if (this.mPreferenceManager.setPreferences(preferenceScreen) && preferenceScreen != null) {
            this.onUnbindPreferences();
            this.mHavePrefs = true;
            if (this.mInitDone) {
                this.postBindPreferences();
            }
        }
    }

    public PreferenceScreen getPreferenceScreen() {
        return this.mPreferenceManager.getPreferenceScreen();
    }

    public void addPreferencesFromResource(@XmlRes int preferencesResId) {
        this.requirePreferenceManager();
        this.setPreferenceScreen(this.mPreferenceManager.inflateFromResource(this.mStyledContext, preferencesResId, this.getPreferenceScreen()));
    }

    public void setPreferencesFromResource(@XmlRes int preferencesResId, @Nullable String key) {
        Preference root;
        this.requirePreferenceManager();
        PreferenceScreen xmlRoot = this.mPreferenceManager.inflateFromResource(this.mStyledContext, preferencesResId, null);
        if (key != null) {
            root = xmlRoot.findPreference(key);
            if (!(root instanceof PreferenceScreen)) {
                throw new IllegalArgumentException("Preference object with key " + key + " is not a PreferenceScreen");
            }
        } else {
            root = xmlRoot;
        }
        this.setPreferenceScreen((PreferenceScreen)root);
    }

    @Override
    public boolean onPreferenceTreeClick(Preference preference) {
        if (preference.getFragment() != null) {
            boolean handled = false;
            if (this.getCallbackFragment() instanceof OnPreferenceStartFragmentCallback) {
                handled = ((OnPreferenceStartFragmentCallback)this.getCallbackFragment()).onPreferenceStartFragment(this, preference);
            }
            if (!handled && this.getActivity() instanceof OnPreferenceStartFragmentCallback) {
                handled = ((OnPreferenceStartFragmentCallback)this.getActivity()).onPreferenceStartFragment(this, preference);
            }
            return handled;
        }
        return false;
    }

    @Override
    public void onNavigateToScreen(PreferenceScreen preferenceScreen) {
        boolean handled = false;
        if (this.getCallbackFragment() instanceof OnPreferenceStartScreenCallback) {
            handled = ((OnPreferenceStartScreenCallback)this.getCallbackFragment()).onPreferenceStartScreen(this, preferenceScreen);
        }
        if (!handled && this.getActivity() instanceof OnPreferenceStartScreenCallback) {
            ((OnPreferenceStartScreenCallback)this.getActivity()).onPreferenceStartScreen(this, preferenceScreen);
        }
    }

    @Override
    public Preference findPreference(CharSequence key) {
        if (this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.findPreference(key);
    }

    private void requirePreferenceManager() {
        if (this.mPreferenceManager == null) {
            throw new RuntimeException("This should be called after super.onCreate.");
        }
    }

    private void postBindPreferences() {
        if (this.mHandler.hasMessages(1)) {
            return;
        }
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    private void bindPreferences() {
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        if (preferenceScreen != null) {
            this.getListView().setAdapter(this.onCreateAdapter(preferenceScreen));
            preferenceScreen.onAttached();
        }
        this.onBindPreferences();
    }

    private void unbindPreferences() {
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        if (preferenceScreen != null) {
            preferenceScreen.onDetached();
        }
        this.onUnbindPreferences();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void onBindPreferences() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void onUnbindPreferences() {
    }

    public final RecyclerView getListView() {
        return this.mList;
    }

    public RecyclerView onCreateRecyclerView(LayoutInflater inflater, ViewGroup parent, Bundle savedInstanceState) {
        RecyclerView recyclerView = (RecyclerView)inflater.inflate(R.layout.preference_recyclerview, parent, false);
        recyclerView.setLayoutManager(this.onCreateLayoutManager());
        recyclerView.setAccessibilityDelegateCompat((RecyclerViewAccessibilityDelegate)new PreferenceRecyclerViewAccessibilityDelegate(recyclerView));
        return recyclerView;
    }

    public RecyclerView.LayoutManager onCreateLayoutManager() {
        return new LinearLayoutManager((Context)this.getActivity());
    }

    protected RecyclerView.Adapter onCreateAdapter(PreferenceScreen preferenceScreen) {
        return new PreferenceGroupAdapter(preferenceScreen);
    }

    @Override
    public void onDisplayPreferenceDialog(Preference preference) {
        boolean handled = false;
        if (this.getCallbackFragment() instanceof OnPreferenceDisplayDialogCallback) {
            handled = ((OnPreferenceDisplayDialogCallback)this.getCallbackFragment()).onPreferenceDisplayDialog(this, preference);
        }
        if (!handled && this.getActivity() instanceof OnPreferenceDisplayDialogCallback) {
            handled = ((OnPreferenceDisplayDialogCallback)this.getActivity()).onPreferenceDisplayDialog(this, preference);
        }
        if (handled) {
            return;
        }
        if (this.getFragmentManager().findFragmentByTag(DIALOG_FRAGMENT_TAG) != null) {
            return;
        }
        DialogFragment f = null;
        if (preference instanceof DialogPreference) {
            f = ((DialogPreference)preference).onCreateDialogFragment(preference.getKey());
        }
        f.setTargetFragment((Fragment)this, 0);
        f.show(this.getFragmentManager(), DIALOG_FRAGMENT_TAG);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Fragment getCallbackFragment() {
        return null;
    }

    public void scrollToPreference(String key) {
        this.scrollToPreferenceInternal(null, key);
    }

    public void scrollToPreference(Preference preference) {
        this.scrollToPreferenceInternal(preference, null);
    }

    private void scrollToPreferenceInternal(final Preference preference, final String key) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                RecyclerView.Adapter adapter = PreferenceFragment.this.mList.getAdapter();
                if (!(adapter instanceof PreferenceGroup.PreferencePositionCallback)) {
                    if (adapter != null) {
                        throw new IllegalStateException("Adapter must implement PreferencePositionCallback");
                    }
                    return;
                }
                int position = preference != null ? ((PreferenceGroup.PreferencePositionCallback)adapter).getPreferenceAdapterPosition(preference) : ((PreferenceGroup.PreferencePositionCallback)adapter).getPreferenceAdapterPosition(key);
                if (position != -1) {
                    PreferenceFragment.this.mList.scrollToPosition(position);
                } else {
                    adapter.registerAdapterDataObserver((RecyclerView.AdapterDataObserver)new ScrollToPreferenceObserver(adapter, PreferenceFragment.this.mList, preference, key));
                }
            }
        };
        if (this.mList == null) {
            this.mSelectPreferenceRunnable = r;
        } else {
            r.run();
        }
    }

    public class CategoryDivideDividerDecoration
    extends DefaultDividerDecoration {
        private static final int PADDING_DP = 8;
        private int mPadding;

        public CategoryDivideDividerDecoration() {
            this(Math.round(8.0f * this$0.getActivity().getResources().getDisplayMetrics().density));
        }

        public CategoryDivideDividerDecoration(int padding) {
            this.mPadding = padding;
        }

        @Override
        public boolean shouldDrawDividerBelow(View view, RecyclerView parent, PreferenceGroupAdapter adapter, int index, Preference preference) {
            Preference nextPreference = adapter.getItem(index + 1);
            return !(preference instanceof PreferenceCategory) && nextPreference instanceof PreferenceCategory;
        }

        @Override
        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            if (this.shouldDrawDividerBelow(view, parent)) {
                Preference preference;
                PreferenceGroupAdapter adapter = (PreferenceGroupAdapter)parent.getAdapter();
                int index = parent.getChildAdapterPosition(view);
                if (index < adapter.getItemCount() - 1 && (preference = adapter.getItem(index + 1)) instanceof PreferenceCategory) {
                    outRect.bottom = this.mPadding + this.getDividerHeight();
                    return;
                }
                outRect.bottom = this.mPadding * 2 + this.getDividerHeight();
            }
        }

        @Override
        public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
            if (this.getDivider() == null) {
                return;
            }
            int childCount = parent.getChildCount();
            int width = parent.getWidth();
            for (int childViewIndex = 0; childViewIndex < childCount; ++childViewIndex) {
                View view = parent.getChildAt(childViewIndex);
                if (!this.shouldDrawDividerBelow(view, parent)) continue;
                int top = (int)view.getY() + view.getHeight() + this.mPadding;
                this.getDivider().setBounds(0, top, width, top + this.getDividerHeight());
                this.getDivider().draw(c);
            }
        }
    }

    public class DefaultDividerDecoration
    extends DividerDecoration {
        @Override
        public boolean shouldDrawDividerBelow(View view, RecyclerView parent, PreferenceGroupAdapter adapter, int index, Preference preference) {
            Preference nextPreference = adapter.getItem(index + 1);
            return !(preference instanceof PreferenceCategory) && !(nextPreference instanceof PreferenceCategory);
        }
    }

    public abstract class DividerDecoration
    extends RecyclerView.ItemDecoration {
        private Drawable mDivider;
        private int mDividerHeight;
        private boolean mAllowDividerAfterLastItem = false;

        public final boolean shouldDrawDividerBelow(View view, RecyclerView parent) {
            if (!(parent.getAdapter() instanceof PreferenceGroupAdapter)) {
                return false;
            }
            PreferenceGroupAdapter adapter = (PreferenceGroupAdapter)parent.getAdapter();
            int index = parent.getChildAdapterPosition(view);
            if (index == -1) {
                return false;
            }
            Preference preference = adapter.getItem(index);
            switch (preference.getDividerBelowVisibility()) {
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            if (index == adapter.getItemCount() - 1) {
                return this.isAllowDividerAfterLastItem();
            }
            return this.shouldDrawDividerBelow(view, parent, adapter, index, preference);
        }

        public abstract boolean shouldDrawDividerBelow(View var1, RecyclerView var2, PreferenceGroupAdapter var3, int var4, Preference var5);

        public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
            if (this.mDivider == null) {
                return;
            }
            int childCount = parent.getChildCount();
            int width = parent.getWidth();
            for (int childViewIndex = 0; childViewIndex < childCount; ++childViewIndex) {
                View view = parent.getChildAt(childViewIndex);
                if (!this.shouldDrawDividerBelow(view, parent)) continue;
                int top = (int)view.getY() + view.getHeight();
                this.mDivider.setBounds(0, top, width, top + this.mDividerHeight);
                this.mDivider.draw(c);
            }
        }

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            if (this.shouldDrawDividerBelow(view, parent)) {
                outRect.bottom = this.mDividerHeight;
            }
        }

        public Drawable getDivider() {
            return this.mDivider;
        }

        public void setDivider(Drawable divider) {
            this.mDividerHeight = divider != null ? divider.getIntrinsicHeight() : 0;
            this.mDivider = divider;
            PreferenceFragment.this.mList.invalidateItemDecorations();
        }

        public int getDividerHeight() {
            return this.mDividerHeight;
        }

        public void setDividerHeight(int dividerHeight) {
            this.mDividerHeight = dividerHeight;
            PreferenceFragment.this.mList.invalidateItemDecorations();
        }

        public boolean isAllowDividerAfterLastItem() {
            return this.mAllowDividerAfterLastItem;
        }

        public void setAllowDividerAfterLastItem(boolean allowDividerAfterLastItem) {
            this.mAllowDividerAfterLastItem = allowDividerAfterLastItem;
        }
    }

    private static class ScrollToPreferenceObserver
    extends RecyclerView.AdapterDataObserver {
        private final RecyclerView.Adapter mAdapter;
        private final RecyclerView mList;
        private final Preference mPreference;
        private final String mKey;

        public ScrollToPreferenceObserver(RecyclerView.Adapter adapter, RecyclerView list, Preference preference, String key) {
            this.mAdapter = adapter;
            this.mList = list;
            this.mPreference = preference;
            this.mKey = key;
        }

        private void scrollToPreference() {
            this.mAdapter.unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)this);
            int position = this.mPreference != null ? ((PreferenceGroup.PreferencePositionCallback)this.mAdapter).getPreferenceAdapterPosition(this.mPreference) : ((PreferenceGroup.PreferencePositionCallback)this.mAdapter).getPreferenceAdapterPosition(this.mKey);
            if (position != -1) {
                this.mList.scrollToPosition(position);
            }
        }

        public void onChanged() {
            this.scrollToPreference();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            this.scrollToPreference();
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            this.scrollToPreference();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            this.scrollToPreference();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            this.scrollToPreference();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            this.scrollToPreference();
        }
    }

    public static interface OnPreferenceDisplayDialogCallback {
        public boolean onPreferenceDisplayDialog(PreferenceFragment var1, Preference var2);
    }

    public static interface OnPreferenceStartScreenCallback {
        public boolean onPreferenceStartScreen(PreferenceFragment var1, PreferenceScreen var2);
    }

    public static interface OnPreferenceStartFragmentCallback {
        public boolean onPreferenceStartFragment(PreferenceFragment var1, Preference var2);
    }
}

