/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.dynamic;

import com.mockobjects.dynamic.CallCollection;
import com.mockobjects.dynamic.Callable;
import com.mockobjects.dynamic.CallableAddable;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CallBag
extends CallCollection
implements Callable,
CallableAddable {
    private List expectedCalls = new ArrayList();
    private List expectedMatches = new ArrayList();

    public void reset() {
        this.expectedCalls.clear();
        this.expectedMatches.clear();
    }

    public Object call(Mock mock, String methodName, Object[] args) throws Throwable {
        Callable matchingCall = this.findMatchingCall(methodName, args, this.expectedCalls);
        if (matchingCall == null) {
            matchingCall = this.findMatchingCall(methodName, args, this.expectedMatches);
        }
        if (matchingCall == null) {
            throw this.createUnexpectedCallError(methodName, args);
        }
        return matchingCall.call(mock, methodName, args);
    }

    private Callable findMatchingCall(String methodName, Object[] args, List callList) {
        Iterator call = callList.iterator();
        while (call.hasNext()) {
            Callable element = (Callable)call.next();
            if (!element.matches(methodName, args)) continue;
            return element;
        }
        return null;
    }

    public String getDescription() {
        if (this.expectedCalls.isEmpty()) {
            return "no methods";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("one of:\n");
        Iterator i = this.expectedCalls.iterator();
        while (i.hasNext()) {
            buf.append(((Callable)i.next()).getDescription());
            buf.append("\n");
        }
        return buf.toString();
    }

    public boolean matches(String methodName, Object[] args) {
        throw new Error("not implemented");
    }

    public void verify() {
        Iterator call = this.expectedCalls.iterator();
        while (call.hasNext()) {
            Callable element = (Callable)call.next();
            element.verify();
        }
    }

    public void addExpect(Callable call) {
        this.expectedCalls.add(call);
    }

    public void addMatch(Callable call) {
        this.expectedMatches.add(call);
    }
}

