/*
 * Decompiled with CFR 0.152.
 */
package mobi.gspd.segmentedbarview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.v4.content.ContextCompat;
import android.text.Html;
import android.text.Layout;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import java.text.DecimalFormat;
import java.util.List;
import mobi.gspd.segmentedbarview.R;
import mobi.gspd.segmentedbarview.Segment;

public class SegmentedBarView
extends View {
    private List<Segment> segments;
    private String unit;
    private Float value;
    private Rect rectBounds;
    private Rect valueSignBounds;
    private RectF roundRectangleBounds;
    private Paint fillPaint;
    private Paint segmentTextPaint;
    private Paint descriptionTextPaint;
    private DecimalFormat formatter;
    private int valueSignHeight;
    private int valueSignColor;
    private int emptySegmentColor;
    private int valueSignWidth;
    private int arrowHeight;
    private int arrowWidth;
    private int gapWidth;
    private int barHeight;
    private int descriptionBoxHeight;
    private int valueSignRound;
    private String emptySegmentText;
    private int barRoundingRadius = 0;
    private int valueSignCenter = -1;
    private boolean showDescriptionText;
    private boolean showSegmentText;
    private int sideStyle = 1;
    private int sideTextStyle = 0;
    private int valueTextSize;
    private int descriptionTextSize;
    private int segmentTextSize;
    private int valueTextColor = -1;
    private int descriptionTextColor = -12303292;
    private int segmentTextColor = -1;
    private TextPaint valueTextPaint;
    private Path trianglePath;
    private StaticLayout valueTextLayout;
    private Point point1;
    private Point point2;
    private Point point3;
    private Rect segmentRect;

    public SegmentedBarView(Context context) {
        super(context);
        this.init(context, null);
    }

    public SegmentedBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SegmentedBarView, 0, 0);
        try {
            Resources resources = this.getResources();
            this.segmentTextSize = a.getDimensionPixelSize(R.styleable.SegmentedBarView_sbv_segment_text_size, resources.getDimensionPixelSize(R.dimen.sbv_segment_text_size));
            this.valueTextSize = a.getDimensionPixelSize(R.styleable.SegmentedBarView_sbv_value_text_size, resources.getDimensionPixelSize(R.dimen.sbv_value_text_size));
            this.descriptionTextSize = a.getDimensionPixelSize(R.styleable.SegmentedBarView_sbv_description_text_size, resources.getDimensionPixelSize(R.dimen.sbv_description_text_size));
            this.barHeight = a.getDimensionPixelSize(R.styleable.SegmentedBarView_sbv_bar_height, resources.getDimensionPixelSize(R.dimen.sbv_bar_height));
            this.valueSignHeight = a.getDimensionPixelSize(R.styleable.SegmentedBarView_sbv_value_sign_height, resources.getDimensionPixelSize(R.dimen.sbv_value_sign_height));
            this.valueSignWidth = a.getDimensionPixelSize(R.styleable.SegmentedBarView_sbv_value_sign_width, resources.getDimensionPixelSize(R.dimen.sbv_value_sign_width));
            this.arrowHeight = a.getDimensionPixelSize(R.styleable.SegmentedBarView_sbv_arrow_height, resources.getDimensionPixelSize(R.dimen.sbv_arrow_height));
            this.arrowWidth = a.getDimensionPixelSize(R.styleable.SegmentedBarView_sbv_arrow_width, resources.getDimensionPixelSize(R.dimen.sbv_arrow_width));
            this.gapWidth = a.getDimensionPixelSize(R.styleable.SegmentedBarView_sbv_segment_gap_width, resources.getDimensionPixelSize(R.dimen.sbv_segment_gap_width));
            this.valueSignRound = a.getDimensionPixelSize(R.styleable.SegmentedBarView_sbv_value_sign_round, resources.getDimensionPixelSize(R.dimen.sbv_value_sign_round));
            this.descriptionBoxHeight = a.getDimensionPixelSize(R.styleable.SegmentedBarView_sbv_description_box_height, resources.getDimensionPixelSize(R.dimen.sbv_description_box_height));
            this.showSegmentText = a.getBoolean(R.styleable.SegmentedBarView_sbv_show_segment_text, true);
            this.showDescriptionText = a.getBoolean(R.styleable.SegmentedBarView_sbv_show_description_text, false);
            this.emptySegmentText = a.getString(R.styleable.SegmentedBarView_sbv_empty_segment_text);
            if (this.emptySegmentText == null) {
                this.emptySegmentText = resources.getString(R.string.sbv_empty);
            }
            this.valueSignColor = a.getColor(R.styleable.SegmentedBarView_sbv_value_sign_background, ContextCompat.getColor((Context)context, (int)R.color.sbv_value_sign_background));
            this.emptySegmentColor = a.getColor(R.styleable.SegmentedBarView_sbv_empty_segment_background, ContextCompat.getColor((Context)context, (int)R.color.sbv_empty_segment_background));
            this.sideStyle = a.getInt(R.styleable.SegmentedBarView_sbv_side_style, 1);
            this.sideTextStyle = a.getInt(R.styleable.SegmentedBarView_sbv_side_text_style, 0);
        }
        finally {
            a.recycle();
        }
        this.formatter = new DecimalFormat("##.####");
        this.segmentTextPaint = new TextPaint(1);
        this.segmentTextPaint.setColor(-1);
        this.segmentTextPaint.setStyle(Paint.Style.FILL);
        this.valueTextPaint = new TextPaint(1);
        this.valueTextPaint.setColor(-1);
        this.valueTextPaint.setStyle(Paint.Style.FILL);
        this.valueTextPaint.setTextSize((float)this.valueTextSize);
        this.valueTextPaint.setColor(this.valueTextColor);
        this.descriptionTextPaint = new TextPaint(1);
        this.descriptionTextPaint.setColor(-12303292);
        this.descriptionTextPaint.setStyle(Paint.Style.FILL);
        this.fillPaint = new Paint(1);
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.rectBounds = new Rect();
        this.roundRectangleBounds = new RectF();
        this.valueSignBounds = new Rect();
        this.segmentRect = new Rect();
        this.trianglePath = new Path();
        this.trianglePath.setFillType(Path.FillType.EVEN_ODD);
        this.point1 = new Point();
        this.point2 = new Point();
        this.point3 = new Point();
    }

    protected void onDraw(Canvas canvas) {
        int segmentsSize;
        super.onDraw(canvas);
        this.valueSignCenter = -1;
        int n = segmentsSize = this.segments == null ? 0 : this.segments.size();
        if (segmentsSize > 0) {
            for (int i = 0; i < segmentsSize; ++i) {
                Segment segment = this.segments.get(i);
                this.drawSegment(canvas, segment, i, segmentsSize);
            }
        } else {
            this.drawEmptySegment(canvas);
        }
        if (!this.valueIsEmpty()) {
            this.drawValueSign(canvas, this.valueSignSpaceHeight(), this.valueSignCenter);
        }
    }

    private void drawEmptySegment(Canvas canvas) {
        int segmentsSize = 1;
        int singleSegmentWidth = this.getContentWidth() / segmentsSize;
        this.rectBounds.set(this.getPaddingLeft(), this.valueSignSpaceHeight() + this.getPaddingTop(), singleSegmentWidth + this.getPaddingLeft(), this.barHeight + this.valueSignSpaceHeight() + this.getPaddingTop());
        this.fillPaint.setColor(this.emptySegmentColor);
        this.barRoundingRadius = this.rectBounds.height() / 2;
        if (this.barRoundingRadius > singleSegmentWidth / 2) {
            this.sideStyle = 0;
        }
        this.segmentRect.set(this.rectBounds);
        switch (this.sideStyle) {
            case 1: {
                this.roundRectangleBounds.set((float)this.rectBounds.left, (float)this.rectBounds.top, (float)this.rectBounds.right, (float)this.rectBounds.bottom);
                canvas.drawRoundRect(this.roundRectangleBounds, (float)this.barRoundingRadius, (float)this.barRoundingRadius, this.fillPaint);
                break;
            }
            case 2: {
                this.rectBounds.set(this.barRoundingRadius + this.getPaddingLeft(), this.valueSignSpaceHeight() + this.getPaddingTop(), this.getWidth() - this.getPaddingRight() - this.barRoundingRadius, this.barHeight + this.valueSignSpaceHeight() + this.getPaddingTop());
                canvas.drawRect(this.rectBounds, this.fillPaint);
                this.point1.set(this.rectBounds.left - this.barRoundingRadius, this.rectBounds.top + this.barRoundingRadius);
                this.point2.set(this.rectBounds.left, this.rectBounds.top);
                this.point3.set(this.rectBounds.left, this.rectBounds.bottom);
                this.drawTriangle(canvas, this.point1, this.point2, this.point3, this.fillPaint);
                this.point1.set(this.rectBounds.right + this.barRoundingRadius, this.rectBounds.top + this.barRoundingRadius);
                this.point2.set(this.rectBounds.right, this.rectBounds.top);
                this.point3.set(this.rectBounds.right, this.rectBounds.bottom);
                this.drawTriangle(canvas, this.point1, this.point2, this.point3, this.fillPaint);
                break;
            }
            case 0: {
                canvas.drawRect(this.rectBounds, this.fillPaint);
            }
        }
        if (this.showSegmentText) {
            String textToShow = this.emptySegmentText;
            this.segmentTextPaint.setTextSize((float)this.segmentTextSize);
            this.drawTextCentredInRectWithSides(canvas, this.segmentTextPaint, textToShow, this.segmentRect.left, this.segmentRect.top, this.segmentRect.right, this.segmentRect.bottom);
        }
    }

    private int getContentWidth() {
        return this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    private int getContentHeight() {
        return this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
    }

    private void drawSegment(Canvas canvas, Segment segment, int i, int segmentsSize) {
        boolean isLeftAndRight;
        boolean isRightSegment;
        boolean isLeftSegment;
        block15: {
            block14: {
                isLeftSegment = i == 0;
                isRightSegment = i == segmentsSize - 1;
                isLeftAndRight = isLeftSegment && isRightSegment;
                int singleSegmentWidth = this.getContentWidth() / segmentsSize;
                int segmentLeft = singleSegmentWidth * i;
                if (!isLeftSegment) {
                    segmentLeft += this.gapWidth;
                }
                int segmentRight = singleSegmentWidth * (i + 1);
                this.rectBounds.set(segmentLeft + this.getPaddingLeft(), this.valueSignSpaceHeight() + this.getPaddingTop(), segmentRight + this.getPaddingLeft(), this.barHeight + this.valueSignSpaceHeight() + this.getPaddingTop());
                if (!this.valueIsEmpty() && (this.value.floatValue() >= segment.getMinValue() && this.value.floatValue() < segment.getMaxValue() || isRightSegment && segment.getMaxValue() == this.value.floatValue())) {
                    float valueSignCenterPercent = (this.value.floatValue() - segment.getMinValue()) / (segment.getMaxValue() - segment.getMinValue());
                    this.valueSignCenter = (int)((float)(segmentLeft + this.getPaddingLeft()) + valueSignCenterPercent * (float)singleSegmentWidth);
                }
                this.fillPaint.setColor(segment.getColor());
                this.segmentRect.set(this.rectBounds);
                if (!isLeftSegment && !isRightSegment) break block14;
                this.barRoundingRadius = this.rectBounds.height() / 2;
                if (this.barRoundingRadius > singleSegmentWidth / 2) {
                    this.sideStyle = 0;
                }
                switch (this.sideStyle) {
                    case 1: {
                        this.roundRectangleBounds.set((float)this.rectBounds.left, (float)this.rectBounds.top, (float)this.rectBounds.right, (float)this.rectBounds.bottom);
                        canvas.drawRoundRect(this.roundRectangleBounds, (float)this.barRoundingRadius, (float)this.barRoundingRadius, this.fillPaint);
                        if (!isLeftAndRight) {
                            if (isLeftSegment) {
                                this.rectBounds.set(segmentLeft + this.barRoundingRadius + this.getPaddingLeft(), this.valueSignSpaceHeight() + this.getPaddingTop(), segmentRight + this.getPaddingLeft(), this.barHeight + this.valueSignSpaceHeight() + this.getPaddingTop());
                                canvas.drawRect(this.rectBounds, this.fillPaint);
                                break;
                            }
                            this.rectBounds.set(segmentLeft + this.getPaddingLeft(), this.valueSignSpaceHeight() + this.getPaddingTop(), segmentRight - this.barRoundingRadius + this.getPaddingLeft(), this.barHeight + this.valueSignSpaceHeight() + this.getPaddingTop());
                            canvas.drawRect(this.rectBounds, this.fillPaint);
                            break;
                        }
                        break block15;
                    }
                    case 2: {
                        if (isLeftAndRight) {
                            this.rectBounds.set(segmentLeft + this.barRoundingRadius + this.getPaddingLeft(), this.valueSignSpaceHeight() + this.getPaddingTop(), segmentRight - this.barRoundingRadius + this.getPaddingLeft(), this.barHeight + this.valueSignSpaceHeight() + this.getPaddingTop());
                            canvas.drawRect(this.rectBounds, this.fillPaint);
                            this.point1.set(this.rectBounds.left - this.barRoundingRadius, this.rectBounds.top + this.barRoundingRadius);
                            this.point2.set(this.rectBounds.left, this.rectBounds.top);
                            this.point3.set(this.rectBounds.left, this.rectBounds.bottom);
                            this.drawTriangle(canvas, this.point1, this.point2, this.point3, this.fillPaint);
                            this.point1.set(this.rectBounds.right + this.barRoundingRadius, this.rectBounds.top + this.barRoundingRadius);
                            this.point2.set(this.rectBounds.right, this.rectBounds.top);
                            this.point3.set(this.rectBounds.right, this.rectBounds.bottom);
                            this.drawTriangle(canvas, this.point1, this.point2, this.point3, this.fillPaint);
                            break;
                        }
                        if (isLeftSegment) {
                            this.rectBounds.set(segmentLeft + this.barRoundingRadius + this.getPaddingLeft(), this.valueSignSpaceHeight() + this.getPaddingTop(), segmentRight + this.getPaddingLeft(), this.barHeight + this.valueSignSpaceHeight() + this.getPaddingTop());
                            canvas.drawRect(this.rectBounds, this.fillPaint);
                            this.point1.set(this.rectBounds.left - this.barRoundingRadius, this.rectBounds.top + this.barRoundingRadius);
                            this.point2.set(this.rectBounds.left, this.rectBounds.top);
                            this.point3.set(this.rectBounds.left, this.rectBounds.bottom);
                            this.drawTriangle(canvas, this.point1, this.point2, this.point3, this.fillPaint);
                            break;
                        }
                        this.rectBounds.set(segmentLeft + this.getPaddingLeft(), this.valueSignSpaceHeight() + this.getPaddingTop(), segmentRight - this.barRoundingRadius + this.getPaddingLeft(), this.barHeight + this.valueSignSpaceHeight() + this.getPaddingTop());
                        canvas.drawRect(this.rectBounds, this.fillPaint);
                        this.point1.set(this.rectBounds.right + this.barRoundingRadius, this.rectBounds.top + this.barRoundingRadius);
                        this.point2.set(this.rectBounds.right, this.rectBounds.top);
                        this.point3.set(this.rectBounds.right, this.rectBounds.bottom);
                        this.drawTriangle(canvas, this.point1, this.point2, this.point3, this.fillPaint);
                        break;
                    }
                    case 0: {
                        canvas.drawRect(this.rectBounds, this.fillPaint);
                    }
                }
                break block15;
            }
            canvas.drawRect(this.rectBounds, this.fillPaint);
        }
        if (this.showSegmentText) {
            String textToShow = segment.getCustomText() != null ? segment.getCustomText() : (isLeftSegment || isRightSegment ? (isLeftAndRight || this.sideTextStyle == 1 ? String.format("%s - %s", this.formatter.format(segment.getMinValue()), this.formatter.format(segment.getMaxValue())) : (isLeftSegment ? String.format("<%s", this.formatter.format(segment.getMaxValue())) : String.format(">%s", this.formatter.format(segment.getMinValue())))) : String.format("%s - %s", this.formatter.format(segment.getMinValue()), this.formatter.format(segment.getMaxValue())));
            this.segmentTextPaint.setTextSize((float)this.segmentTextSize);
            this.segmentTextPaint.setColor(this.segmentTextColor);
            this.drawTextCentredInRect(canvas, this.segmentTextPaint, textToShow, this.segmentRect);
        }
        if (this.showDescriptionText) {
            this.descriptionTextPaint.setTextSize((float)this.descriptionTextSize);
            this.descriptionTextPaint.setColor(this.descriptionTextColor);
            this.drawTextCentredInRectWithSides(canvas, this.descriptionTextPaint, segment.getDescriptionText(), this.segmentRect.left, this.segmentRect.bottom, this.segmentRect.right, this.segmentRect.bottom + this.descriptionBoxHeight);
        }
    }

    private void drawValueSign(Canvas canvas, int valueSignSpaceHeight, int valueSignCenter) {
        int difference;
        boolean valueNotInSegments;
        boolean bl = valueNotInSegments = valueSignCenter == -1;
        if (valueNotInSegments) {
            valueSignCenter = this.getContentWidth() / 2 + this.getPaddingLeft();
        }
        this.valueSignBounds.set(valueSignCenter - this.valueSignWidth / 2, this.getPaddingTop(), valueSignCenter + this.valueSignWidth / 2, this.valueSignHeight - this.arrowHeight + this.getPaddingTop());
        this.fillPaint.setColor(this.valueSignColor);
        if (this.valueSignBounds.left < this.getPaddingLeft()) {
            difference = -this.valueSignBounds.left + this.getPaddingLeft();
            this.roundRectangleBounds.set((float)(this.valueSignBounds.left + difference), (float)this.valueSignBounds.top, (float)(this.valueSignBounds.right + difference), (float)this.valueSignBounds.bottom);
        } else if (this.valueSignBounds.right > this.getMeasuredWidth() - this.getPaddingRight()) {
            difference = this.valueSignBounds.right - this.getMeasuredWidth() + this.getPaddingRight();
            this.roundRectangleBounds.set((float)(this.valueSignBounds.left - difference), (float)this.valueSignBounds.top, (float)(this.valueSignBounds.right - difference), (float)this.valueSignBounds.bottom);
        } else {
            this.roundRectangleBounds.set((float)this.valueSignBounds.left, (float)this.valueSignBounds.top, (float)this.valueSignBounds.right, (float)this.valueSignBounds.bottom);
        }
        canvas.drawRoundRect(this.roundRectangleBounds, (float)this.valueSignRound, (float)this.valueSignRound, this.fillPaint);
        if (!valueNotInSegments) {
            difference = 0;
            if (valueSignCenter - this.arrowWidth / 2 < this.barRoundingRadius + this.getPaddingLeft()) {
                difference = this.barRoundingRadius - valueSignCenter + this.getPaddingLeft();
            } else if (valueSignCenter + this.arrowWidth / 2 > this.getMeasuredWidth() - this.barRoundingRadius - this.getPaddingRight()) {
                difference = this.getMeasuredWidth() - this.barRoundingRadius - valueSignCenter - this.getPaddingRight();
            }
            this.point1.set(valueSignCenter - this.arrowWidth / 2 + difference, valueSignSpaceHeight - this.arrowHeight + this.getPaddingTop());
            this.point2.set(valueSignCenter + this.arrowWidth / 2 + difference, valueSignSpaceHeight - this.arrowHeight + this.getPaddingTop());
            this.point3.set(valueSignCenter + difference, valueSignSpaceHeight + this.getPaddingTop());
            this.drawTriangle(canvas, this.point1, this.point2, this.point3, this.fillPaint);
        }
        canvas.translate(this.roundRectangleBounds.left, this.roundRectangleBounds.top + this.roundRectangleBounds.height() / 2.0f - (float)(this.valueTextLayout.getHeight() / 2));
        this.valueTextLayout.draw(canvas);
    }

    private void drawTriangle(Canvas canvas, Point point1, Point point2, Point point3, Paint paint) {
        this.trianglePath.reset();
        this.trianglePath.moveTo((float)point1.x, (float)point1.y);
        this.trianglePath.lineTo((float)point2.x, (float)point2.y);
        this.trianglePath.lineTo((float)point3.x, (float)point3.y);
        this.trianglePath.lineTo((float)point1.x, (float)point1.y);
        this.trianglePath.close();
        canvas.drawPath(this.trianglePath, paint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int minWidth = this.getPaddingLeft() + this.getPaddingRight();
        int minHeight = this.barHeight + this.getPaddingBottom() + this.getPaddingTop();
        if (!this.valueIsEmpty()) {
            minHeight += this.valueSignHeight + this.arrowHeight;
        }
        if (this.showDescriptionText) {
            minHeight += this.descriptionBoxHeight;
        }
        int w = SegmentedBarView.resolveSizeAndState((int)minWidth, (int)widthMeasureSpec, (int)0);
        int h = SegmentedBarView.resolveSizeAndState((int)minHeight, (int)heightMeasureSpec, (int)0);
        this.setMeasuredDimension(w, h);
    }

    private int valueSignSpaceHeight() {
        if (this.valueIsEmpty()) {
            return 0;
        }
        return this.valueSignHeight;
    }

    private boolean valueIsEmpty() {
        return this.value == null;
    }

    public void drawTextCentredInRect(Canvas canvas, Paint paint, String text, Rect outsideRect) {
        this.drawTextCentredInRectWithSides(canvas, paint, text, outsideRect.left, outsideRect.top, outsideRect.right, outsideRect.bottom);
    }

    public void drawTextCentredInRectWithSides(Canvas canvas, Paint paint, String text, float left, float top, float right, float bottom) {
        paint.setTextAlign(Paint.Align.CENTER);
        float textHeight = paint.descent() - paint.ascent();
        float textOffset = textHeight / 2.0f - paint.descent();
        canvas.drawText(text, (left + right) / 2.0f, (top + bottom) / 2.0f + textOffset, paint);
    }

    private void createValueTextLayout() {
        if (this.valueIsEmpty()) {
            return;
        }
        String text = this.formatter.format(this.value);
        if (this.unit != null && !this.unit.isEmpty()) {
            text = text + String.format(" <small>%s</small>", this.unit);
        }
        Spanned spanned = Html.fromHtml((String)text);
        this.valueTextLayout = new StaticLayout((CharSequence)spanned, this.valueTextPaint, this.valueSignWidth, Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
        this.invalidate();
        this.requestLayout();
    }

    public void setUnit(String unit) {
        this.unit = unit;
        this.createValueTextLayout();
        this.invalidate();
        this.requestLayout();
    }

    public void setValue(float value) {
        this.value = Float.valueOf(value);
        this.createValueTextLayout();
        this.invalidate();
        this.requestLayout();
    }

    public void setValueWithUnit(float value, String unitHtml) {
        this.value = Float.valueOf(value);
        this.unit = unitHtml;
        if (!this.valueIsEmpty()) {
            this.createValueTextLayout();
        }
        this.invalidate();
        this.requestLayout();
    }

    public void setGapWidth(int gapWidth) {
        this.gapWidth = gapWidth;
        this.invalidate();
        this.requestLayout();
    }

    public void setBarHeight(int barHeight) {
        this.barHeight = barHeight;
        this.invalidate();
        this.requestLayout();
    }

    public void setShowDescriptionText(boolean showDescriptionText) {
        this.showDescriptionText = showDescriptionText;
        this.invalidate();
        this.requestLayout();
    }

    public void setValueSignSize(int width, int height) {
        this.valueSignWidth = width;
        this.valueSignHeight = height;
        if (!this.valueIsEmpty()) {
            this.createValueTextLayout();
        }
        this.invalidate();
        this.requestLayout();
    }

    public void setValueSignColor(int valueSignColor) {
        this.valueSignColor = valueSignColor;
        this.invalidate();
        this.requestLayout();
    }

    public void setShowSegmentText(boolean showSegmentText) {
        this.showSegmentText = showSegmentText;
        this.invalidate();
        this.requestLayout();
    }

    public void setSideStyle(int sideStyle) {
        this.sideStyle = sideStyle;
        this.invalidate();
        this.requestLayout();
    }

    public void setEmptySegmentColor(int emptySegmentColor) {
        this.emptySegmentColor = emptySegmentColor;
        this.invalidate();
        this.requestLayout();
    }

    public void setSideTextStyle(int sideTextStyle) {
        this.sideTextStyle = sideTextStyle;
        this.invalidate();
        this.requestLayout();
    }

    public void setDescriptionTextSize(int descriptionTextSize) {
        this.descriptionTextSize = descriptionTextSize;
        this.invalidate();
        this.requestLayout();
    }

    public void setSegmentTextSize(int segmentTextSize) {
        this.segmentTextSize = segmentTextSize;
        this.invalidate();
        this.requestLayout();
    }

    public void setValueTextSize(int valueTextSize) {
        this.valueTextSize = valueTextSize;
        this.valueTextPaint.setTextSize((float)valueTextSize);
        this.invalidate();
        this.requestLayout();
    }

    public void setDescriptionTextColor(int descriptionTextColor) {
        this.descriptionTextColor = descriptionTextColor;
        this.invalidate();
        this.requestLayout();
    }

    public void setSegmentTextColor(int segmentTextColor) {
        this.segmentTextColor = segmentTextColor;
        this.invalidate();
        this.requestLayout();
    }

    public void setValueTextColor(int valueTextColor) {
        this.valueTextColor = valueTextColor;
        this.valueTextPaint.setColor(valueTextColor);
        this.invalidate();
        this.requestLayout();
    }

    public void setDescriptionBoxHeight(int descriptionBoxHeight) {
        this.descriptionBoxHeight = descriptionBoxHeight;
        this.invalidate();
        this.requestLayout();
    }

    public static Builder builder(Context context) {
        SegmentedBarView segmentedBarView = new SegmentedBarView(context);
        ((Object)((Object)segmentedBarView)).getClass();
        return segmentedBarView.new Builder();
    }

    public class Builder {
        private Builder() {
        }

        public Builder segments(List<Segment> segments) {
            SegmentedBarView.this.segments = segments;
            return this;
        }

        public Builder unit(String unit) {
            SegmentedBarView.this.unit = unit;
            SegmentedBarView.this.createValueTextLayout();
            return this;
        }

        public Builder value(float value) {
            SegmentedBarView.this.value = Float.valueOf(value);
            SegmentedBarView.this.createValueTextLayout();
            return this;
        }

        public Builder gapWidth(int gapWidth) {
            SegmentedBarView.this.gapWidth = gapWidth;
            return this;
        }

        public Builder barHeight(int barHeight) {
            SegmentedBarView.this.barHeight = barHeight;
            return this;
        }

        public Builder showDescriptionText(boolean showDescriptionText) {
            SegmentedBarView.this.showDescriptionText = showDescriptionText;
            return this;
        }

        public Builder valueSignSize(int width, int height) {
            SegmentedBarView.this.valueSignWidth = width;
            SegmentedBarView.this.valueSignHeight = height;
            return this;
        }

        public Builder valueSignColor(int valueSignColor) {
            SegmentedBarView.this.valueSignColor = valueSignColor;
            return this;
        }

        public Builder showSegmentText(boolean showText) {
            SegmentedBarView.this.showSegmentText = showText;
            return this;
        }

        public Builder sideStyle(int sideStyle) {
            SegmentedBarView.this.sideStyle = sideStyle;
            return this;
        }

        public Builder emptySegmentColor(int emptySegmentColor) {
            SegmentedBarView.this.emptySegmentColor = emptySegmentColor;
            return this;
        }

        public Builder sideTextStyle(int sideTextStyle) {
            SegmentedBarView.this.sideTextStyle = sideTextStyle;
            return this;
        }

        public Builder descriptionTextSize(int descriptionTextSize) {
            SegmentedBarView.this.descriptionTextSize = descriptionTextSize;
            return this;
        }

        public Builder segmentTextSize(int segmentTextSize) {
            SegmentedBarView.this.segmentTextSize = segmentTextSize;
            return this;
        }

        public Builder valueTextSize(int valueTextSize) {
            SegmentedBarView.this.valueTextSize = valueTextSize;
            return this;
        }

        public Builder descriptionTextColor(int descriptionTextColor) {
            SegmentedBarView.this.descriptionTextColor = descriptionTextColor;
            return this;
        }

        public Builder segmentTextColor(int segmentTextColor) {
            SegmentedBarView.this.segmentTextColor = segmentTextColor;
            return this;
        }

        public Builder valueTextColor(int valueTextColor) {
            SegmentedBarView.this.valueTextColor = valueTextColor;
            return this;
        }

        public Builder descriptionBoxHeight(int descriptionBoxHeight) {
            SegmentedBarView.this.descriptionBoxHeight = descriptionBoxHeight;
            return this;
        }

        public SegmentedBarView build() {
            return SegmentedBarView.this;
        }
    }
}

