/*
 * Decompiled with CFR 0.152.
 */
package sec.web.render;

import sec.geo.GeoPoint;
import sec.geo.kml.KmlOptions;
import sec.geo.kml.KmlRenderer;
import sec.geo.kml.XsltCoordinateWrapper;
import sec.geo.shape.Cake;
import sec.geo.shape.Radarc;
import sec.geo.shape.Route;
import sec.geo.shape.Track;
import sec.geo.utilities.StringBuilder;
import sec.web.exceptions.InvalidNumberOfPointsException;
import sec.web.render.SymbolModifiers;

public class Shape3DHandler {
    public static final String CYLINDER = "CYLINDER-------";
    public static final String ORBIT = "ORBIT----------";
    public static final String ROUTE = "ROUTE----------";
    public static final String POLYGON = "POLYGON--------";
    public static final String RADARC = "RADARC---------";
    public static final String POLYARC = "POLYARC--------";
    public static final String CAKE = "CAKE-----------";
    public static final String TRACK = "TRACK----------";
    public static final String ATTRIBUTES = "attributes";
    public static final String MIN_ALT = "minalt";
    public static final String MAX_ALT = "maxalt";
    public static final String RADIUS1 = "radius1";
    public static final String RADIUS2 = "radius2";
    public static final String LEFT_AZIMUTH = "leftAzimuth";
    public static final String RIGHT_AZIMUTH = "rightAzimuth";
    public static final double MIN_ALT_DEFAULT = 0.0;
    public static final double MAX_ALT_DEFAULT = 100.0;
    public static final double RADIUS1_DEFAULT = 50.0;
    public static final double RADIUS2_DEFAULT = 100.0;
    public static final double LEFT_AZIMUTH_DEFAULT = 0.0;
    public static final double RIGHT_AZIMUTH_DEFAULT = 90.0;
    public static final String DEFAULT_ATTRIBUTES = "[{radius1:50.0,radius2:100.0,minalt:0.0,maxalt:100.0,rightAzimuth:90.0,leftAzimuth:0.0}]";
    public static final String ERR_ATTRIBUTES_NOT_FORMATTED = "{\"type\":\"error\",\"error\":\"The attribute paramaters are not formatted correctly";
    public static final String ERR_COORDINATES_NOT_FORMATTED = "{\"type\":\"error\",\"error\":\"There was an error creating the Symbol - the coordinates were not formatted correctly";
    public static final String ERR_GENERAL_ERROR = "{\"type\":\"error\",\"error\":\"There was an error creating the Symbol - An unknown error occurred.  Please refer to the stack trace";
    public static final String ERR_INVALID_NUMBER_POINTS_ERROR = "{\"type\":\"error\",\"error\":\"Not enough points were passed in to create a graphic.";

    public static String render3dSymbol(String name, String id, String shapeType, String description, String lineColor, String fillColor, String altitudeMode, String controlPoints, SymbolModifiers attributes) {
        String result = "";
        KmlOptions.AltitudeMode convertedAltitudeMode = KmlOptions.AltitudeMode.RELATIVE_TO_GROUND;
        if (!altitudeMode.equals("")) {
            convertedAltitudeMode = KmlOptions.AltitudeMode.fromString(altitudeMode);
        }
        if (shapeType.equals(CYLINDER)) {
            result = Shape3DHandler.buildCylinder(controlPoints, id, name, description, lineColor, fillColor, convertedAltitudeMode, attributes);
        } else if (shapeType.equals(ORBIT)) {
            result = Shape3DHandler.buildOrbit(controlPoints, id, name, description, lineColor, fillColor, convertedAltitudeMode, attributes);
        } else if (shapeType.equals(RADARC)) {
            result = Shape3DHandler.buildRadarc(controlPoints, id, name, description, lineColor, fillColor, convertedAltitudeMode, attributes);
        } else if (shapeType.equals(POLYARC)) {
            result = Shape3DHandler.buildPolyArc(controlPoints, id, name, description, lineColor, fillColor, convertedAltitudeMode, attributes);
        } else if (shapeType.equals(ROUTE)) {
            result = Shape3DHandler.buildRoute(controlPoints, id, name, description, lineColor, fillColor, convertedAltitudeMode, attributes);
        } else if (shapeType.equals(POLYGON)) {
            result = Shape3DHandler.buildPolygon(controlPoints, id, name, description, lineColor, fillColor, convertedAltitudeMode, attributes);
        } else if (shapeType.equals(CAKE)) {
            result = Shape3DHandler.buildCake(controlPoints, id, name, description, lineColor, fillColor, convertedAltitudeMode, attributes);
        } else if (shapeType.equals(TRACK)) {
            result = Shape3DHandler.buildTrack(controlPoints, id, name, description, lineColor, fillColor, convertedAltitudeMode, attributes);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("Given shape type \"" + shapeType + "\" does not match any of the available shape types.");
            sb.append("\n");
            sb.append("Available Types: ");
            sb.append("CYLINDER-------\n");
            sb.append("ORBIT----------\n");
            sb.append("ROUTE----------\n");
            sb.append("POLYGON--------\n");
            sb.append("RADARC---------\n");
            sb.append("POLYARC--------\n");
            sb.append("CAKE-----------\n");
            sb.append(TRACK);
            System.out.println(sb.toString());
        }
        return result;
    }

    public static String buildPolygon(String controlPoints, String id, String name, String description, String lineColor, String fillColor, KmlOptions.AltitudeMode altitudeMode, SymbolModifiers attributes) {
        StringBuilder output = new StringBuilder();
        String pointArrayStringList = "";
        try {
            String[] latlons = controlPoints.split(" ");
            if (latlons.length < 2) {
                throw new InvalidNumberOfPointsException();
            }
            pointArrayStringList = XsltCoordinateWrapper.getPolygonKml(latlons, id, name, description, lineColor, fillColor, altitudeMode, attributes.X_ALTITUDE_DEPTH.get(0), attributes.X_ALTITUDE_DEPTH.get(1));
        }
        catch (Exception e) {
            pointArrayStringList = "";
        }
        return pointArrayStringList;
    }

    public static String buildCylinder(String controlPoints, String id, String name, String description, String lineColor, String fillColor, KmlOptions.AltitudeMode altitudeMode, SymbolModifiers attributes) {
        StringBuilder output = new StringBuilder();
        String pointArrayStringList = "";
        double pivotx = 0.0;
        double pivoty = 0.0;
        try {
            String[] pivot;
            String[] latlons = controlPoints.split(" ");
            if (latlons.length > 0) {
                pivot = latlons[0].split(",");
                if (pivot.length < 2) {
                    throw new NumberFormatException();
                }
            } else {
                throw new InvalidNumberOfPointsException();
            }
            pivotx = Double.parseDouble(pivot[0]);
            pivoty = Double.parseDouble(pivot[1]);
            pointArrayStringList = XsltCoordinateWrapper.getCircleKml(pivotx, pivoty, id, name, description, lineColor, fillColor, altitudeMode, attributes.AM_DISTANCE.get(0), attributes.X_ALTITUDE_DEPTH.get(0), attributes.X_ALTITUDE_DEPTH.get(1));
        }
        catch (Exception e) {
            pointArrayStringList = "";
        }
        return pointArrayStringList;
    }

    public static String buildKml(String[] coords, String id, String name, String lineColor, String fillColor) {
        StringBuilder kml = new StringBuilder();
        kml.append("<Placemark>");
        kml.append("<name>");
        kml.append(name);
        kml.append("</name>");
        kml.append("<id>");
        kml.append(id);
        kml.append("</id>");
        kml.append("<Style>");
        kml.append("<PolyStyle>");
        kml.append("<color>");
        kml.append(fillColor);
        kml.append("</color>");
        kml.append("</PolyStyle>");
        kml.append("<LineStyle>");
        kml.append(lineColor);
        kml.append("</LineStyle>");
        kml.append("</Style>");
        kml.append("<MultiGeometry>");
        for (String s : coords) {
            kml.append("<Polygon>");
            kml.append("<extrude>0</extrude>");
            kml.append("<altitudeMode>relativeToGround</altitudeMode>");
            kml.append("<outerBoundaryIs>");
            kml.append("<LinearRing>");
            kml.append("<coordinates>");
            kml.append(s);
            kml.append("</coordinates>");
            kml.append("</LinearRing>");
            kml.append("</outerBoundaryIs>");
            kml.append("</Polygon>");
        }
        kml.append("</MultiGeometry>");
        kml.append("</Placemark>");
        return kml.toString();
    }

    public static String buildOrbit(String controlPoints, String id, String name, String description, String lineColor, String fillColor, KmlOptions.AltitudeMode altitudeMode, SymbolModifiers attributes) {
        StringBuilder output = new StringBuilder();
        String pointArrayStringList = "";
        double point1x = 0.0;
        double point1y = 0.0;
        double point2x = 0.0;
        double point2y = 0.0;
        try {
            String[] point2;
            String[] latlons = controlPoints.split(" ");
            if (latlons.length > 1) {
                String[] point1 = latlons[0].split(",");
                if (point1.length < 2) {
                    throw new NumberFormatException();
                }
                point1x = Double.parseDouble(point1[0]);
                point1y = Double.parseDouble(point1[1]);
                point2 = latlons[1].split(",");
                if (point2.length < 2) {
                    throw new NumberFormatException();
                }
            } else {
                throw new InvalidNumberOfPointsException();
            }
            point2x = Double.parseDouble(point2[0]);
            point2y = Double.parseDouble(point2[1]);
            pointArrayStringList = XsltCoordinateWrapper.getOrbitKml(point1x, point1y, point2x, point2y, id, name, description, lineColor, fillColor, altitudeMode, attributes.AM_DISTANCE.get(0), attributes.X_ALTITUDE_DEPTH.get(0), attributes.X_ALTITUDE_DEPTH.get(1));
        }
        catch (Exception e) {
            pointArrayStringList = "";
        }
        return pointArrayStringList;
    }

    public static String buildRadarc(String controlPoints, String id, String name, String description, String lineColor, String fillColor, KmlOptions.AltitudeMode altitudeMode, SymbolModifiers attributes) {
        StringBuilder output = new StringBuilder();
        String pointArrayStringList = "";
        double pivotx = 0.0;
        double pivoty = 0.0;
        try {
            String[] pivot;
            String[] latlons = controlPoints.split(" ");
            if (latlons.length > 0) {
                pivot = latlons[0].split(",");
                if (pivot.length < 2) {
                    throw new NumberFormatException();
                }
            } else {
                throw new InvalidNumberOfPointsException();
            }
            pivotx = Double.parseDouble(pivot[0]);
            pivoty = Double.parseDouble(pivot[1]);
            pointArrayStringList = XsltCoordinateWrapper.getRadarcKml(pivotx, pivoty, id, name, description, lineColor, fillColor, altitudeMode, attributes.AM_DISTANCE.get(0), attributes.AM_DISTANCE.get(1), attributes.AN_AZIMUTH.get(0), attributes.AN_AZIMUTH.get(1), attributes.X_ALTITUDE_DEPTH.get(0), attributes.X_ALTITUDE_DEPTH.get(1));
        }
        catch (Exception e) {
            pointArrayStringList = "";
        }
        return pointArrayStringList;
    }

    public static String buildPolyArc(String controlPoints, String id, String name, String description, String lineColor, String fillColor, KmlOptions.AltitudeMode altitudeMode, SymbolModifiers attributes) {
        StringBuilder output = new StringBuilder();
        String pointArrayStringList = "";
        double pivotx = 0.0;
        double pivoty = 0.0;
        try {
            String[] latlons = controlPoints.split(" ");
            if (latlons.length >= 3) {
                String[] pivot = latlons[0].split(",");
                if (pivot.length < 2) {
                    throw new NumberFormatException();
                }
                pivotx = Double.parseDouble(pivot[0]);
                pivoty = Double.parseDouble(pivot[1]);
            } else {
                throw new InvalidNumberOfPointsException();
            }
            int length = latlons.length - 1;
            String[] points = new String[length];
            System.arraycopy(latlons, 1, points, 0, length);
            pointArrayStringList = XsltCoordinateWrapper.getPolyarcKml(points, pivotx, pivoty, id, name, description, lineColor, fillColor, altitudeMode, attributes.AM_DISTANCE.get(0), attributes.AN_AZIMUTH.get(0), attributes.AN_AZIMUTH.get(1), attributes.X_ALTITUDE_DEPTH.get(0), attributes.X_ALTITUDE_DEPTH.get(1));
        }
        catch (Exception e) {
            pointArrayStringList = "";
        }
        return pointArrayStringList;
    }

    public static String buildRoute(String controlPoints, String id, String name, String description, String lineColor, String fillColor, KmlOptions.AltitudeMode altitudeMode, SymbolModifiers attributes) {
        String pointArrayStringList = "";
        try {
            String[] latlons = controlPoints.split(" ");
            if (latlons.length < 2) {
                throw new InvalidNumberOfPointsException();
            }
            double width = attributes.AM_DISTANCE.get(0);
            double leftWidth = width / 2.0;
            double rightWidth = width / 2.0;
            pointArrayStringList = XsltCoordinateWrapper.getRouteKml(latlons, id, name, description, lineColor, fillColor, altitudeMode, leftWidth, rightWidth, attributes.X_ALTITUDE_DEPTH.get(0), attributes.X_ALTITUDE_DEPTH.get(1));
        }
        catch (Exception e) {
            pointArrayStringList = "";
        }
        return pointArrayStringList;
    }

    public static String buildCake(String controlPoints, String id, String name, String description, String lineColor, String fillColor, KmlOptions.AltitudeMode altitudeMode, SymbolModifiers attributes) {
        StringBuilder output = new StringBuilder();
        String pointArrayStringList = "";
        Cake letThemEat = new Cake();
        double pivotx = 0.0;
        double pivoty = 0.0;
        KmlRenderer kmlRender = new KmlRenderer();
        try {
            String[] latlons = controlPoints.split(" ");
            int numberOfPoints = latlons.length;
            if (numberOfPoints > 0) {
                String[] pivotString = latlons[0].split(",");
                if (pivotString.length < 2) {
                    throw new NumberFormatException();
                }
                pivotx = Double.parseDouble(pivotString[0]);
                pivoty = Double.parseDouble(pivotString[1]);
                letThemEat.setPivot(new GeoPoint(pivotx, pivoty));
                int attributesArrayLength = attributes.X_ALTITUDE_DEPTH.size();
                for (int i = 0; i < attributesArrayLength; ++i) {
                    Radarc layerCake = new Radarc();
                    layerCake.setAltitudeMode(altitudeMode);
                    layerCake.setPivot(new GeoPoint(pivotx, pivoty));
                    layerCake.setMinRadius(attributes.AM_DISTANCE.get(i));
                    layerCake.setRadius(attributes.AM_DISTANCE.get(i + 1));
                    layerCake.setMinAltitude(attributes.X_ALTITUDE_DEPTH.get(i));
                    layerCake.setMaxAltitude(attributes.X_ALTITUDE_DEPTH.get(i + 1));
                    layerCake.setLeftAzimuthDegrees(attributes.AN_AZIMUTH.get(i));
                    layerCake.setRightAzimuthDegrees(attributes.AN_AZIMUTH.get(i + 1));
                    ++i;
                    letThemEat.addLayer(layerCake);
                }
            } else {
                throw new InvalidNumberOfPointsException();
            }
            pointArrayStringList = kmlRender.getCakeKml(letThemEat, id, name, description, lineColor, fillColor);
        }
        catch (Exception e) {
            pointArrayStringList = "";
        }
        return pointArrayStringList;
    }

    public static String buildTrack(String controlPoints, String id, String name, String description, String lineColor, String fillColor, KmlOptions.AltitudeMode altitudeMode, SymbolModifiers attributes) {
        String pointArrayStringList = "";
        KmlRenderer kmlRender = new KmlRenderer();
        try {
            Track track;
            String[] latlons = controlPoints.split(" ");
            int numberOfPoints = latlons.length;
            int numAM = attributes.AM_DISTANCE.size();
            int numX = attributes.X_ALTITUDE_DEPTH.size();
            double nextToLastAlt = attributes.X_ALTITUDE_DEPTH.get(numX - 2);
            double lastAlt = attributes.X_ALTITUDE_DEPTH.get(numX - 1);
            double lastWidth = attributes.AM_DISTANCE.get(numAM - 1);
            int delta = 2 * (numberOfPoints - 1) - numAM;
            delta = 2 * (numberOfPoints - 1) - numX;
            int j = 0;
            if (delta > 0) {
                for (j = 0; j < delta; ++j) {
                    attributes.AM_DISTANCE.add(lastWidth);
                }
            }
            for (int k = 0; k < delta; k += 2) {
                attributes.X_ALTITUDE_DEPTH.add(nextToLastAlt);
                attributes.X_ALTITUDE_DEPTH.add(lastAlt);
            }
            if (numberOfPoints >= 2) {
                track = new Track();
                for (int i = 0; i < numberOfPoints - 1; ++i) {
                    Route route = new Route();
                    route.setAltitudeMode(altitudeMode);
                    String[] point1String = latlons[i].split(",");
                    String[] point2String = latlons[i + 1].split(",");
                    double point1lon = 0.0;
                    double point1lat = 0.0;
                    double point2lon = 0.0;
                    double point2lat = 0.0;
                    if (point1String.length < 2) {
                        throw new NumberFormatException();
                    }
                    point1lon = Double.parseDouble(point1String[0]);
                    point1lat = Double.parseDouble(point1String[1]);
                    if (point2String.length < 2) {
                        throw new NumberFormatException();
                    }
                    point2lon = Double.parseDouble(point2String[0]);
                    point2lat = Double.parseDouble(point2String[1]);
                    route.addPoint(new GeoPoint(point1lon, point1lat));
                    route.addPoint(new GeoPoint(point2lon, point2lat));
                    route.setLeftWidth(attributes.AM_DISTANCE.get(2 * i));
                    route.setRightWidth(attributes.AM_DISTANCE.get(2 * i + 1));
                    route.setMinAltitude(attributes.X_ALTITUDE_DEPTH.get(2 * i));
                    route.setMaxAltitude(attributes.X_ALTITUDE_DEPTH.get(2 * i + 1));
                    track.addRoute(route);
                }
            } else {
                throw new InvalidNumberOfPointsException();
            }
            pointArrayStringList = kmlRender.getKml(track, id, name, description, lineColor, fillColor);
        }
        catch (Exception e) {
            pointArrayStringList = "";
        }
        return pointArrayStringList;
    }
}

