/*
 * Decompiled with CFR 0.152.
 */
package sec.sun.awt.geom;

public class NonZero {
    public static final boolean debug = false;
    int limit = 0;
    double[] yranges = new double[10];
    double xlo;
    double ylo;
    double xhi;
    double yhi;
    private int[] crosscounts;

    public NonZero(double xlo, double ylo, double xhi, double yhi) {
        this.xlo = xlo;
        this.ylo = ylo;
        this.xhi = xhi;
        this.yhi = yhi;
        this.crosscounts = new int[this.yranges.length / 2];
    }

    public final boolean covers(double ystart, double yend) {
        int i = 0;
        while (i < this.limit) {
            double yhi;
            double ylo = this.yranges[i++];
            if (ystart >= (yhi = this.yranges[i++])) continue;
            if (ystart < ylo) {
                return false;
            }
            if (yend <= yhi) {
                return true;
            }
            ystart = yhi;
        }
        return ystart >= yend;
    }

    public void remove(int cur) {
        this.limit -= 2;
        int rem = this.limit - cur;
        if (rem > 0) {
            System.arraycopy(this.yranges, cur + 2, this.yranges, cur, rem);
            System.arraycopy(this.crosscounts, cur / 2 + 1, this.crosscounts, cur / 2, rem / 2);
        }
    }

    public void insert(int cur, double lo, double hi, int dir) {
        int rem = this.limit - cur;
        double[] oldranges = this.yranges;
        int[] oldcounts = this.crosscounts;
        if (this.limit >= this.yranges.length) {
            this.yranges = new double[this.limit + 10];
            System.arraycopy(oldranges, 0, this.yranges, 0, cur);
            this.crosscounts = new int[(this.limit + 10) / 2];
            System.arraycopy(oldcounts, 0, this.crosscounts, 0, cur / 2);
        }
        if (rem > 0) {
            System.arraycopy(oldranges, cur, this.yranges, cur + 2, rem);
            System.arraycopy(oldcounts, cur / 2, this.crosscounts, cur / 2 + 1, rem / 2);
        }
        this.yranges[cur + 0] = lo;
        this.yranges[cur + 1] = hi;
        this.crosscounts[cur / 2] = dir;
        this.limit += 2;
    }

    public void record(double ystart, double yend, int direction) {
        int cur;
        if (ystart >= yend) {
            return;
        }
        for (cur = 0; cur < this.limit && ystart > this.yranges[cur + 1]; cur += 2) {
        }
        if (cur < this.limit) {
            int rdir = this.crosscounts[cur / 2];
            double yrlo = this.yranges[cur + 0];
            double yrhi = this.yranges[cur + 1];
            if (yrhi == ystart && rdir == direction) {
                if (cur + 2 == this.limit) {
                    this.yranges[cur + 1] = yend;
                    return;
                }
                this.remove(cur);
                ystart = yrlo;
                rdir = this.crosscounts[cur / 2];
                yrlo = this.yranges[cur + 0];
                yrhi = this.yranges[cur + 1];
            }
            if (yend < yrlo) {
                this.insert(cur, ystart, yend, direction);
                return;
            }
            if (yend == yrlo && rdir == direction) {
                this.yranges[cur] = ystart;
                return;
            }
            if (ystart < yrlo) {
                this.insert(cur, ystart, yrlo, direction);
                cur += 2;
                ystart = yrlo;
            } else if (yrlo < ystart) {
                this.insert(cur, yrlo, ystart, rdir);
                cur += 2;
                yrlo = ystart;
            }
            int newdir = rdir + direction;
            double newend = Math.min(yend, yrhi);
            if (newdir == 0) {
                this.remove(cur);
            } else {
                this.crosscounts[cur / 2] = newdir;
                this.yranges[cur++] = ystart;
                this.yranges[cur++] = newend;
            }
            ystart = yrlo = newend;
            if (yrlo < yrhi) {
                this.insert(cur, yrlo, yrhi, rdir);
            }
        }
        if (ystart < yend) {
            this.insert(cur, ystart, yend, direction);
        }
    }

    public final double getXLo() {
        return this.xlo;
    }

    public final double getYLo() {
        return this.ylo;
    }

    public final double getXHi() {
        return this.xhi;
    }

    public final double getYHi() {
        return this.yhi;
    }

    public final boolean isEmpty() {
        return this.limit == 0;
    }

    public boolean accumulateLine(double x0, double y0, double x1, double y1) {
        if (y0 <= y1) {
            return this.accumulateLine2(x0, y0, x1, y1, 1);
        }
        return this.accumulateLine2(x1, y1, x0, y0, -1);
    }

    public boolean accumulateLine2(double x0, double y0, double x1, double y1, int direction) {
        double yend;
        double xend;
        double ystart;
        double xstart;
        if (this.yhi <= y0 || this.ylo >= y1) {
            return false;
        }
        if (x0 >= this.xhi && x1 >= this.xhi) {
            return false;
        }
        if (y0 == y1) {
            return x0 >= this.xlo || x1 >= this.xlo;
        }
        double dx = x1 - x0;
        double dy = y1 - y0;
        if (y0 < this.ylo) {
            xstart = x0 + (this.ylo - y0) * dx / dy;
            ystart = this.ylo;
        } else {
            xstart = x0;
            ystart = y0;
        }
        if (this.yhi < y1) {
            xend = x0 + (this.yhi - y0) * dx / dy;
            yend = this.yhi;
        } else {
            xend = x1;
            yend = y1;
        }
        if (xstart >= this.xhi && xend >= this.xhi) {
            return false;
        }
        if (xstart > this.xlo || xend > this.xlo) {
            return true;
        }
        this.record(ystart, yend, direction);
        return false;
    }
}

