/*
 * Decompiled with CFR 0.152.
 */
package sec.sun.awt.geom;

import sec.sun.awt.geom.CurveObject;

final class Edge {
    static final int INIT_PARTS = 4;
    static final int GROW_PARTS = 10;
    CurveObject curve;
    int ctag;
    int etag;
    double activey;
    int equivalence;
    private Edge lastEdge;
    private int lastResult;
    private double lastLimit;

    public Edge(CurveObject c, int ctag) {
        this(c, ctag, 0);
    }

    public Edge(CurveObject c, int ctag, int etag) {
        this.curve = c;
        this.ctag = ctag;
        this.etag = etag;
    }

    public CurveObject getCurve() {
        return this.curve;
    }

    public int getCurveTag() {
        return this.ctag;
    }

    public int getEdgeTag() {
        return this.etag;
    }

    public void setEdgeTag(int etag) {
        this.etag = etag;
    }

    public int getEquivalence() {
        return this.equivalence;
    }

    public void setEquivalence(int eq) {
        this.equivalence = eq;
    }

    public int compareTo(Edge other, double[] yrange) {
        if (other == this.lastEdge && yrange[0] < this.lastLimit) {
            if (yrange[1] > this.lastLimit) {
                yrange[1] = this.lastLimit;
            }
            return this.lastResult;
        }
        if (this == other.lastEdge && yrange[0] < other.lastLimit) {
            if (yrange[1] > other.lastLimit) {
                yrange[1] = other.lastLimit;
            }
            return 0 - other.lastResult;
        }
        int ret = this.curve.compareTo(other.curve, yrange);
        this.lastEdge = other;
        this.lastLimit = yrange[1];
        this.lastResult = ret;
        return ret;
    }

    public void record(double yend, int etag) {
        this.activey = yend;
        this.etag = etag;
    }

    public boolean isActiveFor(double y, int etag) {
        return this.etag == etag && this.activey >= y;
    }

    public String toString() {
        return "Edge[" + this.curve + ", " + (this.ctag == 0 ? "L" : "R") + ", " + (this.etag == 1 ? "I" : (this.etag == -1 ? "O" : "N")) + "]";
    }
}

