/*
 * Decompiled with CFR 0.152.
 */
package sec.sun.awt.geom;

import armyc2.c2sd.graphics2d.Rectangle2D;
import sec.sun.awt.geom.CrossingsObject;
import sec.sun.awt.geom.Curve;
import sec.sun.awt.geom.Order0;
import sec.sun.awt.geom.Order1;
import sec.sun.awt.geom.Order2;
import sec.sun.awt.geom.Order3;

public class CurveObject {
    private Order0 order0 = null;
    private Order1 order1 = null;
    private Order2 order2 = null;
    private Order3 order3 = null;
    int order = -1;

    public CurveObject(Object obj) {
        if (obj instanceof Order0) {
            this.order0 = (Order0)obj;
            this.order = 0;
        } else if (obj instanceof Order1) {
            this.order1 = (Order1)obj;
            this.order = 1;
        } else if (obj instanceof Order2) {
            this.order2 = (Order2)obj;
            this.order = 2;
        } else if (obj instanceof Order3) {
            this.order3 = (Order3)obj;
            this.order = 3;
        }
        this.setParent();
    }

    private void setParent() {
        switch (this.order) {
            case 0: {
                this.order0.setParent(this);
                break;
            }
            case 1: {
                this.order1.setParent(this);
                break;
            }
            case 2: {
                this.order2.setParent(this);
                break;
            }
            case 3: {
                this.order3.setParent(this);
                break;
            }
        }
    }

    public Object getCurve() {
        switch (this.order) {
            case 0: {
                return this.order0;
            }
            case 1: {
                return this.order1;
            }
            case 2: {
                return this.order2;
            }
            case 3: {
                return this.order3;
            }
        }
        return null;
    }

    public int getOrder() {
        return this.order;
    }

    public double getXTop() {
        switch (this.order) {
            case 0: {
                return this.order0.getXTop();
            }
            case 1: {
                return this.order1.getXTop();
            }
            case 2: {
                return this.order2.getXTop();
            }
            case 3: {
                return this.order3.getXTop();
            }
        }
        return -7.0;
    }

    public CurveObject(int direction) {
        switch (this.order) {
            case 0: {
                this.order0.direction = direction;
                break;
            }
            case 1: {
                this.order1.direction = direction;
                break;
            }
            case 2: {
                this.order2.direction = direction;
                break;
            }
            case 3: {
                this.order3.direction = direction;
                break;
            }
        }
    }

    public double getYTop() {
        switch (this.order) {
            case 0: {
                return this.order0.getYTop();
            }
            case 1: {
                return this.order1.getYTop();
            }
            case 2: {
                return this.order2.getYTop();
            }
            case 3: {
                return this.order3.getYTop();
            }
        }
        return -7.0;
    }

    public double getXBot() {
        switch (this.order) {
            case 0: {
                return this.order0.getXBot();
            }
            case 1: {
                return this.order1.getXBot();
            }
            case 2: {
                return this.order2.getXBot();
            }
            case 3: {
                return this.order3.getXBot();
            }
        }
        return -7.0;
    }

    public double getYBot() {
        switch (this.order) {
            case 0: {
                return this.order0.getYBot();
            }
            case 1: {
                return this.order1.getYBot();
            }
            case 2: {
                return this.order2.getYBot();
            }
            case 3: {
                return this.order3.getYBot();
            }
        }
        return -7.0;
    }

    public double getXMin() {
        switch (this.order) {
            case 0: {
                return this.order0.getXMin();
            }
            case 1: {
                return this.order1.getXMin();
            }
            case 2: {
                return this.order2.getXMin();
            }
            case 3: {
                return this.order3.getXMin();
            }
        }
        return -7.0;
    }

    public double getXMax() {
        switch (this.order) {
            case 0: {
                return this.order0.getXMax();
            }
            case 1: {
                return this.order1.getXMax();
            }
            case 2: {
                return this.order2.getXMax();
            }
            case 3: {
                return this.order3.getXMax();
            }
        }
        return -7.0;
    }

    public final int getDirection() {
        switch (this.order) {
            case 0: {
                return this.order0.direction;
            }
            case 1: {
                return this.order1.direction;
            }
            case 2: {
                return this.order2.direction;
            }
            case 3: {
                return this.order3.direction;
            }
        }
        return -1;
    }

    public double XforY(double y) {
        switch (this.order) {
            case 0: {
                return this.order0.XforY(y);
            }
            case 1: {
                return this.order1.XforY(y);
            }
            case 2: {
                return this.order2.XforY(y);
            }
            case 3: {
                return this.order3.XforY(y);
            }
        }
        return -7.0;
    }

    public Object getReversedCurve() {
        switch (this.order) {
            case 0: {
                return this.order0.getReversedCurve();
            }
            case 1: {
                return this.order1.getReversedCurve();
            }
            case 2: {
                return this.order2.getReversedCurve();
            }
            case 3: {
                return this.order3.getReversedCurve();
            }
        }
        return null;
    }

    public double getX0() {
        switch (this.order) {
            case 0: {
                return this.order0.getX0();
            }
            case 1: {
                return this.order1.getX0();
            }
            case 2: {
                return this.order2.getX0();
            }
            case 3: {
                return this.order3.getX0();
            }
        }
        return -7.0;
    }

    public double getY0() {
        switch (this.order) {
            case 0: {
                return this.order0.getY0();
            }
            case 1: {
                return this.order1.getY0();
            }
            case 2: {
                return this.order2.getY0();
            }
            case 3: {
                return this.order3.getY0();
            }
        }
        return -7.0;
    }

    public double getX1() {
        switch (this.order) {
            case 0: {
                return this.order0.getX1();
            }
            case 1: {
                return this.order1.getX1();
            }
            case 2: {
                return this.order2.getX1();
            }
            case 3: {
                return this.order3.getX1();
            }
        }
        return -7.0;
    }

    public double getY1() {
        switch (this.order) {
            case 0: {
                return this.order0.getY1();
            }
            case 1: {
                return this.order1.getY1();
            }
            case 2: {
                return this.order2.getY1();
            }
            case 3: {
                return this.order3.getY1();
            }
        }
        return -7.0;
    }

    public double XforT(double t) {
        switch (this.order) {
            case 0: {
                return this.order0.XforT(t);
            }
            case 1: {
                return this.order1.XforT(t);
            }
            case 2: {
                return this.order2.XforT(t);
            }
            case 3: {
                return this.order3.XforT(t);
            }
        }
        return -7.0;
    }

    public double YforT(double t) {
        switch (this.order) {
            case 0: {
                return this.order0.YforT(t);
            }
            case 1: {
                return this.order1.YforT(t);
            }
            case 2: {
                return this.order2.YforT(t);
            }
            case 3: {
                return this.order3.YforT(t);
            }
        }
        return -7.0;
    }

    public double TforY(double t) {
        switch (this.order) {
            case 0: {
                return this.order0.TforY(t);
            }
            case 1: {
                return this.order1.TforY(t);
            }
            case 2: {
                return this.order2.TforY(t);
            }
            case 3: {
                return this.order3.TforY(t);
            }
        }
        return -7.0;
    }

    public double nextVertical(double t0, double t1) {
        switch (this.order) {
            case 0: {
                return this.order0.nextVertical(t0, t1);
            }
            case 1: {
                return this.order1.nextVertical(t0, t1);
            }
            case 2: {
                return this.order2.nextVertical(t0, t1);
            }
            case 3: {
                return this.order3.nextVertical(t0, t1);
            }
        }
        return -7.0;
    }

    public String controlPointString() {
        switch (this.order) {
            case 0: {
                return "";
            }
            case 1: {
                return "";
            }
            case 2: {
                return this.order2.controlPointString();
            }
            case 3: {
                return this.order3.controlPointString();
            }
        }
        return "";
    }

    public String toString() {
        return "Curve[" + this.getOrder() + ", " + "(" + Curve.round(this.getX0()) + ", " + Curve.round(this.getY0()) + "), " + this.controlPointString() + "(" + Curve.round(this.getX1()) + ", " + Curve.round(this.getY1()) + "), " + (this.getDirection() == 1 ? "D" : "U") + "]";
    }

    public int crossingsFor(double x, double y) {
        if (y >= this.getYTop() && y < this.getYBot() && x < this.getXMax() && (x < this.getXMin() || x < this.XforY(y))) {
            return 1;
        }
        return 0;
    }

    public boolean accumulateCrossings(CrossingsObject c) {
        double tend;
        double yend;
        double tstart;
        double ystart;
        double xhi = c.getXHi();
        if (this.getXMin() >= xhi) {
            return false;
        }
        double xlo = c.getXLo();
        double ylo = c.getYLo();
        double yhi = c.getYHi();
        double y0 = this.getYTop();
        double y1 = this.getYBot();
        if (y0 < ylo) {
            if (y1 <= ylo) {
                return false;
            }
            ystart = ylo;
            tstart = this.TforY(ylo);
        } else {
            if (y0 >= yhi) {
                return false;
            }
            ystart = y0;
            tstart = 0.0;
        }
        if (y1 > yhi) {
            yend = yhi;
            tend = this.TforY(yhi);
        } else {
            yend = y1;
            tend = 1.0;
        }
        boolean hitLo = false;
        boolean hitHi = false;
        while (true) {
            double x;
            if ((x = this.XforT(tstart)) < xhi) {
                if (hitHi || x > xlo) {
                    return true;
                }
                hitLo = true;
            } else {
                if (hitLo) {
                    return true;
                }
                hitHi = true;
            }
            if (tstart >= tend) break;
            tstart = this.nextVertical(tstart, tend);
        }
        if (hitLo) {
            c.record(ystart, yend, this.getDirection());
        }
        return false;
    }

    public double refineTforY(double t0, double yt0, double y0) {
        double t1 = 1.0;
        while (true) {
            double th;
            if ((th = (t0 + t1) / 2.0) == t0 || th == t1) {
                return t1;
            }
            double y = this.YforT(th);
            if (y < y0) {
                t0 = th;
                yt0 = y;
                continue;
            }
            if (!(y > y0)) break;
            t1 = th;
        }
        return t1;
    }

    public boolean findIntersect(CurveObject that, double[] yrange, double ymin, int slevel, int tlevel, double s0, double xs0, double ys0, double s1, double xs1, double ys1, double t0, double xt0, double yt0, double t1, double xt1, double yt1) {
        if (ys0 > yt1 || yt0 > ys1) {
            return false;
        }
        if (Math.min(xs0, xs1) > Math.max(xt0, xt1) || Math.max(xs0, xs1) < Math.min(xt0, xt1)) {
            return false;
        }
        if (s1 - s0 > 0.001) {
            double s = (s0 + s1) / 2.0;
            double xs = this.XforT(s);
            double ys = this.YforT(s);
            if (s == s0 || s == s1) {
                System.out.println("s0 = " + s0);
                System.out.println("s1 = " + s1);
                throw new InternalError("no s progress!");
            }
            if (t1 - t0 > 0.001) {
                double t = (t0 + t1) / 2.0;
                double xt = that.XforT(t);
                double yt = that.YforT(t);
                if (t == t0 || t == t1) {
                    System.out.println("t0 = " + t0);
                    System.out.println("t1 = " + t1);
                    throw new InternalError("no t progress!");
                }
                if (ys >= yt0 && yt >= ys0 && this.findIntersect(that, yrange, ymin, slevel + 1, tlevel + 1, s0, xs0, ys0, s, xs, ys, t0, xt0, yt0, t, xt, yt)) {
                    return true;
                }
                if (ys >= yt && this.findIntersect(that, yrange, ymin, slevel + 1, tlevel + 1, s0, xs0, ys0, s, xs, ys, t, xt, yt, t1, xt1, yt1)) {
                    return true;
                }
                if (yt >= ys && this.findIntersect(that, yrange, ymin, slevel + 1, tlevel + 1, s, xs, ys, s1, xs1, ys1, t0, xt0, yt0, t, xt, yt)) {
                    return true;
                }
                if (ys1 >= yt && yt1 >= ys && this.findIntersect(that, yrange, ymin, slevel + 1, tlevel + 1, s, xs, ys, s1, xs1, ys1, t, xt, yt, t1, xt1, yt1)) {
                    return true;
                }
            } else {
                if (ys >= yt0 && this.findIntersect(that, yrange, ymin, slevel + 1, tlevel, s0, xs0, ys0, s, xs, ys, t0, xt0, yt0, t1, xt1, yt1)) {
                    return true;
                }
                if (yt1 >= ys && this.findIntersect(that, yrange, ymin, slevel + 1, tlevel, s, xs, ys, s1, xs1, ys1, t0, xt0, yt0, t1, xt1, yt1)) {
                    return true;
                }
            }
        } else if (t1 - t0 > 0.001) {
            double t = (t0 + t1) / 2.0;
            double xt = that.XforT(t);
            double yt = that.YforT(t);
            if (t == t0 || t == t1) {
                System.out.println("t0 = " + t0);
                System.out.println("t1 = " + t1);
                throw new InternalError("no t progress!");
            }
            if (yt >= ys0 && this.findIntersect(that, yrange, ymin, slevel, tlevel + 1, s0, xs0, ys0, s1, xs1, ys1, t0, xt0, yt0, t, xt, yt)) {
                return true;
            }
            if (ys1 >= yt && this.findIntersect(that, yrange, ymin, slevel, tlevel + 1, s0, xs0, ys0, s1, xs1, ys1, t, xt, yt, t1, xt1, yt1)) {
                return true;
            }
        } else {
            double xlk = xs1 - xs0;
            double ylk = ys1 - ys0;
            double xnm = xt1 - xt0;
            double ynm = yt1 - yt0;
            double xmk = xt0 - xs0;
            double ymk = yt0 - ys0;
            double det = xnm * ylk - ynm * xlk;
            if (det != 0.0) {
                double detinv = 1.0 / det;
                double s = (xnm * ymk - ynm * xmk) * detinv;
                double t = (xlk * ymk - ylk * xmk) * detinv;
                if (s >= 0.0 && s <= 1.0 && t >= 0.0 && t <= 1.0) {
                    double y;
                    s = s0 + s * (s1 - s0);
                    t = t0 + t * (t1 - t0);
                    if (s < 0.0 || s > 1.0 || t < 0.0 || t > 1.0) {
                        System.out.println("Uh oh!");
                    }
                    if ((y = (this.YforT(s) + that.YforT(t)) / 2.0) <= yrange[1] && y > yrange[0]) {
                        yrange[1] = y;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public int compareTo(CurveObject that, double[] yrange) {
        double t1;
        double t0;
        double yt0;
        double s1;
        if (this.order == 1) {
            return this.order1.compareTo(that, yrange);
        }
        double y0 = yrange[0];
        double y1 = yrange[1];
        if ((y1 = Math.min(Math.min(y1, this.getYBot()), that.getYBot())) <= yrange[0]) {
            System.err.println("this == " + this);
            System.err.println("that == " + that);
            System.out.println("target range = " + yrange[0] + "=>" + yrange[1]);
            throw new InternalError("backstepping from " + yrange[0] + " to " + y1);
        }
        yrange[1] = y1;
        if (this.getXMax() <= that.getXMin()) {
            if (this.getXMin() == that.getXMax()) {
                return 0;
            }
            return -1;
        }
        if (this.getXMin() >= that.getXMax()) {
            return 1;
        }
        double s0 = this.TforY(y0);
        double ys0 = this.YforT(s0);
        if (ys0 < y0) {
            s0 = this.refineTforY(s0, ys0, y0);
            ys0 = this.YforT(s0);
        }
        if (this.YforT(s1 = this.TforY(y1)) < y0) {
            s1 = this.refineTforY(s1, this.YforT(s1), y0);
        }
        if ((yt0 = that.YforT(t0 = that.TforY(y0))) < y0) {
            t0 = that.refineTforY(t0, yt0, y0);
            yt0 = that.YforT(t0);
        }
        if (that.YforT(t1 = that.TforY(y1)) < y0) {
            t1 = that.refineTforY(t1, that.YforT(t1), y0);
        }
        double xs0 = this.XforT(s0);
        double xt0 = that.XforT(t0);
        double scale = Math.max(Math.abs(y0), Math.abs(y1));
        double ymin = Math.max(scale * 1.0E-14, 1.0E-300);
        if (Curve.fairlyClose(xs0, xt0)) {
            double y;
            double bump = ymin;
            double maxbump = Math.min(ymin * 1.0E13, (y1 - y0) * 0.1);
            for (y = y0 + bump; y <= y1; y += bump) {
                double newy;
                if (Curve.fairlyClose(this.XforY(y), that.XforY(y))) {
                    double d;
                    bump *= 2.0;
                    if (!(d > maxbump)) continue;
                    bump = maxbump;
                    continue;
                }
                y -= bump;
                while (!((newy = y + (bump /= 2.0)) <= y)) {
                    if (!Curve.fairlyClose(this.XforY(newy), that.XforY(newy))) continue;
                    y = newy;
                }
                break;
            }
            if (y > y0) {
                if (y < y1) {
                    yrange[1] = y;
                }
                return 0;
            }
        }
        if (ymin <= 0.0) {
            System.out.println("ymin = " + ymin);
        }
        while (s0 < s1 && t0 < t1) {
            double sh = this.nextVertical(s0, s1);
            double xsh = this.XforT(sh);
            double ysh = this.YforT(sh);
            double th = that.nextVertical(t0, t1);
            double xth = that.XforT(th);
            double yth = that.YforT(th);
            try {
                if (this.findIntersect(that, yrange, ymin, 0, 0, s0, xs0, ys0, sh, xsh, ysh, t0, xt0, yt0, th, xth, yth)) {
                    break;
                }
            }
            catch (Throwable t) {
                System.err.println("Error: " + t);
                System.err.println("y range was " + yrange[0] + "=>" + yrange[1]);
                System.err.println("s y range is " + ys0 + "=>" + ysh);
                System.err.println("t y range is " + yt0 + "=>" + yth);
                System.err.println("ymin is " + ymin);
                return 0;
            }
            if (ysh < yth) {
                if (ysh > yrange[0]) {
                    if (!(ysh < yrange[1])) break;
                    yrange[1] = ysh;
                    break;
                }
                s0 = sh;
                xs0 = xsh;
                ys0 = ysh;
                continue;
            }
            if (yth > yrange[0]) {
                if (!(yth < yrange[1])) break;
                yrange[1] = yth;
                break;
            }
            t0 = th;
            xt0 = xth;
            yt0 = yth;
        }
        double ymid = (yrange[0] + yrange[1]) / 2.0;
        return Curve.orderof(this.XforY(ymid), that.XforY(ymid));
    }

    public int getSegment(double[] coords) {
        switch (this.order) {
            case 0: {
                return this.order0.getSegment(coords);
            }
            case 1: {
                return this.order1.getSegment(coords);
            }
            case 2: {
                return this.order2.getSegment(coords);
            }
            case 3: {
                return this.order3.getSegment(coords);
            }
        }
        return -7;
    }

    public Object getSubCurve(double ystart, double yend, int dir) {
        switch (this.order) {
            case 0: {
                return this.order0.getSubCurve(ystart, yend, dir);
            }
            case 1: {
                return this.order1.getSubCurve(ystart, yend, dir);
            }
            case 2: {
                return this.order2.getSubCurve(ystart, yend, dir);
            }
            case 3: {
                return this.order3.getSubCurve(ystart, yend, dir);
            }
        }
        return null;
    }

    public void enlarge(Rectangle2D r) {
        switch (this.order) {
            case 0: {
                this.order0.enlarge(r);
            }
            case 1: {
                this.order1.enlarge(r);
            }
            case 2: {
                this.order2.enlarge(r);
            }
            case 3: {
                this.order3.enlarge(r);
            }
        }
    }

    public Object getWithDirection(int direction) {
        switch (this.order) {
            case 0: {
                return this.order0.getWithDirection(direction);
            }
            case 1: {
                return this.order1.getWithDirection(direction);
            }
            case 2: {
                return this.order2.getWithDirection(direction);
            }
            case 3: {
                return this.order3.getWithDirection(direction);
            }
        }
        return null;
    }
}

