/*
 * Decompiled with CFR 0.152.
 */
package sec.sun.awt.geom;

public class Crossings {
    public static final boolean debug = false;
    int limit = 0;
    double[] yranges = new double[10];
    double xlo;
    double ylo;
    double xhi;
    double yhi;

    public Crossings(double xlo, double ylo, double xhi, double yhi) {
        this.xlo = xlo;
        this.ylo = ylo;
        this.xhi = xhi;
        this.yhi = yhi;
    }

    public final double getXLo() {
        return this.xlo;
    }

    public final double getYLo() {
        return this.ylo;
    }

    public final double getXHi() {
        return this.xhi;
    }

    public final double getYHi() {
        return this.yhi;
    }

    public final boolean isEmpty() {
        return this.limit == 0;
    }

    public boolean accumulateLine(double x0, double y0, double x1, double y1) {
        if (y0 <= y1) {
            return this.accumulateLine2(x0, y0, x1, y1, 1);
        }
        return this.accumulateLine2(x1, y1, x0, y0, -1);
    }

    public boolean accumulateLine2(double x0, double y0, double x1, double y1, int direction) {
        double yend;
        double xend;
        double ystart;
        double xstart;
        if (this.yhi <= y0 || this.ylo >= y1) {
            return false;
        }
        if (x0 >= this.xhi && x1 >= this.xhi) {
            return false;
        }
        if (y0 == y1) {
            return x0 >= this.xlo || x1 >= this.xlo;
        }
        double dx = x1 - x0;
        double dy = y1 - y0;
        if (y0 < this.ylo) {
            xstart = x0 + (this.ylo - y0) * dx / dy;
            ystart = this.ylo;
        } else {
            xstart = x0;
            ystart = y0;
        }
        if (this.yhi < y1) {
            xend = x0 + (this.yhi - y0) * dx / dy;
            yend = this.yhi;
        } else {
            xend = x1;
            yend = y1;
        }
        if (xstart >= this.xhi && xend >= this.xhi) {
            return false;
        }
        if (xstart > this.xlo || xend > this.xlo) {
            return true;
        }
        this.record(ystart, yend, direction);
        return false;
    }

    public void record(double ystart, double yend, int direction) {
        int from;
        if (ystart >= yend) {
            return;
        }
        for (from = 0; from < this.limit && ystart > this.yranges[from + 1]; from += 2) {
        }
        int to = from;
        while (from < this.limit) {
            double yhh;
            double yhl;
            double ylh;
            double yll;
            double yrlo = this.yranges[from++];
            double yrhi = this.yranges[from++];
            if (yend < yrlo) {
                this.yranges[to++] = ystart;
                this.yranges[to++] = yend;
                ystart = yrlo;
                yend = yrhi;
                continue;
            }
            if (ystart < yrlo) {
                yll = ystart;
                ylh = yrlo;
            } else {
                yll = yrlo;
                ylh = ystart;
            }
            if (yend < yrhi) {
                yhl = yend;
                yhh = yrhi;
            } else {
                yhl = yrhi;
                yhh = yend;
            }
            if (ylh == yhl) {
                ystart = yll;
                yend = yhh;
            } else {
                if (ylh > yhl) {
                    ystart = yhl;
                    yhl = ylh;
                    ylh = ystart;
                }
                if (yll != ylh) {
                    this.yranges[to++] = yll;
                    this.yranges[to++] = ylh;
                }
                ystart = yhl;
                yend = yhh;
            }
            if (!(ystart >= yend)) continue;
            break;
        }
        if (to < from && from < this.limit) {
            System.arraycopy(this.yranges, from, this.yranges, to, this.limit - from);
        }
        to += this.limit - from;
        if (ystart < yend) {
            if (to >= this.yranges.length) {
                double[] newranges = new double[to + 10];
                System.arraycopy(this.yranges, 0, newranges, 0, to);
                this.yranges = newranges;
            }
            this.yranges[to++] = ystart;
            this.yranges[to++] = yend;
        }
        this.limit = to;
    }
}

