/*
 * Decompiled with CFR 0.152.
 */
package sec.sun.awt.geom;

import sec.sun.awt.geom.CurveObject;
import sec.sun.awt.geom.Edge;

public class Arrays {
    private static final int INSERTIONSORT_THRESHOLD = 7;

    public static void sort(Object[] a) {
        Object[] aux = new Object[a.length];
        int n = a.length;
        for (int j = 0; j < n; ++j) {
            aux[j] = a[j];
        }
        Arrays.mergeSort(aux, a, 0, a.length, 0);
    }

    private static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static int compare(Object o1, Object o2) {
        double v2;
        CurveObject c1 = ((Edge)o1).getCurve();
        CurveObject c2 = ((Edge)o2).getCurve();
        double v1 = c1.getYTop();
        if (v1 == (v2 = c2.getYTop()) && (v1 = c1.getXTop()) == (v2 = c2.getXTop())) {
            return 0;
        }
        if (v1 < v2) {
            return -1;
        }
        return 1;
    }

    private static void mergeSort(Object[] src, Object[] dest, int low, int high, int off) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && Arrays.compare(dest[j - 1], dest[j]) > 0; --j) {
                    Arrays.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >>> 1;
        Arrays.mergeSort(dest, src, low, mid, -off);
        Arrays.mergeSort(dest, src, mid, high, -off);
        if (Arrays.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
        }
        int p = low;
        int q = mid;
        for (int i = destLow; i < destHigh; ++i) {
            dest[i] = q >= high || p < mid && Arrays.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    public static void arraycopy(Object[] src, int srcPos, Object[] dest, int destPos, int length) {
        for (int j = 0; j < length; ++j) {
            dest[j + destPos] = src[srcPos + j];
        }
    }
}

