/*
 * Decompiled with CFR 0.152.
 */
package sec.sun.awt.geom;

import armyc2.c2sd.graphics2d.AffineTransform;
import sec.sun.awt.geom.CurveObject;
import sec.sun.awt.geom.Vector;

public class AreaIterator {
    private final AffineTransform transform;
    private final Vector curves;
    private int index;
    private CurveObject prevcurve;
    private CurveObject thiscurve;

    public AreaIterator(Vector curves, AffineTransform at) {
        this.curves = curves;
        this.transform = at;
        if (curves.size() >= 1) {
            this.thiscurve = (CurveObject)curves.get(0);
        }
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.prevcurve == null && this.thiscurve == null;
    }

    public void next() {
        if (this.prevcurve != null) {
            this.prevcurve = null;
        } else {
            this.prevcurve = this.thiscurve;
            ++this.index;
            if (this.index < this.curves.size()) {
                this.thiscurve = (CurveObject)this.curves.get(this.index);
                if (this.thiscurve.getOrder() != 0 && this.prevcurve.getX1() == this.thiscurve.getX0() && this.prevcurve.getY1() == this.thiscurve.getY0()) {
                    this.prevcurve = null;
                }
            } else {
                this.thiscurve = null;
            }
        }
    }

    public int currentSegmentFlt(float[] coords) {
        double[] dcoords = new double[6];
        int segtype = this.currentSegment(dcoords);
        int numpoints = segtype == 4 ? 0 : (segtype == 2 ? 2 : (segtype == 3 ? 3 : 1));
        for (int i = 0; i < numpoints * 2; ++i) {
            coords[i] = (float)dcoords[i];
        }
        return segtype;
    }

    public int currentSegment(double[] coords) {
        int segtype = 0;
        int numpoints = 0;
        if (this.prevcurve != null) {
            if (this.thiscurve == null || this.thiscurve.getOrder() == 0) {
                return 4;
            }
            coords[0] = this.thiscurve.getX0();
            coords[1] = this.thiscurve.getY0();
            segtype = 1;
            numpoints = 1;
        } else if (this.thiscurve != null) {
            segtype = this.thiscurve.getSegment(coords);
            numpoints = this.thiscurve.getOrder();
            if (numpoints == 0) {
                numpoints = 1;
            }
        }
        return segtype;
    }
}

