/*
 * Decompiled with CFR 0.152.
 */
package sec.geo.shape;

import java.util.ArrayList;
import sec.geo.GeoBlock2;
import sec.geo.GeoPoint;
import sec.geo.ShapeObject;
import sec.geo.kml.KmlOptions;
import sec.sun.awt.geom.Area;

public class Route {
    private double minAltitudeMeters;
    private double maxAltitudeMeters;
    protected double maxDistanceMeters = 100000.0;
    protected double flatnessDistanceMeters = 1.0;
    protected KmlOptions.AltitudeMode altitudeMode;
    protected int limit = 4;
    private double leftWidthMeters;
    private double rightWidthMeters;
    private Area shape;
    protected final ArrayList<GeoPoint> points = new ArrayList();

    public void addPoint(GeoPoint point) {
        this.points.add(point);
        this.shapeChanged();
    }

    public void addPoints(ArrayList<GeoPoint> points) {
        this.points.addAll(points);
        this.shapeChanged();
    }

    public void setLeftWidth(double widthMeters) {
        this.leftWidthMeters = widthMeters;
        this.shapeChanged();
    }

    public void setRightWidth(double widthMeters) {
        this.rightWidthMeters = widthMeters;
        this.shapeChanged();
    }

    protected Area createShape() {
        Area route = new Area();
        GeoPoint previousPoint = null;
        int n = this.points.size();
        for (int i = 0; i < n; ++i) {
            GeoPoint point = this.points.get(i);
            if (previousPoint != null) {
                if (previousPoint.equals(point)) continue;
                GeoBlock2 block = new GeoBlock2(previousPoint, point, this.leftWidthMeters, this.rightWidthMeters, this.maxDistanceMeters, this.flatnessDistanceMeters, this.limit);
                Area area = new Area(new ShapeObject(block));
                route.add(area);
            }
            previousPoint = point;
        }
        return route;
    }

    protected void shapeChanged() {
        this.shape = null;
    }

    public Area getShape() {
        if (this.shape == null) {
            this.shape = this.createShape();
        }
        return this.shape;
    }

    public double getMinAltitude() {
        return this.minAltitudeMeters;
    }

    public void setMinAltitude(double minAltitudeMeters) {
        this.minAltitudeMeters = minAltitudeMeters;
        this.shapeChanged();
    }

    public double getMaxAltitude() {
        return this.maxAltitudeMeters;
    }

    public void setMaxAltitude(double maxAltitudeMeters) {
        this.maxAltitudeMeters = maxAltitudeMeters;
        this.shapeChanged();
    }

    public void setMaxDistance(double maxDistanceMeters) {
        this.maxDistanceMeters = maxDistanceMeters;
        this.shapeChanged();
    }

    public void setFlatness(double flatnessDistanceMeters) {
        this.flatnessDistanceMeters = flatnessDistanceMeters;
        this.shapeChanged();
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.shapeChanged();
    }

    public KmlOptions.AltitudeMode getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(KmlOptions.AltitudeMode altitudeMode) {
        this.altitudeMode = altitudeMode;
    }
}

