/*
 * Decompiled with CFR 0.152.
 */
package sec.geo.shape;

import java.util.ArrayList;
import sec.geo.GeoPath;
import sec.geo.GeoPoint;
import sec.geo.ShapeObject;
import sec.geo.kml.KmlOptions;

public class Polyarc {
    private double minAltitudeMeters;
    private double maxAltitudeMeters;
    private ShapeObject shape;
    protected double maxDistanceMeters = 100000.0;
    protected double flatnessDistanceMeters = 1.0;
    protected int limit = 4;
    private GeoPoint pivot;
    private double radiusMeters;
    private double leftAzimuthDegrees;
    private double rightAzimuthDegrees;
    protected KmlOptions.AltitudeMode altitudeMode;
    protected final ArrayList<GeoPoint> points = new ArrayList();

    public void addPoint(GeoPoint point) {
        this.points.add(point);
        this.shapeChanged();
    }

    public void addPoints(ArrayList<GeoPoint> points) {
        this.points.addAll(points);
        this.shapeChanged();
    }

    public void setRadius(double radiusMeters) {
        this.radiusMeters = radiusMeters;
        this.shapeChanged();
    }

    public void setPivot(GeoPoint pivot) {
        this.pivot = pivot;
        this.shapeChanged();
    }

    public void setRightAzimuthDegrees(double rightAzimuthDegrees) {
        this.rightAzimuthDegrees = rightAzimuthDegrees;
        this.shapeChanged();
    }

    public void setLeftAzimuthDegrees(double leftAzimuthDegrees) {
        this.leftAzimuthDegrees = leftAzimuthDegrees;
        this.shapeChanged();
    }

    protected ShapeObject createShape() {
        GeoPath path = new GeoPath(this.maxDistanceMeters, this.flatnessDistanceMeters, this.limit);
        int n = this.points.size();
        for (int i = 0; i < n; ++i) {
            GeoPoint point = this.points.get(i);
            if (i == 0) {
                path.moveTo(point);
                continue;
            }
            path.lineTo(point);
        }
        path.arcTo(this.pivot, this.radiusMeters * 2.0, this.radiusMeters * 2.0, this.leftAzimuthDegrees, this.rightAzimuthDegrees);
        path.closePath();
        return new ShapeObject(path);
    }

    protected void shapeChanged() {
        this.shape = null;
    }

    public ShapeObject getShape() {
        if (this.shape == null) {
            this.shape = this.createShape();
        }
        return this.shape;
    }

    public double getMinAltitude() {
        return this.minAltitudeMeters;
    }

    public void setMinAltitude(double minAltitudeMeters) {
        this.minAltitudeMeters = minAltitudeMeters;
        this.shapeChanged();
    }

    public double getMaxAltitude() {
        return this.maxAltitudeMeters;
    }

    public void setMaxAltitude(double maxAltitudeMeters) {
        this.maxAltitudeMeters = maxAltitudeMeters;
        this.shapeChanged();
    }

    public void setMaxDistance(double maxDistanceMeters) {
        this.maxDistanceMeters = maxDistanceMeters;
        this.shapeChanged();
    }

    public void setFlatness(double flatnessDistanceMeters) {
        this.flatnessDistanceMeters = flatnessDistanceMeters;
        this.shapeChanged();
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.shapeChanged();
    }

    public KmlOptions.AltitudeMode getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(KmlOptions.AltitudeMode altitudeMode) {
        this.altitudeMode = altitudeMode;
    }
}

