/*
 * Decompiled with CFR 0.152.
 */
package sec.geo.shape;

import java.util.ArrayList;
import sec.geo.GeoBlock;
import sec.geo.GeoEllipse;
import sec.geo.GeoPoint;
import sec.geo.ShapeObject;
import sec.geo.kml.KmlOptions;
import sec.sun.awt.geom.Area;

public class Orbit {
    private double minAltitudeMeters;
    private double maxAltitudeMeters;
    protected double maxDistanceMeters = 100000.0;
    protected double flatnessDistanceMeters = 1.0;
    protected KmlOptions.AltitudeMode altitudeMode;
    private Area shape;
    protected int limit = 4;
    private double widthMeters;
    protected final ArrayList<GeoPoint> points = new ArrayList();

    public void addPoint(GeoPoint point) {
        this.points.add(point);
        this.shapeChanged();
    }

    public void addPoints(ArrayList<GeoPoint> points) {
        this.points.addAll(points);
        this.shapeChanged();
    }

    public void setWidth(double widthMeters) {
        this.widthMeters = widthMeters;
        this.shapeChanged();
    }

    protected Area createShape() {
        Area orbit = new Area();
        GeoPoint previousPoint = null;
        for (GeoPoint point : this.points) {
            GeoEllipse ellipse = new GeoEllipse(point, this.widthMeters, this.widthMeters, this.maxDistanceMeters, this.flatnessDistanceMeters, this.limit);
            ShapeObject el = new ShapeObject(ellipse);
            Area rhs = new Area(el);
            orbit.add(rhs);
            if (previousPoint != null) {
                GeoBlock block = new GeoBlock(previousPoint, point, this.widthMeters, this.maxDistanceMeters, this.flatnessDistanceMeters, this.limit);
                ShapeObject bl = new ShapeObject(block);
                Area rhs2 = new Area(bl);
                orbit.add(rhs2);
            }
            previousPoint = point;
        }
        return orbit;
    }

    public Area getShape() {
        if (this.shape == null) {
            this.shape = this.createShape();
        }
        return this.shape;
    }

    protected void shapeChanged() {
        this.shape = null;
    }

    public double getMinAltitude() {
        return this.minAltitudeMeters;
    }

    public void setMinAltitude(double minAltitudeMeters) {
        this.minAltitudeMeters = minAltitudeMeters;
        this.shapeChanged();
    }

    public double getMaxAltitude() {
        return this.maxAltitudeMeters;
    }

    public void setMaxAltitude(double maxAltitudeMeters) {
        this.maxAltitudeMeters = maxAltitudeMeters;
        this.shapeChanged();
    }

    public void setMaxDistance(double maxDistanceMeters) {
        this.maxDistanceMeters = maxDistanceMeters;
        this.shapeChanged();
    }

    public void setFlatness(double flatnessDistanceMeters) {
        this.flatnessDistanceMeters = flatnessDistanceMeters;
        this.shapeChanged();
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.shapeChanged();
    }

    public KmlOptions.AltitudeMode getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(KmlOptions.AltitudeMode altitudeMode) {
        this.altitudeMode = altitudeMode;
    }
}

