/*
 * Decompiled with CFR 0.152.
 */
package sec.geo.shape;

import sec.geo.GeoEllipse;
import sec.geo.GeoPoint;
import sec.geo.ShapeObject;
import sec.geo.kml.KmlOptions;

public class Circle {
    protected GeoPoint pivot = new GeoPoint();
    protected double radiusMeters;
    private ShapeObject shape;
    protected double maxDistanceMeters = 100000.0;
    protected double flatnessDistanceMeters = 1.0;
    protected KmlOptions.AltitudeMode altitudeMode;
    private double minAltitudeMeters;
    private double maxAltitudeMeters;
    protected int limit = 4;

    public ShapeObject getShape() {
        if (this.shape == null) {
            this.shape = this.createShape();
        }
        return this.shape;
    }

    public void setRadius(double radiusMeters) {
        this.radiusMeters = radiusMeters;
        this.shapeChanged();
    }

    public void setPivot(GeoPoint pivot) {
        this.pivot = pivot;
        this.shapeChanged();
    }

    protected ShapeObject createShape() {
        GeoEllipse e = new GeoEllipse(this.pivot, this.radiusMeters * 2.0, this.radiusMeters * 2.0, this.maxDistanceMeters, this.flatnessDistanceMeters, this.limit);
        return new ShapeObject(e);
    }

    protected void shapeChanged() {
        this.shape = null;
    }

    public double getMinAltitude() {
        return this.minAltitudeMeters;
    }

    public void setMinAltitude(double minAltitudeMeters) {
        this.minAltitudeMeters = minAltitudeMeters;
        this.shapeChanged();
    }

    public double getMaxAltitude() {
        return this.maxAltitudeMeters;
    }

    public void setMaxAltitude(double maxAltitudeMeters) {
        this.maxAltitudeMeters = maxAltitudeMeters;
        this.shapeChanged();
    }

    public void setMaxDistance(double maxDistanceMeters) {
        this.maxDistanceMeters = maxDistanceMeters;
        this.shapeChanged();
    }

    public void setFlatness(double flatnessDistanceMeters) {
        this.flatnessDistanceMeters = flatnessDistanceMeters;
        this.shapeChanged();
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.shapeChanged();
    }

    public KmlOptions.AltitudeMode getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(KmlOptions.AltitudeMode altitudeMode) {
        this.altitudeMode = altitudeMode;
    }
}

