/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import armyc2.c2sd.renderer.utilities.SVGPath;
import armyc2.c2sd.renderer.utilities.XMLParser;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UnitSVGTable {
    private static Boolean _initCalled = false;
    private static UnitSVGTable _instance = null;
    private static Map<String, SVGPath> _UnitDefinitions = null;

    private UnitSVGTable() {
    }

    public static synchronized UnitSVGTable getInstance() {
        if (_instance == null) {
            _instance = new UnitSVGTable();
        }
        return _instance;
    }

    public synchronized void init(String unitSVG) {
        if (!_initCalled.booleanValue()) {
            _instance = new UnitSVGTable();
            _UnitDefinitions = new HashMap<String, SVGPath>();
            String lookupXml = unitSVG.replace("&#x", "");
            this.populateLookup(lookupXml);
            _initCalled = true;
        }
    }

    private void populateLookup(String xml) {
        Document doc = XMLParser.getDomElement(xml);
        NodeList nl = doc.getElementsByTagName("glyph");
        for (int i = 0; i < nl.getLength(); ++i) {
            String index = XMLParser.getAttribute((Element)nl.item(i), "unicode");
            String strPath = XMLParser.getAttribute((Element)nl.item(i), "d");
            if (strPath == null || strPath.equals("") || index == null || index.length() <= 3) continue;
            index = index.replace("&#x", "");
            index = index.replace(";", "");
            SVGPath path = new SVGPath(index, strPath);
            index = path.getID();
            _UnitDefinitions.put(index, path);
        }
    }

    public SVGPath getSVGPath(String index) {
        SVGPath returnVal = null;
        try {
            if (_UnitDefinitions.containsKey(index)) {
                returnVal = new SVGPath(_UnitDefinitions.get(index));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnVal;
    }

    public Boolean HasSVGPath(String index) {
        if (index != null && index.length() > 0) {
            return _UnitDefinitions.containsKey(index);
        }
        return false;
    }
}

