/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.util.Log;
import armyc2.c2sd.renderer.utilities.SymbolUtilities;
import armyc2.c2sd.renderer.utilities.UnitDef;
import armyc2.c2sd.renderer.utilities.XMLParser;
import armyc2.c2sd.renderer.utilities.XMLUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnitDefTable {
    private static Boolean _initCalled = false;
    private static UnitDefTable _instance = null;
    private static Map<String, UnitDef> _UnitDefinitionsB = null;
    private static ArrayList<UnitDef> _UnitDefDupsB = null;
    private static Map<String, UnitDef> _UnitDefinitionsC = null;
    private static ArrayList<UnitDef> _UnitDefDupsC = null;
    private String TAG = "UnitDefTable";
    private static String propSymbolID = "SYMBOLID";
    private static String propDrawCategory = "DRAWCATEGORY";
    private static String propModifiers = "MODIFIERS";
    private static String propDescription = "DESCRIPTION";
    private static String propHierarchy = "HIERARCHY";
    private static String propAlphaHierarchy = "ALPHAHIERARCHY";
    private static String propPath = "PATH";

    private UnitDefTable() {
    }

    public static synchronized UnitDefTable getInstance() {
        if (_instance == null) {
            _instance = new UnitDefTable();
        }
        return _instance;
    }

    private String getXML(String xmlName) {
        String xmlFolder = "res/raw/";
        String xml = null;
        Object tf = null;
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(xmlFolder + xmlName);
            if (is != null) {
                String line;
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader r = new BufferedReader(isr);
                StringBuilder total = new StringBuilder();
                while ((line = r.readLine()) != null) {
                    total.append(line);
                }
                xml = total.toString();
                r.close();
                isr.close();
                is.close();
                r = null;
                isr = null;
                is = null;
                total = null;
            }
        }
        catch (Exception exc) {
            Log.e((String)this.TAG, (String)exc.getMessage(), (Throwable)exc);
        }
        return xml;
    }

    public final synchronized void init() {
        if (!_initCalled.booleanValue()) {
            String[] xml = new String[]{this.getXML("unitconstantsb.xml"), this.getXML("unitconstantsc.xml")};
            this.init(xml);
        }
    }

    public synchronized void init(String[] unitConstantsXML) {
        if (!_initCalled.booleanValue()) {
            _UnitDefinitionsB = new HashMap<String, UnitDef>();
            _UnitDefDupsB = new ArrayList();
            _UnitDefinitionsC = new HashMap<String, UnitDef>();
            _UnitDefDupsC = new ArrayList();
            String lookupXmlB = unitConstantsXML[0];
            String lookupXmlC = unitConstantsXML[1];
            UnitDefTable.populateLookup(lookupXmlB, 0);
            UnitDefTable.populateLookup(lookupXmlC, 1);
            _initCalled = true;
        }
    }

    private static void populateLookup(String xml, int symStd) {
        UnitDef ud = null;
        Document document = XMLParser.getDomElement(xml);
        NodeList symbols = XMLUtil.getItemList(document, "SYMBOL");
        for (int i = 0; i < symbols.getLength(); ++i) {
            Node node = symbols.item(i);
            String symbolID = XMLUtil.parseTagValue(node, "SYMBOLID");
            String description = XMLUtil.parseTagValue(node, "DESCRIPTION");
            description = description.replaceAll("&amp;", "&");
            String drawCategory = XMLUtil.parseTagValue(node, "DRAWCATEGORY");
            String hierarchy = XMLUtil.parseTagValue(node, "HIERARCHY");
            String alphaHierarchy = XMLUtil.parseTagValue(node, "ALPHAHIERARCHY");
            String path = XMLUtil.parseTagValue(node, "PATH");
            if (SymbolUtilities.isInstallation(symbolID)) {
                symbolID = symbolID.substring(0, 10) + "H****";
            }
            int idc = 0;
            if (drawCategory != null || !drawCategory.equals("")) {
                idc = Integer.valueOf(drawCategory);
            }
            ud = new UnitDef(symbolID, description, idc, hierarchy, path);
            boolean isMCSSpecificFE = SymbolUtilities.isMCSSpecificForceElement(ud);
            if (symStd == 0) {
                if (!_UnitDefinitionsB.containsKey(symbolID) && !isMCSSpecificFE) {
                    _UnitDefinitionsB.put(symbolID, ud);
                    continue;
                }
                if (isMCSSpecificFE) continue;
                _UnitDefDupsB.add(ud);
                continue;
            }
            if (!_UnitDefinitionsC.containsKey(symbolID) && !isMCSSpecificFE) {
                _UnitDefinitionsC.put(symbolID, ud);
                continue;
            }
            if (isMCSSpecificFE) continue;
            _UnitDefDupsC.add(ud);
        }
    }

    public UnitDef getUnitDef(String basicSymbolID, int symStd) {
        UnitDef returnVal = null;
        try {
            if (symStd == 0) {
                returnVal = _UnitDefinitionsB.get(basicSymbolID);
            } else if (symStd == 1) {
                returnVal = _UnitDefinitionsC.get(basicSymbolID);
            }
        }
        catch (Exception exc) {
            Log.e((String)"UnitDefTable", (String)exc.getMessage(), (Throwable)exc);
        }
        catch (Throwable thrown) {
            Log.wtf((String)"UnitDefTable", (String)thrown.getMessage(), (Throwable)thrown);
        }
        return returnVal;
    }

    public Map<String, UnitDef> getAllUnitDefs(int symStd) {
        if (symStd == 0) {
            return _UnitDefinitionsB;
        }
        return _UnitDefinitionsC;
    }

    public ArrayList<UnitDef> getUnitDefDups(int symStd) {
        if (symStd == 0) {
            return _UnitDefDupsB;
        }
        return _UnitDefDupsC;
    }

    public Boolean hasUnitDef(String basicSymbolID, int symStd) {
        if (basicSymbolID != null && basicSymbolID.length() == 15) {
            if (symStd == 0) {
                return _UnitDefinitionsB.containsKey(basicSymbolID);
            }
            if (symStd == 1) {
                return _UnitDefinitionsC.containsKey(basicSymbolID);
            }
            return false;
        }
        return false;
    }
}

