/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import armyc2.c2sd.renderer.utilities.ErrorLogger;
import armyc2.c2sd.renderer.utilities.RendererSettings;
import armyc2.c2sd.renderer.utilities.SymbolUtilities;
import armyc2.c2sd.renderer.utilities.XMLParser;
import armyc2.c2sd.renderer.utilities.XMLUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TacticalGraphicLookup {
    private Map<String, Integer> symbolMap = new HashMap<String, Integer>();
    private static TacticalGraphicLookup _instance = null;

    private TacticalGraphicLookup() {
    }

    public static synchronized TacticalGraphicLookup getInstance() {
        if (_instance == null) {
            _instance = new TacticalGraphicLookup();
        }
        return _instance;
    }

    public synchronized void init(String xml) {
        this.populateLookup(xml);
    }

    private void populateLookup(String xml) {
        Document document = XMLParser.getDomElement(xml);
        NodeList symbols = XMLUtil.getItemList(document, "SYMBOL");
        for (int i = 0; i < symbols.getLength(); ++i) {
            Node node = symbols.item(i);
            String basicID = XMLUtil.parseTagValue(node, "SYMBOLID");
            String mapping = XMLUtil.parseTagValue(node, "MAPPING");
            mapping = TacticalGraphicLookup.checkMappingIndex(mapping);
            this.symbolMap.put(basicID, Integer.valueOf(mapping));
        }
    }

    private static String checkMappingIndex(String index) {
        int i = -1;
        if (SymbolUtilities.isNumber(index)) {
            i = Integer.valueOf(index);
            return String.valueOf(i + 57000);
        }
        return index;
    }

    public int getCharCodeFromSymbol(String symbolCode) {
        int symStd = RendererSettings.getInstance().getSymbologyStandard();
        return this.getCharCodeFromSymbol(symbolCode, symStd);
    }

    public int getCharCodeFromSymbol(String symbolCode, int symStd) {
        try {
            String basicID = symbolCode;
            int charCode = -1;
            if (!SymbolUtilities.is3dAirspace(symbolCode)) {
                basicID = SymbolUtilities.getBasicSymbolID(symbolCode);
            }
            if (this.symbolMap.containsKey(basicID) && (charCode = this.symbolMap.get(basicID).intValue()) == 59053 && symStd == 1) {
                charCode = 59052;
            }
            return charCode;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("TacticalGraphicLookup", "getCharCodeFromSymbol", exc, Level.WARNING);
            return -1;
        }
    }
}

