/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import armyc2.c2sd.renderer.utilities.Color;
import armyc2.c2sd.renderer.utilities.ErrorLogger;
import armyc2.c2sd.renderer.utilities.ModifiersTG;
import armyc2.c2sd.renderer.utilities.RendererSettings;
import armyc2.c2sd.renderer.utilities.SymbolDef;
import armyc2.c2sd.renderer.utilities.SymbolDefTable;
import armyc2.c2sd.renderer.utilities.UnitDef;
import armyc2.c2sd.renderer.utilities.UnitDefTable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class SymbolUtilities {
    private static SimpleDateFormat dateFormatFront = new SimpleDateFormat("ddHHmmss");
    private static SimpleDateFormat dateFormatBack = new SimpleDateFormat("MMMyy");
    private static SimpleDateFormat dateFormatFull = new SimpleDateFormat("ddHHmmssZMMMyy");
    private static SimpleDateFormat dateFormatZulu = new SimpleDateFormat("Z");
    private static final String Digits = "(\\p{Digit}+)";
    private static final String HexDigits = "(\\p{XDigit}+)";
    private static final String Exp = "[eE][+-]?(\\p{Digit}+)";
    private static final String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
    private static final Pattern pIsNumber = Pattern.compile("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");
    private static RendererSettings rendererSettings = RendererSettings.getInstance();

    public static String getBasicSymbolID(String strSymbolID) {
        try {
            StringBuilder sb = new StringBuilder();
            if (strSymbolID != null && strSymbolID.length() == 15) {
                if (SymbolUtilities.isWeather(strSymbolID) || SymbolUtilities.isBasicShape(strSymbolID)) {
                    return strSymbolID;
                }
                if (SymbolUtilities.isTacticalGraphic(strSymbolID)) {
                    sb.append(strSymbolID.charAt(0));
                    sb.append("*");
                    sb.append(strSymbolID.charAt(2));
                    sb.append("*");
                    sb.append(strSymbolID.substring(4, 10));
                    sb.append("****");
                    sb.append("X");
                    if (SymbolUtilities.isEMSNaturalEvent(strSymbolID)) {
                        sb.deleteCharAt(14).append("*");
                    }
                    return sb.toString();
                }
                if (SymbolUtilities.isWarfighting(strSymbolID)) {
                    sb.append(strSymbolID.charAt(0));
                    sb.append("*");
                    sb.append(strSymbolID.charAt(2));
                    sb.append("*");
                    sb.append(strSymbolID.substring(4, 10));
                    if (SymbolUtilities.isSIGINT(strSymbolID)) {
                        sb.append("--***");
                    } else if (SymbolUtilities.isInstallation(strSymbolID)) {
                        sb.append("H****");
                    } else {
                        sb.append("*****");
                        UnitDefTable udt = UnitDefTable.getInstance();
                        String temp = sb.toString();
                        for (int i = 0; i < 2; ++i) {
                            if (udt.hasUnitDef(temp, i).booleanValue()) {
                                return temp;
                            }
                            if (udt.hasUnitDef(temp = temp.substring(0, 10) + "H****", i).booleanValue()) {
                                return temp;
                            }
                            if (udt.hasUnitDef(temp = temp.substring(0, 10) + "MO***", i).booleanValue()) {
                                return temp;
                            }
                            temp = temp.substring(0, 10) + "*****";
                        }
                    }
                    return sb.toString();
                }
                return strSymbolID;
            }
            return strSymbolID;
        }
        catch (Throwable t) {
            System.out.println(t);
            return "";
        }
    }

    public static String getBasicSymbolIDStrict(String strSymbolID) {
        if (strSymbolID != null && strSymbolID.length() == 15) {
            StringBuilder sb = new StringBuilder();
            char scheme = strSymbolID.charAt(0);
            if (scheme == 'G') {
                sb.append(strSymbolID.charAt(0));
                sb.append("*");
                sb.append(strSymbolID.charAt(2));
                sb.append("*");
                sb.append(strSymbolID.substring(4, 10));
                sb.append("****X");
            } else if (scheme != 'W' && scheme != 'B' && scheme != 'P') {
                sb.append(strSymbolID.charAt(0));
                sb.append("*");
                sb.append(strSymbolID.charAt(2));
                sb.append("*");
                sb.append(strSymbolID.substring(4, 10));
                sb.append("*****");
            } else {
                return strSymbolID;
            }
            return sb.toString();
        }
        return strSymbolID;
    }

    public static String reconcileSymbolID(String symbolID) {
        return SymbolUtilities.reconcileSymbolID(symbolID, false);
    }

    public static String reconcileSymbolID(String symbolID, boolean isMultiPoint) {
        StringBuilder sb = new StringBuilder("");
        char codingScheme = symbolID.charAt(0);
        if (symbolID.startsWith("BS_") || symbolID.startsWith("BBS_") || symbolID.startsWith("PBS_")) {
            return symbolID;
        }
        if (symbolID.length() < 15) {
            while (symbolID.length() < 15) {
                symbolID = symbolID + "-";
            }
        }
        if (symbolID.length() > 15) {
            symbolID = symbolID.substring(0, 15);
        }
        if (symbolID != null && symbolID.length() == 15) {
            if (codingScheme == 'S' || codingScheme == 'I' || codingScheme == 'O' || codingScheme == 'E') {
                sb.append(codingScheme);
                if (!SymbolUtilities.hasValidAffiliation(symbolID).booleanValue()) {
                    sb.append('U');
                } else {
                    sb.append(symbolID.charAt(1));
                }
                if (!SymbolUtilities.hasValidBattleDimension(symbolID).booleanValue()) {
                    sb.append('Z');
                    sb.replace(0, 1, "S");
                } else {
                    sb.append(symbolID.charAt(2));
                }
                if (!SymbolUtilities.hasValidStatus(symbolID).booleanValue()) {
                    sb.append('P');
                } else {
                    sb.append(symbolID.charAt(3));
                }
                sb.append("------");
                sb.append(symbolID.substring(10, 15));
            } else if (codingScheme == 'G') {
                sb.append(codingScheme);
                if (!SymbolUtilities.hasValidAffiliation(symbolID).booleanValue()) {
                    sb.append('U');
                } else {
                    sb.append(symbolID.charAt(1));
                }
                sb.append('G');
                if (!SymbolUtilities.hasValidStatus(symbolID).booleanValue()) {
                    sb.append('P');
                } else {
                    sb.append(symbolID.charAt(3));
                }
                if (isMultiPoint) {
                    sb.append("GAG---");
                } else {
                    sb.append("GPP---");
                }
                sb.append(symbolID.substring(10, 15));
            } else {
                if (codingScheme == 'W') {
                    return "SUZP-----------";
                }
                sb.append('S');
                if (!SymbolUtilities.hasValidAffiliation(symbolID).booleanValue()) {
                    sb.append('U');
                } else {
                    sb.append(symbolID.charAt(1));
                }
                if (!SymbolUtilities.hasValidBattleDimension(symbolID).booleanValue()) {
                    sb.append('Z');
                } else {
                    sb.append(symbolID.charAt(2));
                }
                if (!SymbolUtilities.hasValidStatus(symbolID).booleanValue()) {
                    sb.append('P');
                } else {
                    sb.append(symbolID.charAt(3));
                }
                sb.append("------");
                sb.append(symbolID.substring(10, 15));
            }
        } else {
            return "SUZP-----------";
        }
        return sb.toString();
    }

    public static Boolean hasValidStatus(String SymbolID) {
        if (SymbolID != null && SymbolID.length() >= 10) {
            char status = SymbolID.charAt(3);
            char codingScheme = SymbolID.charAt(0);
            if (codingScheme == 'S' || codingScheme == 'I' || codingScheme == 'O' || codingScheme == 'E') {
                if (status == 'A' || status == 'P' || status == 'C' || status == 'D' || status == 'X' || status == 'F') {
                    return true;
                }
                return false;
            }
            if (codingScheme == 'G') {
                if (status == 'A' || status == 'S' || status == 'P' || status == 'K') {
                    return true;
                }
                return false;
            }
            if (codingScheme == 'W') {
                return true;
            }
            return false;
        }
        return false;
    }

    public static Boolean hasValidAffiliation(String SymbolID) {
        if (SymbolID != null && SymbolID.length() >= 10 && !SymbolUtilities.isWeather(SymbolID)) {
            char affiliation = SymbolID.charAt(1);
            if (affiliation == 'P' || affiliation == 'U' || affiliation == 'A' || affiliation == 'F' || affiliation == 'N' || affiliation == 'S' || affiliation == 'H' || affiliation == 'G' || affiliation == 'W' || affiliation == 'M' || affiliation == 'D' || affiliation == 'L' || affiliation == 'J' || affiliation == 'K') {
                return true;
            }
            return false;
        }
        return false;
    }

    public static Boolean hasValidCodingScheme(String symbolID) {
        if (symbolID != null && symbolID.length() > 0) {
            char codingScheme = symbolID.charAt(0);
            if (codingScheme == 'S' || codingScheme == 'G' || codingScheme == 'W' || codingScheme == 'I' || codingScheme == 'O' || codingScheme == 'E') {
                return true;
            }
            return false;
        }
        return false;
    }

    public static Boolean hasValidBattleDimension(String SymbolID) {
        if (SymbolID != null && SymbolID.length() >= 10) {
            char codingScheme = SymbolID.charAt(0);
            char bd = SymbolID.charAt(2);
            if (codingScheme == 'S') {
                if (bd == 'P' || bd == 'A' || bd == 'G' || bd == 'S' || bd == 'U' || bd == 'F' || bd == 'Z') {
                    return true;
                }
                return false;
            }
            if (codingScheme == 'O') {
                if (bd == 'V' || bd == 'L' || bd == 'O' || bd == 'I' || bd == 'P' || bd == 'G' || bd == 'R') {
                    return true;
                }
                return false;
            }
            if (codingScheme == 'E') {
                if (bd == 'I' || bd == 'N' || bd == 'O' || bd == 'F') {
                    return true;
                }
                return false;
            }
            if (codingScheme == 'G') {
                if (bd == 'T' || bd == 'G' || bd == 'M' || bd == 'F' || bd == 'S' || bd == 'O') {
                    return true;
                }
                return false;
            }
            if (codingScheme == 'W') {
                return true;
            }
            if (codingScheme == 'I') {
                if (bd == 'P' || bd == 'A' || bd == 'G' || bd == 'S' || bd == 'U' || bd == 'Z') {
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public static Boolean hasValidCountryCode(String symbolID) {
        if (Character.isLetter(symbolID.charAt(12)) && Character.isLetter(symbolID.charAt(13))) {
            return true;
        }
        return false;
    }

    public static String getDateLabel(Date time) {
        String modifierString = null;
        String zulu = "";
        zulu = dateFormatZulu.format(time);
        if (zulu != null && zulu.length() == 5) {
            zulu = zulu.startsWith("+") ? zulu.substring(1, 3) : zulu.substring(0, 3);
            int intZulu = Integer.valueOf(zulu);
            zulu = SymbolUtilities.getZuluCharFromTimeZoneOffset(intZulu);
        } else {
            zulu = SymbolUtilities.getZuluCharFromTimeZoneOffset(time);
        }
        modifierString = dateFormatFront.format(time) + zulu + dateFormatBack.format(time);
        return modifierString.toUpperCase();
    }

    private static String getZuluCharFromTimeZoneOffset(Date time) {
        TimeZone tz = TimeZone.getDefault();
        Date offset = new Date(tz.getOffset(time.getTime()));
        long lOffset = offset.getTime() / 3600000L;
        int hour = (int)lOffset;
        return SymbolUtilities.getZuluCharFromTimeZoneOffset(hour);
    }

    private static String getZuluCharFromTimeZoneOffset(int hour) {
        if (hour == 0) {
            return "Z";
        }
        if (hour == -1) {
            return "N";
        }
        if (hour == -2) {
            return "O";
        }
        if (hour == -3) {
            return "P";
        }
        if (hour == -4) {
            return "Q";
        }
        if (hour == -5) {
            return "R";
        }
        if (hour == -6) {
            return "S";
        }
        if (hour == -7) {
            return "T";
        }
        if (hour == -8) {
            return "U";
        }
        if (hour == -9) {
            return "V";
        }
        if (hour == -10) {
            return "W";
        }
        if (hour == -11) {
            return "X";
        }
        if (hour == -12) {
            return "Y";
        }
        if (hour == 1) {
            return "A";
        }
        if (hour == 2) {
            return "B";
        }
        if (hour == 3) {
            return "C";
        }
        if (hour == 4) {
            return "D";
        }
        if (hour == 5) {
            return "E";
        }
        if (hour == 6) {
            return "F";
        }
        if (hour == 7) {
            return "G";
        }
        if (hour == 8) {
            return "H";
        }
        if (hour == 9) {
            return "I";
        }
        if (hour == 10) {
            return "K";
        }
        if (hour == 11) {
            return "L";
        }
        if (hour == 12) {
            return "M";
        }
        return "-";
    }

    public static boolean canUnitHaveModifier(String symbolID, int unitModifier) {
        boolean returnVal = false;
        try {
            if (unitModifier == 2) {
                return SymbolUtilities.isUnit(symbolID) || SymbolUtilities.isSTBOPS(symbolID);
            }
            if (unitModifier == 3) {
                return SymbolUtilities.isEquipment(symbolID) || SymbolUtilities.isEMSEquipment(symbolID) || SymbolUtilities.isEMSIncident(symbolID);
            }
            if (unitModifier == 4) {
                return SymbolUtilities.isUnit(symbolID) || SymbolUtilities.isSTBOPS(symbolID);
            }
            if (unitModifier == 6) {
                return SymbolUtilities.isUnit(symbolID) || SymbolUtilities.isSTBOPS(symbolID);
            }
            if (unitModifier == 7) {
                return !SymbolUtilities.isEMS(symbolID);
            }
            if (unitModifier == 8) {
                return true;
            }
            if (unitModifier == 11) {
                return true;
            }
            if (unitModifier == 12) {
                return SymbolUtilities.isUnit(symbolID) || SymbolUtilities.isSTBOPS(symbolID) || SymbolUtilities.hasInstallationModifier(symbolID) && !SymbolUtilities.isEMS(symbolID);
            }
            if (unitModifier == 13) {
                return SymbolUtilities.isEquipment(symbolID) || SymbolUtilities.isSIGINT(symbolID);
            }
            if (unitModifier == 14) {
                return SymbolUtilities.isUnit(symbolID) || SymbolUtilities.isSIGINT(symbolID);
            }
            if (unitModifier == 15) {
                return SymbolUtilities.isEquipment(symbolID);
            }
            if (unitModifier == 16) {
                return symbolID.charAt(0) == 'S' || SymbolUtilities.isSTBOPS(symbolID);
            }
            if (unitModifier == 17) {
                return !SymbolUtilities.hasInstallationModifier(symbolID) && !SymbolUtilities.isSIGINT(symbolID);
            }
            if (unitModifier == 18) {
                return SymbolUtilities.isEquipment(symbolID) || SymbolUtilities.isEMSEquipment(symbolID);
            }
            if (unitModifier == 19) {
                return SymbolUtilities.isSIGINT(symbolID);
            }
            if (unitModifier == 20) {
                return !SymbolUtilities.isSIGINT(symbolID);
            }
            if (unitModifier == 21) {
                return true;
            }
            if (unitModifier == 23) {
                return SymbolUtilities.isEquipment(symbolID) || SymbolUtilities.isSIGINT(symbolID) || SymbolUtilities.isEMSEquipment(symbolID);
            }
            if (unitModifier == 24) {
                return true;
            }
            if (unitModifier == 26) {
                return !SymbolUtilities.isSIGINT(symbolID);
            }
            if (unitModifier == 27) {
                return true;
            }
            if (unitModifier == 28) {
                return !SymbolUtilities.hasInstallationModifier(symbolID) && !SymbolUtilities.isSIGINT(symbolID);
            }
            if (unitModifier == 29) {
                return SymbolUtilities.isUnit(symbolID) || SymbolUtilities.isSTBOPS(symbolID);
            }
            if (unitModifier == 30) {
                return !SymbolUtilities.isSIGINT(symbolID) && !SymbolUtilities.isEMS(symbolID);
            }
            if (unitModifier == 31) {
                return !SymbolUtilities.isSIGINT(symbolID);
            }
            if (unitModifier == 32) {
                return SymbolUtilities.isSIGINT(symbolID);
            }
            if (unitModifier == 33) {
                return SymbolUtilities.isSIGINT(symbolID);
            }
            if (unitModifier == 34) {
                return SymbolUtilities.isSIGINT(symbolID);
            }
            if (unitModifier == 35) {
                return SymbolUtilities.isEquipment(symbolID);
            }
            if (unitModifier == 36 || unitModifier == 37 || unitModifier == 38) {
                return !SymbolUtilities.isSIGINT(symbolID) && !SymbolUtilities.hasInstallationModifier(symbolID);
            }
            if (unitModifier == 39) {
                return !SymbolUtilities.isSIGINT(symbolID) && !SymbolUtilities.isEMS(symbolID) && !SymbolUtilities.hasInstallationModifier(symbolID);
            }
            if (unitModifier == 40) {
                return !SymbolUtilities.isUnit(symbolID);
            }
            if (unitModifier == 41) {
                return (SymbolUtilities.isEquipment(symbolID) || SymbolUtilities.isUnit(symbolID) || SymbolUtilities.hasInstallationModifier(symbolID)) && !SymbolUtilities.isEMS(symbolID);
            }
            if (unitModifier == 1) {
                return true;
            }
            if (unitModifier == 5) {
                return true;
            }
            if (unitModifier == 50) {
                String temp;
                return SymbolUtilities.isSubSurface(symbolID) && ((temp = symbolID.substring(4, 10)).equals("WMGC--") || temp.equals("WMMC--") || temp.equals("WMFC--") || temp.equals("WMC---"));
            }
            return false;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SymbolUtilties", "canHaveModifier", exc);
            return returnVal;
        }
    }

    public static Boolean hasModifier(String symbolID, int modifier) {
        return SymbolUtilities.hasModifier(symbolID, modifier, rendererSettings.getSymbologyStandard());
    }

    public static Boolean hasModifier(String symbolID, int modifier, int symStd) {
        Boolean returnVal = false;
        returnVal = SymbolUtilities.isTacticalGraphic(symbolID) ? Boolean.valueOf(SymbolUtilities.canSymbolHaveModifier(symbolID, modifier, symStd)) : Boolean.valueOf(SymbolUtilities.canUnitHaveModifier(symbolID, modifier));
        return returnVal;
    }

    public static boolean canSymbolHaveModifier(String symbolID, int tgModifier) {
        return SymbolUtilities.canSymbolHaveModifier(symbolID, tgModifier, rendererSettings.getSymbologyStandard());
    }

    public static boolean canSymbolHaveModifier(String symbolID, int tgModifier, int symStd) {
        String basic = null;
        SymbolDef sd = null;
        boolean returnVal = false;
        String modCode = ModifiersTG.getModifierLetterCode(tgModifier);
        try {
            block14: {
                int dc;
                block15: {
                    basic = SymbolUtilities.getBasicSymbolID(symbolID);
                    sd = SymbolDefTable.getInstance().getSymbolDef(basic, symStd);
                    if (sd == null || modCode.equals("")) break block14;
                    dc = sd.getDrawCategory();
                    if (tgModifier != 16) break block15;
                    switch (dc) {
                        case 17: 
                        case 18: 
                        case 20: {
                            returnVal = true;
                            break;
                        }
                        case 16: 
                        case 19: {
                            returnVal = true;
                            break;
                        }
                        case 1: {
                            if (sd.getModifiers().indexOf(modCode + ".") > -1) {
                                returnVal = true;
                                break;
                            }
                            break block14;
                        }
                        default: {
                            returnVal = false;
                            break;
                        }
                    }
                    break block14;
                }
                if (tgModifier == 17) {
                    switch (dc) {
                        case 17: 
                        case 18: {
                            returnVal = true;
                            break;
                        }
                        default: {
                            returnVal = false;
                            break;
                        }
                    }
                } else if (sd.getModifiers().indexOf(modCode + ".") > -1) {
                    returnVal = true;
                }
            }
            return returnVal;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SymbolUtilities", "canSymbolHaveModifier", exc);
            return returnVal;
        }
    }

    public static Color getLineColorOfAffiliation(String symbolID) {
        Color retColor = null;
        String basicSymbolID = SymbolUtilities.getBasicSymbolID(symbolID);
        try {
            String switchChar;
            if (symbolID == null || symbolID.equals("")) {
                return retColor;
            }
            retColor = SymbolUtilities.isTacticalGraphic(symbolID) ? (symbolID.substring(0, 4).equals("ESRI") || SymbolUtilities.isJWARN(symbolID) ? rendererSettings.getFriendlyGraphicLineColor() : (SymbolUtilities.isWeather(symbolID) ? SymbolUtilities.getLineColorOfWeather(symbolID) : (SymbolUtilities.isObstacle(symbolID) ? rendererSettings.getNeutralGraphicLineColor() : (SymbolUtilities.isNBC(symbolID) && (basicSymbolID.equals("G*M*NR----****X") || basicSymbolID.equals("G*M*NC----****X") || basicSymbolID.equals("G*M*NB----****X")) ? rendererSettings.getFriendlyGraphicLineColor() : (SymbolUtilities.isEMSNaturalEvent(symbolID) ? rendererSettings.getFriendlyGraphicLineColor() : ((switchChar = symbolID.substring(1, 2)).equals("F") || switchChar.equals("A") || switchChar.equals("D") || switchChar.equals("M") ? rendererSettings.getFriendlyGraphicLineColor() : (switchChar.equals("H") || switchChar.equals("S") || switchChar.equals("J") || switchChar.equals("K") ? (SymbolUtilities.getBasicSymbolID(symbolID).equals("G*G*GLC---****X") ? rendererSettings.getFriendlyGraphicLineColor() : rendererSettings.getHostileGraphicLineColor()) : (switchChar.equals("N") || switchChar.equals("L") ? rendererSettings.getNeutralGraphicLineColor() : (switchChar.equals("U") || switchChar.equals("P") || switchChar.equals("O") || switchChar.equals("G") || switchChar.equals("W") ? (symbolID.substring(0, 8).equals("WOS-HDS-") ? Color.GRAY : rendererSettings.getUnknownGraphicLineColor()) : rendererSettings.getFriendlyGraphicLineColor()))))))))) : rendererSettings.getFriendlyUnitLineColor();
        }
        catch (Exception e) {
            ErrorLogger.LogException("SymbolUtilties", "getLineColorOfAffiliation", e);
        }
        return retColor;
    }

    public static Color getFillColorOfAffiliation(String symbolID) {
        Color retColor = null;
        String basicSymbolID = SymbolUtilities.getBasicSymbolID(symbolID);
        try {
            char switchChar;
            if (symbolID == null || symbolID.equals("")) {
                return retColor;
            }
            retColor = basicSymbolID.equals("G*M*NZ----****X") || basicSymbolID.equals("G*M*NEB---****X") || basicSymbolID.equals("G*M*NEC---****X") ? rendererSettings.getUnknownUnitFillColor() : (SymbolUtilities.isTacticalGraphic(symbolID) && !SymbolUtilities.isTGSPWithFill(symbolID) ? (basicSymbolID.equals("G*M*NZ----****X") || basicSymbolID.equals("G*M*NEB---****X") || basicSymbolID.equals("G*M*NEC---****X") ? rendererSettings.getUnknownUnitFillColor() : ((switchChar = symbolID.charAt(1)) == 'F' || switchChar == 'A' || switchChar == 'D' || switchChar == 'M' ? rendererSettings.getFriendlyGraphicFillColor() : (switchChar == 'H' || switchChar == 'S' || switchChar == 'J' || switchChar == 'K' ? rendererSettings.getHostileGraphicFillColor() : (switchChar == 'N' || switchChar == 'L' ? rendererSettings.getNeutralGraphicFillColor() : (switchChar == 'U' || switchChar == 'P' || switchChar == 'O' || switchChar == 'G' || switchChar == 'W' ? new Color(255, 250, 205) : rendererSettings.getUnknownGraphicFillColor()))))) : ((switchChar = symbolID.charAt(1)) == 'F' || switchChar == 'A' || switchChar == 'D' || switchChar == 'M' ? rendererSettings.getFriendlyUnitFillColor() : (switchChar == 'H' || switchChar == 'S' || switchChar == 'J' || switchChar == 'K' ? rendererSettings.getHostileUnitFillColor() : (switchChar == 'N' || switchChar == 'L' ? rendererSettings.getNeutralUnitFillColor() : (switchChar == 'U' || switchChar == 'P' || switchChar == 'O' || switchChar == 'G' || switchChar == 'W' ? rendererSettings.getUnknownUnitFillColor() : rendererSettings.getUnknownUnitFillColor())))));
        }
        catch (Exception e) {
            ErrorLogger.LogException("SymbolUtilties", "getFillColorOfAffiliation", e);
        }
        return retColor;
    }

    public static Color getLineColorOfWeather(String symbolID) {
        Color retColor = Color.BLACK;
        retColor = symbolID.equals("WAS-WSGRL-P----") || symbolID.equals("WAS-WSGRMHP----") || symbolID.equals("WAS-PL----P----") || symbolID.equals("WAS-PC----P----") || symbolID.equals("WAS-WSIC--P----") || symbolID.equals("WAS-WSPLL-P----") || symbolID.equals("WAS-WSPLM-P----") || symbolID.equals("WAS-WSPLH-P----") || symbolID.equals("WAS-WST-NPP----") || symbolID.equals("WAS-WSTMR-P----") || symbolID.equals("WAS-WSTHR-P----") || symbolID.equals("WAS-WSTMH-P----") || symbolID.equals("WAS-WSTHH-P----") || symbolID.equals("WAS-WST-FCP----") || symbolID.equals("WAS-WST-SQP----") || symbolID.equals("WAS-WST-LGP----") || symbolID.equals("WAS-WSFGFVP----") || symbolID.equals("WAS-WSFGFOP----") || symbolID.equals("WAS-WSTSD-P----") || symbolID.equals("WAS-WSTSS-P----") || symbolID.equals("WAS-WSTSH-P----") || symbolID.equals("WAS-WSRFL-P----") || symbolID.equals("WAS-WSRFMHP----") || symbolID.equals("WAS-WSDFL-P----") || symbolID.equals("WAS-WSDFMHP----") || symbolID.equals("WOS-HHDMDBP----") || symbolID.equals("WOS-HHDMDFP----") || symbolID.substring(0, 7).equals("WA-DPFW") || symbolID.equals("WA-DBAIF----A--") || symbolID.equals("WA-DBAFP----A--") || symbolID.equals("WA-DBAT-----A--") || symbolID.equals("WA-DIPIS---L---") || symbolID.equals("WA-DIPTH---L---") || symbolID.equals("WA-DWJ-----L---") || symbolID.equals("WO-DGMSB----A--") || symbolID.equals("WO-DGMRR----A--") || symbolID.equals("WO-DGMCH----A--") || symbolID.equals("WO-DGMIBE---A--") || symbolID.equals("WO-DGMBCC---A--") || symbolID.equals("WO-DOBVI----A--") ? Color.RED : (symbolID.equals("WAS-PH----P----") || symbolID.equals("WAS-PA----P----") || symbolID.equals("WA-DBAMV----A--") || symbolID.equals("WA-DBATB----A--") || symbolID.substring(0, 5).equals("WAS-T") || symbolID.substring(0, 7).equals("WA-DPFC") || symbolID.equals("WO-DGMIBA---A--") ? Color.BLUE : (symbolID.equals("WAS-WSFGPSP----") || symbolID.equals("WAS-WSFGCSP----") || symbolID.equals("WAS-WSFGP-P----") || symbolID.equals("WAS-WSFGSVP----") || symbolID.equals("WAS-WSFGSOP----") || symbolID.equals("WA-DBAFG----A--") || symbolID.equals("WO-DGMRM----A--") || symbolID.equals("WO-DGMCM----A--") || symbolID.equals("WO-DGMIBC---A--") || symbolID.equals("WO-DGMBCB---A--") || symbolID.equals("WO-DGMBTE---A--") || symbolID.equals("WAS-WSBR--P----") ? Color.YELLOW : (symbolID.equals("WAS-WSFU--P----") || symbolID.equals("WAS-WSHZ--P----") || symbolID.equals("WAS-WSDSLMP----") || symbolID.equals("WAS-WSDSS-P----") || symbolID.equals("WAS-WSDD--P----") || symbolID.equals("WA-DBAD-----A--") || symbolID.equals("WAS-WSBD--P----") ? new Color(165, 42, 42) : (symbolID.equals("WA-DBALPNC--A--") || symbolID.equals("WA-DBALPC---A--") || symbolID.equals("WA-DIPID---L---") || symbolID.equals("WO-DGMSIM---A--") || symbolID.equals("WO-DGMRS----A--") || symbolID.equals("WO-DGMCL----A--") || symbolID.equals("WO-DGMIBB---A--") || symbolID.equals("WO-DGMBCA---A--") || symbolID.equals("WAS-WSR-LIP----") || symbolID.equals("WAS-WSR-LCP----") || symbolID.equals("WAS-WSR-MIP----") || symbolID.equals("WAS-WSR-MCP----") || symbolID.equals("WAS-WSR-HIP----") || symbolID.equals("WAS-WSR-HCP----") || symbolID.equals("WAS-WSRSL-P----") || symbolID.equals("WAS-WSRSMHP----") || symbolID.equals("WAS-WSRST-P----") || symbolID.equals("WAS-WSD-LIP----") || symbolID.equals("WAS-WSD-LCP----") || symbolID.equals("WAS-WSD-MIP----") || symbolID.equals("WAS-WSD-MCP----") || symbolID.equals("WAS-WSD-HIP----") || symbolID.equals("WAS-WSD-HCP----") || symbolID.equals("WAS-WSM-L-P----") || symbolID.equals("WAS-WSM-MHP----") || symbolID.equals("WAS-WSMSL-P----") || symbolID.equals("WAS-WSMSMHP----") || symbolID.equals("WAS-WSUKP-P----") || symbolID.equals("WAS-WSS-LIP----") || symbolID.equals("WAS-WSS-LCP----") || symbolID.equals("WAS-WSS-MIP----") || symbolID.equals("WAS-WSS-MCP----") || symbolID.equals("WAS-WSS-HIP----") || symbolID.equals("WAS-WSS-HCP----") || symbolID.equals("WAS-WSSBLMP----") || symbolID.equals("WAS-WSSBH-P----") || symbolID.equals("WAS-WSSG--P----") || symbolID.equals("WAS-WSSSL-P----") || symbolID.equals("WAS-WSSSMHP----") ? Color.GREEN : (symbolID.equals("WO-DHCF----L---") || symbolID.equals("WO-DHCF-----A--") ? new Color(173, 255, 47) : (symbolID.startsWith("WAS-IC") || symbolID.startsWith("WAS-IR") || symbolID.startsWith("WAS-IM") ? new Color(128, 96, 16) : (symbolID.equals("WOS-HDS---P----") || symbolID.equals("WOS-HHDF--P----") || symbolID.equals("WO-DHHDF----A--") || symbolID.equals("WOS-HPFS--P----") || symbolID.equals("WOS-HPFS---L---") || symbolID.equals("WOS-HPFF----A--") || symbolID.equals("WO-DHDDL---L---") || symbolID.equals("WO-DHDDC---L---") || symbolID.equals("WO-DHCC----L---") || symbolID.equals("WO-DHPBP---L---") || symbolID.equals("WO-DHPMO---L---") || symbolID.equals("WO-DHPSPA--L---") || symbolID.equals("WO-DHPSPB--L---") || symbolID.equals("WO-DHPSPS--L---") || symbolID.equals("WO-DHHDK--P----") || symbolID.equals("WO-DHHDK----A--") || symbolID.equals("WO-DHHDB---L---") || symbolID.equals("WO-DTCCCFE-L---") || symbolID.equals("WO-DTCCCFF-L---") || symbolID.equals("WOS-TCCTD-P----") || symbolID.equals("WO-DHCW-----A--") || symbolID.equals("WO-DMOA-----A--") || symbolID.equals("WO-DMPA----L---") ? Color.GRAY : (symbolID.equals("WO-DBSM-----A--") || symbolID.equals("WO-DBSF-----A--") || symbolID.equals("WO-DGMN-----A--") ? new Color(230, 230, 230) : (symbolID.equals("WO-DBSG-----A--") || symbolID.equals("WO-DBST-----A--") ? new Color(169, 169, 169) : (symbolID.equals("WAS-WSVE--P----") || symbolID.equals("WAS-WSVA--P----") || symbolID.equals("WAS-WST-LVP----") || symbolID.equals("WAS-WSF-LVP----") ? Color.BLACK : (symbolID.equals("WOS-HPBA--P----") || symbolID.equals("WOS-HPBA---L---") || symbolID.equals("WOS-HPBA----A--") || symbolID.equals("WOS-HPCP--P----") || symbolID.equals("WOS-HPFH--P----") || symbolID.equals("WOS-HPM-FC-L---") || symbolID.equals("WOS-HABM--P----") || symbolID.equals("WOS-HAL---P----") || symbolID.equals("WA-DIPIT---L---") || symbolID.equals("WOS-TCCTG-P----") || symbolID.equals("WO-DL-ML---L---") || symbolID.equals("WOS-HPM-FC-L---") || symbolID.equals("WO-DL-RA---L---") || symbolID.equals("WO-DHPBA---L---") || symbolID.equals("WO-DMCA----L---") || symbolID.equals("WO-DHPBA----A--") || symbolID.equals("WO-DL-MA----A--") || symbolID.equals("WO-DL-SA----A--") || symbolID.equals("WO-DL-TA----A--") || symbolID.equals("WO-DGMSR----A--") ? new Color(255, 0, 255) : (symbolID.substring(0, 7).equals("WA-DPFO") ? new Color(226, 159, 255) : (symbolID.equals("WA-DPXITCZ-L---") || symbolID.equals("WO-DL-O-----A--") || symbolID.equals("WA-DPXCV---L---") ? new Color(255, 165, 0) : (symbolID.equals("WA-DBAI-----A--") || symbolID.startsWith("WAS-IC") || symbolID.startsWith("WAS-IR") || symbolID.startsWith("WAS-IM") ? new Color(128, 96, 16) : (symbolID.equals("WO-DHCI-----A--") || symbolID.equals("WO-DHCB-----A--") || symbolID.equals("WO-DHPMO----A--") || symbolID.equals("WO-DHCI-----A--") ? new Color(210, 176, 106) : (symbolID.equals("WO-DOBVA----A--") ? new Color(26, 153, 77) : (symbolID.equals("WO-DGMBTI---A--") ? new Color(255, 48, 0) : (symbolID.equals("WO-DGMBTH---A--") ? new Color(255, 80, 0) : (symbolID.equals("WO-DGMBTG---A--") ? new Color(255, 127, 0) : (symbolID.equals("WO-DGMBTF---A--") ? new Color(255, 207, 0) : (symbolID.equals("WO-DGMBTA---A--") ? new Color(48, 255, 0) : (symbolID.equals("WO-DGML-----A--") ? new Color(220, 220, 220) : (symbolID.equals("WO-DGMS-SH--A--") ? new Color(255, 220, 220) : (symbolID.equals("WO-DGMS-PH--A--") ? new Color(255, 190, 190) : (symbolID.equals("WO-DOBVC----A--") ? new Color(128, 255, 51) : (symbolID.equals("WO-DOBVE----A--") ? new Color(255, 255, 0) : (symbolID.equals("WO-DGMS-CO--A--") ? new Color(255, 150, 150) : (symbolID.equals("WO-DGMBTC---A--") ? new Color(175, 255, 0) : (symbolID.equals("WO-DGMBTD---A--") ? new Color(207, 255, 0) : (symbolID.equals("WO-DGMBTB---A--") ? new Color(127, 255, 0) : (symbolID.equals("WO-DGMIBD---A--") ? new Color(255, 127, 0) : (symbolID.equals("WO-DGMSIF---A--") ? new Color(25, 255, 230) : (symbolID.equals("WO-DGMSIVF--A--") ? new Color(0, 215, 255) : (symbolID.equals("WO-DGMSSVF--A--") ? new Color(255, 255, 220) : (symbolID.equals("WO-DGMSSF---A--") ? new Color(255, 255, 140) : (symbolID.equals("WO-DGMSSM---A--") ? new Color(255, 235, 0) : (symbolID.equals("WO-DGMSSC---A--") ? new Color(255, 215, 0) : (symbolID.equals("WO-DGMSSVS--A--") ? new Color(255, 180, 0) : (symbolID.equals("WO-DGMSIC---A--") ? new Color(200, 255, 105) : (symbolID.equals("WO-DGMSC----A--") ? new Color(100, 130, 255) : (symbolID.equals("WO-DOBVH----A--") ? new Color(255, 77, 0) : (symbolID.equals("WO-DOBVG----A--") ? new Color(255, 128, 0) : (symbolID.equals("WO-DOBVF----A--") ? new Color(255, 204, 0) : (symbolID.equals("WO-DOBVD----A--") ? new Color(204, 255, 26) : Color.BLACK))))))))))))))))))))))))))))))))))))))))))));
        return retColor;
    }

    public static Color getFillColorOfWeather(String symbolID) {
        if (symbolID.equals("WOS-HPM-R-P----")) {
            return new Color(148, 48, 0);
        }
        if (symbolID.equals("WOS-HPD---P----")) {
            return new Color(148, 48, 0);
        }
        if (symbolID.equals("WO-DHCB-----A--")) {
            return new Color(249, 243, 241);
        }
        if (symbolID.equals("WOS-HABB--P----")) {
            return new Color(255, 0, 255);
        }
        if (symbolID.equals("WOS-HHRS--P----")) {
            return new Color(0, 204, 255);
        }
        if (symbolID.equals("WOS-HHDS--P----")) {
            return new Color(0, 204, 255);
        }
        if (symbolID.equals("WOS-HHDWB-P----")) {
            return new Color(0, 204, 255);
        }
        if (symbolID.equals("WOS-TCCTG-P----")) {
            return new Color(210, 176, 106);
        }
        if (symbolID.equals("WO-DHCW-----A--")) {
            return new Color(255, 255, 255);
        }
        if (symbolID.equals("WO-DHABP----A--") || symbolID.equals("WO-DMCC-----A--")) {
            return new Color(0, 0, 255);
        }
        if (symbolID.equals("WO-DHHD-----A--") || symbolID.equals("WO-DHHDD----A--") || symbolID.equals("WO-DHDDA----A--")) {
            return new Color(0, 191, 255);
        }
        if (symbolID.equals("WO-DHPMD----A--")) {
            return new Color(188, 153, 58);
        }
        if (symbolID.equals("WO-DHCF----L---") || symbolID.equals("WO-DHCF-----A--")) {
            return new Color(173, 255, 47);
        }
        return null;
    }

    public static String hierarchyToSymbolID(String strHierarchy) {
        return "";
    }

    public static boolean isTacticalGraphic(String strSymbolID) {
        try {
            if (strSymbolID == null) {
                return false;
            }
            if (strSymbolID.charAt(0) == 'G' || SymbolUtilities.isWeather(strSymbolID) || SymbolUtilities.isEMSNaturalEvent(strSymbolID) || SymbolUtilities.isBasicShape(strSymbolID)) {
                return true;
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return false;
    }

    public static boolean isBasicShape(String symbolID) {
        if (symbolID != null && symbolID.length() >= 2) {
            return symbolID.startsWith("BS_") || symbolID.startsWith("BBS_") || symbolID.startsWith("PBS_");
        }
        return false;
    }

    public static boolean isWarfighting(String strSymbolID) {
        try {
            if (strSymbolID == null) {
                return false;
            }
            if (strSymbolID.charAt(0) == 'O' || strSymbolID.charAt(0) == 'S' || strSymbolID.charAt(0) == 'I' || strSymbolID.charAt(0) == 'E' && strSymbolID.charAt(2) != 'N') {
                return true;
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return false;
    }

    public static boolean isWeather(String strSymbolID) {
        try {
            return strSymbolID.charAt(0) == 'W';
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isNumber(String text) {
        return pIsNumber.matcher(text).matches();
    }

    public static String colorToHexString(Color color, Boolean withAlpha) {
        String hex = color.toHexString();
        if (withAlpha.booleanValue()) {
            return hex;
        }
        return hex.substring(2);
    }

    public static Color getColorFromHexString(String hexValue) {
        try {
            if (hexValue == null || hexValue.isEmpty()) {
                return null;
            }
            String hexOriginal = hexValue;
            String hexAlphabet = "0123456789ABCDEF";
            if (hexValue.charAt(0) == '#') {
                hexValue = hexValue.substring(1);
            }
            if (hexValue.substring(0, 2).equals("0x") || hexValue.substring(0, 2).equals("0X")) {
                hexValue = hexValue.substring(2);
            }
            hexValue = hexValue.toUpperCase();
            int count = hexValue.length();
            int[] value = null;
            int k = 0;
            int int1 = 0;
            int int2 = 0;
            if (count == 8 || count == 6) {
                value = new int[count / 2];
                for (int i = 0; i < count; i += 2) {
                    int1 = hexAlphabet.indexOf(hexValue.charAt(i));
                    int2 = hexAlphabet.indexOf(hexValue.charAt(i + 1));
                    value[k] = int1 * 16 + int2;
                    ++k;
                }
                if (count == 8) {
                    return new Color(value[1], value[2], value[3], value[0]);
                }
                if (count == 6) {
                    return new Color(value[0], value[1], value[2]);
                }
            } else {
                ErrorLogger.LogMessage("SymbolUtilties", "getColorFromHexString", "Bad hex value: " + hexOriginal, Level.WARNING);
            }
            return null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SymbolUtilities", "getColorFromHexString", exc);
            return null;
        }
    }

    public static boolean isMCSSpecificTacticalGraphic(SymbolDef sd) {
        return sd.getHierarchy().startsWith("2.X.7") || sd.getHierarchy().startsWith("2.X.5.2.3") || sd.getBasicSymbolId().startsWith("G*R*") || sd.getHierarchy().startsWith("21.X") || sd.getBasicSymbolId().startsWith("G*E*");
    }

    public static boolean is3dAirspace(String symbolID) {
        return symbolID == "CYLINDER-------" || symbolID == "ORBIT----------" || symbolID == "ROUTE----------" || symbolID == "POLYGON--------" || symbolID == "RADARC---------" || symbolID == "POLYARC--------" || symbolID == "CAKE-----------" || symbolID == "TRACK----------" || symbolID == "CURTAIN--------";
    }

    public static boolean isMCSSpecificForceElement(UnitDef ud) {
        return SymbolUtilities.isSASO(ud);
    }

    public static Boolean is3dGraphic(String symbolID) {
        String symbolId = symbolID.substring(4, 10);
        if (symbolId.equals("ACAI--") || symbolId.equals("ACAR--") || symbolId.equals("ACAC--") || symbolId.equals("AKPC--") || symbolId.equals("AKPR--") || symbolId.equals("AKPI--") || symbolId.equals("ALC---") || symbolId.equals("ALM---") || symbolId.equals("ALS---") || symbolId.equals("ALU---") || symbolId.equals("ALL---") || symbolId.equals("AAR---") || symbolId.equals("AAF---") || symbolId.equals("AAH---") || symbolId.equals("AAM---") || symbolId.equals("AAML--") || symbolId.equals("AAMH--")) {
            return true;
        }
        return false;
    }

    public static boolean isSASO(UnitDef sd) {
        return sd.getHierarchy().startsWith("5.X.10") || sd.getHierarchy().startsWith("5.X.11") || sd.getHierarchy().startsWith("5.X.12") || sd.getHierarchy().startsWith("5.X.13") || sd.getHierarchy().startsWith("5.X.14");
    }

    public static boolean isCheckPoint(String strSymbolID) {
        try {
            String strBasicSymbolID = SymbolUtilities.getBasicSymbolID(strSymbolID);
            boolean blRetVal = false;
            if (strBasicSymbolID.equals("G*G*GPPE--****X") || strBasicSymbolID.equals("G*G*GPPK--****X") || strBasicSymbolID.equals("G*G*GPPS--****X")) {
                blRetVal = true;
            }
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isCriticalPoint(String strSymbolID) {
        try {
            String strBasicSymbolID = SymbolUtilities.getBasicSymbolID(strSymbolID);
            boolean blRetVal = false;
            if (SymbolUtilities.isTacticalGraphic(strBasicSymbolID)) {
                String[] arr = new String[]{"G*M*BDD---****X", "G*M*BDE---****X", "G*M*BDI---****X", "G*R*CN----****X", "G*R*CP----****X", "G*R*FD----****X", "G*R*FR----****X", "G*R*PCC---****X", "G*R*PCO---****X", "G*R*PDC---****X", "G*R*PHP---****X", "G*R*PMC---****X", "G*R*PO----****X", "G*R*PPO---****X", "G*R*PTO---****X", "G*R*RLGC--****X", "G*R*SG----****X", "G*R*SSC---****X", "G*R*SC----****X", "G*R*TN----****X", "G*R*UP----****X"};
                int arrLength = arr.length;
                for (int i = 0; i < arrLength; ++i) {
                    if (!arr[i].equals(strBasicSymbolID)) continue;
                    blRetVal = true;
                    break;
                }
            } else if (strBasicSymbolID.equals("O*E*AL---------") || strBasicSymbolID.equals("O*E*AM---------") || strBasicSymbolID.equals("S*G*IMNB-------")) {
                blRetVal = true;
            }
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isRoute(String strSymbolID) {
        try {
            String strBasicSymbolID = SymbolUtilities.getBasicSymbolID(strSymbolID);
            boolean blRetVal = false;
            if (strBasicSymbolID.equals("G*S*LRA---****X") || strBasicSymbolID.equals("G*S*LRM---****X")) {
                blRetVal = true;
            }
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isRoad(String strSymbolID) {
        try {
            String strBasicSymbolID = SymbolUtilities.getBasicSymbolID(strSymbolID);
            boolean blRetVal = false;
            if (strBasicSymbolID.equals("ROAD------****X")) {
                blRetVal = true;
            }
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isJWARN(String strSymbolID) {
        try {
            return strSymbolID.substring(0, 5).equals("JWARN");
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isMOOTW(String strSymbolID) {
        try {
            return strSymbolID.charAt(0) == 'O';
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isSTBOPS(String strSymbolID) {
        try {
            return strSymbolID.charAt(0) == 'O';
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isEvent(String strSymbolID) {
        try {
            String[] arr = null;
            char category = strSymbolID.charAt(2);
            String strBasicSymbolID = SymbolUtilities.getBasicSymbolID(strSymbolID);
            if (SymbolUtilities.isMOOTW(strSymbolID) || SymbolUtilities.isEMS(strSymbolID) && (category == 'I' || category == 'N' || category == 'O')) {
                return true;
            }
            arr = new String[]{"S*G*EXI---*****", "S*G*EXI---MO***"};
            int arrLength = arr.length;
            for (int i = 0; i < arrLength; ++i) {
                if (!arr[i].equals(strBasicSymbolID)) continue;
                return true;
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return false;
    }

    public static boolean isHQ(String strSymbolID) {
        boolean blRetVal = false;
        try {
            char hq = strSymbolID.charAt(10);
            if (hq != '-' && hq != '*') {
                if (hq == 'A' || hq == 'B' || hq == 'C' || hq == 'D') {
                    blRetVal = true;
                }
            } else if (strSymbolID.charAt(0) == 'S' && strSymbolID.substring(4, 6).equals("UH")) {
                blRetVal = true;
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return blRetVal;
    }

    public static boolean isTaskForce(String strSymbolID) {
        try {
            char mod1 = strSymbolID.charAt(10);
            boolean blRetVal = mod1 == 'B' || mod1 == 'D' || mod1 == 'E' || mod1 == 'G';
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isFeintDummy(String strSymbolID) {
        try {
            char mod1 = strSymbolID.charAt(10);
            boolean blRetVal = mod1 == 'C' || mod1 == 'D' || mod1 == 'F' || mod1 == 'G';
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isMobilityWheeled(String strSymbolID) {
        boolean mobilityWheeledIsOn = false;
        try {
            mobilityWheeledIsOn = SymbolUtilities.isEquipment(strSymbolID) && strSymbolID.charAt(10) == 'M' && strSymbolID.charAt(11) == 'O';
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return mobilityWheeledIsOn;
    }

    public static boolean isMobility(String strSymbolID) {
        boolean mobilityIsOn = false;
        try {
            String mod = strSymbolID.substring(10, 12);
            if (mod.equals("MO") || mod.equals("MP") || mod.equals("MQ") || mod.equals("MR") || mod.equals("MS") || mod.equals("MT") || mod.equals("MU") || mod.equals("MV") || mod.equals("MW") || mod.equals("MX") || mod.equals("MY") || mod.equals("NS") || mod.equals("NL")) {
                mobilityIsOn = true;
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return mobilityIsOn;
    }

    public static Boolean isTarget(String strSymbolID) {
        String basicID = SymbolUtilities.getBasicSymbolID(strSymbolID);
        String sub = basicID.substring(0, 6);
        if (sub.equals("G*F*PT") || sub.equals("G*F*LT") || sub.equals("G*F*AT")) {
            return true;
        }
        return false;
    }

    public static Boolean isAirTrack(String strSymbolID) {
        if (strSymbolID.charAt(0) == 'S' && strSymbolID.charAt(2) == 'A') {
            return true;
        }
        return false;
    }

    public static boolean isObstacle(String strSymbolID) {
        try {
            boolean blRetVal = SymbolUtilities.isTacticalGraphic(strSymbolID) && strSymbolID.charAt(2) == 'M' && strSymbolID.charAt(4) == 'O';
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isDeconPoint(String strSymbolID) {
        try {
            boolean blRetVal = SymbolUtilities.isNBC(strSymbolID) && strSymbolID.substring(4, 6).equals("ND");
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isEchelonGraphic(String strSymbolID, int symStd) {
        try {
            SymbolDefTable symDefTable;
            SymbolDef sd;
            boolean blIsSinglePointTG = false;
            String basicID = SymbolUtilities.getBasicSymbolID(strSymbolID);
            if (SymbolUtilities.isTacticalGraphic(strSymbolID) && (sd = (symDefTable = SymbolDefTable.getInstance()).getSymbolDef(basicID, symStd)).getDrawCategory() == 8) {
                blIsSinglePointTG = true;
            }
            boolean blRetVal = SymbolUtilities.isUnit(strSymbolID) || SymbolUtilities.isSOF(strSymbolID) || SymbolUtilities.isMOOTW(strSymbolID) || SymbolUtilities.isObstacle(strSymbolID) && !blIsSinglePointTG || basicID.equals("G*G*GLB---****X") || basicID.equals("G*G*DAB---****X") || basicID.equals("G*G*DABP--****X") || basicID.equals("G*M*SP----****X");
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static String getEchelonText(String echelon) {
        char[] dots = new char[]{'\u2022', '\u2022', '\u2022'};
        String dot = new String(dots);
        String text = null;
        if (echelon != null) {
            if (echelon.equals("A")) {
                text = "0";
            } else if (echelon.equals("B")) {
                text = dot.substring(0, 1);
            } else if (echelon.equals("C")) {
                text = dot.substring(0, 2);
            } else if (echelon.equals("D")) {
                text = dot;
            } else if (echelon.equals("E")) {
                text = "|";
            } else if (echelon.equals("F")) {
                text = "||";
            } else if (echelon.equals("G")) {
                text = "|||";
            } else if (echelon.equals("H")) {
                text = "X";
            } else if (echelon.equals("I")) {
                text = "XX";
            } else if (echelon.equals("J")) {
                text = "XXX";
            } else if (echelon.equals("K")) {
                text = "XXXX";
            } else if (echelon.equals("L")) {
                text = "XXXXX";
            } else if (echelon.equals("M")) {
                text = "XXXXXX";
            } else if (echelon.equals("N")) {
                text = "++";
            }
        }
        return text;
    }

    public static boolean isUnit(String strSymbolID) {
        try {
            boolean blRetVal = strSymbolID.charAt(0) == 'S' && strSymbolID.charAt(2) == 'G' && strSymbolID.charAt(4) == 'U';
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isNBC(String strSymbolID) {
        try {
            String temp = SymbolUtilities.getBasicSymbolID(strSymbolID);
            boolean blRetVal = SymbolUtilities.isTacticalGraphic(strSymbolID) && temp.substring(0, 5).equals("G*M*N");
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isTGWithControlPoints(String strSymbolID, int symStd) {
        String temp = SymbolUtilities.getBasicSymbolID(strSymbolID);
        SymbolDef sd = SymbolDefTable.getInstance().getSymbolDef(temp, symStd);
        return sd != null && sd.getDrawCategory() == 5;
    }

    public static boolean isTGSPWithSpecialModifierLayout(String strSymbolID) {
        String temp = SymbolUtilities.getBasicSymbolID(strSymbolID);
        boolean blRetVal = temp.equals("G*G*GPH---****X") || temp.equals("G*G*GPPC--****X") || temp.equals("G*G*GPPD--****X") || temp.equals("G*G*GPPW--****X") || temp.equals("G*G*APP---****X") || temp.equals("G*G*APC---****X") || temp.equals("G*G*DPT---****X") || temp.equals("G*F*PTS---****X") || temp.equals("G*F*PTN---****X") || temp.equals("G*F*PCF---****X") || temp.equals("G*M*NZ----****X") || temp.equals("G*M*NEB---****X") || temp.equals("G*M*NEC---****X") || temp.equals("G*G*GPRI--****X") || temp.equals("G*M*OFS---****X") || temp.equals("WAS-WSF-LVP----") || temp.equals("WAS-PLT---P----") || temp.equals("WAS-PHT---P----") || temp.equals("WAS-WST-LVP----");
        return blRetVal;
    }

    public static boolean isTGSPWithIntegralText(String strSymbolID) {
        String temp = SymbolUtilities.getBasicSymbolID(strSymbolID);
        boolean blRetVal = temp.equals("G*G*GPRD--****X") || temp.equals("G*G*APU---****X") || temp.equals("G*M*NZ----****X") || temp.equals("G*M*NF----****X") || temp.equals("G*M*NEB---****X") || temp.equals("G*M*NEC---****X");
        return blRetVal;
    }

    public static boolean isTGSPWithFill(String strSymbolID) {
        String temp = SymbolUtilities.getBasicSymbolID(strSymbolID);
        boolean blRetVal = SymbolUtilities.isDeconPoint(temp) || temp.startsWith("G*S*P") || temp.equals("G*G*GPP---****X") || temp.equals("G*G*GPPK--****X") || temp.equals("G*G*GPPL--****X") || temp.equals("G*G*GPPP--****X") || temp.equals("G*G*GPPR--****X") || temp.equals("G*G*GPPE--****X") || temp.equals("G*G*GPPS--****X") || temp.equals("G*G*GPPA--****X") || temp.equals("G*G*GPPN--****X") || temp.equals("G*G*APD---****X") || temp.equals("G*G*OPP---****X") || temp.equals("G*F*PCS---****X") || temp.equals("G*F*PCB---****X") || temp.equals("G*F*PCR---****X") || temp.equals("G*F*PCH---****X") || temp.equals("G*F*PCL---****X") || temp.equals("G*M*BCP---****X") || temp.equals("G*O*ES----****X") || temp.startsWith("G*G*GPPD-") || temp.equals("G*G*GPPO--****X") || temp.equals("G*G*APP---****X") || temp.equals("G*G*APC---****X") || temp.equals("G*G*APU---****X") || temp.startsWith("G*G*GPUY") || temp.startsWith("G*G*GPR") && temp.charAt(7) != 'I' || temp.equals("G*M*NEB---****X") || temp.equals("G*M*NEC---****X") || temp.equals("G*M*NF----****X") || temp.equals("G*M*NZ----****X");
        return blRetVal;
    }

    public static boolean hasDefaultFill(String strSymbolID) {
        if (SymbolUtilities.isTacticalGraphic(strSymbolID)) {
            String temp = SymbolUtilities.getBasicSymbolID(strSymbolID);
            return temp.equals("G*M*NEB---****X") || temp.equals("G*M*NEC---****X") || temp.equals("G*M*NZ----****X");
        }
        return true;
    }

    public static String getTGFillSymbolCode(String strSymbolID) {
        String temp = SymbolUtilities.getBasicSymbolID(strSymbolID);
        if (temp.equals("G*M*NEB---****X")) {
            return "NBCBIOFILL****X";
        }
        if (temp.equals("G*M*NEC---****X")) {
            return "NBCCMLFILL****X";
        }
        if (temp.equals("G*M*NZ----****X") || temp.equals("G*M*NF----****X")) {
            return "NBCNUCFILL****X";
        }
        if (temp.startsWith("G*G*GPUY")) {
            return "SONOBYFILL****X";
        }
        if (temp.equals("G*G*GPPO--****X") || temp.equals("G*G*APP---****X") || temp.equals("G*G*APC---****X") || temp.equals("G*G*APU---****X")) {
            return "CPOINTFILL****X";
        }
        if (SymbolUtilities.isDeconPoint(temp) || temp.startsWith("G*S*P") || temp.equals("G*G*GPP---****X") || temp.equals("G*G*GPPK--****X") || temp.equals("G*G*GPPL--****X") || temp.equals("G*G*GPPP--****X") || temp.equals("G*G*GPPR--****X") || temp.equals("G*G*GPPE--****X") || temp.equals("G*G*GPPS--****X") || temp.equals("G*G*GPPA--****X") || temp.equals("G*G*APD---****X") || temp.equals("G*G*OPP---****X") || temp.equals("G*F*PCS---****X") || temp.equals("G*F*PCB---****X") || temp.equals("G*F*PCR---****X") || temp.equals("G*F*PCH---****X") || temp.equals("G*F*PCL---****X") || temp.equals("G*G*GPPN--****X") || temp.equals("G*O*ES----****X") || temp.equals("G*M*BCP---****X")) {
            return "CHKPNTFILL****X";
        }
        if (temp.startsWith("G*G*GPR") && temp.charAt(7) != 'I') {
            return "REFPNTFILL****X";
        }
        if (temp.startsWith("G*G*GPPD")) {
            return "DECPNTFILL****X";
        }
        return null;
    }

    public static boolean isWeatherSPWithFill(String symbolID) {
        return symbolID.equals("WOS-HPM-R-P----") || symbolID.equals("WOS-HPD---P----") || symbolID.equals("WOS-HABB--P----") || symbolID.equals("WOS-HHRS--P----") || symbolID.equals("WOS-HHDS--P----") || symbolID.equals("WOS-HHDWB-P----") || symbolID.equals("WOS-TCCTG-P----");
    }

    public static boolean isSOF(String strSymbolID) {
        try {
            boolean blRetVal = strSymbolID.charAt(0) == 'S' && strSymbolID.charAt(2) == 'F';
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isSonobuoy(String strSymbolID) {
        try {
            String basic = SymbolUtilities.getBasicSymbolID(strSymbolID);
            boolean blRetVal = basic.substring(0, 8) == "G*G*GPUY";
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isSeaSurface(String strSymbolID) {
        try {
            boolean blRetVal = strSymbolID.charAt(0) == 'S' && strSymbolID.charAt(2) == 'S';
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isSubSurface(String strSymbolID) {
        try {
            boolean blRetVal = strSymbolID.charAt(0) == 'S' && strSymbolID.charAt(2) == 'U';
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isEquipment(String strSymbolID) {
        try {
            boolean blRetVal = strSymbolID.charAt(0) == 'S' && strSymbolID.charAt(2) == 'G' && strSymbolID.charAt(4) == 'E';
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isEMSEquipment(String strSymbolID) {
        String basicCode = SymbolUtilities.getBasicSymbolID(strSymbolID);
        boolean blRetVal = false;
        try {
            if (strSymbolID.startsWith("E") && (basicCode.equals("E*O*AB----*****") || basicCode.equals("E*O*AE----*****") || basicCode.equals("E*O*AF----*****") || basicCode.equals("E*O*BB----*****") || basicCode.equals("E*O*CB----*****") || basicCode.equals("E*O*CC----*****") || basicCode.equals("E*O*DB----*****") || basicCode.startsWith("E*O*D") && basicCode.endsWith("B---*****") || basicCode.startsWith("E*O*E") && basicCode.endsWith("----*****") || basicCode.equals("E*F*BA----*****") || basicCode.equals("E*F*LF----*****") || basicCode.equals("E*F*MA----*****") || basicCode.equals("E*F*MC----*****"))) {
                blRetVal = true;
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return blRetVal;
    }

    public static boolean isEMS(String strSymbolID) {
        boolean blRetVal = false;
        try {
            if (strSymbolID.startsWith("E")) {
                blRetVal = true;
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return blRetVal;
    }

    public static boolean isEMSNaturalEvent(String strSymbolID) {
        boolean blRetVal = false;
        try {
            if (strSymbolID.charAt(0) == 'E' && strSymbolID.charAt(2) == 'N') {
                blRetVal = true;
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return blRetVal;
    }

    public static boolean isEMSIncident(String strSymbolID) {
        boolean blRetVal = false;
        try {
            if (strSymbolID.charAt(0) == 'E' && strSymbolID.charAt(2) == 'I') {
                blRetVal = true;
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return blRetVal;
    }

    public static boolean isEMSInstallation(String strSymbolID) {
        boolean blRetVal = false;
        try {
            if (strSymbolID.charAt(0) == 'E') {
                if (strSymbolID.charAt(2) == 'O' && strSymbolID.charAt(4) == 'D' && (strSymbolID.charAt(6) == 'C' || strSymbolID.charAt(5) == 'K')) {
                    blRetVal = true;
                } else if (strSymbolID.charAt(2) == 'F' && !strSymbolID.substring(4, 6).equals("BA")) {
                    blRetVal = true;
                } else if (strSymbolID.charAt(2) == 'O') {
                    if (strSymbolID.charAt(4) == 'A') {
                        switch (strSymbolID.charAt(5)) {
                            case 'C': 
                            case 'D': 
                            case 'G': 
                            case 'J': 
                            case 'K': 
                            case 'L': 
                            case 'M': {
                                blRetVal = true;
                                break;
                            }
                        }
                    } else if (strSymbolID.charAt(4) == 'B') {
                        switch (strSymbolID.charAt(5)) {
                            case 'C': 
                            case 'E': 
                            case 'F': 
                            case 'G': 
                            case 'H': 
                            case 'I': 
                            case 'K': 
                            case 'L': {
                                blRetVal = true;
                                break;
                            }
                        }
                    } else if (strSymbolID.charAt(4) == 'C') {
                        switch (strSymbolID.charAt(5)) {
                            case 'D': 
                            case 'E': {
                                blRetVal = true;
                                break;
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return blRetVal;
    }

    public static boolean isInstallation(String strSymbolID) {
        try {
            boolean blRetVal = false;
            if (strSymbolID.charAt(0) == 'S') {
                blRetVal = strSymbolID.charAt(2) == 'G' && strSymbolID.charAt(4) == 'I';
            } else if (strSymbolID.charAt(0) == 'E') {
                blRetVal = SymbolUtilities.isEMSInstallation(strSymbolID);
            }
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isSIGINT(String strSymbolID) {
        try {
            boolean blRetVal = strSymbolID.charAt(0) == 'I';
            return blRetVal;
        }
        catch (Throwable t) {
            System.out.println(t);
            return false;
        }
    }

    public static boolean isFeintDummyInstallation(String strSymbolID) {
        boolean feintDummyInstallationIsOn = false;
        try {
            feintDummyInstallationIsOn = strSymbolID.charAt(10) == 'H' && strSymbolID.charAt(11) == 'B';
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return feintDummyInstallationIsOn;
    }

    public static boolean hasInstallationModifier(String strSymbolID) {
        boolean hasInstallationModifier = false;
        try {
            hasInstallationModifier = strSymbolID.charAt(10) == 'H';
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return hasInstallationModifier;
    }

    public static char getAffiliation(String strSymbolID) {
        try {
            return strSymbolID.charAt(1);
        }
        catch (Throwable t) {
            System.out.println(t);
            return 'U';
        }
    }

    public static String getStatus(String strSymbolID) {
        try {
            String strStatus = strSymbolID.substring(3, 4);
            return strStatus;
        }
        catch (Throwable t) {
            System.out.println(t);
            return "P";
        }
    }

    public static String getEchelon(String strSymbolID) {
        try {
            char tenth = strSymbolID.charAt(10);
            String strSubEch = null;
            if (tenth != 'H' && tenth != 'M' && tenth != 'N') {
                strSubEch = strSymbolID.substring(11, 12);
            }
            return strSubEch;
        }
        catch (Throwable t) {
            System.out.println(t);
            return "-";
        }
    }

    public static String getSymbolModifier(String strSymbolID) {
        try {
            String strModifiers = strSymbolID.substring(10, 11);
            if (strModifiers.equals("A")) {
                return "A";
            }
            if (strModifiers.equals("B")) {
                return "B";
            }
            if (strModifiers.equals("C")) {
                return "C";
            }
            if (strModifiers.equals("D")) {
                return "D";
            }
            if (strModifiers.equals("E")) {
                return "E";
            }
            if (strModifiers.equals("F")) {
                return "F";
            }
            if (strModifiers.equals("G")) {
                return "G";
            }
            if (strModifiers.equals("H")) {
                String subModifier = strSymbolID.substring(11, 12);
                if (subModifier.equals("B")) {
                    return "HB";
                }
                return "H";
            }
            if (strModifiers.equals("M")) {
                String subModifier = strSymbolID.substring(11, 12);
                if (subModifier.equals("O")) {
                    return "MO";
                }
                return "M";
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return "-";
    }

    public static String getUnitAffiliationModifier(String symbolID, int symStd) {
        String textChar = null;
        try {
            char affiliation = symbolID.charAt(1);
            if (affiliation == 'F' || affiliation == 'H' || affiliation == 'U' || affiliation == 'N' || affiliation == 'P') {
                textChar = null;
            } else if (affiliation == 'A' || affiliation == 'S') {
                textChar = symStd == 0 ? "?" : null;
            } else if (affiliation == 'J') {
                textChar = "J";
            } else if (affiliation == 'K') {
                textChar = "K";
            } else if (affiliation == 'D' || affiliation == 'L' || affiliation == 'G' || affiliation == 'W') {
                textChar = "X";
            } else if (affiliation == 'M') {
                textChar = symStd == 0 ? "X?" : "X";
            }
            if (symStd == 1 && symbolID.charAt(0) == 'S' && symbolID.indexOf("WM") == 4) {
                textChar = symbolID.indexOf("GX") == 6 || symbolID.indexOf("MX") == 6 || symbolID.indexOf("FX") == 6 || symbolID.indexOf("X") == 6 || symbolID.indexOf("SX") == 6 ? "X" : null;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SymbolUtilities", "getUnitAffiliationModifier", exc, Level.WARNING);
            return null;
        }
        return textChar;
    }

    public static boolean hasDirectionOfMovement(String symbolID, int symStd) {
        SymbolDef temp = null;
        if (SymbolUtilities.isNBC(symbolID)) {
            temp = SymbolDefTable.getInstance().getSymbolDef(SymbolUtilities.getBasicSymbolID(symbolID), symStd);
            if (temp != null) {
                return temp.getModifiers().indexOf("Q.") != -1;
            }
            return false;
        }
        if (SymbolUtilities.isWarfighting(symbolID)) {
            return !SymbolUtilities.isSIGINT(symbolID);
        }
        return false;
    }

    public static Boolean hasAMmodifierWidth(String symbolID) {
        return SymbolUtilities.hasAMmodifierWidth(symbolID, rendererSettings.getSymbologyStandard());
    }

    public static Boolean hasAMmodifierWidth(String symbolID, int symStd) {
        SymbolDef sd = null;
        Boolean returnVal = false;
        String basic = SymbolUtilities.getBasicSymbolID(symbolID);
        sd = SymbolDefTable.getInstance().getSymbolDef(basic, symStd);
        if (sd != null) {
            int dc = sd.getDrawCategory();
            switch (dc) {
                case 17: 
                case 18: 
                case 20: {
                    returnVal = true;
                    break;
                }
                default: {
                    returnVal = false;
                }
            }
        }
        return returnVal;
    }

    public static Boolean hasANmodifier(String symbolID) {
        return SymbolUtilities.hasANmodifier(symbolID, rendererSettings.getSymbologyStandard());
    }

    public static Boolean hasANmodifier(String symbolID, int symStd) {
        SymbolDef sd = null;
        Boolean returnVal = false;
        String basic = SymbolUtilities.getBasicSymbolID(symbolID);
        sd = SymbolDefTable.getInstance().getSymbolDef(basic, symStd);
        if (sd != null) {
            int dc = sd.getDrawCategory();
            switch (dc) {
                case 17: 
                case 18: {
                    returnVal = true;
                    break;
                }
                default: {
                    returnVal = false;
                }
            }
        }
        return returnVal;
    }

    public static Boolean hasAMmodifierRadius(String symbolID) {
        return SymbolUtilities.hasAMmodifierRadius(symbolID, rendererSettings.getSymbologyStandard());
    }

    public static Boolean hasAMmodifierRadius(String symbolID, int symStd) {
        SymbolDef sd = null;
        Boolean returnVal = false;
        String basic = SymbolUtilities.getBasicSymbolID(symbolID);
        sd = SymbolDefTable.getInstance().getSymbolDef(basic, symStd);
        if (sd != null) {
            int dc = sd.getDrawCategory();
            switch (dc) {
                case 16: 
                case 19: {
                    returnVal = true;
                    break;
                }
                default: {
                    returnVal = false;
                }
            }
        }
        return returnVal;
    }

    public static String setAffiliation(String strSymbolID, String strAffiliationID) {
        try {
            if (strSymbolID != null && strSymbolID.length() == 15 && !SymbolUtilities.isWeather(strSymbolID) && strAffiliationID != null && strAffiliationID.length() == 1) {
                String strChangedID = strSymbolID.substring(0, 1) + strAffiliationID.toUpperCase() + strSymbolID.substring(2, 15);
                if (SymbolUtilities.hasValidAffiliation(strChangedID).booleanValue()) {
                    return strChangedID;
                }
                return strSymbolID;
            }
            return strSymbolID;
        }
        catch (Throwable t) {
            System.out.println(t);
            return "";
        }
    }

    public static String setEchelon(String strSymbolID, String strEchelon) {
        String strChangedID = strSymbolID;
        try {
            if (strSymbolID.length() == 15) {
                String strUppercaseEchelon = strEchelon.toUpperCase();
                strChangedID = strSymbolID.substring(0, 11) + strUppercaseEchelon + strSymbolID.substring(12, 15);
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return strChangedID;
    }

    public static String setStatus(String strSymbolID, String strStatusID) {
        String changedID = strSymbolID;
        try {
            if (strSymbolID.length() == 15 && !SymbolUtilities.isWeather(strSymbolID) && !SymbolUtilities.isBasicShape(strSymbolID)) {
                if (strStatusID.toLowerCase().equals("present")) {
                    changedID = strSymbolID.substring(0, 3) + "P" + strSymbolID.substring(4, 15);
                } else if (strStatusID.equalsIgnoreCase("planned") || strStatusID.equalsIgnoreCase("anticipated") || strStatusID.equalsIgnoreCase("plannedanticipated")) {
                    changedID = strSymbolID.substring(0, 3) + "A" + strSymbolID.substring(4, 15);
                }
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        return changedID;
    }

    public static String setSymbolModifier(String strSymbolID, String symbolModifierID) {
        String strChangedID = strSymbolID;
        if (strSymbolID.length() == 15) {
            if (symbolModifierID.equals("-")) {
                strChangedID = SymbolUtilities.isMobilityWheeled(strSymbolID) || SymbolUtilities.isFeintDummyInstallation(strSymbolID) ? strSymbolID.substring(0, 10) + "--" + strSymbolID.substring(12, 15) : strSymbolID.substring(0, 10) + "-" + strSymbolID.substring(11, 15);
            } else if (symbolModifierID.equals("A")) {
                strChangedID = strSymbolID.substring(0, 10) + "A" + strSymbolID.substring(11, 15);
            } else if (symbolModifierID.equals("B")) {
                strChangedID = strSymbolID.substring(0, 10) + "B" + strSymbolID.substring(11, 15);
            } else if (symbolModifierID.equals("C")) {
                strChangedID = strSymbolID.substring(0, 10) + "C" + strSymbolID.substring(11, 15);
            } else if (symbolModifierID.equals("D")) {
                strChangedID = strSymbolID.substring(0, 10) + "D" + strSymbolID.substring(11, 15);
            } else if (symbolModifierID.equals("E")) {
                strChangedID = strSymbolID.substring(0, 10) + "E" + strSymbolID.substring(11, 15);
            } else if (symbolModifierID.equals("F")) {
                strChangedID = strSymbolID.substring(0, 10) + "F" + strSymbolID.substring(11, 15);
            } else if (symbolModifierID.equals("G")) {
                strChangedID = strSymbolID.substring(0, 10) + "G" + strSymbolID.substring(11, 15);
            } else if (symbolModifierID.equals("HB")) {
                strChangedID = strSymbolID.substring(0, 10) + "HB" + strSymbolID.substring(12, 15);
            } else if (symbolModifierID.equals("HH")) {
                strChangedID = strSymbolID.substring(0, 10) + "H" + strSymbolID.substring(11, 15);
            } else if (symbolModifierID.equals("M")) {
                strChangedID = strSymbolID.substring(0, 10) + "M" + strSymbolID.substring(11, 15);
            } else if (symbolModifierID.equals("MO")) {
                strChangedID = strSymbolID.substring(0, 10) + "MO" + strSymbolID.substring(12, 15);
            }
        }
        return strChangedID;
    }
}

