/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import armyc2.c2sd.renderer.utilities.RectUtilities;
import armyc2.c2sd.renderer.utilities.SinglePointLookup;
import armyc2.c2sd.renderer.utilities.SinglePointLookupInfo;
import armyc2.c2sd.renderer.utilities.SymbolUtilities;

public class SymbolDimensions {
    public static float[] getUnitBounds(int charIndex, float fontSize) {
        int index = charIndex;
        RectF rect = null;
        float[] dimensions = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        switch (index - 57000) {
            case 800: 
            case 801: 
            case 802: {
                dimensions[2] = 60.8f;
                dimensions[3] = 60.8f;
                break;
            }
            case 803: 
            case 804: 
            case 805: {
                dimensions[2] = 62.547f;
                dimensions[3] = 44.52632f;
                break;
            }
            case 806: 
            case 807: 
            case 808: {
                dimensions[2] = 62.5f;
                dimensions[3] = 62.5f;
                break;
            }
            case 809: 
            case 810: 
            case 811: {
                dimensions[2] = 47.6085f;
                dimensions[3] = 47.6085f;
                break;
            }
            case 812: 
            case 813: 
            case 814: {
                dimensions[2] = 51.0625f;
                dimensions[3] = 51.0625f;
                break;
            }
            case 816: 
            case 817: 
            case 818: 
            case 840: 
            case 841: 
            case 842: {
                dimensions[1] = 8.0f;
                dimensions[2] = 47.8463f;
                dimensions[3] = 53.0f;
                break;
            }
            case 819: 
            case 820: 
            case 821: 
            case 843: 
            case 844: 
            case 845: {
                dimensions[1] = 6.0f;
                dimensions[2] = 46.5f;
                dimensions[3] = 48.0f;
                break;
            }
            case 822: 
            case 823: 
            case 824: 
            case 846: 
            case 847: 
            case 848: {
                dimensions[1] = 6.0f;
                dimensions[2] = 47.0f;
                dimensions[3] = 48.0f;
                break;
            }
            case 825: 
            case 826: 
            case 827: 
            case 849: 
            case 850: 
            case 851: {
                dimensions[1] = 6.5f;
                dimensions[2] = 64.7f;
                dimensions[3] = 56.0f;
                break;
            }
            case 828: 
            case 829: 
            case 830: {
                dimensions[1] = -8.0f;
                dimensions[2] = 47.8463f;
                dimensions[3] = 53.0f;
                break;
            }
            case 831: 
            case 832: 
            case 833: {
                dimensions[1] = -6.0f;
                dimensions[2] = 46.6f;
                dimensions[3] = 48.0f;
                break;
            }
            case 834: 
            case 835: 
            case 836: {
                dimensions[1] = -6.0f;
                dimensions[2] = 46.5f;
                dimensions[3] = 48.0f;
                break;
            }
            case 837: 
            case 838: 
            case 839: {
                rect = RectUtilities.makeRectF(0.0f, 0.0f, 64.7f, 56.0f);
                dimensions[1] = -6.0f;
                dimensions[2] = 64.7f;
                dimensions[3] = 56.0f;
                break;
            }
            default: {
                dimensions[2] = 54.0f;
                dimensions[3] = 54.0f;
            }
        }
        float ratio = 1.0f;
        if (fontSize != 50.0f) {
            ratio = fontSize / 50.0f;
            dimensions[1] = dimensions[1] * ratio;
            dimensions[2] = dimensions[2] * ratio;
            dimensions[3] = dimensions[3] * ratio;
        }
        return dimensions;
    }

    public static Rect getSymbolBounds(String symbolID, int symStd, float fontSize) {
        SinglePointLookupInfo spli = SinglePointLookup.getInstance().getSPLookupInfo(symbolID, symStd);
        RectF rect = new RectF(0.0f, 0.0f, (float)spli.getWidth(), (float)spli.getHeight());
        if (fontSize != 60.0f) {
            double ratio = (double)fontSize / 60.0;
            rect = RectUtilities.makeRectF(0.0f, 0.0f, (float)((double)rect.width() * ratio), (float)((double)rect.height() * ratio));
        }
        return new Rect((int)rect.left, (int)rect.top, (int)((double)rect.right + 0.5), (int)((double)rect.bottom + 0.5));
    }

    public static Point getSymbolCenter(String symbolID, RectF bounds) {
        String basicID = SymbolUtilities.getBasicSymbolID(symbolID);
        PointF center = new PointF();
        if (basicID.equals("G*G*GPUUB-****X") || basicID.equals("G*G*GPUUL-****X") || basicID.equals("G*G*GPUUS-****X") || basicID.equals("G*G*GPRI--****X") || basicID.equals("G*G*GPWE--****X") || basicID.equals("G*G*GPWG--****X") || basicID.equals("G*G*GPWM--****X") || basicID.equals("G*G*GPP---****X") || basicID.equals("G*G*GPPC--****X") || basicID.equals("G*G*GPPL--****X") || basicID.equals("G*G*GPPP--****X") || basicID.equals("G*G*GPPR--****X") || basicID.equals("G*G*GPPA--****X") || basicID.equals("G*G*APD---****X") || basicID.equals("G*G*OPP---****X") || basicID.substring(0, 7).equals("G*M*OAO") || basicID.equals("G*M*BCP---****X") || basicID.equals("G*F*PCS---****X") || basicID.equals("G*F*PCB---****X") || basicID.equals("G*F*PCR---****X") || basicID.equals("G*F*PCH---****X") || basicID.equals("G*F*PCL---****X") || basicID.substring(0, 5).equals("G*S*P") || basicID.equals("G*O*ED----****X") || basicID.equals("G*O*EP----****X") || basicID.equals("G*O*EV----****X") || basicID.equals("G*O*SB----****X") || basicID.equals("G*O*SBM---****X") || basicID.equals("G*O*SBN---****X") || basicID.equals("G*O*SS----****X") || basicID.equals("G*G*GPPN--****X") || basicID.equals("G*S*PX----****X") || basicID.equals("G*O*ES----****X") || SymbolUtilities.isNBC(basicID) || SymbolUtilities.isDeconPoint(basicID) || SymbolUtilities.isCheckPoint(basicID)) {
            center.x = bounds.width() / 2.0f;
            center.y = bounds.height();
        } else if (SymbolUtilities.isSonobuoy(basicID)) {
            center.x = bounds.width() / 2.0f;
            center.y = (int)((double)bounds.height() * 0.75);
        } else if (basicID.substring(0, 7).equals("G*G*GPO") && !(basicID.charAt(7) == '-')) {
            center.x = bounds.width() / 2.0f;
            center.y = (int)((double)bounds.height() * 0.33);
        } else if (basicID.equals("G*M*OMD---****X")) {
            center.x = bounds.width() / 2.0f;
            center.y = (int)((double)bounds.height() * 0.28);
        } else if (basicID.substring(0, 7).equals("G*G*DPO")) {
            if (basicID.charAt(7) == 'C') {
                center.x = bounds.width() / 2.0f;
                center.y = (int)((double)bounds.height() * 0.55);
            } else {
                center.x = bounds.width() / 2.0f;
                center.y = (int)((double)bounds.height() * 0.65);
            }
        } else if (basicID.equals("G*G*GPWD--****X") || basicID.equals("G*G*PN----****X") || basicID.equals("G*M*OB----****X") || basicID.equals("G*M*OME---****X") || basicID.equals("G*M*OMW---****X") || basicID.equals("G*M*OMP---****X") || basicID.equals("G*M*OHTL--****X") || basicID.equals("G*M*OHTH--****X") || basicID.equals("G*O*HM----****X") || basicID.equals("G*O*HI----****X") || basicID.equals("G*O*SM----****X")) {
            if (basicID.equals("G*G*GPWD--****X")) {
                center.x = bounds.width() / 2.0f;
                center.y = (int)((double)bounds.height() * 0.87);
            } else if (basicID.equals("G*G*PN----****X")) {
                center.x = bounds.width() / 2.0f;
                center.y = (int)((double)bounds.height() * 0.69);
            } else if (basicID.equals("G*M*OB----****X")) {
                center.x = bounds.width() / 2.0f;
                center.y = (int)((double)bounds.height() * 0.79);
            } else if (basicID.equals("G*M*OME---****X")) {
                center.x = bounds.width() / 2.0f;
                center.y = (int)((double)bounds.height() * 0.77);
            } else if (basicID.equals("G*M*OMW---****X")) {
                center.x = bounds.width() / 2.0f;
                center.y = (int)((double)bounds.height() * 0.3);
            } else if (basicID.equals("G*M*OMP---****X")) {
                center.x = bounds.width() / 2.0f;
                center.y = (int)((double)bounds.height() * 0.64);
            } else if (basicID.equals("G*M*OHTL--****X")) {
                center.x = bounds.width() / 2.0f;
                center.y = (int)((double)bounds.height() * 0.88);
            } else if (basicID.equals("G*M*OHTH--****X")) {
                center.x = bounds.width() / 2.0f;
                center.y = (int)((double)bounds.height() * 0.9);
            } else if (basicID.equals("G*O*HM----****X")) {
                center.x = bounds.width() / 2.0f;
                center.y = (int)((double)bounds.height() * 0.65);
            } else if (basicID.equals("G*O*HI----****X")) {
                center.x = bounds.width() / 2.0f;
                center.y = (int)((double)bounds.height() * 0.58);
            } else if (basicID.equals("G*O*SM----****X")) {
                center.x = 0.0f;
                center.y = (int)((double)bounds.height() * 0.5);
            }
        } else if (basicID.equals("G*O*SS----****X")) {
            center.x = 0.0f;
            center.y = (int)((double)bounds.height() * 0.45);
        } else {
            center.x = bounds.width() / 2.0f;
            center.y = bounds.height() / 2.0f;
        }
        return new Point(Math.round(center.x), Math.round(center.y));
    }
}

