/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import armyc2.c2sd.renderer.utilities.ErrorLogger;
import armyc2.c2sd.renderer.utilities.SinglePointLookupInfo;
import armyc2.c2sd.renderer.utilities.SymbolUtilities;
import armyc2.c2sd.renderer.utilities.XMLParser;
import armyc2.c2sd.renderer.utilities.XMLUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SinglePointLookup {
    private static boolean _initCalled = false;
    private static SinglePointLookup _instance;
    private boolean _ready = false;
    private static Map<String, SinglePointLookupInfo> hashMapB;
    private static Map<String, SinglePointLookupInfo> hashMapC;

    public boolean getReady() {
        return this._ready;
    }

    private SinglePointLookup() {
    }

    public static synchronized SinglePointLookup getInstance() {
        if (_instance == null) {
            _instance = new SinglePointLookup();
        }
        return _instance;
    }

    public synchronized void init(String[] singlepointLookupXML) {
        if (!_initCalled) {
            _instance = new SinglePointLookup();
            hashMapB = new HashMap<String, SinglePointLookupInfo>();
            hashMapC = new HashMap<String, SinglePointLookupInfo>();
            String lookupXmlB = singlepointLookupXML[0];
            String lookupXmlC = singlepointLookupXML[1];
            SinglePointLookup.populateLookup(lookupXmlB, 0);
            SinglePointLookup.populateLookup(lookupXmlC, 1);
            _initCalled = true;
        }
    }

    private static void populateLookup(String xml, int symStd) {
        Document document = XMLParser.getDomElement(xml);
        NodeList symbols = XMLUtil.getItemList(document, "SYMBOL");
        for (int i = 0; i < symbols.getLength(); ++i) {
            Node node = symbols.item(i);
            SinglePointLookupInfo spli = null;
            String basicID = XMLUtil.parseTagValue(node, "SYMBOLID");
            String description = XMLUtil.parseTagValue(node, "DESCRIPTION");
            String mappingP = XMLUtil.parseTagValue(node, "MAPPINGP");
            String mappingA = XMLUtil.parseTagValue(node, "MAPPINGA");
            String width = XMLUtil.parseTagValue(node, "WIDTH");
            String height = XMLUtil.parseTagValue(node, "HEIGHT");
            mappingP = SinglePointLookup.checkMappingIndex(mappingP);
            mappingA = SinglePointLookup.checkMappingIndex(mappingA);
            spli = new SinglePointLookupInfo(basicID, description, mappingP, mappingA, width, height);
            if (symStd == 0) {
                hashMapB.put(basicID, spli);
                continue;
            }
            if (symStd != 1) continue;
            hashMapC.put(basicID, spli);
        }
    }

    private static String checkMappingIndex(String index) {
        int i = -1;
        if (SymbolUtilities.isNumber(index)) {
            i = Integer.valueOf(index);
            return String.valueOf(i + 57000);
        }
        return index;
    }

    public int getCharCodeFromSymbol(String symbolCode, int symStd) {
        try {
            String strSymbolLookup = symbolCode;
            Map<String, SinglePointLookupInfo> hashMap = null;
            if (symStd == 0) {
                hashMap = hashMapB;
            } else if (symStd == 1) {
                hashMap = hashMapC;
            }
            SinglePointLookupInfo spli = null;
            if (SymbolUtilities.isWeather(strSymbolLookup) || symbolCode.contains("FILL")) {
                spli = hashMap.get(strSymbolLookup);
                if (spli != null) {
                    return spli.getMappingP();
                }
                return -1;
            }
            if (!hashMap.containsKey(strSymbolLookup)) {
                strSymbolLookup = SymbolUtilities.getBasicSymbolID(strSymbolLookup);
            }
            if ((spli = hashMap.get(strSymbolLookup)) != null) {
                if (SymbolUtilities.getStatus(symbolCode).equals("A")) {
                    return spli.getMappingA();
                }
                return spli.getMappingP();
            }
            return -1;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SinglePointLookup", "getCharCodeFromSymbol", exc, Level.WARNING);
            return -1;
        }
    }

    public SinglePointLookupInfo getSPLookupInfo(String basicSymbolID, int symStd) {
        SinglePointLookupInfo spli = null;
        if (symStd == 0) {
            spli = hashMapB.get(basicSymbolID);
        } else if (symStd == 1) {
            spli = hashMapC.get(basicSymbolID);
        }
        return spli;
    }

    static {
        hashMapB = null;
        hashMapC = null;
    }
}

