/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.Log;
import armyc2.c2sd.renderer.utilities.Color;

public class SVGPath {
    private String _ID = null;
    private String _strPath = null;
    private static String _regex1 = "(?=[M,m,Z,z,L,l,H,h,V,v,C,c,S,s,Q,q,T,t,A,a])";
    private static String _regex2 = "(?=[M,m,L,l,H,h,V,v,C,c,S,s,Q,q,T,t,A,a])";
    private static char[] svgCommands = new char[]{'M', 'm', 'Z', 'z', 'L', 'l', 'H', 'h', 'V', 'v', 'C', 'c', 'S', 's', 'Q', 'q', 'T', 't', 'A', 'a'};
    private Path _path = null;
    private static final RectF arcRectf = new RectF();
    private static final Matrix arcMatrix = new Matrix();
    private static final Matrix arcMatrix2 = new Matrix();

    public String getID() {
        return this._ID;
    }

    public RectF getBounds() {
        RectF bounds = new RectF();
        this._path.computeBounds(bounds, true);
        return bounds;
    }

    public RectF getBounds(float outlineWidth) {
        RectF bounds = new RectF();
        this._path.computeBounds(bounds, true);
        bounds = new RectF(bounds.left - outlineWidth, bounds.top - outlineWidth, bounds.right + outlineWidth, bounds.bottom + outlineWidth);
        return bounds;
    }

    private SVGPath() {
    }

    public SVGPath(SVGPath path) {
        this._path = new Path(path._path);
        this._ID = path._ID;
        this._strPath = path._strPath.substring(0);
    }

    public SVGPath(String unicodeHex, String path) {
        this._ID = String.valueOf(Integer.parseInt(unicodeHex, 16));
        this._strPath = path;
        this._path = new Path();
        this.parsePath();
    }

    private void parsePath() {
        String delimiter = " ";
        String[] commands = this._strPath.split(_regex1);
        String[] values = null;
        float[] points = new float[7];
        PointF[] pointFs = new PointF[4];
        PointF lastPoint = new PointF(0.0f, 0.0f);
        PointF lastControlPoint = new PointF(0.0f, 0.0f);
        try {
            for (int i = 0; i < commands.length; ++i) {
                PointF QP1;
                String strCommand = commands[i];
                int action = strCommand != null && strCommand.length() > 0 ? (int)strCommand.charAt(0) : 32;
                values = strCommand.split(delimiter);
                if (action == 77) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue();
                    points[1] = -Float.valueOf(values[1]).floatValue();
                    this._path.moveTo(points[0], points[1]);
                    lastPoint.set(points[0], points[1]);
                    continue;
                }
                if (action == 109) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue() + lastPoint.x;
                    points[1] = -Float.valueOf(values[1]).floatValue() + lastPoint.y;
                    this._path.moveTo(points[0], points[1]);
                    lastPoint.set(points[0], points[1]);
                    continue;
                }
                if (action == 76) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue();
                    points[1] = -Float.valueOf(values[1]).floatValue();
                    this._path.lineTo(points[0], points[1]);
                    lastPoint.set(points[0], points[1]);
                    continue;
                }
                if (action == 108) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue() + lastPoint.x;
                    points[1] = -Float.valueOf(values[1]).floatValue() + lastPoint.y;
                    this._path.lineTo(points[0], points[1]);
                    lastPoint.set(points[0], points[1]);
                    continue;
                }
                if (action == 72) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue();
                    this._path.lineTo(points[0], lastPoint.y);
                    lastPoint.set(points[0], lastPoint.y);
                    continue;
                }
                if (action == 104) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue() + lastPoint.x;
                    this._path.lineTo(points[0], lastPoint.y);
                    lastPoint.set(points[0], lastPoint.y);
                    continue;
                }
                if (action == 86) {
                    points[0] = -Float.valueOf(values[0].substring(1)).floatValue();
                    this._path.lineTo(lastPoint.x, points[0]);
                    lastPoint.set(lastPoint.x, points[0]);
                    continue;
                }
                if (action == 118) {
                    points[0] = -Float.valueOf(values[0].substring(1)).floatValue() + lastPoint.y;
                    this._path.lineTo(lastPoint.x, points[0]);
                    lastPoint.set(lastPoint.x, points[0]);
                    continue;
                }
                if (action == 67) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue();
                    points[1] = -Float.valueOf(values[1]).floatValue();
                    points[2] = Float.valueOf(values[2]).floatValue();
                    points[3] = -Float.valueOf(values[3]).floatValue();
                    points[4] = Float.valueOf(values[4]).floatValue();
                    points[5] = -Float.valueOf(values[5]).floatValue();
                    this._path.cubicTo(points[0], points[1], points[2], points[3], points[4], points[5]);
                    lastPoint.set(points[4], points[5]);
                    lastControlPoint.set(points[2], points[3]);
                    continue;
                }
                if (action == 99) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue() + lastPoint.x;
                    points[1] = -Float.valueOf(values[1]).floatValue() + lastPoint.y;
                    points[2] = Float.valueOf(values[2]).floatValue() + lastPoint.x;
                    points[3] = -Float.valueOf(values[3]).floatValue() + lastPoint.y;
                    points[4] = Float.valueOf(values[4]).floatValue() + lastPoint.x;
                    points[5] = -Float.valueOf(values[5]).floatValue() + lastPoint.y;
                    pointFs[0] = lastPoint;
                    pointFs[1] = new PointF(points[0], points[1]);
                    pointFs[2] = new PointF(points[2], points[3]);
                    pointFs[3] = new PointF(points[4], points[5]);
                    this._path.cubicTo(points[0], points[1], points[2], points[3], points[4], points[5]);
                    lastPoint.set(points[2], points[3]);
                    lastControlPoint.set(points[2], points[3]);
                    continue;
                }
                if (action == 83) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue();
                    points[1] = -Float.valueOf(values[1]).floatValue();
                    points[2] = Float.valueOf(values[2]).floatValue();
                    points[3] = -Float.valueOf(values[3]).floatValue();
                    pointFs[0] = lastPoint;
                    pointFs[1] = this.mirrorControlPoint(lastControlPoint, lastPoint);
                    pointFs[2] = new PointF(points[0], points[1]);
                    pointFs[3] = new PointF(points[2], points[3]);
                    this._path.cubicTo(pointFs[1].x, pointFs[1].y, points[0], points[1], points[2], points[3]);
                    lastPoint.set(points[2], points[3]);
                    lastControlPoint.set(points[0], points[1]);
                    continue;
                }
                if (action == 115) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue() + lastPoint.x;
                    points[1] = -Float.valueOf(values[1]).floatValue() + lastPoint.y;
                    points[2] = Float.valueOf(values[2]).floatValue() + lastPoint.x;
                    points[3] = -Float.valueOf(values[3]).floatValue() + lastPoint.y;
                    pointFs[0] = lastPoint;
                    pointFs[1] = this.mirrorControlPoint(lastControlPoint, lastPoint);
                    this._path.cubicTo(pointFs[1].x, pointFs[1].y, points[0], points[1], points[2], points[3]);
                    lastPoint.set(points[2], points[3]);
                    lastControlPoint.set(points[0], points[1]);
                    continue;
                }
                if (action == 81) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue();
                    points[1] = -Float.valueOf(values[1]).floatValue();
                    points[2] = Float.valueOf(values[2]).floatValue();
                    points[3] = -Float.valueOf(values[3]).floatValue();
                    this._path.quadTo(points[0], points[1], points[2], points[3]);
                    lastPoint.set(points[2], points[3]);
                    lastControlPoint.set(points[0], points[1]);
                    continue;
                }
                if (action == 113) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue() + lastPoint.x;
                    points[1] = -Float.valueOf(values[1]).floatValue() + lastPoint.y;
                    points[2] = Float.valueOf(values[2]).floatValue() + lastPoint.x;
                    points[3] = -Float.valueOf(values[3]).floatValue() + lastPoint.y;
                    this._path.quadTo(points[0], points[1], points[2], points[3]);
                    lastPoint.set(points[2], points[3]);
                    lastControlPoint.set(points[0], points[1]);
                    continue;
                }
                if (action == 84) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue();
                    points[1] = -Float.valueOf(values[1]).floatValue();
                    QP1 = this.mirrorControlPoint(lastControlPoint, lastPoint);
                    this._path.quadTo(QP1.x, QP1.y, points[0], points[1]);
                    lastPoint.set(points[0], points[1]);
                    lastControlPoint = QP1;
                    continue;
                }
                if (action == 116) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue() + lastPoint.x;
                    points[1] = -Float.valueOf(values[1]).floatValue() + lastPoint.y;
                    QP1 = this.mirrorControlPoint(lastControlPoint, lastPoint);
                    this._path.quadTo(QP1.x, QP1.y, points[0], points[1]);
                    lastPoint.set(points[0], points[1]);
                    lastControlPoint = QP1;
                    continue;
                }
                if (action == 65) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue();
                    points[1] = Float.valueOf(values[1]).floatValue();
                    points[2] = Float.valueOf(values[2]).floatValue();
                    points[3] = Float.valueOf(values[3]).floatValue();
                    points[4] = Float.valueOf(values[4]).floatValue();
                    points[5] = Float.valueOf(values[5]).floatValue();
                    points[6] = -Float.valueOf(values[6]).floatValue();
                    SVGPath.drawArc(this._path, lastPoint.x, lastPoint.y, points[0], points[1], points[2], points[3], points[4], (int)points[5], (int)points[6]);
                    lastPoint.set(points[5], points[6]);
                    lastControlPoint.set(points[2], points[3]);
                    continue;
                }
                if (action == 97) {
                    points[0] = Float.valueOf(values[0].substring(1)).floatValue();
                    points[1] = Float.valueOf(values[1]).floatValue();
                    points[2] = Float.valueOf(values[2]).floatValue();
                    points[3] = Float.valueOf(values[3]).floatValue();
                    points[4] = Float.valueOf(values[4]).floatValue();
                    points[5] = Float.valueOf(values[5] + lastPoint.x).floatValue();
                    points[6] = -Float.valueOf(values[6] + lastPoint.y).floatValue();
                    SVGPath.drawArc(this._path, lastPoint.x, lastPoint.y, points[0], points[1], points[2], points[3], points[4], (int)points[5], (int)points[6]);
                    lastPoint.set(points[5], points[6]);
                    lastControlPoint.set(points[2], points[3]);
                    continue;
                }
                if (action != 90 && action != 122) continue;
                this._path.close();
            }
        }
        catch (Exception exc) {
            Log.e((String)"SVGPath.parsePath", (String)exc.getMessage());
        }
    }

    private PointF mirrorControlPoint(PointF cp, PointF endPoint) {
        float xOffset = endPoint.x - cp.x;
        float yOffset = endPoint.y - cp.y;
        PointF mirror = new PointF(endPoint.x + xOffset, endPoint.y + yOffset);
        return mirror;
    }

    private static double angle(double x1, double y1, double x2, double y2) {
        return Math.toDegrees(Math.atan2(x1, y1) - Math.atan2(x2, y2)) % 360.0;
    }

    private static void drawArc(Path p, float lastX, float lastY, float x, float y, float rx, float ry, float theta, int largeArc, int sweepArc) {
        double rys;
        double y1t;
        double y1ts;
        double rxs;
        double yc;
        double xc;
        if (rx == 0.0f || ry == 0.0f) {
            p.lineTo(x, y);
            return;
        }
        if (x == lastX && y == lastY) {
            return;
        }
        rx = Math.abs(rx);
        ry = Math.abs(ry);
        double thrad = (double)theta * Math.PI / 180.0;
        double st = Math.sin(thrad);
        double ct = Math.cos(thrad);
        double x1t = ct * (xc = (double)((lastX - x) / 2.0f)) + st * (yc = (double)((lastY - y) / 2.0f));
        double x1ts = x1t * x1t;
        double lambda = (x1ts / (rxs = (double)(rx * rx)) + (y1ts = (y1t = -st * xc + ct * yc) * y1t) / (rys = (double)(ry * ry))) * (double)1.001f;
        if (lambda > 1.0) {
            double lambdasr = Math.sqrt(lambda);
            rx = (float)((double)rx * lambdasr);
            ry = (float)((double)ry * lambdasr);
            rxs = rx * rx;
            rys = ry * ry;
        }
        double R2 = Math.sqrt((rxs * rys - rxs * y1ts - rys * x1ts) / (rxs * y1ts + rys * x1ts)) * (double)(largeArc == sweepArc ? -1 : 1);
        double cxt = R2 * (double)rx * y1t / (double)ry;
        double cyt = -R2 * (double)ry * x1t / (double)rx;
        double cx = ct * cxt - st * cyt + (double)((lastX + x) / 2.0f);
        double cy = st * cxt + ct * cyt + (double)((lastY + y) / 2.0f);
        double th1 = SVGPath.angle(1.0, 0.0, (x1t - cxt) / (double)rx, (y1t - cyt) / (double)ry);
        double dth = SVGPath.angle((x1t - cxt) / (double)rx, (y1t - cyt) / (double)ry, (-x1t - cxt) / (double)rx, (-y1t - cyt) / (double)ry);
        if (sweepArc == 0 && dth > 0.0) {
            dth -= 360.0;
        } else if (sweepArc != 0 && dth < 0.0) {
            dth += 360.0;
        }
        if (theta % 360.0f == 0.0f) {
            arcRectf.set((float)(cx - (double)rx), (float)(cy - (double)ry), (float)(cx + (double)rx), (float)(cy + (double)ry));
            p.arcTo(arcRectf, (float)th1, (float)dth);
        } else {
            arcRectf.set(-rx, -ry, rx, ry);
            arcMatrix.reset();
            arcMatrix.postRotate(theta);
            arcMatrix.postTranslate((float)cx, (float)cy);
            arcMatrix.invert(arcMatrix2);
            p.transform(arcMatrix2);
            p.arcTo(arcRectf, (float)th1, (float)dth);
            p.transform(arcMatrix);
        }
    }

    public Matrix TransformToFitDimensions(int width, int height) {
        RectF rect = new RectF();
        this._path.computeBounds(rect, true);
        Matrix m = new Matrix();
        Matrix mScale = new Matrix();
        Matrix mTranslate = new Matrix();
        float sx = (float)width / rect.width();
        float sy = (float)height / rect.height();
        if (sx < sy) {
            mScale.setScale(sx, sx);
            m.setScale(sx, sx);
        } else {
            mScale.setScale(sy, sy);
            m.setScale(sy, sy);
        }
        this._path.transform(mScale);
        this._path.computeBounds(rect, true);
        float transx = 0.0f;
        float transy = 0.0f;
        if (rect.left < 0.0f) {
            transx = rect.left * -1.0f;
        }
        if (rect.top < 0.0f) {
            transy = rect.top * -1.0f;
        }
        mTranslate.setTranslate(transx, transy);
        m.postTranslate(transx, transy);
        this._path.transform(mTranslate);
        return m;
    }

    public void Transform(Matrix m) {
        this._path.transform(m);
    }

    public void Draw(Canvas c, Color lineColor, float lineWidth, Color fillColor, Matrix m) {
        if (m != null) {
            this._path.transform(m);
        }
        if (lineColor != null) {
            Paint strokePaint = new Paint();
            strokePaint.setStyle(Paint.Style.STROKE);
            strokePaint.setColor(lineColor.toARGB());
            strokePaint.setAntiAlias(true);
            c.drawPath(this._path, strokePaint);
        }
        if (fillColor != null) {
            Paint fillPaint = new Paint();
            fillPaint.setStyle(Paint.Style.FILL);
            fillPaint.setColor(fillColor.toARGB());
            fillPaint.setAntiAlias(true);
            c.drawPath(this._path, fillPaint);
        }
    }

    public Bitmap Draw(int width, int height, Color lineColor, Color fillColor) {
        Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(bmp);
        Object foo = null;
        RectF rect = new RectF();
        this._path.computeBounds(rect, true);
        Matrix m = new Matrix();
        float sx = (float)width / rect.width();
        float sy = (float)height / rect.height();
        if (sx < sy) {
            m.postScale(sx, sx);
        } else {
            m.postScale(sy, sy);
        }
        this._path.transform(m);
        this._path.computeBounds(rect, true);
        m = new Matrix();
        float transx = 0.0f;
        float transy = 0.0f;
        if (rect.left < 0.0f) {
            transx = rect.left * -1.0f;
        }
        if (rect.top < 0.0f) {
            transy = rect.top * -1.0f;
        }
        m.postTranslate(transx, transy);
        this._path.transform(m);
        this._path.computeBounds(rect, true);
        if (lineColor != null) {
            Paint strokePaint = new Paint();
            strokePaint.setStyle(Paint.Style.STROKE);
            strokePaint.setColor(lineColor.toARGB());
            strokePaint.setAntiAlias(true);
            c.drawPath(this._path, strokePaint);
        }
        if (fillColor != null) {
            Paint fillPaint = new Paint();
            fillPaint.setStyle(Paint.Style.FILL);
            fillPaint.setColor(fillColor.toARGB());
            fillPaint.setAntiAlias(true);
            c.drawPath(this._path, fillPaint);
        }
        return bmp;
    }
}

