/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.SparseArray;
import armyc2.c2sd.renderer.utilities.Color;
import armyc2.c2sd.renderer.utilities.RendererSettings;

public class RendererUtilities {
    private static SparseArray<Color> pastIdealOutlineColors = new SparseArray();

    public static Color getIdealOutlineColor(Color color) {
        Color idealColor = Color.white;
        if (color != null && pastIdealOutlineColors.indexOfKey(color.toInt()) >= 0) {
            return (Color)pastIdealOutlineColors.get(color.toInt());
        }
        if (color != null) {
            int b;
            int g;
            int threshold = RendererSettings.getInstance().getTextBackgroundAutoColorThreshold();
            int r = color.getRed();
            float delta = (float)r * 0.299f + (float)(g = color.getGreen()) * 0.587f + (float)(b = color.getBlue()) * 0.114f;
            idealColor = 255.0f - delta < (float)threshold ? Color.black : Color.white;
        }
        if (color != null) {
            pastIdealOutlineColors.put(color.toInt(), (Object)idealColor);
        }
        return idealColor;
    }

    public static void renderSymbolCharacter(Canvas ctx, String symbol, int x, int y, Paint paint, Color color, int outlineWidth) {
        int tbm = RendererSettings.getInstance().getTextBackgroundMethod();
        Color outlineColor = RendererUtilities.getIdealOutlineColor(color);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(outlineColor.toInt());
        if (outlineWidth > 0) {
            for (int i = 1; i <= outlineWidth; ++i) {
                if (i % 2 == 1) {
                    ctx.drawText(symbol, (float)(x - i), (float)y, paint);
                    ctx.drawText(symbol, (float)(x + i), (float)y, paint);
                    ctx.drawText(symbol, (float)x, (float)(y + i), paint);
                    ctx.drawText(symbol, (float)x, (float)(y - i), paint);
                    continue;
                }
                ctx.drawText(symbol, (float)(x - i), (float)(y - i), paint);
                ctx.drawText(symbol, (float)(x + i), (float)(y - i), paint);
                ctx.drawText(symbol, (float)(x - i), (float)(y + i), paint);
                ctx.drawText(symbol, (float)(x + i), (float)(y + i), paint);
            }
        }
        paint.setColor(color.toInt());
        ctx.drawText(symbol, (float)x, (float)y, paint);
    }
}

