/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.graphics.PointF;
import armyc2.c2sd.graphics2d.Point2D;
import armyc2.c2sd.renderer.utilities.GeoPixelConversion3D;
import armyc2.c2sd.renderer.utilities.IPointConversion;

public class PointConverter3D
implements IPointConversion {
    private double _controlLat = 0.0;
    private double _controlLong = 0.0;
    private double _scale = 0.0;
    private double _metersPerPixel = 0.0;

    public PointConverter3D(double controlLong, double controlLat, double scale) {
        this._controlLat = controlLat;
        this._controlLong = controlLong;
        this._scale = scale;
        this._metersPerPixel = GeoPixelConversion3D.metersPerPixel(scale);
    }

    @Override
    public PointF PixelsToGeo(PointF pixel) {
        PointF pt2dGeo = null;
        double y = GeoPixelConversion3D.y2lat(pixel.y, this._scale, this._controlLat, this._metersPerPixel);
        double x = GeoPixelConversion3D.x2long(pixel.x, this._scale, this._controlLong, y, this._metersPerPixel);
        pt2dGeo = new PointF((float)x, (float)y);
        return pt2dGeo;
    }

    @Override
    public PointF GeoToPixels(PointF coord) {
        PointF ptPixels = null;
        double y = GeoPixelConversion3D.lat2y(coord.y, this._scale, this._controlLat, this._metersPerPixel);
        double x = GeoPixelConversion3D.long2x(coord.x, this._scale, this._controlLong, coord.y, this._metersPerPixel);
        ptPixels = new PointF((float)x, (float)y);
        return ptPixels;
    }

    @Override
    public Point2D PixelsToGeo(Point2D pixel) {
        Point2D.Double pt2dGeo = null;
        double y = GeoPixelConversion3D.y2lat(pixel.getY(), this._scale, this._controlLat, this._metersPerPixel);
        double x = GeoPixelConversion3D.x2long(pixel.getX(), this._scale, this._controlLong, y, this._metersPerPixel);
        pt2dGeo = new Point2D.Double(x, y);
        return pt2dGeo;
    }

    @Override
    public Point2D GeoToPixels(Point2D coord) {
        Point2D.Double ptPixels = null;
        double y = GeoPixelConversion3D.lat2y(coord.getY(), this._scale, this._controlLat, this._metersPerPixel);
        double x = GeoPixelConversion3D.long2x(coord.getX(), this._scale, this._controlLong, coord.getY(), this._metersPerPixel);
        ptPixels = new Point2D.Double(x, y);
        return ptPixels;
    }
}

