/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.graphics.PointF;
import armyc2.c2sd.graphics2d.Point2D;
import armyc2.c2sd.renderer.utilities.IPointConversion;

public class PointConversion
implements IPointConversion {
    double _scale = 0.0;
    int _pixelWidth = 0;
    int _PixelHeight = 0;
    double _geoTop = 0.0;
    double _geoLeft = 0.0;
    double _geoBottom = 0.0;
    double _geoRight = 0.0;
    double _pixelMultiplierX = 0.0;
    double _pixelMultiplierY = 0.0;
    boolean _normalize = true;

    public void set_normalize(boolean value) {
        this._normalize = value;
    }

    public PointConversion(int pixelWidth, int pixelHeight, double geoTop, double geoLeft, double geoBottom, double geoRight) {
        this.UpdateExtents(pixelWidth, pixelHeight, geoTop, geoLeft, geoBottom, geoRight);
    }

    public void UpdateExtents(int pixelWidth, int pixelHeight, double geoTop, double geoLeft, double geoBottom, double geoRight) {
        this._pixelWidth = pixelWidth;
        this._PixelHeight = pixelHeight;
        this._geoTop = geoTop;
        this._geoLeft = geoLeft;
        this._geoBottom = geoBottom;
        this._geoRight = geoRight;
        this._pixelMultiplierX = (this._geoRight - this._geoLeft) / (double)this._pixelWidth;
        this._pixelMultiplierY = (this._geoTop - this._geoBottom) / (double)this._PixelHeight;
        if (this._geoRight - this._geoLeft < -180.0) {
            this._pixelMultiplierX = (this._geoRight - this._geoLeft + 360.0) / (double)this._pixelWidth;
        }
        if (this._geoRight - this._geoLeft > 180.0) {
            this._pixelMultiplierX = (360.0 - (this._geoRight - this._geoLeft)) / (double)this._pixelWidth;
        }
        this._pixelMultiplierY = this._geoTop < this._geoBottom ? -Math.abs(this._pixelMultiplierY) : Math.abs(this._pixelMultiplierY);
        double distanceInDegrees = Math.abs(this._geoRight - this._geoLeft);
        if (Math.abs(this._geoRight - this._geoLeft) > 180.0) {
            distanceInDegrees = Math.abs(distanceInDegrees - 360.0);
        }
        double distanceInMeters = distanceInDegrees / 360.0 * 4.0075E7;
        double scale = (double)this._pixelWidth / distanceInMeters * 0.010416666666666666 * 0.025400050800101603;
        this._scale = 1.0 / scale;
    }

    @Override
    public PointF PixelsToGeo(PointF pixel) {
        PointF coords = new PointF();
        coords.x = (float)((double)pixel.x * this._pixelMultiplierX + this._geoLeft);
        coords.y = (float)(this._geoTop - (double)pixel.y * this._pixelMultiplierY);
        if (coords.x > 180.0f) {
            coords.x -= 360.0f;
        }
        if (coords.x < -180.0f) {
            coords.x += 360.0f;
        }
        return coords;
    }

    @Override
    public PointF GeoToPixels(PointF coord) {
        PointF pixel = new PointF();
        double calcValue = (double)coord.x - this._geoLeft;
        if (this._normalize) {
            if (calcValue < -180.0) {
                calcValue += 360.0;
            } else if (calcValue > 180.0) {
                calcValue -= 360.0;
            }
        }
        double temp = calcValue / this._pixelMultiplierX;
        pixel.x = (float)temp;
        temp = (this._geoTop - (double)coord.y) / this._pixelMultiplierY;
        pixel.y = (float)temp;
        return pixel;
    }

    @Override
    public Point2D PixelsToGeo(Point2D pixel) {
        Point2D.Double coords = new Point2D.Double();
        double x = (float)(pixel.getX() * this._pixelMultiplierX + this._geoLeft);
        double y = (float)(this._geoTop - pixel.getY() * this._pixelMultiplierY);
        if (x > 180.0) {
            x -= 360.0;
        }
        if (x < -180.0) {
            x += 360.0;
        }
        ((Point2D)coords).setLocation(x, y);
        return coords;
    }

    @Override
    public Point2D GeoToPixels(Point2D coord) {
        double temp;
        Point2D.Double pixel = new Point2D.Double();
        double x = 0.0;
        double y = 0.0;
        double calcValue = coord.getX() - this._geoLeft;
        if (this._normalize) {
            if (calcValue < -180.0) {
                calcValue += 360.0;
            } else if (calcValue > 180.0) {
                calcValue -= 360.0;
            }
        }
        x = temp = calcValue / this._pixelMultiplierX;
        y = temp = (this._geoTop - coord.getY()) / this._pixelMultiplierY;
        ((Point2D)pixel).setLocation(x, y);
        return pixel;
    }

    public int getPixelWidth() {
        return this._pixelWidth;
    }

    public int getPixelHeight() {
        return this._PixelHeight;
    }

    public double getUpperLat() {
        return this._geoTop;
    }

    public double getLowerLat() {
        return this._geoBottom;
    }

    public double getLeftLon() {
        return this._geoLeft;
    }

    public double getRightLon() {
        return this._geoRight;
    }
}

